/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.portal.service.base;

import com.liferay.exportimport.kernel.lar.ExportImportHelperUtil;
import com.liferay.exportimport.kernel.lar.ManifestSummary;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.petra.function.UnsafeFunction;
import com.liferay.petra.sql.dsl.query.DSLQuery;
import com.liferay.portal.kernel.bean.BeanReference;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.jdbc.SqlUpdate;
import com.liferay.portal.kernel.dao.jdbc.SqlUpdateFactoryUtil;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DefaultActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQueryFactoryUtil;
import com.liferay.portal.kernel.dao.orm.ExportActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.IndexableActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Projection;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.model.PersistedModel;
import com.liferay.portal.kernel.model.UserGroup;
import com.liferay.portal.kernel.module.framework.service.IdentifiableOSGiService;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.service.BaseLocalServiceImpl;
import com.liferay.portal.kernel.service.PersistedModelLocalServiceRegistry;
import com.liferay.portal.kernel.service.UserGroupLocalService;
import com.liferay.portal.kernel.service.UserGroupLocalServiceUtil;
import com.liferay.portal.kernel.service.persistence.BasePersistence;
import com.liferay.portal.kernel.service.persistence.GroupPersistence;
import com.liferay.portal.kernel.service.persistence.TeamPersistence;
import com.liferay.portal.kernel.service.persistence.UserGroupFinder;
import com.liferay.portal.kernel.service.persistence.UserGroupPersistence;
import com.liferay.portal.kernel.service.persistence.UserPersistence;
import com.liferay.portal.kernel.service.persistence.change.tracking.CTPersistence;
import com.liferay.portal.kernel.transaction.Transactional;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PortalUtil;

import java.io.Serializable;

import java.lang.reflect.Field;

import java.util.List;

import javax.sql.DataSource;

/**
 * Provides the base implementation for the user group local service.
 *
 * <p>
 * This implementation exists only as a container for the default service methods generated by ServiceBuilder. All custom service methods should be put in {@link com.liferay.portal.service.impl.UserGroupLocalServiceImpl}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see com.liferay.portal.service.impl.UserGroupLocalServiceImpl
 * @generated
 */
public abstract class UserGroupLocalServiceBaseImpl
	extends BaseLocalServiceImpl
	implements IdentifiableOSGiService, UserGroupLocalService {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. Use <code>UserGroupLocalService</code> via injection or a <code>org.osgi.util.tracker.ServiceTracker</code> or use <code>UserGroupLocalServiceUtil</code>.
	 */

	/**
	 * Adds the user group to the database. Also notifies the appropriate model listeners.
	 *
	 * <p>
	 * <strong>Important:</strong> Inspect UserGroupLocalServiceImpl for overloaded versions of the method. If provided, use these entry points to the API, as the implementation logic may require the additional parameters defined there.
	 * </p>
	 *
	 * @param userGroup the user group
	 * @return the user group that was added
	 */
	@Indexable(type = IndexableType.REINDEX)
	@Override
	public UserGroup addUserGroup(UserGroup userGroup) {
		userGroup.setNew(true);

		return userGroupPersistence.update(userGroup);
	}

	/**
	 * Creates a new user group with the primary key. Does not add the user group to the database.
	 *
	 * @param userGroupId the primary key for the new user group
	 * @return the new user group
	 */
	@Override
	@Transactional(enabled = false)
	public UserGroup createUserGroup(long userGroupId) {
		return userGroupPersistence.create(userGroupId);
	}

	/**
	 * Deletes the user group with the primary key from the database. Also notifies the appropriate model listeners.
	 *
	 * <p>
	 * <strong>Important:</strong> Inspect UserGroupLocalServiceImpl for overloaded versions of the method. If provided, use these entry points to the API, as the implementation logic may require the additional parameters defined there.
	 * </p>
	 *
	 * @param userGroupId the primary key of the user group
	 * @return the user group that was removed
	 * @throws PortalException if a user group with the primary key could not be found
	 */
	@Indexable(type = IndexableType.DELETE)
	@Override
	public UserGroup deleteUserGroup(long userGroupId) throws PortalException {
		return userGroupPersistence.remove(userGroupId);
	}

	/**
	 * Deletes the user group from the database. Also notifies the appropriate model listeners.
	 *
	 * <p>
	 * <strong>Important:</strong> Inspect UserGroupLocalServiceImpl for overloaded versions of the method. If provided, use these entry points to the API, as the implementation logic may require the additional parameters defined there.
	 * </p>
	 *
	 * @param userGroup the user group
	 * @return the user group that was removed
	 * @throws PortalException
	 */
	@Indexable(type = IndexableType.DELETE)
	@Override
	public UserGroup deleteUserGroup(UserGroup userGroup)
		throws PortalException {

		return userGroupPersistence.remove(userGroup);
	}

	@Override
	public <T> T dslQuery(DSLQuery dslQuery) {
		return userGroupPersistence.dslQuery(dslQuery);
	}

	@Override
	public int dslQueryCount(DSLQuery dslQuery) {
		Long count = dslQuery(dslQuery);

		return count.intValue();
	}

	@Override
	public DynamicQuery dynamicQuery() {
		Class<?> clazz = getClass();

		return DynamicQueryFactoryUtil.forClass(
			UserGroup.class, clazz.getClassLoader());
	}

	/**
	 * Performs a dynamic query on the database and returns the matching rows.
	 *
	 * @param dynamicQuery the dynamic query
	 * @return the matching rows
	 */
	@Override
	public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery) {
		return userGroupPersistence.findWithDynamicQuery(dynamicQuery);
	}

	/**
	 * Performs a dynamic query on the database and returns a range of the matching rows.
	 *
	 * <p>
	 * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to <code>com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS</code> will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent, then the query will include the default ORDER BY logic from <code>com.liferay.portal.model.impl.UserGroupModelImpl</code>.
	 * </p>
	 *
	 * @param dynamicQuery the dynamic query
	 * @param start the lower bound of the range of model instances
	 * @param end the upper bound of the range of model instances (not inclusive)
	 * @return the range of matching rows
	 */
	@Override
	public <T> List<T> dynamicQuery(
		DynamicQuery dynamicQuery, int start, int end) {

		return userGroupPersistence.findWithDynamicQuery(
			dynamicQuery, start, end);
	}

	/**
	 * Performs a dynamic query on the database and returns an ordered range of the matching rows.
	 *
	 * <p>
	 * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to <code>com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS</code> will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent, then the query will include the default ORDER BY logic from <code>com.liferay.portal.model.impl.UserGroupModelImpl</code>.
	 * </p>
	 *
	 * @param dynamicQuery the dynamic query
	 * @param start the lower bound of the range of model instances
	 * @param end the upper bound of the range of model instances (not inclusive)
	 * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
	 * @return the ordered range of matching rows
	 */
	@Override
	public <T> List<T> dynamicQuery(
		DynamicQuery dynamicQuery, int start, int end,
		OrderByComparator<T> orderByComparator) {

		return userGroupPersistence.findWithDynamicQuery(
			dynamicQuery, start, end, orderByComparator);
	}

	/**
	 * Returns the number of rows matching the dynamic query.
	 *
	 * @param dynamicQuery the dynamic query
	 * @return the number of rows matching the dynamic query
	 */
	@Override
	public long dynamicQueryCount(DynamicQuery dynamicQuery) {
		return userGroupPersistence.countWithDynamicQuery(dynamicQuery);
	}

	/**
	 * Returns the number of rows matching the dynamic query.
	 *
	 * @param dynamicQuery the dynamic query
	 * @param projection the projection to apply to the query
	 * @return the number of rows matching the dynamic query
	 */
	@Override
	public long dynamicQueryCount(
		DynamicQuery dynamicQuery, Projection projection) {

		return userGroupPersistence.countWithDynamicQuery(
			dynamicQuery, projection);
	}

	@Override
	public UserGroup fetchUserGroup(long userGroupId) {
		return userGroupPersistence.fetchByPrimaryKey(userGroupId);
	}

	/**
	 * Returns the user group with the matching UUID and company.
	 *
	 * @param uuid the user group's UUID
	 * @param companyId the primary key of the company
	 * @return the matching user group, or <code>null</code> if a matching user group could not be found
	 */
	@Override
	public UserGroup fetchUserGroupByUuidAndCompanyId(
		String uuid, long companyId) {

		return userGroupPersistence.fetchByUuid_C_First(uuid, companyId, null);
	}

	/**
	 * Returns the user group with the matching external reference code and company.
	 *
	 * @param companyId the primary key of the company
	 * @param externalReferenceCode the user group's external reference code
	 * @return the matching user group, or <code>null</code> if a matching user group could not be found
	 */
	@Override
	public UserGroup fetchUserGroupByExternalReferenceCode(
		long companyId, String externalReferenceCode) {

		return userGroupPersistence.fetchByC_ERC(
			companyId, externalReferenceCode);
	}

	/**
	 * @deprecated As of Cavanaugh (7.4.x), replaced by {@link #fetchUserGroupByExternalReferenceCode(long, String)}
	 */
	@Deprecated
	@Override
	public UserGroup fetchUserGroupByReferenceCode(
		long companyId, String externalReferenceCode) {

		return fetchUserGroupByExternalReferenceCode(
			companyId, externalReferenceCode);
	}

	/**
	 * Returns the user group with the matching external reference code and company.
	 *
	 * @param companyId the primary key of the company
	 * @param externalReferenceCode the user group's external reference code
	 * @return the matching user group
	 * @throws PortalException if a matching user group could not be found
	 */
	@Override
	public UserGroup getUserGroupByExternalReferenceCode(
			long companyId, String externalReferenceCode)
		throws PortalException {

		return userGroupPersistence.findByC_ERC(
			companyId, externalReferenceCode);
	}

	/**
	 * Returns the user group with the primary key.
	 *
	 * @param userGroupId the primary key of the user group
	 * @return the user group
	 * @throws PortalException if a user group with the primary key could not be found
	 */
	@Override
	public UserGroup getUserGroup(long userGroupId) throws PortalException {
		return userGroupPersistence.findByPrimaryKey(userGroupId);
	}

	@Override
	public ActionableDynamicQuery getActionableDynamicQuery() {
		ActionableDynamicQuery actionableDynamicQuery =
			new DefaultActionableDynamicQuery();

		actionableDynamicQuery.setBaseLocalService(userGroupLocalService);
		actionableDynamicQuery.setClassLoader(getClassLoader());
		actionableDynamicQuery.setModelClass(UserGroup.class);

		actionableDynamicQuery.setPrimaryKeyPropertyName("userGroupId");

		return actionableDynamicQuery;
	}

	@Override
	public IndexableActionableDynamicQuery
		getIndexableActionableDynamicQuery() {

		IndexableActionableDynamicQuery indexableActionableDynamicQuery =
			new IndexableActionableDynamicQuery();

		indexableActionableDynamicQuery.setBaseLocalService(
			userGroupLocalService);
		indexableActionableDynamicQuery.setClassLoader(getClassLoader());
		indexableActionableDynamicQuery.setModelClass(UserGroup.class);

		indexableActionableDynamicQuery.setPrimaryKeyPropertyName(
			"userGroupId");

		return indexableActionableDynamicQuery;
	}

	protected void initActionableDynamicQuery(
		ActionableDynamicQuery actionableDynamicQuery) {

		actionableDynamicQuery.setBaseLocalService(userGroupLocalService);
		actionableDynamicQuery.setClassLoader(getClassLoader());
		actionableDynamicQuery.setModelClass(UserGroup.class);

		actionableDynamicQuery.setPrimaryKeyPropertyName("userGroupId");
	}

	@Override
	public ExportActionableDynamicQuery getExportActionableDynamicQuery(
		final PortletDataContext portletDataContext) {

		final ExportActionableDynamicQuery exportActionableDynamicQuery =
			new ExportActionableDynamicQuery() {

				@Override
				public long performCount() throws PortalException {
					ManifestSummary manifestSummary =
						portletDataContext.getManifestSummary();

					StagedModelType stagedModelType = getStagedModelType();

					long modelAdditionCount = super.performCount();

					manifestSummary.addModelAdditionCount(
						stagedModelType, modelAdditionCount);

					long modelDeletionCount =
						ExportImportHelperUtil.getModelDeletionCount(
							portletDataContext, stagedModelType);

					manifestSummary.addModelDeletionCount(
						stagedModelType, modelDeletionCount);

					return modelAdditionCount;
				}

			};

		initActionableDynamicQuery(exportActionableDynamicQuery);

		exportActionableDynamicQuery.setAddCriteriaMethod(
			new ActionableDynamicQuery.AddCriteriaMethod() {

				@Override
				public void addCriteria(DynamicQuery dynamicQuery) {
					portletDataContext.addDateRangeCriteria(
						dynamicQuery, "modifiedDate");
				}

			});

		exportActionableDynamicQuery.setCompanyId(
			portletDataContext.getCompanyId());

		exportActionableDynamicQuery.setPerformActionMethod(
			new ActionableDynamicQuery.PerformActionMethod<UserGroup>() {

				@Override
				public void performAction(UserGroup userGroup)
					throws PortalException {

					StagedModelDataHandlerUtil.exportStagedModel(
						portletDataContext, userGroup);
				}

			});
		exportActionableDynamicQuery.setStagedModelType(
			new StagedModelType(
				PortalUtil.getClassNameId(UserGroup.class.getName())));

		return exportActionableDynamicQuery;
	}

	/**
	 * @throws PortalException
	 */
	@Override
	public PersistedModel createPersistedModel(Serializable primaryKeyObj)
		throws PortalException {

		return userGroupPersistence.create(((Long)primaryKeyObj).longValue());
	}

	/**
	 * @throws PortalException
	 */
	@Override
	public PersistedModel deletePersistedModel(PersistedModel persistedModel)
		throws PortalException {

		return userGroupLocalService.deleteUserGroup((UserGroup)persistedModel);
	}

	@Override
	public BasePersistence<UserGroup> getBasePersistence() {
		return userGroupPersistence;
	}

	/**
	 * @throws PortalException
	 */
	@Override
	public PersistedModel getPersistedModel(Serializable primaryKeyObj)
		throws PortalException {

		return userGroupPersistence.findByPrimaryKey(primaryKeyObj);
	}

	/**
	 * Returns the user group with the matching UUID and company.
	 *
	 * @param uuid the user group's UUID
	 * @param companyId the primary key of the company
	 * @return the matching user group
	 * @throws PortalException if a matching user group could not be found
	 */
	@Override
	public UserGroup getUserGroupByUuidAndCompanyId(String uuid, long companyId)
		throws PortalException {

		return userGroupPersistence.findByUuid_C_First(uuid, companyId, null);
	}

	/**
	 * Returns a range of all the user groups.
	 *
	 * <p>
	 * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to <code>com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS</code> will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent, then the query will include the default ORDER BY logic from <code>com.liferay.portal.model.impl.UserGroupModelImpl</code>.
	 * </p>
	 *
	 * @param start the lower bound of the range of user groups
	 * @param end the upper bound of the range of user groups (not inclusive)
	 * @return the range of user groups
	 */
	@Override
	public List<UserGroup> getUserGroups(int start, int end) {
		return userGroupPersistence.findAll(start, end);
	}

	/**
	 * Returns the number of user groups.
	 *
	 * @return the number of user groups
	 */
	@Override
	public int getUserGroupsCount() {
		return userGroupPersistence.countAll();
	}

	/**
	 * Updates the user group in the database or adds it if it does not yet exist. Also notifies the appropriate model listeners.
	 *
	 * <p>
	 * <strong>Important:</strong> Inspect UserGroupLocalServiceImpl for overloaded versions of the method. If provided, use these entry points to the API, as the implementation logic may require the additional parameters defined there.
	 * </p>
	 *
	 * @param userGroup the user group
	 * @return the user group that was updated
	 */
	@Indexable(type = IndexableType.REINDEX)
	@Override
	public UserGroup updateUserGroup(UserGroup userGroup) {
		return userGroupPersistence.update(userGroup);
	}

	/**
	 */
	@Override
	public void addGroupUserGroup(long groupId, long userGroupId) {
		groupPersistence.addUserGroup(groupId, userGroupId);
	}

	/**
	 */
	@Override
	public void addGroupUserGroup(long groupId, UserGroup userGroup) {
		groupPersistence.addUserGroup(groupId, userGroup);
	}

	/**
	 */
	@Override
	public void addGroupUserGroups(long groupId, long[] userGroupIds) {
		groupPersistence.addUserGroups(groupId, userGroupIds);
	}

	/**
	 */
	@Override
	public void addGroupUserGroups(long groupId, List<UserGroup> userGroups) {
		groupPersistence.addUserGroups(groupId, userGroups);
	}

	/**
	 */
	@Override
	public void clearGroupUserGroups(long groupId) {
		groupPersistence.clearUserGroups(groupId);
	}

	/**
	 */
	@Override
	public void deleteGroupUserGroup(long groupId, long userGroupId) {
		groupPersistence.removeUserGroup(groupId, userGroupId);
	}

	/**
	 */
	@Override
	public void deleteGroupUserGroup(long groupId, UserGroup userGroup) {
		groupPersistence.removeUserGroup(groupId, userGroup);
	}

	/**
	 */
	@Override
	public void deleteGroupUserGroups(long groupId, long[] userGroupIds) {
		groupPersistence.removeUserGroups(groupId, userGroupIds);
	}

	/**
	 */
	@Override
	public void deleteGroupUserGroups(
		long groupId, List<UserGroup> userGroups) {

		groupPersistence.removeUserGroups(groupId, userGroups);
	}

	/**
	 * Returns the groupIds of the groups associated with the user group.
	 *
	 * @param userGroupId the userGroupId of the user group
	 * @return long[] the groupIds of groups associated with the user group
	 */
	@Override
	public long[] getGroupPrimaryKeys(long userGroupId) {
		return userGroupPersistence.getGroupPrimaryKeys(userGroupId);
	}

	/**
	 */
	@Override
	public List<UserGroup> getGroupUserGroups(long groupId) {
		return groupPersistence.getUserGroups(groupId);
	}

	/**
	 */
	@Override
	public List<UserGroup> getGroupUserGroups(
		long groupId, int start, int end) {

		return groupPersistence.getUserGroups(groupId, start, end);
	}

	/**
	 */
	@Override
	public List<UserGroup> getGroupUserGroups(
		long groupId, int start, int end,
		OrderByComparator<UserGroup> orderByComparator) {

		return groupPersistence.getUserGroups(
			groupId, start, end, orderByComparator);
	}

	/**
	 */
	@Override
	public int getGroupUserGroupsCount(long groupId) {
		return groupPersistence.getUserGroupsSize(groupId);
	}

	/**
	 */
	@Override
	public boolean hasGroupUserGroup(long groupId, long userGroupId) {
		return groupPersistence.containsUserGroup(groupId, userGroupId);
	}

	/**
	 */
	@Override
	public boolean hasGroupUserGroups(long groupId) {
		return groupPersistence.containsUserGroups(groupId);
	}

	/**
	 */
	@Override
	public void setGroupUserGroups(long groupId, long[] userGroupIds) {
		groupPersistence.setUserGroups(groupId, userGroupIds);
	}

	/**
	 */
	@Override
	public void addTeamUserGroup(long teamId, long userGroupId) {
		teamPersistence.addUserGroup(teamId, userGroupId);
	}

	/**
	 */
	@Override
	public void addTeamUserGroup(long teamId, UserGroup userGroup) {
		teamPersistence.addUserGroup(teamId, userGroup);
	}

	/**
	 */
	@Override
	public void addTeamUserGroups(long teamId, long[] userGroupIds) {
		teamPersistence.addUserGroups(teamId, userGroupIds);
	}

	/**
	 */
	@Override
	public void addTeamUserGroups(long teamId, List<UserGroup> userGroups) {
		teamPersistence.addUserGroups(teamId, userGroups);
	}

	/**
	 */
	@Override
	public void clearTeamUserGroups(long teamId) {
		teamPersistence.clearUserGroups(teamId);
	}

	/**
	 */
	@Override
	public void deleteTeamUserGroup(long teamId, long userGroupId) {
		teamPersistence.removeUserGroup(teamId, userGroupId);
	}

	/**
	 */
	@Override
	public void deleteTeamUserGroup(long teamId, UserGroup userGroup) {
		teamPersistence.removeUserGroup(teamId, userGroup);
	}

	/**
	 */
	@Override
	public void deleteTeamUserGroups(long teamId, long[] userGroupIds) {
		teamPersistence.removeUserGroups(teamId, userGroupIds);
	}

	/**
	 */
	@Override
	public void deleteTeamUserGroups(long teamId, List<UserGroup> userGroups) {
		teamPersistence.removeUserGroups(teamId, userGroups);
	}

	/**
	 * Returns the teamIds of the teams associated with the user group.
	 *
	 * @param userGroupId the userGroupId of the user group
	 * @return long[] the teamIds of teams associated with the user group
	 */
	@Override
	public long[] getTeamPrimaryKeys(long userGroupId) {
		return userGroupPersistence.getTeamPrimaryKeys(userGroupId);
	}

	/**
	 */
	@Override
	public List<UserGroup> getTeamUserGroups(long teamId) {
		return teamPersistence.getUserGroups(teamId);
	}

	/**
	 */
	@Override
	public List<UserGroup> getTeamUserGroups(long teamId, int start, int end) {
		return teamPersistence.getUserGroups(teamId, start, end);
	}

	/**
	 */
	@Override
	public List<UserGroup> getTeamUserGroups(
		long teamId, int start, int end,
		OrderByComparator<UserGroup> orderByComparator) {

		return teamPersistence.getUserGroups(
			teamId, start, end, orderByComparator);
	}

	/**
	 */
	@Override
	public int getTeamUserGroupsCount(long teamId) {
		return teamPersistence.getUserGroupsSize(teamId);
	}

	/**
	 */
	@Override
	public boolean hasTeamUserGroup(long teamId, long userGroupId) {
		return teamPersistence.containsUserGroup(teamId, userGroupId);
	}

	/**
	 */
	@Override
	public boolean hasTeamUserGroups(long teamId) {
		return teamPersistence.containsUserGroups(teamId);
	}

	/**
	 */
	@Override
	public void setTeamUserGroups(long teamId, long[] userGroupIds) {
		teamPersistence.setUserGroups(teamId, userGroupIds);
	}

	/**
	 */
	@Override
	public void addUserUserGroup(long userId, long userGroupId) {
		userPersistence.addUserGroup(userId, userGroupId);
	}

	/**
	 */
	@Override
	public void addUserUserGroup(long userId, UserGroup userGroup) {
		userPersistence.addUserGroup(userId, userGroup);
	}

	/**
	 */
	@Override
	public void addUserUserGroups(long userId, long[] userGroupIds) {
		userPersistence.addUserGroups(userId, userGroupIds);
	}

	/**
	 */
	@Override
	public void addUserUserGroups(long userId, List<UserGroup> userGroups) {
		userPersistence.addUserGroups(userId, userGroups);
	}

	/**
	 */
	@Override
	public void clearUserUserGroups(long userId) {
		userPersistence.clearUserGroups(userId);
	}

	/**
	 */
	@Override
	public void deleteUserUserGroup(long userId, long userGroupId) {
		userPersistence.removeUserGroup(userId, userGroupId);
	}

	/**
	 */
	@Override
	public void deleteUserUserGroup(long userId, UserGroup userGroup) {
		userPersistence.removeUserGroup(userId, userGroup);
	}

	/**
	 */
	@Override
	public void deleteUserUserGroups(long userId, long[] userGroupIds) {
		userPersistence.removeUserGroups(userId, userGroupIds);
	}

	/**
	 */
	@Override
	public void deleteUserUserGroups(long userId, List<UserGroup> userGroups) {
		userPersistence.removeUserGroups(userId, userGroups);
	}

	/**
	 * Returns the userIds of the users associated with the user group.
	 *
	 * @param userGroupId the userGroupId of the user group
	 * @return long[] the userIds of users associated with the user group
	 */
	@Override
	public long[] getUserPrimaryKeys(long userGroupId) {
		return userGroupPersistence.getUserPrimaryKeys(userGroupId);
	}

	/**
	 */
	@Override
	public List<UserGroup> getUserUserGroups(long userId) {
		return userPersistence.getUserGroups(userId);
	}

	/**
	 */
	@Override
	public List<UserGroup> getUserUserGroups(long userId, int start, int end) {
		return userPersistence.getUserGroups(userId, start, end);
	}

	/**
	 */
	@Override
	public List<UserGroup> getUserUserGroups(
		long userId, int start, int end,
		OrderByComparator<UserGroup> orderByComparator) {

		return userPersistence.getUserGroups(
			userId, start, end, orderByComparator);
	}

	/**
	 */
	@Override
	public int getUserUserGroupsCount(long userId) {
		return userPersistence.getUserGroupsSize(userId);
	}

	/**
	 */
	@Override
	public boolean hasUserUserGroup(long userId, long userGroupId) {
		return userPersistence.containsUserGroup(userId, userGroupId);
	}

	/**
	 */
	@Override
	public boolean hasUserUserGroups(long userId) {
		return userPersistence.containsUserGroups(userId);
	}

	/**
	 * @throws PortalException
	 */
	@Override
	public void setUserUserGroups(long userId, long[] userGroupIds)
		throws PortalException {

		userPersistence.setUserGroups(userId, userGroupIds);
	}

	/**
	 * Returns the user group local service.
	 *
	 * @return the user group local service
	 */
	public UserGroupLocalService getUserGroupLocalService() {
		return userGroupLocalService;
	}

	/**
	 * Sets the user group local service.
	 *
	 * @param userGroupLocalService the user group local service
	 */
	public void setUserGroupLocalService(
		UserGroupLocalService userGroupLocalService) {

		this.userGroupLocalService = userGroupLocalService;
	}

	/**
	 * Returns the user group persistence.
	 *
	 * @return the user group persistence
	 */
	public UserGroupPersistence getUserGroupPersistence() {
		return userGroupPersistence;
	}

	/**
	 * Sets the user group persistence.
	 *
	 * @param userGroupPersistence the user group persistence
	 */
	public void setUserGroupPersistence(
		UserGroupPersistence userGroupPersistence) {

		this.userGroupPersistence = userGroupPersistence;
	}

	/**
	 * Returns the user group finder.
	 *
	 * @return the user group finder
	 */
	public UserGroupFinder getUserGroupFinder() {
		return userGroupFinder;
	}

	/**
	 * Sets the user group finder.
	 *
	 * @param userGroupFinder the user group finder
	 */
	public void setUserGroupFinder(UserGroupFinder userGroupFinder) {
		this.userGroupFinder = userGroupFinder;
	}

	/**
	 * Returns the counter local service.
	 *
	 * @return the counter local service
	 */
	public com.liferay.counter.kernel.service.CounterLocalService
		getCounterLocalService() {

		return counterLocalService;
	}

	/**
	 * Sets the counter local service.
	 *
	 * @param counterLocalService the counter local service
	 */
	public void setCounterLocalService(
		com.liferay.counter.kernel.service.CounterLocalService
			counterLocalService) {

		this.counterLocalService = counterLocalService;
	}

	public void afterPropertiesSet() {
		persistedModelLocalServiceRegistry.register(
			"com.liferay.portal.kernel.model.UserGroup", userGroupLocalService);

		_setLocalServiceUtilService(userGroupLocalService);
	}

	public void destroy() {
		persistedModelLocalServiceRegistry.unregister(
			"com.liferay.portal.kernel.model.UserGroup");

		_setLocalServiceUtilService(null);
	}

	/**
	 * Returns the OSGi service identifier.
	 *
	 * @return the OSGi service identifier
	 */
	@Override
	public String getOSGiServiceIdentifier() {
		return UserGroupLocalService.class.getName();
	}

	@Override
	public CTPersistence<UserGroup> getCTPersistence() {
		return userGroupPersistence;
	}

	@Override
	public Class<UserGroup> getModelClass() {
		return UserGroup.class;
	}

	@Override
	public <R, E extends Throwable> R updateWithUnsafeFunction(
			UnsafeFunction<CTPersistence<UserGroup>, R, E> updateUnsafeFunction)
		throws E {

		return updateUnsafeFunction.apply(userGroupPersistence);
	}

	protected String getModelClassName() {
		return UserGroup.class.getName();
	}

	/**
	 * Performs a SQL query.
	 *
	 * @param sql the sql query
	 */
	protected void runSQL(String sql) {
		try {
			DataSource dataSource = userGroupPersistence.getDataSource();

			DB db = DBManagerUtil.getDB();

			sql = db.buildSQL(sql);
			sql = PortalUtil.transformSQL(sql);

			SqlUpdate sqlUpdate = SqlUpdateFactoryUtil.getSqlUpdate(
				dataSource, sql);

			sqlUpdate.update();
		}
		catch (Exception exception) {
			throw new SystemException(exception);
		}
	}

	private void _setLocalServiceUtilService(
		UserGroupLocalService userGroupLocalService) {

		try {
			Field field = UserGroupLocalServiceUtil.class.getDeclaredField(
				"_service");

			field.setAccessible(true);

			field.set(null, userGroupLocalService);
		}
		catch (ReflectiveOperationException reflectiveOperationException) {
			throw new RuntimeException(reflectiveOperationException);
		}
	}

	@BeanReference(type = UserGroupLocalService.class)
	protected UserGroupLocalService userGroupLocalService;

	@BeanReference(type = UserGroupPersistence.class)
	protected UserGroupPersistence userGroupPersistence;

	@BeanReference(type = UserGroupFinder.class)
	protected UserGroupFinder userGroupFinder;

	@BeanReference(
		type = com.liferay.counter.kernel.service.CounterLocalService.class
	)
	protected com.liferay.counter.kernel.service.CounterLocalService
		counterLocalService;

	@BeanReference(type = GroupPersistence.class)
	protected GroupPersistence groupPersistence;

	@BeanReference(type = TeamPersistence.class)
	protected TeamPersistence teamPersistence;

	@BeanReference(type = UserPersistence.class)
	protected UserPersistence userPersistence;

	@BeanReference(type = PersistedModelLocalServiceRegistry.class)
	protected PersistedModelLocalServiceRegistry
		persistedModelLocalServiceRegistry;

}