/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.portal.kernel.xuggler;

import com.liferay.portal.kernel.exception.PortalException;

/**
 * @author Andrew Betts
 * @deprecated As of Cavanaugh (7.4.x), with no direct replacement
 */
@Deprecated
public class XugglerInstallException extends PortalException {

	public static class MustBeURLClassLoader extends XugglerInstallException {

		public MustBeURLClassLoader() {
			super(
				"Unable to install JAR because the portal class loader is " +
					"not an instance of URLClassLoader");
		}

	}

	public static class MustInstallJar extends XugglerInstallException {

		public MustInstallJar(String name, Throwable throwable) {
			super("Unable to install jar " + name, throwable);
		}

	}

	private XugglerInstallException(String message) {
		super(message);
	}

	private XugglerInstallException(String message, Throwable throwable) {
		super(message, throwable);
	}

}