/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.portal.kernel.model;

import org.osgi.annotation.versioning.ProviderType;

/**
 * The base model interface for the PasswordPolicyRel service. Represents a row in the &quot;PasswordPolicyRel&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This interface and its corresponding implementation <code>com.liferay.portal.model.impl.PasswordPolicyRelModelImpl</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in <code>com.liferay.portal.model.impl.PasswordPolicyRelImpl</code>.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see PasswordPolicyRel
 * @generated
 */
@ProviderType
public interface PasswordPolicyRelModel
	extends AttachedModel, BaseModel<PasswordPolicyRel>, MVCCModel,
			ShardedModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this interface directly. All methods that expect a password policy rel model instance should use the {@link PasswordPolicyRel} interface instead.
	 */

	/**
	 * Returns the primary key of this password policy rel.
	 *
	 * @return the primary key of this password policy rel
	 */
	public long getPrimaryKey();

	/**
	 * Sets the primary key of this password policy rel.
	 *
	 * @param primaryKey the primary key of this password policy rel
	 */
	public void setPrimaryKey(long primaryKey);

	/**
	 * Returns the mvcc version of this password policy rel.
	 *
	 * @return the mvcc version of this password policy rel
	 */
	@Override
	public long getMvccVersion();

	/**
	 * Sets the mvcc version of this password policy rel.
	 *
	 * @param mvccVersion the mvcc version of this password policy rel
	 */
	@Override
	public void setMvccVersion(long mvccVersion);

	/**
	 * Returns the password policy rel ID of this password policy rel.
	 *
	 * @return the password policy rel ID of this password policy rel
	 */
	public long getPasswordPolicyRelId();

	/**
	 * Sets the password policy rel ID of this password policy rel.
	 *
	 * @param passwordPolicyRelId the password policy rel ID of this password policy rel
	 */
	public void setPasswordPolicyRelId(long passwordPolicyRelId);

	/**
	 * Returns the company ID of this password policy rel.
	 *
	 * @return the company ID of this password policy rel
	 */
	@Override
	public long getCompanyId();

	/**
	 * Sets the company ID of this password policy rel.
	 *
	 * @param companyId the company ID of this password policy rel
	 */
	@Override
	public void setCompanyId(long companyId);

	/**
	 * Returns the password policy ID of this password policy rel.
	 *
	 * @return the password policy ID of this password policy rel
	 */
	public long getPasswordPolicyId();

	/**
	 * Sets the password policy ID of this password policy rel.
	 *
	 * @param passwordPolicyId the password policy ID of this password policy rel
	 */
	public void setPasswordPolicyId(long passwordPolicyId);

	/**
	 * Returns the fully qualified class name of this password policy rel.
	 *
	 * @return the fully qualified class name of this password policy rel
	 */
	@Override
	public String getClassName();

	public void setClassName(String className);

	/**
	 * Returns the class name ID of this password policy rel.
	 *
	 * @return the class name ID of this password policy rel
	 */
	@Override
	public long getClassNameId();

	/**
	 * Sets the class name ID of this password policy rel.
	 *
	 * @param classNameId the class name ID of this password policy rel
	 */
	@Override
	public void setClassNameId(long classNameId);

	/**
	 * Returns the class pk of this password policy rel.
	 *
	 * @return the class pk of this password policy rel
	 */
	@Override
	public long getClassPK();

	/**
	 * Sets the class pk of this password policy rel.
	 *
	 * @param classPK the class pk of this password policy rel
	 */
	@Override
	public void setClassPK(long classPK);

	@Override
	public PasswordPolicyRel cloneWithOriginalValues();

}