/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.portal.kernel.model;

import com.liferay.portal.kernel.bean.AutoEscape;

import org.osgi.annotation.versioning.ProviderType;

/**
 * The base model interface for the CountryLocalization service. Represents a row in the &quot;CountryLocalization&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This interface and its corresponding implementation <code>com.liferay.portal.model.impl.CountryLocalizationModelImpl</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in <code>com.liferay.portal.model.impl.CountryLocalizationImpl</code>.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see CountryLocalization
 * @generated
 */
@ProviderType
public interface CountryLocalizationModel
	extends BaseModel<CountryLocalization>, MVCCModel, ShardedModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this interface directly. All methods that expect a country localization model instance should use the {@link CountryLocalization} interface instead.
	 */

	/**
	 * Returns the primary key of this country localization.
	 *
	 * @return the primary key of this country localization
	 */
	public long getPrimaryKey();

	/**
	 * Sets the primary key of this country localization.
	 *
	 * @param primaryKey the primary key of this country localization
	 */
	public void setPrimaryKey(long primaryKey);

	/**
	 * Returns the mvcc version of this country localization.
	 *
	 * @return the mvcc version of this country localization
	 */
	@Override
	public long getMvccVersion();

	/**
	 * Sets the mvcc version of this country localization.
	 *
	 * @param mvccVersion the mvcc version of this country localization
	 */
	@Override
	public void setMvccVersion(long mvccVersion);

	/**
	 * Returns the country localization ID of this country localization.
	 *
	 * @return the country localization ID of this country localization
	 */
	public long getCountryLocalizationId();

	/**
	 * Sets the country localization ID of this country localization.
	 *
	 * @param countryLocalizationId the country localization ID of this country localization
	 */
	public void setCountryLocalizationId(long countryLocalizationId);

	/**
	 * Returns the company ID of this country localization.
	 *
	 * @return the company ID of this country localization
	 */
	@Override
	public long getCompanyId();

	/**
	 * Sets the company ID of this country localization.
	 *
	 * @param companyId the company ID of this country localization
	 */
	@Override
	public void setCompanyId(long companyId);

	/**
	 * Returns the country ID of this country localization.
	 *
	 * @return the country ID of this country localization
	 */
	public long getCountryId();

	/**
	 * Sets the country ID of this country localization.
	 *
	 * @param countryId the country ID of this country localization
	 */
	public void setCountryId(long countryId);

	/**
	 * Returns the language ID of this country localization.
	 *
	 * @return the language ID of this country localization
	 */
	@AutoEscape
	public String getLanguageId();

	/**
	 * Sets the language ID of this country localization.
	 *
	 * @param languageId the language ID of this country localization
	 */
	public void setLanguageId(String languageId);

	/**
	 * Returns the title of this country localization.
	 *
	 * @return the title of this country localization
	 */
	@AutoEscape
	public String getTitle();

	/**
	 * Sets the title of this country localization.
	 *
	 * @param title the title of this country localization
	 */
	public void setTitle(String title);

	@Override
	public CountryLocalization cloneWithOriginalValues();

}