/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.dispatch.model;

import com.liferay.portal.kernel.bean.AutoEscape;
import com.liferay.portal.kernel.model.AuditedModel;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.MVCCModel;
import com.liferay.portal.kernel.model.ShardedModel;

import java.util.Date;

import org.osgi.annotation.versioning.ProviderType;

/**
 * The base model interface for the DispatchLog service. Represents a row in the &quot;DispatchLog&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This interface and its corresponding implementation <code>com.liferay.dispatch.model.impl.DispatchLogModelImpl</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in <code>com.liferay.dispatch.model.impl.DispatchLogImpl</code>.
 * </p>
 *
 * @author Matija Petanjek
 * @see DispatchLog
 * @generated
 */
@ProviderType
public interface DispatchLogModel
	extends AuditedModel, BaseModel<DispatchLog>, MVCCModel, ShardedModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this interface directly. All methods that expect a dispatch log model instance should use the {@link DispatchLog} interface instead.
	 */

	/**
	 * Returns the primary key of this dispatch log.
	 *
	 * @return the primary key of this dispatch log
	 */
	public long getPrimaryKey();

	/**
	 * Sets the primary key of this dispatch log.
	 *
	 * @param primaryKey the primary key of this dispatch log
	 */
	public void setPrimaryKey(long primaryKey);

	/**
	 * Returns the mvcc version of this dispatch log.
	 *
	 * @return the mvcc version of this dispatch log
	 */
	@Override
	public long getMvccVersion();

	/**
	 * Sets the mvcc version of this dispatch log.
	 *
	 * @param mvccVersion the mvcc version of this dispatch log
	 */
	@Override
	public void setMvccVersion(long mvccVersion);

	/**
	 * Returns the dispatch log ID of this dispatch log.
	 *
	 * @return the dispatch log ID of this dispatch log
	 */
	public long getDispatchLogId();

	/**
	 * Sets the dispatch log ID of this dispatch log.
	 *
	 * @param dispatchLogId the dispatch log ID of this dispatch log
	 */
	public void setDispatchLogId(long dispatchLogId);

	/**
	 * Returns the company ID of this dispatch log.
	 *
	 * @return the company ID of this dispatch log
	 */
	@Override
	public long getCompanyId();

	/**
	 * Sets the company ID of this dispatch log.
	 *
	 * @param companyId the company ID of this dispatch log
	 */
	@Override
	public void setCompanyId(long companyId);

	/**
	 * Returns the user ID of this dispatch log.
	 *
	 * @return the user ID of this dispatch log
	 */
	@Override
	public long getUserId();

	/**
	 * Sets the user ID of this dispatch log.
	 *
	 * @param userId the user ID of this dispatch log
	 */
	@Override
	public void setUserId(long userId);

	/**
	 * Returns the user uuid of this dispatch log.
	 *
	 * @return the user uuid of this dispatch log
	 */
	@Override
	public String getUserUuid();

	/**
	 * Sets the user uuid of this dispatch log.
	 *
	 * @param userUuid the user uuid of this dispatch log
	 */
	@Override
	public void setUserUuid(String userUuid);

	/**
	 * Returns the user name of this dispatch log.
	 *
	 * @return the user name of this dispatch log
	 */
	@AutoEscape
	@Override
	public String getUserName();

	/**
	 * Sets the user name of this dispatch log.
	 *
	 * @param userName the user name of this dispatch log
	 */
	@Override
	public void setUserName(String userName);

	/**
	 * Returns the create date of this dispatch log.
	 *
	 * @return the create date of this dispatch log
	 */
	@Override
	public Date getCreateDate();

	/**
	 * Sets the create date of this dispatch log.
	 *
	 * @param createDate the create date of this dispatch log
	 */
	@Override
	public void setCreateDate(Date createDate);

	/**
	 * Returns the modified date of this dispatch log.
	 *
	 * @return the modified date of this dispatch log
	 */
	@Override
	public Date getModifiedDate();

	/**
	 * Sets the modified date of this dispatch log.
	 *
	 * @param modifiedDate the modified date of this dispatch log
	 */
	@Override
	public void setModifiedDate(Date modifiedDate);

	/**
	 * Returns the dispatch trigger ID of this dispatch log.
	 *
	 * @return the dispatch trigger ID of this dispatch log
	 */
	public long getDispatchTriggerId();

	/**
	 * Sets the dispatch trigger ID of this dispatch log.
	 *
	 * @param dispatchTriggerId the dispatch trigger ID of this dispatch log
	 */
	public void setDispatchTriggerId(long dispatchTriggerId);

	/**
	 * Returns the end date of this dispatch log.
	 *
	 * @return the end date of this dispatch log
	 */
	public Date getEndDate();

	/**
	 * Sets the end date of this dispatch log.
	 *
	 * @param endDate the end date of this dispatch log
	 */
	public void setEndDate(Date endDate);

	/**
	 * Returns the error of this dispatch log.
	 *
	 * @return the error of this dispatch log
	 */
	@AutoEscape
	public String getError();

	/**
	 * Sets the error of this dispatch log.
	 *
	 * @param error the error of this dispatch log
	 */
	public void setError(String error);

	/**
	 * Returns the output of this dispatch log.
	 *
	 * @return the output of this dispatch log
	 */
	@AutoEscape
	public String getOutput();

	/**
	 * Sets the output of this dispatch log.
	 *
	 * @param output the output of this dispatch log
	 */
	public void setOutput(String output);

	/**
	 * Returns the start date of this dispatch log.
	 *
	 * @return the start date of this dispatch log
	 */
	public Date getStartDate();

	/**
	 * Sets the start date of this dispatch log.
	 *
	 * @param startDate the start date of this dispatch log
	 */
	public void setStartDate(Date startDate);

	/**
	 * Returns the status of this dispatch log.
	 *
	 * @return the status of this dispatch log
	 */
	public int getStatus();

	/**
	 * Sets the status of this dispatch log.
	 *
	 * @param status the status of this dispatch log
	 */
	public void setStatus(int status);

	@Override
	public DispatchLog cloneWithOriginalValues();

}