/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.commerce.shop.by.diagram.model;

import com.liferay.portal.kernel.bean.AutoEscape;
import com.liferay.portal.kernel.model.AuditedModel;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.ShardedModel;

import java.util.Date;

import org.osgi.annotation.versioning.ProviderType;

/**
 * The base model interface for the CPDefinitionDiagramPin service. Represents a row in the &quot;CPDefinitionDiagramPin&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This interface and its corresponding implementation <code>com.liferay.commerce.shop.by.diagram.model.impl.CPDefinitionDiagramPinModelImpl</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in <code>com.liferay.commerce.shop.by.diagram.model.impl.CPDefinitionDiagramPinImpl</code>.
 * </p>
 *
 * @author Andrea Sbarra
 * @see CPDefinitionDiagramPin
 * @generated
 */
@ProviderType
public interface CPDefinitionDiagramPinModel
	extends AuditedModel, BaseModel<CPDefinitionDiagramPin>, ShardedModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this interface directly. All methods that expect a cp definition diagram pin model instance should use the {@link CPDefinitionDiagramPin} interface instead.
	 */

	/**
	 * Returns the primary key of this cp definition diagram pin.
	 *
	 * @return the primary key of this cp definition diagram pin
	 */
	public long getPrimaryKey();

	/**
	 * Sets the primary key of this cp definition diagram pin.
	 *
	 * @param primaryKey the primary key of this cp definition diagram pin
	 */
	public void setPrimaryKey(long primaryKey);

	/**
	 * Returns the cp definition diagram pin ID of this cp definition diagram pin.
	 *
	 * @return the cp definition diagram pin ID of this cp definition diagram pin
	 */
	public long getCPDefinitionDiagramPinId();

	/**
	 * Sets the cp definition diagram pin ID of this cp definition diagram pin.
	 *
	 * @param CPDefinitionDiagramPinId the cp definition diagram pin ID of this cp definition diagram pin
	 */
	public void setCPDefinitionDiagramPinId(long CPDefinitionDiagramPinId);

	/**
	 * Returns the company ID of this cp definition diagram pin.
	 *
	 * @return the company ID of this cp definition diagram pin
	 */
	@Override
	public long getCompanyId();

	/**
	 * Sets the company ID of this cp definition diagram pin.
	 *
	 * @param companyId the company ID of this cp definition diagram pin
	 */
	@Override
	public void setCompanyId(long companyId);

	/**
	 * Returns the user ID of this cp definition diagram pin.
	 *
	 * @return the user ID of this cp definition diagram pin
	 */
	@Override
	public long getUserId();

	/**
	 * Sets the user ID of this cp definition diagram pin.
	 *
	 * @param userId the user ID of this cp definition diagram pin
	 */
	@Override
	public void setUserId(long userId);

	/**
	 * Returns the user uuid of this cp definition diagram pin.
	 *
	 * @return the user uuid of this cp definition diagram pin
	 */
	@Override
	public String getUserUuid();

	/**
	 * Sets the user uuid of this cp definition diagram pin.
	 *
	 * @param userUuid the user uuid of this cp definition diagram pin
	 */
	@Override
	public void setUserUuid(String userUuid);

	/**
	 * Returns the user name of this cp definition diagram pin.
	 *
	 * @return the user name of this cp definition diagram pin
	 */
	@AutoEscape
	@Override
	public String getUserName();

	/**
	 * Sets the user name of this cp definition diagram pin.
	 *
	 * @param userName the user name of this cp definition diagram pin
	 */
	@Override
	public void setUserName(String userName);

	/**
	 * Returns the create date of this cp definition diagram pin.
	 *
	 * @return the create date of this cp definition diagram pin
	 */
	@Override
	public Date getCreateDate();

	/**
	 * Sets the create date of this cp definition diagram pin.
	 *
	 * @param createDate the create date of this cp definition diagram pin
	 */
	@Override
	public void setCreateDate(Date createDate);

	/**
	 * Returns the modified date of this cp definition diagram pin.
	 *
	 * @return the modified date of this cp definition diagram pin
	 */
	@Override
	public Date getModifiedDate();

	/**
	 * Sets the modified date of this cp definition diagram pin.
	 *
	 * @param modifiedDate the modified date of this cp definition diagram pin
	 */
	@Override
	public void setModifiedDate(Date modifiedDate);

	/**
	 * Returns the cp definition ID of this cp definition diagram pin.
	 *
	 * @return the cp definition ID of this cp definition diagram pin
	 */
	public long getCPDefinitionId();

	/**
	 * Sets the cp definition ID of this cp definition diagram pin.
	 *
	 * @param CPDefinitionId the cp definition ID of this cp definition diagram pin
	 */
	public void setCPDefinitionId(long CPDefinitionId);

	/**
	 * Returns the number of this cp definition diagram pin.
	 *
	 * @return the number of this cp definition diagram pin
	 */
	public int getNumber();

	/**
	 * Sets the number of this cp definition diagram pin.
	 *
	 * @param number the number of this cp definition diagram pin
	 */
	public void setNumber(int number);

	/**
	 * Returns the position x of this cp definition diagram pin.
	 *
	 * @return the position x of this cp definition diagram pin
	 */
	public double getPositionX();

	/**
	 * Sets the position x of this cp definition diagram pin.
	 *
	 * @param positionX the position x of this cp definition diagram pin
	 */
	public void setPositionX(double positionX);

	/**
	 * Returns the position y of this cp definition diagram pin.
	 *
	 * @return the position y of this cp definition diagram pin
	 */
	public double getPositionY();

	/**
	 * Sets the position y of this cp definition diagram pin.
	 *
	 * @param positionY the position y of this cp definition diagram pin
	 */
	public void setPositionY(double positionY);

}