/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.commerce.shop.by.diagram.model;

import com.liferay.portal.kernel.bean.AutoEscape;
import com.liferay.portal.kernel.model.AuditedModel;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.ShardedModel;

import java.util.Date;

import org.osgi.annotation.versioning.ProviderType;

/**
 * The base model interface for the CPDefinitionDiagramEntry service. Represents a row in the &quot;CPDefinitionDiagramEntry&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This interface and its corresponding implementation <code>com.liferay.commerce.shop.by.diagram.model.impl.CPDefinitionDiagramEntryModelImpl</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in <code>com.liferay.commerce.shop.by.diagram.model.impl.CPDefinitionDiagramEntryImpl</code>.
 * </p>
 *
 * @author Andrea Sbarra
 * @see CPDefinitionDiagramEntry
 * @generated
 */
@ProviderType
public interface CPDefinitionDiagramEntryModel
	extends AuditedModel, BaseModel<CPDefinitionDiagramEntry>, ShardedModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this interface directly. All methods that expect a cp definition diagram entry model instance should use the {@link CPDefinitionDiagramEntry} interface instead.
	 */

	/**
	 * Returns the primary key of this cp definition diagram entry.
	 *
	 * @return the primary key of this cp definition diagram entry
	 */
	public long getPrimaryKey();

	/**
	 * Sets the primary key of this cp definition diagram entry.
	 *
	 * @param primaryKey the primary key of this cp definition diagram entry
	 */
	public void setPrimaryKey(long primaryKey);

	/**
	 * Returns the cp definition diagram entry ID of this cp definition diagram entry.
	 *
	 * @return the cp definition diagram entry ID of this cp definition diagram entry
	 */
	public long getCPDefinitionDiagramEntryId();

	/**
	 * Sets the cp definition diagram entry ID of this cp definition diagram entry.
	 *
	 * @param CPDefinitionDiagramEntryId the cp definition diagram entry ID of this cp definition diagram entry
	 */
	public void setCPDefinitionDiagramEntryId(long CPDefinitionDiagramEntryId);

	/**
	 * Returns the company ID of this cp definition diagram entry.
	 *
	 * @return the company ID of this cp definition diagram entry
	 */
	@Override
	public long getCompanyId();

	/**
	 * Sets the company ID of this cp definition diagram entry.
	 *
	 * @param companyId the company ID of this cp definition diagram entry
	 */
	@Override
	public void setCompanyId(long companyId);

	/**
	 * Returns the user ID of this cp definition diagram entry.
	 *
	 * @return the user ID of this cp definition diagram entry
	 */
	@Override
	public long getUserId();

	/**
	 * Sets the user ID of this cp definition diagram entry.
	 *
	 * @param userId the user ID of this cp definition diagram entry
	 */
	@Override
	public void setUserId(long userId);

	/**
	 * Returns the user uuid of this cp definition diagram entry.
	 *
	 * @return the user uuid of this cp definition diagram entry
	 */
	@Override
	public String getUserUuid();

	/**
	 * Sets the user uuid of this cp definition diagram entry.
	 *
	 * @param userUuid the user uuid of this cp definition diagram entry
	 */
	@Override
	public void setUserUuid(String userUuid);

	/**
	 * Returns the user name of this cp definition diagram entry.
	 *
	 * @return the user name of this cp definition diagram entry
	 */
	@AutoEscape
	@Override
	public String getUserName();

	/**
	 * Sets the user name of this cp definition diagram entry.
	 *
	 * @param userName the user name of this cp definition diagram entry
	 */
	@Override
	public void setUserName(String userName);

	/**
	 * Returns the create date of this cp definition diagram entry.
	 *
	 * @return the create date of this cp definition diagram entry
	 */
	@Override
	public Date getCreateDate();

	/**
	 * Sets the create date of this cp definition diagram entry.
	 *
	 * @param createDate the create date of this cp definition diagram entry
	 */
	@Override
	public void setCreateDate(Date createDate);

	/**
	 * Returns the modified date of this cp definition diagram entry.
	 *
	 * @return the modified date of this cp definition diagram entry
	 */
	@Override
	public Date getModifiedDate();

	/**
	 * Sets the modified date of this cp definition diagram entry.
	 *
	 * @param modifiedDate the modified date of this cp definition diagram entry
	 */
	@Override
	public void setModifiedDate(Date modifiedDate);

	/**
	 * Returns the cp definition ID of this cp definition diagram entry.
	 *
	 * @return the cp definition ID of this cp definition diagram entry
	 */
	public long getCPDefinitionId();

	/**
	 * Sets the cp definition ID of this cp definition diagram entry.
	 *
	 * @param CPDefinitionId the cp definition ID of this cp definition diagram entry
	 */
	public void setCPDefinitionId(long CPDefinitionId);

	/**
	 * Returns the cp instance uuid of this cp definition diagram entry.
	 *
	 * @return the cp instance uuid of this cp definition diagram entry
	 */
	@AutoEscape
	public String getCPInstanceUuid();

	/**
	 * Sets the cp instance uuid of this cp definition diagram entry.
	 *
	 * @param CPInstanceUuid the cp instance uuid of this cp definition diagram entry
	 */
	public void setCPInstanceUuid(String CPInstanceUuid);

	/**
	 * Returns the c product ID of this cp definition diagram entry.
	 *
	 * @return the c product ID of this cp definition diagram entry
	 */
	public long getCProductId();

	/**
	 * Sets the c product ID of this cp definition diagram entry.
	 *
	 * @param CProductId the c product ID of this cp definition diagram entry
	 */
	public void setCProductId(long CProductId);

	/**
	 * Returns the diagram of this cp definition diagram entry.
	 *
	 * @return the diagram of this cp definition diagram entry
	 */
	public boolean getDiagram();

	/**
	 * Returns <code>true</code> if this cp definition diagram entry is diagram.
	 *
	 * @return <code>true</code> if this cp definition diagram entry is diagram; <code>false</code> otherwise
	 */
	public boolean isDiagram();

	/**
	 * Sets whether this cp definition diagram entry is diagram.
	 *
	 * @param diagram the diagram of this cp definition diagram entry
	 */
	public void setDiagram(boolean diagram);

	/**
	 * Returns the number of this cp definition diagram entry.
	 *
	 * @return the number of this cp definition diagram entry
	 */
	public int getNumber();

	/**
	 * Sets the number of this cp definition diagram entry.
	 *
	 * @param number the number of this cp definition diagram entry
	 */
	public void setNumber(int number);

	/**
	 * Returns the quantity of this cp definition diagram entry.
	 *
	 * @return the quantity of this cp definition diagram entry
	 */
	public int getQuantity();

	/**
	 * Sets the quantity of this cp definition diagram entry.
	 *
	 * @param quantity the quantity of this cp definition diagram entry
	 */
	public void setQuantity(int quantity);

	/**
	 * Returns the sku of this cp definition diagram entry.
	 *
	 * @return the sku of this cp definition diagram entry
	 */
	@AutoEscape
	public String getSku();

	/**
	 * Sets the sku of this cp definition diagram entry.
	 *
	 * @param sku the sku of this cp definition diagram entry
	 */
	public void setSku(String sku);

}