/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.commerce.application.list.constants;

import com.liferay.application.list.constants.PanelCategoryKeys;

/**
 * @author Marco Leo
 * @author Alessio Antonio Rendina
 */
public class CommercePanelCategoryKeys {

	public static final String COMMERCE = PanelCategoryKeys.COMMERCE;

	public static final String COMMERCE_INVENTORY_MANAGEMENT =
		"commerce.inventory_management";

	public static final String COMMERCE_ORDER_MANAGEMENT =
		"commerce.order_management";

	/**
	 * @deprecated As of Athanasius (7.3.x)
	 */
	@Deprecated
	public static final String COMMERCE_ORDERS_MANAGEMENT =
		COMMERCE_ORDER_MANAGEMENT;

	public static final String COMMERCE_PRICING = "commerce.pricing";

	public static final String COMMERCE_PRODUCT_MANAGEMENT =
		"commerce.product_management";

	public static final String COMMERCE_SETTINGS = "commerce.settings";

	public static final String COMMERCE_STORE_MANAGEMENT =
		"commerce.store_management";

}