Liferay.Loader.define("layout-taglib@5.3.26/select_layout/js/SelectLayout.es", ['module', 'exports', 'require', '@frontend-taglib-clay$clayui/button', '@frontend-taglib-clay$clayui/form', '@frontend-taglib-clay$clayui/layout', '@frontend-taglib-clay$clayui/management-toolbar', 'frontend-js-components-web', 'frontend-js-react-web$prop-types', 'frontend-js-react-web$react'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    function _typeof(obj) {
      "@babel/helpers - typeof";
      if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
        _typeof = function _typeof(obj) {
          return typeof obj;
        };
      } else {
        _typeof = function _typeof(obj) {
          return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
        };
      }return _typeof(obj);
    }

    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;

    var _button = require("@frontend-taglib-clay$clayui/button");

    var _form = require("@frontend-taglib-clay$clayui/form");

    var _layout = _interopRequireDefault(require("@frontend-taglib-clay$clayui/layout"));

    var _managementToolbar = _interopRequireDefault(require("@frontend-taglib-clay$clayui/management-toolbar"));

    var _frontendJsComponentsWeb = require("frontend-js-components-web");

    var _propTypes = _interopRequireDefault(require("frontend-js-react-web$prop-types"));

    var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

    function _getRequireWildcardCache() {
      if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
        return cache;
      };return cache;
    }

    function _interopRequireWildcard(obj) {
      if (obj && obj.__esModule) {
        return obj;
      }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
        return { default: obj };
      }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
        return cache.get(obj);
      }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
        if (Object.prototype.hasOwnProperty.call(obj, key)) {
          var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
            Object.defineProperty(newObj, key, desc);
          } else {
            newObj[key] = obj[key];
          }
        }
      }newObj.default = obj;if (cache) {
        cache.set(obj, newObj);
      }return newObj;
    }

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    function _slicedToArray(arr, i) {
      return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
    }

    function _nonIterableRest() {
      throw new TypeError("Invalid attempt to destructure non-iterable instance");
    }

    function _iterableToArrayLimit(arr, i) {
      if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) {
        return;
      }var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
        for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
          _arr.push(_s.value);if (i && _arr.length === i) break;
        }
      } catch (err) {
        _d = true;_e = err;
      } finally {
        try {
          if (!_n && _i["return"] != null) _i["return"]();
        } finally {
          if (_d) throw _e;
        }
      }return _arr;
    }

    function _arrayWithHoles(arr) {
      if (Array.isArray(arr)) return arr;
    }

    function visit(nodes, callback) {
      nodes.forEach(function (node) {
        callback(node);

        if (node.children) {
          visit(node.children, callback);
        }
      });
    }
    /**
     * SelectLayout
     *
     * This component shows a list of available layouts to select in expanded tree
     * and allows to filter them by searching.
     *
     * @review
     */

    var SelectLayout = function SelectLayout(_ref) {
      var followURLOnTitleClick = _ref.followURLOnTitleClick,
          itemSelectorSaveEvent = _ref.itemSelectorSaveEvent,
          multiSelection = _ref.multiSelection,
          namespace = _ref.namespace,
          nodes = _ref.nodes;

      var _useState = (0, _react.useState)(),
          _useState2 = _slicedToArray(_useState, 2),
          filterQuery = _useState2[0],
          setFilterQuery = _useState2[1];

      return (/*#__PURE__*/_react.default.createElement("div", {
          className: "select-layout"
        }, /*#__PURE__*/_react.default.createElement(_managementToolbar.default, null, /*#__PURE__*/_react.default.createElement(_managementToolbar.default.Search, {
          onSubmit: function onSubmit(event) {
            event.preventDefault();
          }
        }, /*#__PURE__*/_react.default.createElement(_form.ClayInput.Group, null, /*#__PURE__*/_react.default.createElement(_form.ClayInput.GroupItem, null, /*#__PURE__*/_react.default.createElement(_form.ClayInput, {
          className: "form-control input-group-inset input-group-inset-after",
          name: "".concat(namespace, "filterKeywords"),
          onInput: function onInput(event) {
            setFilterQuery(event.target.value.toLowerCase());
          },
          placeholder: Liferay.Language.get('search-for'),
          type: "text"
        }), /*#__PURE__*/_react.default.createElement(_form.ClayInput.GroupInsetItem, {
          after: true,
          tag: "span"
        }, /*#__PURE__*/_react.default.createElement(_button.ClayButtonWithIcon, {
          className: "navbar-breakpoint-d-none",
          displayType: "unstyled",
          symbol: "times"
        }), /*#__PURE__*/_react.default.createElement(_button.ClayButtonWithIcon, {
          className: "navbar-breakpoint-d-block",
          displayType: "unstyled",
          symbol: "search"
        })))))), /*#__PURE__*/_react.default.createElement(_layout.default.ContainerFluid, {
          className: "layouts-selector",
          id: "".concat(namespace, "selectLayoutFm")
        }, /*#__PURE__*/_react.default.createElement("fieldset", {
          className: "panel-body"
        }, /*#__PURE__*/_react.default.createElement("div", {
          className: "layout-tree",
          id: "".concat(namespace, "layoutContainer")
        }, /*#__PURE__*/_react.default.createElement(_frontendJsComponentsWeb.Treeview, {
          NodeComponent: _frontendJsComponentsWeb.Treeview.Card,
          filterQuery: filterQuery,
          multiSelection: multiSelection,
          nodes: nodes,
          onSelectedNodesChange: function handleSelectionChange(selectedNodeIds) {
            if (!selectedNodeIds.size) {
              return;
            }

            var data = [];
            visit(nodes, function (node) {
              if (selectedNodeIds.has(node.id)) {
                data.push({
                  groupId: node.groupId,
                  id: node.id,
                  layoutId: node.layoutId,
                  name: node.value,
                  privateLayout: node.privateLayout,
                  value: node.url
                });
              }
            });

            if (!multiSelection) {
              data = data[0];
            }

            if (followURLOnTitleClick) {
              Liferay.Util.getOpener().document.location.href = data.url;
            } else {
              Liferay.fire(itemSelectorSaveEvent, {
                data: data
              });
              Liferay.Util.getOpener().Liferay.fire(itemSelectorSaveEvent, {
                data: data
              });
            }
          }
        })))))
      );
    };

    var _default = SelectLayout;
    exports.default = _default;
    //# sourceMappingURL=SelectLayout.es.js.map
  }
});
//# sourceMappingURL=SelectLayout.es.js.map