Liferay.Loader.define("ratings-taglib@2.1.11/js/components/RatingsSelectStars", ['module', 'exports', 'require', '@frontend-taglib-clay$clayui/button', '@frontend-taglib-clay$clayui/drop-down', '@frontend-taglib-clay$clayui/icon', '@frontend-taglib-clay$clayui/layout', '@frontend-taglib-clay$clayui/tooltip', 'frontend-js-react-web$react', '../utils/lang'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    function _typeof(obj) {
      "@babel/helpers - typeof";
      if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
        _typeof = function _typeof(obj) {
          return typeof obj;
        };
      } else {
        _typeof = function _typeof(obj) {
          return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
        };
      }return _typeof(obj);
    }

    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = RatingsSelectStars;

    var _button = _interopRequireDefault(require("@frontend-taglib-clay$clayui/button"));

    var _dropDown = _interopRequireDefault(require("@frontend-taglib-clay$clayui/drop-down"));

    var _icon = _interopRequireDefault(require("@frontend-taglib-clay$clayui/icon"));

    var _layout = _interopRequireDefault(require("@frontend-taglib-clay$clayui/layout"));

    var _tooltip = require("@frontend-taglib-clay$clayui/tooltip");

    var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

    var _lang = _interopRequireDefault(require("../utils/lang"));

    function _getRequireWildcardCache() {
      if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
        return cache;
      };return cache;
    }

    function _interopRequireWildcard(obj) {
      if (obj && obj.__esModule) {
        return obj;
      }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
        return { default: obj };
      }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
        return cache.get(obj);
      }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
        if (Object.prototype.hasOwnProperty.call(obj, key)) {
          var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
            Object.defineProperty(newObj, key, desc);
          } else {
            newObj[key] = obj[key];
          }
        }
      }newObj.default = obj;if (cache) {
        cache.set(obj, newObj);
      }return newObj;
    }

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    function _slicedToArray(arr, i) {
      return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
    }

    function _nonIterableRest() {
      throw new TypeError("Invalid attempt to destructure non-iterable instance");
    }

    function _iterableToArrayLimit(arr, i) {
      if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) {
        return;
      }var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
        for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
          _arr.push(_s.value);if (i && _arr.length === i) break;
        }
      } catch (err) {
        _d = true;_e = err;
      } finally {
        try {
          if (!_n && _i["return"] != null) _i["return"]();
        } finally {
          if (_d) throw _e;
        }
      }return _arr;
    }

    function _arrayWithHoles(arr) {
      if (Array.isArray(arr)) return arr;
    }

    function RatingsSelectStars(_ref) {
      var averageScore = _ref.averageScore,
          disabled = _ref.disabled,
          getSrAverageMessage = _ref.getSrAverageMessage,
          getTitle = _ref.getTitle,
          numberOfStars = _ref.numberOfStars,
          onVote = _ref.onVote,
          score = _ref.score,
          starScores = _ref.starScores,
          totalEntries = _ref.totalEntries;

      var _useState = (0, _react.useState)(false),
          _useState2 = _slicedToArray(_useState, 2),
          isDropdownOpen = _useState2[0],
          setIsDropdownOpen = _useState2[1];

      var handleOnClick = function handleOnClick(index) {
        setIsDropdownOpen(false);
        onVote(index);
      };

      return (/*#__PURE__*/_react.default.createElement(_tooltip.ClayTooltipProvider, null, /*#__PURE__*/_react.default.createElement(_layout.default.ContentRow, {
          className: "ratings-stars",
          noGutters: true,
          verticalAlign: "center"
        }, /*#__PURE__*/_react.default.createElement(_layout.default.ContentCol, null, /*#__PURE__*/_react.default.createElement(_dropDown.default, {
          active: isDropdownOpen,
          menuElementAttrs: {
            className: 'ratings-stars-dropdown'
          },
          onActiveChange: function onActiveChange(isActive) {
            return setIsDropdownOpen(isActive);
          },
          trigger: /*#__PURE__*/_react.default.createElement(_button.default, {
            "aria-pressed": !!score,
            borderless: true,
            className: "ratings-stars-dropdown-toggle",
            disabled: disabled,
            displayType: "secondary",
            small: true,
            title: getTitle(),
            value: score
          }, /*#__PURE__*/_react.default.createElement("span", {
            className: "inline-item inline-item-before"
          }, /*#__PURE__*/_react.default.createElement(_icon.default, {
            symbol: score ? 'star' : 'star-o'
          })), /*#__PURE__*/_react.default.createElement("span", {
            className: "inline-item ratings-stars-button-text"
          }, score || '-'))
        }, /*#__PURE__*/_react.default.createElement(_dropDown.default.ItemList, null, starScores.map(function (_ref2, index) {
          var label = _ref2.label;
          var srMessage = index === 0 ? Liferay.Language.get('rate-this-x-star-out-of-x') : Liferay.Language.get('rate-this-x-stars-out-of-x');
          return (/*#__PURE__*/_react.default.createElement(_dropDown.default.Item, {
              active: label === score,
              key: index,
              onClick: function onClick() {
                handleOnClick(index);
              }
            }, label, /*#__PURE__*/_react.default.createElement("span", {
              className: "sr-only"
            }, _lang.default.sub(srMessage, [index + 1, numberOfStars])))
          );
        }), /*#__PURE__*/_react.default.createElement(_dropDown.default.Item, {
          disabled: score === 0,
          onClick: handleOnClick
        }, Liferay.Language.get('delete'))))), /*#__PURE__*/_react.default.createElement(_layout.default.ContentCol, null, /*#__PURE__*/_react.default.createElement("span", {
          className: "ratings-stars-average"
        }, /*#__PURE__*/_react.default.createElement("span", {
          className: "inline-item inline-item-before"
        }, /*#__PURE__*/_react.default.createElement(_icon.default, {
          className: "ratings-stars-average-icon",
          symbol: "star"
        })), /*#__PURE__*/_react.default.createElement("span", {
          className: "inline-item ratings-stars-average-text"
        }, averageScore.toFixed(1), !!totalEntries && " (".concat(totalEntries, " ").concat(totalEntries === 1 ? Liferay.Language.get('vote') : Liferay.Language.get('votes'), ")")), /*#__PURE__*/_react.default.createElement("span", {
          className: "sr-only"
        }, getSrAverageMessage())))))
      );
    }
    //# sourceMappingURL=RatingsSelectStars.js.map
  }
});
//# sourceMappingURL=RatingsSelectStars.js.map