Liferay.Loader.define("ratings-taglib@2.1.11/js/Ratings", ['module', 'exports', 'require', 'frontend-js-web', 'frontend-js-react-web$prop-types', 'frontend-js-react-web$react', './RATINGS_TYPES', './components/RatingsLike', './components/RatingsStars', './components/RatingsThumbs', './utils/toast'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    function _typeof(obj) {
      "@babel/helpers - typeof";
      if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
        _typeof = function _typeof(obj) {
          return typeof obj;
        };
      } else {
        _typeof = function _typeof(obj) {
          return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
        };
      }return _typeof(obj);
    }

    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;

    var _frontendJsWeb = require("frontend-js-web");

    var _propTypes = _interopRequireDefault(require("frontend-js-react-web$prop-types"));

    var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

    var _RATINGS_TYPES = _interopRequireDefault(require("./RATINGS_TYPES"));

    var _RatingsLike = _interopRequireDefault(require("./components/RatingsLike"));

    var _RatingsStars = _interopRequireDefault(require("./components/RatingsStars"));

    var _RatingsThumbs = _interopRequireDefault(require("./components/RatingsThumbs"));

    var _toast = require("./utils/toast");

    function _getRequireWildcardCache() {
      if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
        return cache;
      };return cache;
    }

    function _interopRequireWildcard(obj) {
      if (obj && obj.__esModule) {
        return obj;
      }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
        return { default: obj };
      }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
        return cache.get(obj);
      }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
        if (Object.prototype.hasOwnProperty.call(obj, key)) {
          var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
            Object.defineProperty(newObj, key, desc);
          } else {
            newObj[key] = obj[key];
          }
        }
      }newObj.default = obj;if (cache) {
        cache.set(obj, newObj);
      }return newObj;
    }

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    function _extends() {
      _extends = Object.assign || function (target) {
        for (var i = 1; i < arguments.length; i++) {
          var source = arguments[i];for (var key in source) {
            if (Object.prototype.hasOwnProperty.call(source, key)) {
              target[key] = source[key];
            }
          }
        }return target;
      };return _extends.apply(this, arguments);
    }

    function _defineProperty(obj, key, value) {
      if (key in obj) {
        Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
      } else {
        obj[key] = value;
      }return obj;
    }

    function _objectWithoutProperties(source, excluded) {
      if (source == null) return {};var target = _objectWithoutPropertiesLoose(source, excluded);var key, i;if (Object.getOwnPropertySymbols) {
        var sourceSymbolKeys = Object.getOwnPropertySymbols(source);for (i = 0; i < sourceSymbolKeys.length; i++) {
          key = sourceSymbolKeys[i];if (excluded.indexOf(key) >= 0) continue;if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue;target[key] = source[key];
        }
      }return target;
    }

    function _objectWithoutPropertiesLoose(source, excluded) {
      if (source == null) return {};var target = {};var sourceKeys = Object.keys(source);var key, i;for (i = 0; i < sourceKeys.length; i++) {
        key = sourceKeys[i];if (excluded.indexOf(key) >= 0) continue;target[key] = source[key];
      }return target;
    }

    var Ratings = function Ratings(_ref) {
      var _RatingsTypes;

      var className = _ref.className,
          classPK = _ref.classPK,
          _ref$enabled = _ref.enabled,
          enabled = _ref$enabled === void 0 ? false : _ref$enabled,
          _ref$inTrash = _ref.inTrash,
          inTrash = _ref$inTrash === void 0 ? false : _ref$inTrash,
          signedIn = _ref.signedIn,
          type = _ref.type,
          url = _ref.url,
          restProps = _objectWithoutProperties(_ref, ["className", "classPK", "enabled", "inTrash", "signedIn", "type", "url"]);

      var sendVoteRequest = (0, _react.useCallback)(function (score) {
        Liferay.fire('ratings:vote', {
          className: className,
          classPK: classPK,
          ratingType: type,
          score: score
        });
        var body = (0, _frontendJsWeb.objectToFormData)({
          className: className,
          classPK: classPK,
          p_auth: Liferay.authToken,
          p_l_id: themeDisplay.getPlid(),
          score: score
        });
        return (0, _frontendJsWeb.fetch)(url, {
          body: body,
          method: 'POST'
        }).then(function (response) {
          return response.json();
        }).catch(function () {
          (0, _toast.errorToast)();
        });
      }, [className, classPK, type, url]);
      var RatingsTypes = (_RatingsTypes = {}, _defineProperty(_RatingsTypes, _RATINGS_TYPES.default.LIKE, _RatingsLike.default), _defineProperty(_RatingsTypes, _RATINGS_TYPES.default.STARS, _RatingsStars.default), _defineProperty(_RatingsTypes, _RATINGS_TYPES.default.STACKED_STARS, _RatingsStars.default), _defineProperty(_RatingsTypes, _RATINGS_TYPES.default.THUMBS, _RatingsThumbs.default), _RatingsTypes);
      var RatingsComponent = RatingsTypes[type];
      return (/*#__PURE__*/_react.default.createElement(RatingsComponent, _extends({}, restProps, {
          disabled: !signedIn || !enabled,
          inititalTitle: function getDefaultTitle() {
            if (!signedIn) {
              return '';
            }

            if (inTrash) {
              return Liferay.Language.get('ratings-are-disabled-because-this-entry-is-in-the-recycle-bin');
            } else if (!enabled) {
              return Liferay.Language.get('ratings-are-disabled-in-staging');
            }
          }(),
          sendVoteRequest: sendVoteRequest,
          type: type
        }))
      );
    };

    var _default = Ratings;
    exports.default = _default;
    //# sourceMappingURL=Ratings.js.map
  }
});
//# sourceMappingURL=Ratings.js.map