Liferay.Loader.define("frontend-taglib-clay@6.3.11/data_set_display/utilities/modules", ['module', 'exports', 'require', 'frontend-js-react-web$react'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.getLiferayJsModule = getLiferayJsModule;
    exports.getFakeJsModule = getFakeJsModule;
    exports.getComponentByModuleURL = getComponentByModuleURL;
    exports.fetchedJsModules = exports.getJsModule = void 0;

    var _react = _interopRequireDefault(require("frontend-js-react-web$react"));

    var _Liferay$Loader;

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    function getLiferayJsModule(moduleURL) {
      return new Promise(function (resolve, reject) {
        Liferay.Loader.require(moduleURL, function (jsModule) {
          return resolve(jsModule.default || jsModule);
        }, function (error) {
          return reject(error);
        });
      });
    }

    function getFakeJsModule() {
      return new Promise(function (resolve) {
        setTimeout(function () {
          return resolve(function () {
            return (/*#__PURE__*/_react.default.createElement("div", {
                className: "custom-component"
              }, "fakely fetched component")
            );
          });
        }, 3000);
      });
    }

    var getJsModule = ((_Liferay$Loader = Liferay.Loader) === null || _Liferay$Loader === void 0 ? void 0 : _Liferay$Loader.require) ? getLiferayJsModule : getFakeJsModule;
    exports.getJsModule = getJsModule;
    var fetchedJsModules = [];
    exports.fetchedJsModules = fetchedJsModules;

    function getComponentByModuleURL(url) {
      return new Promise(function (resolve, reject) {
        var foundModule = fetchedJsModules.find(function (cr) {
          return cr.url === url;
        });

        if (foundModule) {
          resolve(foundModule.component);
        }

        return getJsModule(url).then(function (fetchedComponent) {
          fetchedJsModules.push({
            component: fetchedComponent,
            url: url
          });
          return resolve(fetchedComponent);
        }).catch(reject);
      });
    }
    //# sourceMappingURL=modules.js.map
  }
});
//# sourceMappingURL=modules.js.map