Liferay.Loader.define("frontend-taglib-clay@6.3.11/data_set_display/utilities/debounce", ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = debounce;

    /**
     * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
     *
     * This library is free software; you can redistribute it and/or modify it under
     * the terms of the GNU Lesser General Public License as published by the Free
     * Software Foundation; either version 2.1 of the License, or (at your option)
     * any later version.
     *
     * This library is distributed in the hope that it will be useful, but WITHOUT
     * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
     * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
     * details.
     */
    function debounce(func, wait, immediate) {
      var _arguments = arguments,
          _this = this;

      var timeout;
      return function () {
        var context = _this;
        var args = _arguments;

        var callNow = immediate && !timeout;
        clearTimeout(timeout);
        timeout = setTimeout(function later() {
          timeout = null;

          if (!immediate) {
            func.apply(context, args);
          }
        }, wait);

        if (callNow) {
          func.apply(context, args);
        }
      };
    }
    //# sourceMappingURL=debounce.js.map
  }
});
//# sourceMappingURL=debounce.js.map