Liferay.Loader.define("frontend-taglib-clay@6.3.11/data_set_display/management_bar/components/filters/DateRangeFilter", ['module', 'exports', 'require', '@frontend-taglib-clay$clayui/button', '@frontend-taglib-clay$clayui/drop-down', '@frontend-taglib-clay$clayui/form', 'frontend-taglib-clay$prop-types', 'frontend-js-react-web$react', '../../../utilities/dates'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    function _typeof(obj) {
      "@babel/helpers - typeof";
      if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
        _typeof = function _typeof(obj) {
          return typeof obj;
        };
      } else {
        _typeof = function _typeof(obj) {
          return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
        };
      }return _typeof(obj);
    }

    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;

    var _button = _interopRequireDefault(require("@frontend-taglib-clay$clayui/button"));

    var _dropDown = _interopRequireDefault(require("@frontend-taglib-clay$clayui/drop-down"));

    var _form = _interopRequireDefault(require("@frontend-taglib-clay$clayui/form"));

    var _propTypes = _interopRequireDefault(require("frontend-taglib-clay$prop-types"));

    var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

    var _dates = require("../../../utilities/dates");

    function _getRequireWildcardCache() {
      if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
        return cache;
      };return cache;
    }

    function _interopRequireWildcard(obj) {
      if (obj && obj.__esModule) {
        return obj;
      }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
        return { default: obj };
      }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
        return cache.get(obj);
      }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
        if (Object.prototype.hasOwnProperty.call(obj, key)) {
          var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
            Object.defineProperty(newObj, key, desc);
          } else {
            newObj[key] = obj[key];
          }
        }
      }newObj.default = obj;if (cache) {
        cache.set(obj, newObj);
      }return newObj;
    }

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    function _slicedToArray(arr, i) {
      return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
    }

    function _nonIterableRest() {
      throw new TypeError("Invalid attempt to destructure non-iterable instance");
    }

    function _iterableToArrayLimit(arr, i) {
      if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) {
        return;
      }var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
        for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
          _arr.push(_s.value);if (i && _arr.length === i) break;
        }
      } catch (err) {
        _d = true;_e = err;
      } finally {
        try {
          if (!_n && _i["return"] != null) _i["return"]();
        } finally {
          if (_d) throw _e;
        }
      }return _arr;
    }

    function _arrayWithHoles(arr) {
      if (Array.isArray(arr)) return arr;
    }

    function getOdataString(value, key) {
      if (value.from && value.to) {
        return "".concat(key, " ge ").concat((0, _dates.convertObjectDateToIsoString)(value.from, 'from'), ") and (").concat(key, " le ").concat((0, _dates.convertObjectDateToIsoString)(value.to, 'to'));
      }

      if (value.from) {
        return "".concat(key, " ge ").concat((0, _dates.convertObjectDateToIsoString)(value.from, 'from'));
      }

      if (value.to) {
        return "".concat(key, " le ").concat((0, _dates.convertObjectDateToIsoString)(value.to, 'to'));
      }
    }

    function DateRangeFilter(_ref) {
      var actions = _ref.actions,
          id = _ref.id,
          max = _ref.max,
          min = _ref.min,
          placeholder = _ref.placeholder,
          valueProp = _ref.value;

      var _useState = (0, _react.useState)(valueProp && valueProp.from && (0, _dates.formatDateObject)(valueProp.from)),
          _useState2 = _slicedToArray(_useState, 2),
          fromValue = _useState2[0],
          setFromValue = _useState2[1];

      var _useState3 = (0, _react.useState)(valueProp && valueProp.to && (0, _dates.formatDateObject)(valueProp.to)),
          _useState4 = _slicedToArray(_useState3, 2),
          toValue = _useState4[0],
          setToValue = _useState4[1];

      var actionType = 'edit';

      if (valueProp && !fromValue && !toValue) {
        actionType = 'delete';
      }

      if (!valueProp) {
        actionType = 'add';
      }

      var submitDisabled = true;

      if (actionType === 'delete' || (!valueProp || !valueProp.from) && fromValue || (!valueProp || !valueProp.to) && toValue || valueProp && valueProp.from && fromValue !== (0, _dates.formatDateObject)(valueProp.from) || valueProp && valueProp.to && toValue !== (0, _dates.formatDateObject)(valueProp.to)) {
        submitDisabled = false;
      }

      return (/*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_dropDown.default.Caption, null, /*#__PURE__*/_react.default.createElement("div", {
          className: "form-group"
        }, /*#__PURE__*/_react.default.createElement(_form.default.Group, {
          className: "form-group-sm"
        }, /*#__PURE__*/_react.default.createElement("label", {
          htmlFor: "from-".concat(id)
        }, Liferay.Language.get('from')), /*#__PURE__*/_react.default.createElement("input", {
          className: "form-control",
          id: "from-".concat(id),
          max: toValue || max && (0, _dates.formatDateObject)(max),
          min: min && (0, _dates.formatDateObject)(min),
          onChange: function onChange(e) {
            return setFromValue(e.target.value);
          },
          pattern: "\\d{4}-\\d{2}-\\d{2}",
          placeholder: placeholder || 'yyyy-mm-dd',
          type: "date",
          value: fromValue || ''
        })), /*#__PURE__*/_react.default.createElement(_form.default.Group, {
          className: "form-group-sm mt-2"
        }, /*#__PURE__*/_react.default.createElement("label", {
          htmlFor: "to-".concat(id)
        }, Liferay.Language.get('to')), /*#__PURE__*/_react.default.createElement("input", {
          className: "form-control",
          id: "to-".concat(id),
          max: max && (0, _dates.formatDateObject)(max),
          min: fromValue || min && (0, _dates.formatDateObject)(min),
          onChange: function onChange(e) {
            return setToValue(e.target.value);
          },
          pattern: "\\d{4}-\\d{2}-\\d{2}",
          placeholder: placeholder || 'yyyy-mm-dd',
          type: "date",
          value: toValue || ''
        })))), /*#__PURE__*/_react.default.createElement(_dropDown.default.Divider, null), /*#__PURE__*/_react.default.createElement(_dropDown.default.Caption, null, /*#__PURE__*/_react.default.createElement(_button.default, {
          disabled: submitDisabled,
          onClick: function onClick() {
            if (actionType === 'delete') {
              actions.updateFilterState(id);
            } else {
              var newValue = {
                from: fromValue ? (0, _dates.getDateFromDateString)(fromValue) : null,
                to: toValue ? (0, _dates.getDateFromDateString)(toValue) : null
              };
              actions.updateFilterState(id, newValue, (0, _dates.formatDateRangeObject)(newValue), getOdataString(newValue, id));
            }
          },
          small: true
        }, actionType === 'add' && Liferay.Language.get('add-filter'), actionType === 'edit' && Liferay.Language.get('edit-filter'), actionType === 'delete' && Liferay.Language.get('delete-filter'))))
      );
    }

    var _default = DateRangeFilter;
    exports.default = _default;
    //# sourceMappingURL=DateRangeFilter.js.map
  }
});
//# sourceMappingURL=DateRangeFilter.js.map