Liferay.Loader.define("frontend-taglib-clay@6.3.11/data_set_display/management_bar/components/filters/CheckboxesFilter", ['module', 'exports', 'require', '@frontend-taglib-clay$clayui/button', '@frontend-taglib-clay$clayui/drop-down', '@frontend-taglib-clay$clayui/form', 'frontend-taglib-clay$prop-types', 'frontend-js-react-web$react', '../../../utilities/index'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    function _typeof(obj) {
      "@babel/helpers - typeof";
      if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
        _typeof = function _typeof(obj) {
          return typeof obj;
        };
      } else {
        _typeof = function _typeof(obj) {
          return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
        };
      }return _typeof(obj);
    }

    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = exports.formatValue = void 0;

    var _button = _interopRequireDefault(require("@frontend-taglib-clay$clayui/button"));

    var _dropDown = _interopRequireDefault(require("@frontend-taglib-clay$clayui/drop-down"));

    var _form = require("@frontend-taglib-clay$clayui/form");

    var _propTypes = _interopRequireDefault(require("frontend-taglib-clay$prop-types"));

    var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

    var _index = require("../../../utilities/index");

    function _getRequireWildcardCache() {
      if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
        return cache;
      };return cache;
    }

    function _interopRequireWildcard(obj) {
      if (obj && obj.__esModule) {
        return obj;
      }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
        return { default: obj };
      }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
        return cache.get(obj);
      }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
        if (Object.prototype.hasOwnProperty.call(obj, key)) {
          var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
            Object.defineProperty(newObj, key, desc);
          } else {
            newObj[key] = obj[key];
          }
        }
      }newObj.default = obj;if (cache) {
        cache.set(obj, newObj);
      }return newObj;
    }

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    function _slicedToArray(arr, i) {
      return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
    }

    function _nonIterableRest() {
      throw new TypeError("Invalid attempt to destructure non-iterable instance");
    }

    function _iterableToArrayLimit(arr, i) {
      if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) {
        return;
      }var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
        for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
          _arr.push(_s.value);if (i && _arr.length === i) break;
        }
      } catch (err) {
        _d = true;_e = err;
      } finally {
        try {
          if (!_n && _i["return"] != null) _i["return"]();
        } finally {
          if (_d) throw _e;
        }
      }return _arr;
    }

    function _arrayWithHoles(arr) {
      if (Array.isArray(arr)) return arr;
    }

    var formatValue = function formatValue(values, items, exclude) {
      var formattedValue = values ? values.map(function (value) {
        return items.reduce(function (found, item) {
          return found || (item.value === value ? item.label : null);
        }, null);
      }).join(', ') : '';
      return (exclude ? "(".concat(Liferay.Language.get('exclude'), ") ") : '') + formattedValue;
    };

    exports.formatValue = formatValue;

    function getOdataString(values, key) {
      var exclude = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;

      if (values === null || values === void 0 ? void 0 : values.length) {
        return "".concat(key, "/any(x:").concat(values.map(function (value) {
          return "(x ".concat(exclude ? 'ne' : 'eq', " ").concat(typeof value === 'string' ? "'".concat(value, "'") : value, ")");
        }).join(exclude ? ' and ' : ' or '), ")");
      }

      return null;
    }

    function CheckboxesFilter(_ref) {
      var actions = _ref.actions,
          id = _ref.id,
          items = _ref.items,
          valueProp = _ref.value;

      var _useState = (0, _react.useState)(valueProp && valueProp.itemsValues || []),
          _useState2 = _slicedToArray(_useState, 2),
          itemsValues = _useState2[0],
          setItemsValues = _useState2[1];

      var _useState3 = (0, _react.useState)(valueProp ? valueProp.exclude : false),
          _useState4 = _slicedToArray(_useState3, 2),
          exclude = _useState4[0],
          setExclude = _useState4[1];

      function selectCheckbox(selected) {
        if (itemsValues.includes(selected)) {
          return setItemsValues(itemsValues.filter(function (value) {
            return value !== selected;
          }));
        }

        return setItemsValues(itemsValues.concat(selected));
      }

      (0, _react.useEffect)(function () {
        setItemsValues(valueProp ? valueProp.itemsValues : []);
        setExclude(valueProp ? valueProp.exclude : false);
      }, [valueProp]);
      var actionType = 'edit';

      if ((valueProp === null || valueProp === void 0 ? void 0 : valueProp.itemsValues) && !itemsValues.length) {
        actionType = 'delete';
      }

      if (!valueProp) {
        actionType = 'add';
      }

      var submitDisabled = true;

      if (actionType === 'delete' || !valueProp && itemsValues.length || valueProp && (0, _index.isValuesArrayChanged)(valueProp.itemsValues, itemsValues) || valueProp && itemsValues.length && valueProp.exclude !== exclude) {
        submitDisabled = false;
      }

      return (/*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_dropDown.default.Caption, {
          className: "pb-0"
        }, /*#__PURE__*/_react.default.createElement("div", {
          className: "row"
        }, /*#__PURE__*/_react.default.createElement("div", {
          className: "col"
        }, /*#__PURE__*/_react.default.createElement("label", {
          htmlFor: "autocomplete-exclude-".concat(id)
        }, Liferay.Language.get('exclude'))), /*#__PURE__*/_react.default.createElement("div", {
          className: "col-auto"
        }, /*#__PURE__*/_react.default.createElement(_form.ClayToggle, {
          id: "autocomplete-exclude-".concat(id),
          onToggle: function onToggle() {
            return setExclude(!exclude);
          },
          toggled: exclude
        })))), /*#__PURE__*/_react.default.createElement(_dropDown.default.Divider, null), /*#__PURE__*/_react.default.createElement(_dropDown.default.Caption, null, /*#__PURE__*/_react.default.createElement("div", {
          className: "inline-scroller mb-n2 mx-n2 px-2"
        }, items.map(function (item, i) {
          var checked = false;

          if (itemsValues) {
            checked = itemsValues.reduce(function (acc, el) {
              return acc || el === item.value;
            }, false);
          }

          return (/*#__PURE__*/_react.default.createElement(_form.ClayCheckbox, {
              "aria-label": item.label,
              checked: checked,
              key: i,
              label: item.label,
              onChange: function onChange() {
                return selectCheckbox(item.value);
              }
            })
          );
        }))), /*#__PURE__*/_react.default.createElement(_dropDown.default.Divider, null), /*#__PURE__*/_react.default.createElement(_dropDown.default.Caption, null, /*#__PURE__*/_react.default.createElement(_button.default, {
          disabled: submitDisabled,
          onClick: function onClick() {
            return actionType !== 'delete' ? actions.updateFilterState(id, {
              exclude: exclude,
              itemsValues: itemsValues
            }, formatValue(itemsValues, items, exclude), getOdataString(itemsValues, id, exclude)) : actions.updateFilterState(id);
          },
          small: true
        }, actionType === 'add' && Liferay.Language.get('add-filter'), actionType === 'edit' && Liferay.Language.get('edit-filter'), actionType === 'delete' && Liferay.Language.get('delete-filter'))))
      );
    }

    var _default = CheckboxesFilter;
    exports.default = _default;
    //# sourceMappingURL=CheckboxesFilter.js.map
  }
});
//# sourceMappingURL=CheckboxesFilter.js.map