Liferay.Loader.define("frontend-taglib-clay@6.3.11/data_set_display/management_bar/components/ActiveFiltersBar", ['module', 'exports', 'require', '@frontend-taglib-clay$clayui/button', 'frontend-taglib-clay$prop-types', 'frontend-js-react-web$react', './Context', './FilterResume'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;

    var _button = _interopRequireDefault(require("@frontend-taglib-clay$clayui/button"));

    var _propTypes = _interopRequireDefault(require("frontend-taglib-clay$prop-types"));

    var _react = _interopRequireDefault(require("frontend-js-react-web$react"));

    var _Context = require("./Context");

    var _FilterResume = _interopRequireDefault(require("./FilterResume"));

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    function _extends() {
      _extends = Object.assign || function (target) {
        for (var i = 1; i < arguments.length; i++) {
          var source = arguments[i];for (var key in source) {
            if (Object.prototype.hasOwnProperty.call(source, key)) {
              target[key] = source[key];
            }
          }
        }return target;
      };return _extends.apply(this, arguments);
    }

    function ActiveFiltersBar(_ref) {
      var disabled = _ref.disabled;

      var _useAppState = (0, _Context.useAppState)(),
          actions = _useAppState.actions,
          state = _useAppState.state;

      var filtersActive = state.filters.reduce(function (acc, filter) {
        return filter.value && !filter.invisible ? acc.concat(filter.id) : acc;
      }, []);
      return filtersActive.length ? /*#__PURE__*/_react.default.createElement("div", {
        className: "management-bar management-bar-light navbar navbar-expand-md"
      }, /*#__PURE__*/_react.default.createElement("div", {
        className: "container-fluid container-fluid-max-xl"
      }, /*#__PURE__*/_react.default.createElement("nav", {
        className: "mb-0 py-3 subnav-tbar subnav-tbar-light subnav-tbar-primary w-100"
      }, /*#__PURE__*/_react.default.createElement("ul", {
        className: "tbar-nav"
      }, /*#__PURE__*/_react.default.createElement("li", {
        className: "p-0 tbar-item tbar-item-expand"
      }, /*#__PURE__*/_react.default.createElement("div", {
        className: "tbar-section"
      }, filtersActive.map(function (id) {
        var filter = state.filters.reduce(function (found, filter) {
          return found || (filter.id === id ? filter : null);
        }, null);

        if (!filter) {
          throw new Error("Filter \"".concat(id, "\" not found."));
        }

        return (/*#__PURE__*/_react.default.createElement(_FilterResume.default, _extends({
            disabled: disabled,
            key: filter.id
          }, filter))
        );
      }))), /*#__PURE__*/_react.default.createElement("li", {
        className: "tbar-item"
      }, /*#__PURE__*/_react.default.createElement("div", {
        className: "tbar-section"
      }, /*#__PURE__*/_react.default.createElement(_button.default, {
        disabled: disabled,
        displayType: "unstyled",
        onClick: actions.resetFiltersValue
      }, Liferay.Language.get('reset-filters')))))))) : null;
    }

    var _default = ActiveFiltersBar;
    exports.default = _default;
    //# sourceMappingURL=ActiveFiltersBar.js.map
  }
});
//# sourceMappingURL=ActiveFiltersBar.js.map