Liferay.Loader.define("frontend-taglib-clay@6.3.11/data_set_display/data_renderers/ActionLinkRenderer", ['module', 'exports', 'require', '@frontend-taglib-clay$clayui/icon', '@frontend-taglib-clay$clayui/link', 'frontend-js-web', 'frontend-taglib-clay$prop-types', 'frontend-js-react-web$react', '../DataSetDisplayContext', '../utilities/index', './DefaultRenderer'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    function _typeof(obj) {
      "@babel/helpers - typeof";
      if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
        _typeof = function _typeof(obj) {
          return typeof obj;
        };
      } else {
        _typeof = function _typeof(obj) {
          return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
        };
      }return _typeof(obj);
    }

    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;

    var _icon = _interopRequireDefault(require("@frontend-taglib-clay$clayui/icon"));

    var _link = _interopRequireDefault(require("@frontend-taglib-clay$clayui/link"));

    var _frontendJsWeb = require("frontend-js-web");

    var _propTypes = _interopRequireDefault(require("frontend-taglib-clay$prop-types"));

    var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

    var _DataSetDisplayContext = _interopRequireDefault(require("../DataSetDisplayContext"));

    var _index = require("../utilities/index");

    var _DefaultRenderer = _interopRequireDefault(require("./DefaultRenderer"));

    function _getRequireWildcardCache() {
      if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
        return cache;
      };return cache;
    }

    function _interopRequireWildcard(obj) {
      if (obj && obj.__esModule) {
        return obj;
      }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
        return { default: obj };
      }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
        return cache.get(obj);
      }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
        if (Object.prototype.hasOwnProperty.call(obj, key)) {
          var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
            Object.defineProperty(newObj, key, desc);
          } else {
            newObj[key] = obj[key];
          }
        }
      }newObj.default = obj;if (cache) {
        cache.set(obj, newObj);
      }return newObj;
    }

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    function ownKeys(object, enumerableOnly) {
      var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
        var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
          return Object.getOwnPropertyDescriptor(object, sym).enumerable;
        });keys.push.apply(keys, symbols);
      }return keys;
    }

    function _objectSpread(target) {
      for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
          ownKeys(Object(source), true).forEach(function (key) {
            _defineProperty(target, key, source[key]);
          });
        } else if (Object.getOwnPropertyDescriptors) {
          Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
        } else {
          ownKeys(Object(source)).forEach(function (key) {
            Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
          });
        }
      }return target;
    }

    function _defineProperty(obj, key, value) {
      if (key in obj) {
        Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
      } else {
        obj[key] = value;
      }return obj;
    }

    function ActionLinkRenderer(_ref) {
      var _currentAction$data;

      var actions = _ref.actions,
          itemData = _ref.itemData,
          itemId = _ref.itemId,
          options = _ref.options,
          value = _ref.value;

      var _useContext = (0, _react.useContext)(_DataSetDisplayContext.default),
          executeAsyncItemAction = _useContext.executeAsyncItemAction,
          highlightItems = _useContext.highlightItems,
          openModal = _useContext.openModal,
          openSidePanel = _useContext.openSidePanel;

      if (!actions || !actions.length) {
        return value ? /*#__PURE__*/_react.default.createElement(_DefaultRenderer.default, {
          value: value
        }) : null;
      }

      var currentAction = (options === null || options === void 0 ? void 0 : options.actionId) ? actions.find(function (action) {
        return action.id === options.actionId;
      }) : actions[0];

      if (!currentAction) {
        return null;
      }

      if ((_currentAction$data = currentAction.data) === null || _currentAction$data === void 0 ? void 0 : _currentAction$data.permissionKey) {
        if (itemData.actions[currentAction.data.permissionKey]) {
          if (currentAction.target === 'headless') {
            var _currentAction$method, _currentAction$data2;

            currentAction = _objectSpread(_objectSpread(_objectSpread({}, currentAction), itemData.actions[currentAction.data.id]), {}, {
              method: (_currentAction$method = currentAction.method) !== null && _currentAction$method !== void 0 ? _currentAction$method : (_currentAction$data2 = currentAction.data) === null || _currentAction$data2 === void 0 ? void 0 : _currentAction$data2.method
            });
          }
        } else {
          return value ? /*#__PURE__*/_react.default.createElement(_DefaultRenderer.default, {
            value: value
          }) : null;
        }
      }

      var formattedHref = currentAction.href && (0, _index.formatActionURL)(currentAction.href, itemData);

      function handleClickOnLink(event) {
        if (currentAction.target === 'modal') {
          event.preventDefault();
          openModal({
            size: currentAction.size || 'lg',
            title: currentAction.title,
            url: formattedHref
          });
        } else if (currentAction.target === 'sidePanel') {
          event.preventDefault();
          highlightItems([itemId]);
          openSidePanel({
            size: currentAction.size || 'lg',
            title: currentAction.title,
            url: formattedHref
          });
        } else if (currentAction.target === 'async' || currentAction.target === 'headless') {
          event.preventDefault();
          executeAsyncItemAction(formattedHref, currentAction.method).then(function () {
            var _currentAction$data3;

            (0, _frontendJsWeb.openToast)({
              message: ((_currentAction$data3 = currentAction.data) === null || _currentAction$data3 === void 0 ? void 0 : _currentAction$data3.successMessage) || Liferay.Language.get('action-completed'),
              type: 'success'
            });
          });
        } else if (currentAction.onClick) {
          event.preventDefault();
          event.target.setAttribute('onClick', currentAction.onClick);
          event.target.onclick();
          event.target.removeAttribute('onClick');
        }
      }

      function isNotALink() {
        return Boolean(currentAction.target && currentAction.target !== 'link' || currentAction.onClick);
      }

      return (/*#__PURE__*/_react.default.createElement("div", {
          className: "table-list-title"
        }, /*#__PURE__*/_react.default.createElement(_link.default, {
          "data-senna-off": true,
          href: formattedHref || '#',
          onClick: isNotALink() ? handleClickOnLink : null
        }, value || /*#__PURE__*/_react.default.createElement(_icon.default, {
          symbol: currentAction.icon
        })))
      );
    }

    var _default = ActionLinkRenderer;
    exports.default = _default;
    //# sourceMappingURL=ActionLinkRenderer.js.map
  }
});
//# sourceMappingURL=ActionLinkRenderer.js.map