Liferay.Loader.define("data-engine-taglib@2.5.24/data_layout_builder/js/hooks/useHeightTransition.es", ['module', 'exports', 'require', 'frontend-js-react-web$react'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;

    var _react = require("frontend-js-react-web$react");

    function _slicedToArray(arr, i) {
      return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
    }

    function _nonIterableRest() {
      throw new TypeError("Invalid attempt to destructure non-iterable instance");
    }

    function _iterableToArrayLimit(arr, i) {
      if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) {
        return;
      }var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
        for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
          _arr.push(_s.value);if (i && _arr.length === i) break;
        }
      } catch (err) {
        _d = true;_e = err;
      } finally {
        try {
          if (!_n && _i["return"] != null) _i["return"]();
        } finally {
          if (_d) throw _e;
        }
      }return _arr;
    }

    function _arrayWithHoles(arr) {
      if (Array.isArray(arr)) return arr;
    }

    var removeCollapseHeight = function removeCollapseHeight(collapseElementRef) {
      if (collapseElementRef && collapseElementRef.current) {
        collapseElementRef.current.style.removeProperty('height');
      }
    };

    var setCollapseHeight = function setCollapseHeight(collapseElementRef) {
      if (collapseElementRef && collapseElementRef.current) {
        var height = Array.prototype.slice.call(collapseElementRef.current.children).reduce(function (acc, child) {
          return acc + child.clientHeight;
        }, 0);
        collapseElementRef.current.setAttribute('style', "height: ".concat(height, "px"));
      }
    };

    var _default = function _default(visible, setVisible, contentRef) {
      var _useState = (0, _react.useState)(false),
          _useState2 = _slicedToArray(_useState, 2),
          transitioning = _useState2[0],
          setTransitioning = _useState2[1];

      (0, _react.useEffect)(function () {
        if (transitioning) {
          setCollapseHeight(contentRef);

          if (visible) {
            removeCollapseHeight(contentRef);
          }
        }
      }, [contentRef, transitioning, visible]);

      return [transitioning, function handleTransitionEnd(event) {
        if (event.target === contentRef.current && transitioning && !visible) {
          setVisible(true);
          setTransitioning(false);
          removeCollapseHeight(contentRef);
        } else if (event.target === contentRef.current) {
          setVisible(false);
          setTransitioning(false);
        }
      }, function startTransition(event) {
        event.preventDefault();

        if (visible && !transitioning) {
          setCollapseHeight(contentRef);
        }

        if (!transitioning) {
          setTransitioning(true);
        }
      }];
    };

    exports.default = _default;
    //# sourceMappingURL=useHeightTransition.es.js.map
  }
});
//# sourceMappingURL=useHeightTransition.es.js.map