Liferay.Loader.define("data-engine-taglib@2.5.24/data_layout_builder/js/components/translation-manager/TranslationManager.es", ['module', 'exports', 'require', '@frontend-taglib-clay$clayui/button', '@frontend-taglib-clay$clayui/drop-down', '@frontend-taglib-clay$clayui/icon', 'frontend-js-react-web$classnames', 'frontend-js-react-web$react'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    function _typeof(obj) {
      "@babel/helpers - typeof";
      if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
        _typeof = function _typeof(obj) {
          return typeof obj;
        };
      } else {
        _typeof = function _typeof(obj) {
          return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
        };
      }return _typeof(obj);
    }

    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = exports.TranslationManagerLabel = exports.formatIcon = exports.formatLabel = void 0;

    var _button = _interopRequireDefault(require("@frontend-taglib-clay$clayui/button"));

    var _dropDown = _interopRequireDefault(require("@frontend-taglib-clay$clayui/drop-down"));

    var _icon = _interopRequireDefault(require("@frontend-taglib-clay$clayui/icon"));

    var _classnames = _interopRequireDefault(require("frontend-js-react-web$classnames"));

    var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

    function _getRequireWildcardCache() {
      if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
        return cache;
      };return cache;
    }

    function _interopRequireWildcard(obj) {
      if (obj && obj.__esModule) {
        return obj;
      }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
        return { default: obj };
      }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
        return cache.get(obj);
      }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
        if (Object.prototype.hasOwnProperty.call(obj, key)) {
          var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
            Object.defineProperty(newObj, key, desc);
          } else {
            newObj[key] = obj[key];
          }
        }
      }newObj.default = obj;if (cache) {
        cache.set(obj, newObj);
      }return newObj;
    }

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    function _defineProperty(obj, key, value) {
      if (key in obj) {
        Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
      } else {
        obj[key] = value;
      }return obj;
    }

    function _slicedToArray(arr, i) {
      return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
    }

    function _nonIterableRest() {
      throw new TypeError("Invalid attempt to destructure non-iterable instance");
    }

    function _iterableToArrayLimit(arr, i) {
      if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) {
        return;
      }var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
        for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
          _arr.push(_s.value);if (i && _arr.length === i) break;
        }
      } catch (err) {
        _d = true;_e = err;
      } finally {
        try {
          if (!_n && _i["return"] != null) _i["return"]();
        } finally {
          if (_d) throw _e;
        }
      }return _arr;
    }

    function _arrayWithHoles(arr) {
      if (Array.isArray(arr)) return arr;
    }

    var formatLabel = function formatLabel(label) {
      return label.replace('_', '-');
    };

    exports.formatLabel = formatLabel;

    var formatIcon = function formatIcon(label) {
      return formatLabel(label).toLowerCase();
    };

    exports.formatIcon = formatIcon;

    var TranslationManagerLabel = function TranslationManagerLabel(_ref) {
      var defaultLanguageId = _ref.defaultLanguageId,
          languageId = _ref.languageId,
          translatedLanguageIds = _ref.translatedLanguageIds;
      var className = 'label-warning';
      var label = Liferay.Language.get('not-translated');

      if (languageId === defaultLanguageId) {
        className = 'label-info';
        label = Liferay.Language.get('default');
      } else if (translatedLanguageIds[languageId]) {
        className = 'label-success';
        label = Liferay.Language.get('translated');
      }

      return (/*#__PURE__*/_react.default.createElement("span", {
          className: "autofit-col"
        }, /*#__PURE__*/_react.default.createElement("span", {
          className: (0, _classnames.default)('label', className)
        }, /*#__PURE__*/_react.default.createElement("span", {
          className: "label-item label-item-expand"
        }, label)))
      );
    };

    exports.TranslationManagerLabel = TranslationManagerLabel;

    var _default = function _default(_ref2) {
      var availableLanguageIds = _ref2.availableLanguageIds,
          defaultLanguageId = _ref2.defaultLanguageId,
          editingLanguageId = _ref2.editingLanguageId,
          _ref2$onActiveChange = _ref2.onActiveChange,
          onActiveChange = _ref2$onActiveChange === void 0 ? function () {} : _ref2$onActiveChange,
          onEditingLanguageIdChange = _ref2.onEditingLanguageIdChange,
          _ref2$showUserView = _ref2.showUserView,
          showUserView = _ref2$showUserView === void 0 ? false : _ref2$showUserView,
          translatedLanguageIds = _ref2.translatedLanguageIds,
          className = _ref2.className;

      var _useState = (0, _react.useState)(false),
          _useState2 = _slicedToArray(_useState, 2),
          active = _useState2[0],
          setActive = _useState2[1];

      var _useState3 = (0, _react.useState)({}),
          _useState4 = _slicedToArray(_useState3, 2),
          _availableLanguageIds = _useState4[0],
          setAvailableLanguageIds = _useState4[1];

      var _useState5 = (0, _react.useState)({}),
          _useState6 = _slicedToArray(_useState5, 2),
          available = _useState6[0],
          setAvailable = _useState6[1];

      (0, _react.useEffect)(function () {
        AUI().use('portal-available-languages', function () {
          setAvailable(Liferay.Language.available);
        });
      }, []);
      (0, _react.useEffect)(function () {
        setAvailableLanguageIds(availableLanguageIds || available);
      }, [available, availableLanguageIds]);
      (0, _react.useEffect)(function () {
        onActiveChange(active);
      }, [active, onActiveChange]);
      return (/*#__PURE__*/_react.default.createElement(_dropDown.default, {
          active: active,
          className: (0, _classnames.default)('localizable-dropdown', className),
          onActiveChange: function onActiveChange(newVal) {
            return setActive(newVal);
          },
          trigger: /*#__PURE__*/_react.default.createElement(_button.default, {
            displayType: "secondary",
            monospaced: !showUserView,
            small: showUserView,
            symbol: formatLabel(editingLanguageId)
          }, /*#__PURE__*/_react.default.createElement("span", {
            className: "inline-item"
          }, /*#__PURE__*/_react.default.createElement(_icon.default, {
            symbol: formatIcon(editingLanguageId)
          })), showUserView ? /*#__PURE__*/_react.default.createElement("span", {
            className: "localizable-dropdown-label ml-2"
          }, available[editingLanguageId]) : /*#__PURE__*/_react.default.createElement("span", {
            className: "btn-section"
          }, formatLabel(editingLanguageId)), showUserView && /*#__PURE__*/_react.default.createElement(_icon.default, {
            className: "ml-2",
            symbol: "caret-bottom"
          }))
        }, /*#__PURE__*/_react.default.createElement(_dropDown.default.ItemList, {
          className: "localizable-dropdown-ul"
        }, Object.keys(_availableLanguageIds).map(function (languageId, index) {
          return (/*#__PURE__*/_react.default.createElement(_dropDown.default.Item, {
              className: (0, _classnames.default)('autofit-row', _defineProperty({}, 'localizable-item-default', languageId === defaultLanguageId)),
              key: index,
              onClick: function onClick() {
                onEditingLanguageIdChange(languageId);
                setActive(false);
              }
            }, /*#__PURE__*/_react.default.createElement("span", {
              className: "autofit-col autofit-col-expand"
            }, /*#__PURE__*/_react.default.createElement("span", {
              className: "autofit-section"
            }, /*#__PURE__*/_react.default.createElement("span", {
              className: "inline-item inline-item-before"
            }, /*#__PURE__*/_react.default.createElement(_icon.default, {
              symbol: formatIcon(languageId)
            })), showUserView ? available[languageId] : formatLabel(languageId))), !showUserView && /*#__PURE__*/_react.default.createElement(TranslationManagerLabel, {
              defaultLanguageId: defaultLanguageId,
              languageId: languageId,
              translatedLanguageIds: translatedLanguageIds
            }))
          );
        })))
      );
    };

    exports.default = _default;
    //# sourceMappingURL=TranslationManager.es.js.map
  }
});
//# sourceMappingURL=TranslationManager.es.js.map