Liferay.Loader.define("data-engine-taglib@2.5.24/data_layout_builder/js/AppContext.es", ['module', 'exports', 'require', 'dynamic-data-mapping-form-builder', 'dynamic-data-mapping-form-renderer', 'frontend-js-react-web$react', './actions.es', './utils/dataDefinition.es', './utils/dataLayoutVisitor.es'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    function _typeof(obj) {
      "@babel/helpers - typeof";
      if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
        _typeof = function _typeof(obj) {
          return typeof obj;
        };
      } else {
        _typeof = function _typeof(obj) {
          return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
        };
      }return _typeof(obj);
    }

    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.createReducer = exports.initialState = exports.default = void 0;

    var _dynamicDataMappingFormBuilder = require("dynamic-data-mapping-form-builder");

    var _dynamicDataMappingFormRenderer = require("dynamic-data-mapping-form-renderer");

    var _react = require("frontend-js-react-web$react");

    var _actions = require("./actions.es");

    var _dataDefinition6 = require("./utils/dataDefinition.es");

    var DataLayoutVisitor = _interopRequireWildcard(require("./utils/dataLayoutVisitor.es"));

    function _getRequireWildcardCache() {
      if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
        return cache;
      };return cache;
    }

    function _interopRequireWildcard(obj) {
      if (obj && obj.__esModule) {
        return obj;
      }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
        return { default: obj };
      }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
        return cache.get(obj);
      }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
        if (Object.prototype.hasOwnProperty.call(obj, key)) {
          var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
            Object.defineProperty(newObj, key, desc);
          } else {
            newObj[key] = obj[key];
          }
        }
      }newObj.default = obj;if (cache) {
        cache.set(obj, newObj);
      }return newObj;
    }

    function _toConsumableArray(arr) {
      return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _nonIterableSpread();
    }

    function _nonIterableSpread() {
      throw new TypeError("Invalid attempt to spread non-iterable instance");
    }

    function _iterableToArray(iter) {
      if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === "[object Arguments]") return Array.from(iter);
    }

    function _arrayWithoutHoles(arr) {
      if (Array.isArray(arr)) {
        for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) {
          arr2[i] = arr[i];
        }return arr2;
      }
    }

    function ownKeys(object, enumerableOnly) {
      var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
        var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
          return Object.getOwnPropertyDescriptor(object, sym).enumerable;
        });keys.push.apply(keys, symbols);
      }return keys;
    }

    function _objectSpread(target) {
      for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
          ownKeys(Object(source), true).forEach(function (key) {
            _defineProperty(target, key, source[key]);
          });
        } else if (Object.getOwnPropertyDescriptors) {
          Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
        } else {
          ownKeys(Object(source)).forEach(function (key) {
            Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
          });
        }
      }return target;
    }

    function _defineProperty(obj, key, value) {
      if (key in obj) {
        Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
      } else {
        obj[key] = value;
      }return obj;
    }

    var AppContext = /*#__PURE__*/(0, _react.createContext)();
    var initialState = {
      appProps: {},
      config: {
        allowFieldSets: false,
        allowNestedFields: true,
        allowRules: false,
        disabledProperties: [],
        disabledTabs: [],
        multiPage: true,
        ruleSettings: {},
        unimplementedProperties: []
      },
      dataDefinition: {
        availableLanguageIds: [],
        dataDefinitionFields: [],
        name: {}
      },
      dataDefinitionId: 0,
      dataLayout: {
        dataLayoutPages: [],
        dataRules: [],
        name: {},
        paginationMode: 'wizard'
      },
      dataLayoutId: 0,
      editingDataDefinitionId: 0,
      editingLanguageId: themeDisplay.getLanguageId(),
      fieldSets: [],
      fieldTypes: [],
      focusedCustomObjectField: {},
      focusedField: {},
      hoveredField: {},
      initialAvailableLanguageIds: [],
      sidebarOpen: true,
      sidebarPanelId: 'fields',
      spritemap: "".concat(Liferay.ThemeDisplay.getPathThemeImages(), "/clay/icons.svg")
    };
    exports.initialState = initialState;

    var addCustomObjectField = function addCustomObjectField(_ref) {
      var dataLayoutBuilder = _ref.dataLayoutBuilder,
          fieldTypeName = _ref.fieldTypeName,
          fieldTypes = _ref.fieldTypes;
      var fieldType = fieldTypes.find(function (_ref2) {
        var name = _ref2.name;
        return name === fieldTypeName;
      });
      var dataDefinitionField = dataLayoutBuilder.getDataDefinitionField(fieldType);
      return _objectSpread(_objectSpread({}, dataDefinitionField), {}, {
        label: _defineProperty({}, themeDisplay.getLanguageId(), fieldType.label),
        name: _dynamicDataMappingFormBuilder.FieldSupport.getDefaultFieldName()
      });
    };

    var deleteDataDefinitionField = function deleteDataDefinitionField(dataDefinition, fieldName) {
      return _objectSpread(_objectSpread({}, dataDefinition), {}, {
        dataDefinitionFields: dataDefinition.dataDefinitionFields.filter(function (field) {
          return field.name !== fieldName;
        })
      });
    };

    var deleteDataLayoutField = function deleteDataLayoutField(dataLayout, fieldName) {
      return _objectSpread(_objectSpread({}, dataLayout), {}, {
        dataLayoutPages: DataLayoutVisitor.deleteField(dataLayout.dataLayoutPages, fieldName)
      });
    };

    var editFocusedCustomObjectField = function editFocusedCustomObjectField(_ref3) {
      var _objectSpread3;

      var focusedCustomObjectField = _ref3.focusedCustomObjectField,
          propertyName = _ref3.propertyName,
          propertyValue = _ref3.propertyValue;
      var localizableProperty = false;
      var settingsContext = focusedCustomObjectField.settingsContext;
      var visitor = new _dynamicDataMappingFormRenderer.PagesVisitor(settingsContext.pages);

      var newSettingsContext = _objectSpread(_objectSpread({}, settingsContext), {}, {
        pages: visitor.mapFields(function (field) {
          var fieldName = field.fieldName,
              localizable = field.localizable;

          if (fieldName === propertyName) {
            localizableProperty = localizable;
            return _objectSpread(_objectSpread({}, field), {}, {
              localizedValue: _objectSpread(_objectSpread({}, field.localizedValue), {}, _defineProperty({}, themeDisplay.getLanguageId(), propertyValue)),
              value: propertyValue
            });
          }

          return field;
        })
      });

      if (localizableProperty) {
        propertyValue = _defineProperty({}, themeDisplay.getLanguageId(), propertyValue);
      }

      return _objectSpread(_objectSpread({}, focusedCustomObjectField), {}, (_objectSpread3 = {}, _defineProperty(_objectSpread3, propertyName, propertyValue), _defineProperty(_objectSpread3, "settingsContext", newSettingsContext), _objectSpread3));
    };

    var setDataDefinitionFields = function setDataDefinitionFields(dataLayoutBuilder, dataDefinition, dataLayout) {
      var dataDefinitionFields = dataDefinition.dataDefinitionFields;
      var dataLayoutPages = dataLayout.dataLayoutPages;

      var _dataLayoutBuilder$ge = dataLayoutBuilder.getStore(),
          pages = _dataLayoutBuilder$ge.pages;

      var visitor = new _dynamicDataMappingFormRenderer.PagesVisitor(pages);
      var newFields = [];
      visitor.mapFields(function (field) {
        var definitionField = dataLayoutBuilder.getDataDefinitionField(field);
        newFields.push(definitionField);
      });
      return newFields.concat(dataDefinitionFields.filter(function (field) {
        return !DataLayoutVisitor.containsField(dataLayoutPages, field.name) && !newFields.some(function (_ref4) {
          var name = _ref4.name;
          return name === field.name;
        });
      }));
    };

    var setDataLayout = function setDataLayout(dataLayout, dataLayoutBuilder) {
      var dataRules = dataLayout.dataRules;

      var _dataLayoutBuilder$ge2 = dataLayoutBuilder.getStore(),
          pages = _dataLayoutBuilder$ge2.pages;

      var _dataLayoutBuilder$ge3 = dataLayoutBuilder.getDataDefinitionAndDataLayout(pages, dataRules || []),
          layout = _dataLayoutBuilder$ge3.layout;

      return layout;
    };

    var createReducer = function createReducer(dataLayoutBuilder) {
      return function () {
        var state = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : initialState;
        var action = arguments.length > 1 ? arguments[1] : undefined;

        switch (action.type) {
          case _actions.ADD_CUSTOM_OBJECT_FIELD:
            {
              var fieldTypeName = action.payload.fieldTypeName;
              var dataDefinition = state.dataDefinition,
                  fieldSets = state.fieldSets,
                  fieldTypes = state.fieldTypes;
              var newCustomObjectField = addCustomObjectField({
                dataDefinition: dataDefinition,
                dataLayoutBuilder: dataLayoutBuilder,
                fieldSets: fieldSets,
                fieldTypeName: fieldTypeName,
                fieldTypes: fieldTypes
              });
              return _objectSpread(_objectSpread({}, state), {}, {
                dataDefinition: _objectSpread(_objectSpread({}, dataDefinition), {}, {
                  dataDefinitionFields: [].concat(_toConsumableArray(dataDefinition.dataDefinitionFields), [newCustomObjectField])
                }),
                focusedCustomObjectField: _objectSpread(_objectSpread({}, newCustomObjectField), {}, {
                  settingsContext: dataLayoutBuilder.getDDMFormFieldSettingsContext(newCustomObjectField)
                })
              });
            }

          case _actions.ADD_DATA_LAYOUT_RULE:
            {
              var dataRule = action.payload.dataRule;
              var dataRules = state.dataLayout.dataRules;
              dataRule = DataLayoutVisitor.normalizeRule(dataRule);
              return _objectSpread(_objectSpread({}, state), {}, {
                dataLayout: _objectSpread(_objectSpread({}, state.dataLayout), {}, {
                  dataRules: dataRules.concat(dataRule)
                })
              });
            }

          case _actions.DELETE_DATA_DEFINITION_FIELD:
            {
              var fieldName = action.payload.fieldName;
              var _dataDefinition = state.dataDefinition;
              return _objectSpread(_objectSpread({}, state), {}, {
                dataDefinition: deleteDataDefinitionField(_dataDefinition, fieldName)
              });
            }

          case _actions.DELETE_DATA_LAYOUT_FIELD:
            {
              var _fieldName = action.payload.fieldName;
              var dataLayout = state.dataLayout;
              return _objectSpread(_objectSpread({}, state), {}, {
                dataLayout: deleteDataLayoutField(dataLayout, _fieldName)
              });
            }

          case _actions.DELETE_DATA_LAYOUT_RULE:
            {
              var ruleEditedIndex = action.payload.ruleEditedIndex;
              var _dataRules = state.dataLayout.dataRules;
              dataLayoutBuilder.dispatch('ruleDeleted', {
                ruleId: ruleEditedIndex
              });
              return _objectSpread(_objectSpread({}, state), {}, {
                dataLayout: _objectSpread(_objectSpread({}, state.dataLayout), {}, {
                  dataRules: _dataRules.filter(function (_rule, index) {
                    return index !== ruleEditedIndex;
                  })
                })
              });
            }

          case _actions.EDIT_CUSTOM_OBJECT_FIELD:
            {
              var _dataDefinition2 = state.dataDefinition,
                  focusedCustomObjectField = state.focusedCustomObjectField;
              var editedFocusedCustomObjectField = editFocusedCustomObjectField(_objectSpread(_objectSpread({}, action.payload), {}, {
                focusedCustomObjectField: focusedCustomObjectField
              }));
              var nestedDataDefinitionFields = editedFocusedCustomObjectField.nestedDataDefinitionFields,
                  settingsContext = editedFocusedCustomObjectField.settingsContext;
              return _objectSpread(_objectSpread({}, state), {}, {
                dataDefinition: _objectSpread(_objectSpread({}, _dataDefinition2), {}, {
                  dataDefinitionFields: _dataDefinition2.dataDefinitionFields.map(function (dataDefinitionField) {
                    if (dataDefinitionField.name === focusedCustomObjectField.name) {
                      return _objectSpread(_objectSpread({}, dataLayoutBuilder.getDataDefinitionField(editedFocusedCustomObjectField)), {}, {
                        nestedDataDefinitionFields: nestedDataDefinitionFields
                      });
                    }

                    return dataDefinitionField;
                  })
                }),
                focusedCustomObjectField: _objectSpread(_objectSpread({}, editedFocusedCustomObjectField), {}, {
                  settingsContext: settingsContext
                })
              });
            }

          case _actions.SWITCH_SIDEBAR_PANEL:
            {
              var _action$payload = action.payload,
                  sidebarOpen = _action$payload.sidebarOpen,
                  sidebarPanelId = _action$payload.sidebarPanelId;
              return _objectSpread(_objectSpread({}, state), {}, {
                sidebarOpen: sidebarOpen,
                sidebarPanelId: sidebarPanelId
              });
            }

          case _actions.UPDATE_APP_PROPS:
            {
              return _objectSpread(_objectSpread({}, state), {}, {
                appProps: action.payload
              });
            }

          case _actions.UPDATE_DATA_DEFINITION:
            {
              var _dataDefinition3 = action.payload.dataDefinition;
              return _objectSpread(_objectSpread({}, state), {}, {
                dataDefinition: _objectSpread(_objectSpread({}, state.dataDefinition), _dataDefinition3),
                initialAvailableLanguageIds: _dataDefinition3.availableLanguageIds
              });
            }

          case _actions.UPDATE_DATA_LAYOUT:
            {
              var _dataLayout = action.payload.dataLayout;
              return _objectSpread(_objectSpread({}, state), {}, {
                dataLayout: _objectSpread(_objectSpread(_objectSpread({}, state.dataLayout), _dataLayout), {}, {
                  dataRules: dataLayoutBuilder.getLayoutProvider().getRules()
                })
              });
            }

          case _actions.UPDATE_DATA_LAYOUT_NAME:
            {
              var name = action.payload.name;
              return _objectSpread(_objectSpread({}, state), {}, {
                dataLayout: _objectSpread(_objectSpread({}, state.dataLayout), {}, {
                  name: name
                })
              });
            }

          case _actions.UPDATE_DATA_LAYOUT_RULE:
            {
              var _dataRule = action.payload.dataRule;
              var _dataRules2 = state.dataLayout.dataRules;
              _dataRule = DataLayoutVisitor.normalizeRule(_dataRule);
              return _objectSpread(_objectSpread({}, state), {}, {
                dataLayout: _objectSpread(_objectSpread({}, state.dataLayout), {}, {
                  dataRules: _dataRules2.map(function (rule, index) {
                    if (index === _dataRule.ruleEditedIndex) {
                      return _dataRule;
                    }

                    return rule;
                  })
                })
              });
            }

          case _actions.UPDATE_EDITING_DATA_DEFINITION_ID:
            {
              var editingDataDefinitionId = action.payload.editingDataDefinitionId;
              return _objectSpread(_objectSpread({}, state), {}, {
                editingDataDefinitionId: editingDataDefinitionId
              });
            }

          case _actions.UPDATE_EDITING_LANGUAGE_ID:
            {
              var _dataDefinition4 = state.dataDefinition;
              return _objectSpread(_objectSpread({}, state), {}, {
                dataDefinition: _objectSpread(_objectSpread({}, _dataDefinition4), {}, {
                  availableLanguageIds: _toConsumableArray(new Set([].concat(_toConsumableArray(_dataDefinition4.availableLanguageIds), [action.payload])))
                }),
                editingLanguageId: action.payload
              });
            }

          case _actions.UPDATE_FIELD_TYPES:
            {
              var _fieldTypes = action.payload.fieldTypes;
              return _objectSpread(_objectSpread({}, state), {}, {
                fieldTypes: _fieldTypes
              });
            }

          case _actions.UPDATE_FIELDSETS:
            {
              var dataDefinitionId = state.dataDefinitionId,
                  _editingDataDefinitionId = state.editingDataDefinitionId;
              var _fieldSets = action.payload.fieldSets;

              if (dataDefinitionId) {
                _fieldSets = _fieldSets.filter(function (item) {
                  return item.id !== dataDefinitionId;
                });
              }

              if (_editingDataDefinitionId) {
                _fieldSets = _fieldSets.filter(function (item) {
                  return item.id !== _editingDataDefinitionId;
                });
              }

              return _objectSpread(_objectSpread({}, state), {}, {
                fieldSets: _fieldSets
              });
            }

          case _actions.UPDATE_FOCUSED_CUSTOM_OBJECT_FIELD:
            {
              var dataDefinitionField = action.payload.dataDefinitionField;
              var _focusedCustomObjectField = {};

              if (Object.keys(dataDefinitionField).length > 0) {
                _focusedCustomObjectField = _objectSpread(_objectSpread({}, dataDefinitionField), {}, {
                  settingsContext: dataLayoutBuilder.getDDMFormFieldSettingsContext(dataDefinitionField)
                });
                return _objectSpread(_objectSpread({}, state), {}, {
                  focusedCustomObjectField: _focusedCustomObjectField,
                  focusedField: {}
                });
              }

              return _objectSpread(_objectSpread({}, state), {}, {
                focusedCustomObjectField: {}
              });
            }

          case _actions.UPDATE_FOCUSED_FIELD:
            {
              var focusedField = action.payload.focusedField;

              if (Object.keys(focusedField).length > 0) {
                return _objectSpread(_objectSpread({}, state), {}, {
                  focusedCustomObjectField: {},
                  focusedField: _objectSpread(_objectSpread({}, focusedField), {}, {
                    settingsContext: _objectSpread(_objectSpread({}, focusedField.settingsContext), {}, {
                      editingLanguageId: state.editingLanguageId
                    })
                  }),
                  sidebarPanelId: 'fields'
                });
              }

              return _objectSpread(_objectSpread({}, state), {}, {
                focusedCustomObjectField: {},
                focusedField: {}
              });
            }

          case _actions.UPDATE_HOVERED_FIELD:
            {
              var _action$payload$hover = action.payload.hoveredField,
                  hoveredField = _action$payload$hover === void 0 ? {} : _action$payload$hover;
              var newHoveredField = (0, _dataDefinition6.getDataDefinitionField)(state.dataDefinition, hoveredField.fieldName);
              return _objectSpread(_objectSpread({}, state), {}, {
                hoveredField: newHoveredField || state.hoveredField
              });
            }

          case _actions.UPDATE_CONFIG:
            {
              var config = action.payload.config;
              return _objectSpread(_objectSpread({}, state), {}, {
                config: config || state.config
              });
            }

          case _actions.UPDATE_IDS:
            {
              var _action$payload2 = action.payload,
                  _dataDefinitionId = _action$payload2.dataDefinitionId,
                  dataLayoutId = _action$payload2.dataLayoutId;
              return _objectSpread(_objectSpread({}, state), {}, {
                dataDefinitionId: _dataDefinitionId,
                dataLayoutId: dataLayoutId
              });
            }

          case _actions.UPDATE_PAGES:
            {
              var _dataDefinition5 = state.dataDefinition,
                  _dataLayout2 = state.dataLayout;
              return _objectSpread(_objectSpread({}, state), {}, {
                dataDefinition: _objectSpread(_objectSpread({}, _dataDefinition5), {}, {
                  dataDefinitionFields: setDataDefinitionFields(dataLayoutBuilder, _dataDefinition5, _dataLayout2)
                }),
                dataLayout: _objectSpread(_objectSpread({}, _dataLayout2), setDataLayout(_dataLayout2, dataLayoutBuilder))
              });
            }

          default:
            return state;
        }
      };
    };

    exports.createReducer = createReducer;
    var _default = AppContext;
    exports.default = _default;
    //# sourceMappingURL=AppContext.es.js.map
  }
});
//# sourceMappingURL=AppContext.es.js.map