Liferay.Loader.define("sharing-taglib@2.0.24/collaborators/js/components/Collaborators.es", ['module', 'exports', 'require', '@frontend-taglib-clay$clayui/button', '@frontend-taglib-clay$clayui/icon', '@frontend-taglib-clay$clayui/layout', '@frontend-taglib-clay$clayui/sticker', 'frontend-js-web', 'frontend-js-react-web$prop-types', 'frontend-js-react-web$react', './UserIcon.es'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    function _typeof(obj) {
      "@babel/helpers - typeof";
      if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
        _typeof = function _typeof(obj) {
          return typeof obj;
        };
      } else {
        _typeof = function _typeof(obj) {
          return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
        };
      }return _typeof(obj);
    }

    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;

    var _button = _interopRequireDefault(require("@frontend-taglib-clay$clayui/button"));

    var _icon = _interopRequireDefault(require("@frontend-taglib-clay$clayui/icon"));

    var _layout = _interopRequireDefault(require("@frontend-taglib-clay$clayui/layout"));

    var _sticker = _interopRequireDefault(require("@frontend-taglib-clay$clayui/sticker"));

    var _frontendJsWeb = require("frontend-js-web");

    var _propTypes = _interopRequireDefault(require("frontend-js-react-web$prop-types"));

    var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

    var _UserIcon = _interopRequireDefault(require("./UserIcon.es"));

    function _getRequireWildcardCache() {
      if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
        return cache;
      };return cache;
    }

    function _interopRequireWildcard(obj) {
      if (obj && obj.__esModule) {
        return obj;
      }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
        return { default: obj };
      }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
        return cache.get(obj);
      }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
        if (Object.prototype.hasOwnProperty.call(obj, key)) {
          var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
            Object.defineProperty(newObj, key, desc);
          } else {
            newObj[key] = obj[key];
          }
        }
      }newObj.default = obj;if (cache) {
        cache.set(obj, newObj);
      }return newObj;
    }

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    function _extends() {
      _extends = Object.assign || function (target) {
        for (var i = 1; i < arguments.length; i++) {
          var source = arguments[i];for (var key in source) {
            if (Object.prototype.hasOwnProperty.call(source, key)) {
              target[key] = source[key];
            }
          }
        }return target;
      };return _extends.apply(this, arguments);
    }

    function _slicedToArray(arr, i) {
      return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
    }

    function _nonIterableRest() {
      throw new TypeError("Invalid attempt to destructure non-iterable instance");
    }

    function _iterableToArrayLimit(arr, i) {
      if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) {
        return;
      }var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
        for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
          _arr.push(_s.value);if (i && _arr.length === i) break;
        }
      } catch (err) {
        _d = true;_e = err;
      } finally {
        try {
          if (!_n && _i["return"] != null) _i["return"]();
        } finally {
          if (_d) throw _e;
        }
      }return _arr;
    }

    function _arrayWithHoles(arr) {
      if (Array.isArray(arr)) return arr;
    }

    var Collaborators = function Collaborators(_ref) {
      var canManageCollaborators = _ref.canManageCollaborators,
          classNameId = _ref.classNameId,
          classPK = _ref.classPK,
          collaboratorsResourceURL = _ref.collaboratorsResourceURL,
          initialData = _ref.initialData;

      var _useState = (0, _react.useState)(initialData),
          _useState2 = _slicedToArray(_useState, 2),
          data = _useState2[0],
          setData = _useState2[1];

      (0, _react.useEffect)(function () {
        Liferay.on('sharing:changed', function (event) {
          if (classNameId === event.classNameId && event.classPK === classPK) {
            (0, _frontendJsWeb.fetch)(collaboratorsResourceURL).then(function (res) {
              return res.json();
            }).then(setData);
          }
        });
      }, [classNameId, classPK, collaboratorsResourceURL]);
      var collaborators = data.collaborators,
          owner = data.owner,
          total = data.total;

      if (total < 1) {
        return (/*#__PURE__*/_react.default.createElement(_layout.default.ContentRow, {
            className: "sidebar-panel"
          }, /*#__PURE__*/_react.default.createElement(_layout.default.ContentCol, {
            className: "inline-item-before"
          }, /*#__PURE__*/_react.default.createElement(_UserIcon.default, _extends({}, owner, {
            size: ""
          }))), /*#__PURE__*/_react.default.createElement(_layout.default.ContentCol, {
            expand: true
          }, /*#__PURE__*/_react.default.createElement("div", {
            className: "component-title h4 username"
          }, owner.displayURL ? /*#__PURE__*/_react.default.createElement("a", {
            href: owner.displayURL
          }, owner.fullName) : owner.fullName), /*#__PURE__*/_react.default.createElement("small", {
            className: "text-muted"
          }, Liferay.Language.get('owner'))))
        );
      }

      var moreCollaboratorsCount = total - collaborators.length;
      return (/*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_layout.default.ContentRow, {
          className: "sidebar-panel"
        }, /*#__PURE__*/_react.default.createElement(_layout.default.ContentCol, {
          className: "collaborators-owner"
        }, /*#__PURE__*/_react.default.createElement("div", {
          className: "lfr-portal-tooltip",
          "data-title": Liferay.Util.sub(Liferay.Language.get('x-is-the-owner'), owner.fullName)
        }, /*#__PURE__*/_react.default.createElement(_UserIcon.default, _extends({}, owner, {
          size: ""
        })))), /*#__PURE__*/_react.default.createElement(_layout.default.ContentCol, {
          expand: true
        }, /*#__PURE__*/_react.default.createElement(_layout.default.ContentRow, null, collaborators.map(function (collaborator) {
          return (/*#__PURE__*/_react.default.createElement(_layout.default.ContentCol, {
              className: "collaborators-collaborator",
              key: collaborator.userId
            }, /*#__PURE__*/_react.default.createElement("div", {
              className: "lfr-portal-tooltip",
              "data-title": collaborator.fullName
            }, /*#__PURE__*/_react.default.createElement(_UserIcon.default, _extends({}, collaborator, {
              size: ""
            }))))
          );
        }), moreCollaboratorsCount > 0 && /*#__PURE__*/_react.default.createElement(_layout.default.ContentCol, {
          className: "collaborators-collaborator"
        }, /*#__PURE__*/_react.default.createElement("div", {
          className: "lfr-portal-tooltip",
          "data-title": moreCollaboratorsCount == 1 ? Liferay.Util.sub(Liferay.Language.get('x-more-collaborator'), moreCollaboratorsCount) : Liferay.Util.sub(Liferay.Language.get('x-more-collaborators'), moreCollaboratorsCount)
        }, /*#__PURE__*/_react.default.createElement(_sticker.default, {
          className: "sticker-use-icon user-icon-color-0",
          displayType: "secondary",
          shape: "circle"
        }, /*#__PURE__*/_react.default.createElement(_icon.default, {
          symbol: "users"
        }))))))), canManageCollaborators && /*#__PURE__*/_react.default.createElement(_layout.default.ContentRow, {
          className: "sidebar-panel"
        }, /*#__PURE__*/_react.default.createElement(_button.default, {
          className: "btn-link collaborators-btn",
          displayType: "link",
          onClick: function onClick() {
            return Liferay.Sharing.manageCollaborators(classNameId, classPK);
          },
          small: true
        }, Liferay.Language.get('manage-collaborators'))))
      );
    };

    var _default = Collaborators;
    exports.default = _default;
    //# sourceMappingURL=Collaborators.es.js.map
  }
});
//# sourceMappingURL=Collaborators.es.js.map