Liferay.Loader.define("asset-taglib@5.2.22/asset_tags_selector/AssetTagsSelector.es", ['module', 'exports', 'require', '@frontend-taglib-clay$clayui/button', '@frontend-taglib-clay$clayui/data-provider', '@frontend-taglib-clay$clayui/form', '@frontend-taglib-clay$clayui/multi-select', 'frontend-js-react-web', 'frontend-js-web', 'frontend-js-react-web$prop-types', 'frontend-js-react-web$react'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    function _typeof(obj) {
      "@babel/helpers - typeof";
      if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
        _typeof = function _typeof(obj) {
          return typeof obj;
        };
      } else {
        _typeof = function _typeof(obj) {
          return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
        };
      }return _typeof(obj);
    }

    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;

    var _button = _interopRequireDefault(require("@frontend-taglib-clay$clayui/button"));

    var _dataProvider = require("@frontend-taglib-clay$clayui/data-provider");

    var _form = _interopRequireWildcard(require("@frontend-taglib-clay$clayui/form"));

    var _multiSelect = _interopRequireDefault(require("@frontend-taglib-clay$clayui/multi-select"));

    var _frontendJsReactWeb = require("frontend-js-react-web");

    var _frontendJsWeb = require("frontend-js-web");

    var _propTypes = _interopRequireDefault(require("frontend-js-react-web$prop-types"));

    var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

    function _getRequireWildcardCache() {
      if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
        return cache;
      };return cache;
    }

    function _interopRequireWildcard(obj) {
      if (obj && obj.__esModule) {
        return obj;
      }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
        return { default: obj };
      }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
        return cache.get(obj);
      }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
        if (Object.prototype.hasOwnProperty.call(obj, key)) {
          var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
            Object.defineProperty(newObj, key, desc);
          } else {
            newObj[key] = obj[key];
          }
        }
      }newObj.default = obj;if (cache) {
        cache.set(obj, newObj);
      }return newObj;
    }

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    function _toConsumableArray(arr) {
      return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _nonIterableSpread();
    }

    function _nonIterableSpread() {
      throw new TypeError("Invalid attempt to spread non-iterable instance");
    }

    function _iterableToArray(iter) {
      if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === "[object Arguments]") return Array.from(iter);
    }

    function _arrayWithoutHoles(arr) {
      if (Array.isArray(arr)) {
        for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) {
          arr2[i] = arr[i];
        }return arr2;
      }
    }

    var noop = function noop() {};

    function AssetTagsSelector(_ref) {
      var addCallback = _ref.addCallback,
          eventName = _ref.eventName,
          _ref$groupIds = _ref.groupIds,
          groupIds = _ref$groupIds === void 0 ? [] : _ref$groupIds,
          id = _ref.id,
          inputName = _ref.inputName,
          inputValue = _ref.inputValue,
          label = _ref.label,
          _ref$onInputValueChan = _ref.onInputValueChange,
          onInputValueChange = _ref$onInputValueChan === void 0 ? noop : _ref$onInputValueChan,
          _ref$onSelectedItemsC = _ref.onSelectedItemsChange,
          onSelectedItemsChange = _ref$onSelectedItemsC === void 0 ? noop : _ref$onSelectedItemsC,
          portletURL = _ref.portletURL,
          removeCallback = _ref.removeCallback,
          _ref$selectedItems = _ref.selectedItems,
          selectedItems = _ref$selectedItems === void 0 ? [] : _ref$selectedItems,
          showSelectButton = _ref.showSelectButton;

      var _useResource = (0, _dataProvider.useResource)({
        fetchOptions: {
          body: Liferay.Util.objectToFormData({
            cmd: JSON.stringify({
              '/assettag/search': {
                end: 20,
                groupIds: groupIds,
                name: "%".concat(inputValue === '*' ? '' : inputValue, "%"),
                start: 0,
                tagProperties: ''
              }
            }),
            p_auth: Liferay.authToken
          }),
          credentials: 'include',
          method: 'POST',
          'x-csrf-token': Liferay.authToken
        },
        link: "".concat(window.location.origin).concat(themeDisplay.getPathContext(), "\n\t\t\t\t/api/jsonws/invoke")
      }),
          refetch = _useResource.refetch,
          resource = _useResource.resource;

      var previousInputValue = (0, _frontendJsReactWeb.usePrevious)(inputValue);
      (0, _react.useEffect)(function () {
        if (inputValue && inputValue !== previousInputValue) {
          refetch();
        }
      }, [inputValue, previousInputValue, refetch]);

      var callGlobalCallback = function callGlobalCallback(callback, item) {
        if (callback && typeof window[callback] === 'function') {
          window[callback](item);
        }
      };

      return (/*#__PURE__*/_react.default.createElement("div", {
          className: "lfr-tags-selector-content",
          id: id
        }, /*#__PURE__*/_react.default.createElement(_form.default.Group, null, /*#__PURE__*/_react.default.createElement("label", null, label || Liferay.Language.get('tags')), /*#__PURE__*/_react.default.createElement(_form.ClayInput.Group, null, /*#__PURE__*/_react.default.createElement(_form.ClayInput.GroupItem, null, /*#__PURE__*/_react.default.createElement(_multiSelect.default, {
          inputName: inputName,
          inputValue: inputValue,
          items: selectedItems,
          onBlur: function handleInputBlur() {
            var filteredItems = resource && resource.map(function (tag) {
              return tag.value;
            });

            if (!filteredItems || !filteredItems.length) {
              if (inputValue) {
                if (!selectedItems.find(function (item) {
                  return item.label === inputValue;
                })) {
                  onSelectedItemsChange(selectedItems.concat({
                    label: inputValue,
                    value: inputValue
                  }));
                }

                onInputValueChange('');
              }
            }
          },
          onChange: onInputValueChange,
          onItemsChange: function handleItemsChange(items) {
            var addedItems = items.filter(function (item) {
              return !selectedItems.find(function (selectedItem) {
                return selectedItem.value === item.value;
              });
            });
            var removedItems = selectedItems.filter(function (selectedItem) {
              return !items.find(function (item) {
                return item.value === selectedItem.value;
              });
            });
            var current = [].concat(_toConsumableArray(selectedItems), _toConsumableArray(addedItems)).filter(function (item) {
              return !removedItems.find(function (removedItem) {
                return removedItem.value === item.value;
              });
            });
            onSelectedItemsChange(current);
            addedItems.forEach(function (item) {
              return callGlobalCallback(addCallback, item);
            });
            removedItems.forEach(function (item) {
              return callGlobalCallback(removeCallback, item);
            });
          },
          sourceItems: resource ? resource.map(function (tag) {
            return {
              label: tag.text,
              value: tag.value
            };
          }) : []
        })), showSelectButton && /*#__PURE__*/_react.default.createElement(_form.ClayInput.GroupItem, {
          shrink: true
        }, /*#__PURE__*/_react.default.createElement(_button.default, {
          displayType: "secondary",
          onClick: function handleSelectButtonClick() {

            var url = function sub(str, obj) {
              return str.replace(/\{([^}]+)\}/g, function (_, m) {
                return obj[m];
              });
            }(decodeURIComponent(portletURL), {
              selectedTagNames: selectedItems.map(function (item) {
                return item.value;
              }).join()
            });
            (0, _frontendJsWeb.openSelectionModal)({
              buttonAddLabel: Liferay.Language.get('done'),
              multiple: true,
              onSelect: function onSelect(dialogSelectedItems) {
                if (dialogSelectedItems && dialogSelectedItems.items.length) {
                  var newValues = dialogSelectedItems.items.split(',').map(function (value) {
                    return {
                      label: value,
                      value: value
                    };
                  });
                  var addedItems = newValues.filter(function (newValue) {
                    return !selectedItems.find(function (selectedItem) {
                      return selectedItem.label === newValue.label;
                    });
                  });
                  var removedItems = selectedItems.filter(function (selectedItem) {
                    return !newValues.find(function (newValue) {
                      return newValue.label === selectedItem.label;
                    });
                  });
                  onSelectedItemsChange(newValues);
                  addedItems.forEach(function (item) {
                    return callGlobalCallback(addCallback, item);
                  });
                  removedItems.forEach(function (item) {
                    return callGlobalCallback(removeCallback, item);
                  });
                }
              },
              selectEventName: eventName,
              title: Liferay.Language.get('tags'),
              url: url
            });
          }
        }, Liferay.Language.get('select'))))))
      );
    }

    var _default = AssetTagsSelector;
    exports.default = _default;
    //# sourceMappingURL=AssetTagsSelector.es.js.map
  }
});
//# sourceMappingURL=AssetTagsSelector.es.js.map