Liferay.Loader.define("asset-taglib@5.2.22/asset_categories_navigation/js/AssetCategoriesNavigationTreeView", ['module', 'exports', 'require', 'frontend-js-components-web', 'frontend-js-react-web$react'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;

    var _frontendJsComponentsWeb = require("frontend-js-components-web");

    var _react = _interopRequireDefault(require("frontend-js-react-web$react"));

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    function _slicedToArray(arr, i) {
      return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
    }

    function _nonIterableRest() {
      throw new TypeError("Invalid attempt to destructure non-iterable instance");
    }

    function _iterableToArrayLimit(arr, i) {
      if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) {
        return;
      }var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
        for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
          _arr.push(_s.value);if (i && _arr.length === i) break;
        }
      } catch (err) {
        _d = true;_e = err;
      } finally {
        try {
          if (!_n && _i["return"] != null) _i["return"]();
        } finally {
          if (_d) throw _e;
        }
      }return _arr;
    }

    function _arrayWithHoles(arr) {
      if (Array.isArray(arr)) return arr;
    }

    function findCategory(categoryId) {
      var categories = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : [];
      // eslint-disable-next-line no-for-of-loops/no-for-of-loops
      var _iteratorNormalCompletion = true;
      var _didIteratorError = false;
      var _iteratorError = undefined;

      try {
        for (var _iterator = categories[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
          var category = _step.value;

          if (category.id === categoryId) {
            return category;
          }

          var childrenCategory = findCategory(categoryId, category.children);

          if (childrenCategory) {
            return childrenCategory;
          }
        }
      } catch (err) {
        _didIteratorError = true;
        _iteratorError = err;
      } finally {
        try {
          if (!_iteratorNormalCompletion && _iterator.return != null) {
            _iterator.return();
          }
        } finally {
          if (_didIteratorError) {
            throw _iteratorError;
          }
        }
      }

      return null;
    }

    var AssetCategoriesNavigationTreeView = function AssetCategoriesNavigationTreeView(_ref) {
      var selectedCategoryId = _ref.selectedCategoryId,
          vocabularies = _ref.vocabularies;

      return (/*#__PURE__*/_react.default.createElement(_frontendJsComponentsWeb.Treeview, {
          NodeComponent: _frontendJsComponentsWeb.Treeview.Card,
          initialSelectedNodeIds: selectedCategoryId ? [selectedCategoryId] : [],
          multiSelection: false,
          nodes: vocabularies,
          onSelectedNodesChange: function handleSelectionChange(_ref2) {
            var _ref3 = _slicedToArray(_ref2, 1),
                selectedNodeId = _ref3[0];

            if (selectedNodeId && selectedCategoryId !== selectedNodeId) {
              var category = findCategory(selectedNodeId, vocabularies);

              if (category) {
                Liferay.Util.navigate(category.url);
              }
            }
          }
        })
      );
    };

    var _default = AssetCategoriesNavigationTreeView;
    exports.default = _default;
    //# sourceMappingURL=AssetCategoriesNavigationTreeView.js.map
  }
});
//# sourceMappingURL=AssetCategoriesNavigationTreeView.js.map