/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.style.book.model;

import com.liferay.portal.kernel.bean.AutoEscape;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.GroupedModel;
import com.liferay.portal.kernel.model.MVCCModel;
import com.liferay.portal.kernel.model.ShardedModel;
import com.liferay.portal.kernel.model.StagedAuditedModel;
import com.liferay.portal.kernel.model.version.VersionedModel;

import java.util.Date;

import org.osgi.annotation.versioning.ProviderType;

/**
 * The base model interface for the StyleBookEntry service. Represents a row in the &quot;StyleBookEntry&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This interface and its corresponding implementation <code>com.liferay.style.book.model.impl.StyleBookEntryModelImpl</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in <code>com.liferay.style.book.model.impl.StyleBookEntryImpl</code>.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see StyleBookEntry
 * @generated
 */
@ProviderType
public interface StyleBookEntryModel
	extends BaseModel<StyleBookEntry>, GroupedModel, MVCCModel, ShardedModel,
			StagedAuditedModel, VersionedModel<StyleBookEntryVersion> {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this interface directly. All methods that expect a style book entry model instance should use the {@link StyleBookEntry} interface instead.
	 */

	/**
	 * Returns the primary key of this style book entry.
	 *
	 * @return the primary key of this style book entry
	 */
	@Override
	public long getPrimaryKey();

	/**
	 * Sets the primary key of this style book entry.
	 *
	 * @param primaryKey the primary key of this style book entry
	 */
	@Override
	public void setPrimaryKey(long primaryKey);

	/**
	 * Returns the mvcc version of this style book entry.
	 *
	 * @return the mvcc version of this style book entry
	 */
	@Override
	public long getMvccVersion();

	/**
	 * Sets the mvcc version of this style book entry.
	 *
	 * @param mvccVersion the mvcc version of this style book entry
	 */
	@Override
	public void setMvccVersion(long mvccVersion);

	/**
	 * Returns the uuid of this style book entry.
	 *
	 * @return the uuid of this style book entry
	 */
	@AutoEscape
	@Override
	public String getUuid();

	/**
	 * Sets the uuid of this style book entry.
	 *
	 * @param uuid the uuid of this style book entry
	 */
	@Override
	public void setUuid(String uuid);

	/**
	 * Returns the head ID of this style book entry.
	 *
	 * @return the head ID of this style book entry
	 */
	@Override
	public long getHeadId();

	/**
	 * Sets the head ID of this style book entry.
	 *
	 * @param headId the head ID of this style book entry
	 */
	@Override
	public void setHeadId(long headId);

	/**
	 * Returns the style book entry ID of this style book entry.
	 *
	 * @return the style book entry ID of this style book entry
	 */
	public long getStyleBookEntryId();

	/**
	 * Sets the style book entry ID of this style book entry.
	 *
	 * @param styleBookEntryId the style book entry ID of this style book entry
	 */
	public void setStyleBookEntryId(long styleBookEntryId);

	/**
	 * Returns the group ID of this style book entry.
	 *
	 * @return the group ID of this style book entry
	 */
	@Override
	public long getGroupId();

	/**
	 * Sets the group ID of this style book entry.
	 *
	 * @param groupId the group ID of this style book entry
	 */
	@Override
	public void setGroupId(long groupId);

	/**
	 * Returns the company ID of this style book entry.
	 *
	 * @return the company ID of this style book entry
	 */
	@Override
	public long getCompanyId();

	/**
	 * Sets the company ID of this style book entry.
	 *
	 * @param companyId the company ID of this style book entry
	 */
	@Override
	public void setCompanyId(long companyId);

	/**
	 * Returns the user ID of this style book entry.
	 *
	 * @return the user ID of this style book entry
	 */
	@Override
	public long getUserId();

	/**
	 * Sets the user ID of this style book entry.
	 *
	 * @param userId the user ID of this style book entry
	 */
	@Override
	public void setUserId(long userId);

	/**
	 * Returns the user uuid of this style book entry.
	 *
	 * @return the user uuid of this style book entry
	 */
	@Override
	public String getUserUuid();

	/**
	 * Sets the user uuid of this style book entry.
	 *
	 * @param userUuid the user uuid of this style book entry
	 */
	@Override
	public void setUserUuid(String userUuid);

	/**
	 * Returns the user name of this style book entry.
	 *
	 * @return the user name of this style book entry
	 */
	@AutoEscape
	@Override
	public String getUserName();

	/**
	 * Sets the user name of this style book entry.
	 *
	 * @param userName the user name of this style book entry
	 */
	@Override
	public void setUserName(String userName);

	/**
	 * Returns the create date of this style book entry.
	 *
	 * @return the create date of this style book entry
	 */
	@Override
	public Date getCreateDate();

	/**
	 * Sets the create date of this style book entry.
	 *
	 * @param createDate the create date of this style book entry
	 */
	@Override
	public void setCreateDate(Date createDate);

	/**
	 * Returns the modified date of this style book entry.
	 *
	 * @return the modified date of this style book entry
	 */
	@Override
	public Date getModifiedDate();

	/**
	 * Sets the modified date of this style book entry.
	 *
	 * @param modifiedDate the modified date of this style book entry
	 */
	@Override
	public void setModifiedDate(Date modifiedDate);

	/**
	 * Returns the default style book entry of this style book entry.
	 *
	 * @return the default style book entry of this style book entry
	 */
	public boolean getDefaultStyleBookEntry();

	/**
	 * Returns <code>true</code> if this style book entry is default style book entry.
	 *
	 * @return <code>true</code> if this style book entry is default style book entry; <code>false</code> otherwise
	 */
	public boolean isDefaultStyleBookEntry();

	/**
	 * Sets whether this style book entry is default style book entry.
	 *
	 * @param defaultStyleBookEntry the default style book entry of this style book entry
	 */
	public void setDefaultStyleBookEntry(boolean defaultStyleBookEntry);

	/**
	 * Returns the frontend tokens values of this style book entry.
	 *
	 * @return the frontend tokens values of this style book entry
	 */
	@AutoEscape
	public String getFrontendTokensValues();

	/**
	 * Sets the frontend tokens values of this style book entry.
	 *
	 * @param frontendTokensValues the frontend tokens values of this style book entry
	 */
	public void setFrontendTokensValues(String frontendTokensValues);

	/**
	 * Returns the name of this style book entry.
	 *
	 * @return the name of this style book entry
	 */
	@AutoEscape
	public String getName();

	/**
	 * Sets the name of this style book entry.
	 *
	 * @param name the name of this style book entry
	 */
	public void setName(String name);

	/**
	 * Returns the preview file entry ID of this style book entry.
	 *
	 * @return the preview file entry ID of this style book entry
	 */
	public long getPreviewFileEntryId();

	/**
	 * Sets the preview file entry ID of this style book entry.
	 *
	 * @param previewFileEntryId the preview file entry ID of this style book entry
	 */
	public void setPreviewFileEntryId(long previewFileEntryId);

	/**
	 * Returns the style book entry key of this style book entry.
	 *
	 * @return the style book entry key of this style book entry
	 */
	@AutoEscape
	public String getStyleBookEntryKey();

	/**
	 * Sets the style book entry key of this style book entry.
	 *
	 * @param styleBookEntryKey the style book entry key of this style book entry
	 */
	public void setStyleBookEntryKey(String styleBookEntryKey);

}