/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.social.kernel.model;

import com.liferay.portal.kernel.bean.AutoEscape;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.MVCCModel;
import com.liferay.portal.kernel.model.ShardedModel;
import com.liferay.portal.kernel.model.change.tracking.CTModel;

import org.osgi.annotation.versioning.ProviderType;

/**
 * The base model interface for the SocialRelation service. Represents a row in the &quot;SocialRelation&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This interface and its corresponding implementation <code>com.liferay.portlet.social.model.impl.SocialRelationModelImpl</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in <code>com.liferay.portlet.social.model.impl.SocialRelationImpl</code>.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see SocialRelation
 * @generated
 */
@ProviderType
public interface SocialRelationModel
	extends BaseModel<SocialRelation>, CTModel<SocialRelation>, MVCCModel,
			ShardedModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this interface directly. All methods that expect a social relation model instance should use the {@link SocialRelation} interface instead.
	 */

	/**
	 * Returns the primary key of this social relation.
	 *
	 * @return the primary key of this social relation
	 */
	@Override
	public long getPrimaryKey();

	/**
	 * Sets the primary key of this social relation.
	 *
	 * @param primaryKey the primary key of this social relation
	 */
	@Override
	public void setPrimaryKey(long primaryKey);

	/**
	 * Returns the mvcc version of this social relation.
	 *
	 * @return the mvcc version of this social relation
	 */
	@Override
	public long getMvccVersion();

	/**
	 * Sets the mvcc version of this social relation.
	 *
	 * @param mvccVersion the mvcc version of this social relation
	 */
	@Override
	public void setMvccVersion(long mvccVersion);

	/**
	 * Returns the ct collection ID of this social relation.
	 *
	 * @return the ct collection ID of this social relation
	 */
	@Override
	public long getCtCollectionId();

	/**
	 * Sets the ct collection ID of this social relation.
	 *
	 * @param ctCollectionId the ct collection ID of this social relation
	 */
	@Override
	public void setCtCollectionId(long ctCollectionId);

	/**
	 * Returns the uuid of this social relation.
	 *
	 * @return the uuid of this social relation
	 */
	@AutoEscape
	public String getUuid();

	/**
	 * Sets the uuid of this social relation.
	 *
	 * @param uuid the uuid of this social relation
	 */
	public void setUuid(String uuid);

	/**
	 * Returns the relation ID of this social relation.
	 *
	 * @return the relation ID of this social relation
	 */
	public long getRelationId();

	/**
	 * Sets the relation ID of this social relation.
	 *
	 * @param relationId the relation ID of this social relation
	 */
	public void setRelationId(long relationId);

	/**
	 * Returns the company ID of this social relation.
	 *
	 * @return the company ID of this social relation
	 */
	@Override
	public long getCompanyId();

	/**
	 * Sets the company ID of this social relation.
	 *
	 * @param companyId the company ID of this social relation
	 */
	@Override
	public void setCompanyId(long companyId);

	/**
	 * Returns the create date of this social relation.
	 *
	 * @return the create date of this social relation
	 */
	public long getCreateDate();

	/**
	 * Sets the create date of this social relation.
	 *
	 * @param createDate the create date of this social relation
	 */
	public void setCreateDate(long createDate);

	/**
	 * Returns the user id1 of this social relation.
	 *
	 * @return the user id1 of this social relation
	 */
	public long getUserId1();

	/**
	 * Sets the user id1 of this social relation.
	 *
	 * @param userId1 the user id1 of this social relation
	 */
	public void setUserId1(long userId1);

	/**
	 * Returns the user id2 of this social relation.
	 *
	 * @return the user id2 of this social relation
	 */
	public long getUserId2();

	/**
	 * Sets the user id2 of this social relation.
	 *
	 * @param userId2 the user id2 of this social relation
	 */
	public void setUserId2(long userId2);

	/**
	 * Returns the type of this social relation.
	 *
	 * @return the type of this social relation
	 */
	public int getType();

	/**
	 * Sets the type of this social relation.
	 *
	 * @param type the type of this social relation
	 */
	public void setType(int type);

}