/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.portal.model.impl;

import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.util.ExpandoBridgeFactoryUtil;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.LocaleException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSON;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutModel;
import com.liferay.portal.kernel.model.LayoutSoap;
import com.liferay.portal.kernel.model.ModelWrapper;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.impl.BaseModelImpl;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.workflow.WorkflowConstants;

import java.io.Serializable;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;

import java.sql.Types;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.BiConsumer;
import java.util.function.Function;

/**
 * The base model implementation for the Layout service. Represents a row in the &quot;Layout&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface <code>LayoutModel</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link LayoutImpl}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see LayoutImpl
 * @generated
 */
@JSON(strict = true)
public class LayoutModelImpl
	extends BaseModelImpl<Layout> implements LayoutModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a layout model instance should use the <code>Layout</code> interface instead.
	 */
	public static final String TABLE_NAME = "Layout";

	public static final Object[][] TABLE_COLUMNS = {
		{"mvccVersion", Types.BIGINT}, {"ctCollectionId", Types.BIGINT},
		{"uuid_", Types.VARCHAR}, {"plid", Types.BIGINT},
		{"groupId", Types.BIGINT}, {"companyId", Types.BIGINT},
		{"userId", Types.BIGINT}, {"userName", Types.VARCHAR},
		{"createDate", Types.TIMESTAMP}, {"modifiedDate", Types.TIMESTAMP},
		{"parentPlid", Types.BIGINT}, {"privateLayout", Types.BOOLEAN},
		{"layoutId", Types.BIGINT}, {"parentLayoutId", Types.BIGINT},
		{"classNameId", Types.BIGINT}, {"classPK", Types.BIGINT},
		{"name", Types.VARCHAR}, {"title", Types.VARCHAR},
		{"description", Types.CLOB}, {"keywords", Types.VARCHAR},
		{"robots", Types.VARCHAR}, {"type_", Types.VARCHAR},
		{"typeSettings", Types.CLOB}, {"hidden_", Types.BOOLEAN},
		{"system_", Types.BOOLEAN}, {"friendlyURL", Types.VARCHAR},
		{"iconImageId", Types.BIGINT}, {"themeId", Types.VARCHAR},
		{"colorSchemeId", Types.VARCHAR}, {"styleBookEntryId", Types.BIGINT},
		{"css", Types.CLOB}, {"priority", Types.INTEGER},
		{"masterLayoutPlid", Types.BIGINT},
		{"layoutPrototypeUuid", Types.VARCHAR},
		{"layoutPrototypeLinkEnabled", Types.BOOLEAN},
		{"sourcePrototypeLayoutUuid", Types.VARCHAR},
		{"publishDate", Types.TIMESTAMP}, {"lastPublishDate", Types.TIMESTAMP},
		{"status", Types.INTEGER}, {"statusByUserId", Types.BIGINT},
		{"statusByUserName", Types.VARCHAR}, {"statusDate", Types.TIMESTAMP}
	};

	public static final Map<String, Integer> TABLE_COLUMNS_MAP =
		new HashMap<String, Integer>();

	static {
		TABLE_COLUMNS_MAP.put("mvccVersion", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("ctCollectionId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("uuid_", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("plid", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("groupId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("companyId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("createDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("modifiedDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("parentPlid", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("privateLayout", Types.BOOLEAN);
		TABLE_COLUMNS_MAP.put("layoutId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("parentLayoutId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("classNameId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("classPK", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("name", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("title", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("description", Types.CLOB);
		TABLE_COLUMNS_MAP.put("keywords", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("robots", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("type_", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("typeSettings", Types.CLOB);
		TABLE_COLUMNS_MAP.put("hidden_", Types.BOOLEAN);
		TABLE_COLUMNS_MAP.put("system_", Types.BOOLEAN);
		TABLE_COLUMNS_MAP.put("friendlyURL", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("iconImageId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("themeId", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("colorSchemeId", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("styleBookEntryId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("css", Types.CLOB);
		TABLE_COLUMNS_MAP.put("priority", Types.INTEGER);
		TABLE_COLUMNS_MAP.put("masterLayoutPlid", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("layoutPrototypeUuid", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("layoutPrototypeLinkEnabled", Types.BOOLEAN);
		TABLE_COLUMNS_MAP.put("sourcePrototypeLayoutUuid", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("publishDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("lastPublishDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("status", Types.INTEGER);
		TABLE_COLUMNS_MAP.put("statusByUserId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("statusByUserName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("statusDate", Types.TIMESTAMP);
	}

	public static final String TABLE_SQL_CREATE =
		"create table Layout (mvccVersion LONG default 0 not null,ctCollectionId LONG default 0 not null,uuid_ VARCHAR(75) null,plid LONG not null,groupId LONG,companyId LONG,userId LONG,userName VARCHAR(75) null,createDate DATE null,modifiedDate DATE null,parentPlid LONG,privateLayout BOOLEAN,layoutId LONG,parentLayoutId LONG,classNameId LONG,classPK LONG,name STRING null,title STRING null,description TEXT null,keywords STRING null,robots STRING null,type_ VARCHAR(75) null,typeSettings TEXT null,hidden_ BOOLEAN,system_ BOOLEAN,friendlyURL VARCHAR(255) null,iconImageId LONG,themeId VARCHAR(75) null,colorSchemeId VARCHAR(75) null,styleBookEntryId LONG,css TEXT null,priority INTEGER,masterLayoutPlid LONG,layoutPrototypeUuid VARCHAR(75) null,layoutPrototypeLinkEnabled BOOLEAN,sourcePrototypeLayoutUuid VARCHAR(75) null,publishDate DATE null,lastPublishDate DATE null,status INTEGER,statusByUserId LONG,statusByUserName VARCHAR(75) null,statusDate DATE null,primary key (plid, ctCollectionId))";

	public static final String TABLE_SQL_DROP = "drop table Layout";

	public static final String ORDER_BY_JPQL =
		" ORDER BY layout.parentLayoutId ASC, layout.priority ASC";

	public static final String ORDER_BY_SQL =
		" ORDER BY Layout.parentLayoutId ASC, Layout.priority ASC";

	public static final String DATA_SOURCE = "liferayDataSource";

	public static final String SESSION_FACTORY = "liferaySessionFactory";

	public static final String TX_MANAGER = "liferayTransactionManager";

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static final boolean ENTITY_CACHE_ENABLED = true;

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static final boolean FINDER_CACHE_ENABLED = true;

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static final boolean COLUMN_BITMASK_ENABLED = true;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)
	 */
	@Deprecated
	public static final long CLASSNAMEID_COLUMN_BITMASK = 1L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)
	 */
	@Deprecated
	public static final long CLASSPK_COLUMN_BITMASK = 2L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)
	 */
	@Deprecated
	public static final long COMPANYID_COLUMN_BITMASK = 4L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)
	 */
	@Deprecated
	public static final long FRIENDLYURL_COLUMN_BITMASK = 8L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)
	 */
	@Deprecated
	public static final long GROUPID_COLUMN_BITMASK = 16L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)
	 */
	@Deprecated
	public static final long HIDDEN_COLUMN_BITMASK = 32L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)
	 */
	@Deprecated
	public static final long ICONIMAGEID_COLUMN_BITMASK = 64L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)
	 */
	@Deprecated
	public static final long LAYOUTID_COLUMN_BITMASK = 128L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)
	 */
	@Deprecated
	public static final long LAYOUTPROTOTYPEUUID_COLUMN_BITMASK = 256L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)
	 */
	@Deprecated
	public static final long MASTERLAYOUTPLID_COLUMN_BITMASK = 512L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)
	 */
	@Deprecated
	public static final long PARENTLAYOUTID_COLUMN_BITMASK = 1024L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)
	 */
	@Deprecated
	public static final long PARENTPLID_COLUMN_BITMASK = 2048L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)
	 */
	@Deprecated
	public static final long PRIORITY_COLUMN_BITMASK = 4096L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)
	 */
	@Deprecated
	public static final long PRIVATELAYOUT_COLUMN_BITMASK = 8192L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)
	 */
	@Deprecated
	public static final long SOURCEPROTOTYPELAYOUTUUID_COLUMN_BITMASK = 16384L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)
	 */
	@Deprecated
	public static final long TYPE_COLUMN_BITMASK = 32768L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)
	 */
	@Deprecated
	public static final long UUID_COLUMN_BITMASK = 65536L;

	/**
	 * Converts the soap model instance into a normal model instance.
	 *
	 * @param soapModel the soap model instance to convert
	 * @return the normal model instance
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static Layout toModel(LayoutSoap soapModel) {
		if (soapModel == null) {
			return null;
		}

		Layout model = new LayoutImpl();

		model.setMvccVersion(soapModel.getMvccVersion());
		model.setCtCollectionId(soapModel.getCtCollectionId());
		model.setUuid(soapModel.getUuid());
		model.setPlid(soapModel.getPlid());
		model.setGroupId(soapModel.getGroupId());
		model.setCompanyId(soapModel.getCompanyId());
		model.setUserId(soapModel.getUserId());
		model.setUserName(soapModel.getUserName());
		model.setCreateDate(soapModel.getCreateDate());
		model.setModifiedDate(soapModel.getModifiedDate());
		model.setParentPlid(soapModel.getParentPlid());
		model.setPrivateLayout(soapModel.isPrivateLayout());
		model.setLayoutId(soapModel.getLayoutId());
		model.setParentLayoutId(soapModel.getParentLayoutId());
		model.setClassNameId(soapModel.getClassNameId());
		model.setClassPK(soapModel.getClassPK());
		model.setName(soapModel.getName());
		model.setTitle(soapModel.getTitle());
		model.setDescription(soapModel.getDescription());
		model.setKeywords(soapModel.getKeywords());
		model.setRobots(soapModel.getRobots());
		model.setType(soapModel.getType());
		model.setTypeSettings(soapModel.getTypeSettings());
		model.setHidden(soapModel.isHidden());
		model.setSystem(soapModel.isSystem());
		model.setFriendlyURL(soapModel.getFriendlyURL());
		model.setIconImageId(soapModel.getIconImageId());
		model.setThemeId(soapModel.getThemeId());
		model.setColorSchemeId(soapModel.getColorSchemeId());
		model.setStyleBookEntryId(soapModel.getStyleBookEntryId());
		model.setCss(soapModel.getCss());
		model.setPriority(soapModel.getPriority());
		model.setMasterLayoutPlid(soapModel.getMasterLayoutPlid());
		model.setLayoutPrototypeUuid(soapModel.getLayoutPrototypeUuid());
		model.setLayoutPrototypeLinkEnabled(
			soapModel.isLayoutPrototypeLinkEnabled());
		model.setSourcePrototypeLayoutUuid(
			soapModel.getSourcePrototypeLayoutUuid());
		model.setPublishDate(soapModel.getPublishDate());
		model.setLastPublishDate(soapModel.getLastPublishDate());
		model.setStatus(soapModel.getStatus());
		model.setStatusByUserId(soapModel.getStatusByUserId());
		model.setStatusByUserName(soapModel.getStatusByUserName());
		model.setStatusDate(soapModel.getStatusDate());

		return model;
	}

	/**
	 * Converts the soap model instances into normal model instances.
	 *
	 * @param soapModels the soap model instances to convert
	 * @return the normal model instances
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static List<Layout> toModels(LayoutSoap[] soapModels) {
		if (soapModels == null) {
			return null;
		}

		List<Layout> models = new ArrayList<Layout>(soapModels.length);

		for (LayoutSoap soapModel : soapModels) {
			models.add(toModel(soapModel));
		}

		return models;
	}

	public static final long LOCK_EXPIRATION_TIME = GetterUtil.getLong(
		com.liferay.portal.util.PropsUtil.get(
			"lock.expiration.time.com.liferay.portal.kernel.model.Layout"));

	public LayoutModelImpl() {
	}

	@Override
	public long getPrimaryKey() {
		return _plid;
	}

	@Override
	public void setPrimaryKey(long primaryKey) {
		setPlid(primaryKey);
	}

	@Override
	public Serializable getPrimaryKeyObj() {
		return _plid;
	}

	@Override
	public void setPrimaryKeyObj(Serializable primaryKeyObj) {
		setPrimaryKey(((Long)primaryKeyObj).longValue());
	}

	@Override
	public Class<?> getModelClass() {
		return Layout.class;
	}

	@Override
	public String getModelClassName() {
		return Layout.class.getName();
	}

	@Override
	public Map<String, Object> getModelAttributes() {
		Map<String, Object> attributes = new HashMap<String, Object>();

		Map<String, Function<Layout, Object>> attributeGetterFunctions =
			getAttributeGetterFunctions();

		for (Map.Entry<String, Function<Layout, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<Layout, Object> attributeGetterFunction = entry.getValue();

			attributes.put(
				attributeName, attributeGetterFunction.apply((Layout)this));
		}

		return attributes;
	}

	@Override
	public void setModelAttributes(Map<String, Object> attributes) {
		Map<String, BiConsumer<Layout, Object>> attributeSetterBiConsumers =
			getAttributeSetterBiConsumers();

		for (Map.Entry<String, Object> entry : attributes.entrySet()) {
			String attributeName = entry.getKey();

			BiConsumer<Layout, Object> attributeSetterBiConsumer =
				attributeSetterBiConsumers.get(attributeName);

			if (attributeSetterBiConsumer != null) {
				attributeSetterBiConsumer.accept(
					(Layout)this, entry.getValue());
			}
		}
	}

	public Map<String, Function<Layout, Object>> getAttributeGetterFunctions() {
		return _attributeGetterFunctions;
	}

	public Map<String, BiConsumer<Layout, Object>>
		getAttributeSetterBiConsumers() {

		return _attributeSetterBiConsumers;
	}

	private static Function<InvocationHandler, Layout>
		_getProxyProviderFunction() {

		Class<?> proxyClass = ProxyUtil.getProxyClass(
			Layout.class.getClassLoader(), Layout.class, ModelWrapper.class);

		try {
			Constructor<Layout> constructor =
				(Constructor<Layout>)proxyClass.getConstructor(
					InvocationHandler.class);

			return invocationHandler -> {
				try {
					return constructor.newInstance(invocationHandler);
				}
				catch (ReflectiveOperationException
							reflectiveOperationException) {

					throw new InternalError(reflectiveOperationException);
				}
			};
		}
		catch (NoSuchMethodException noSuchMethodException) {
			throw new InternalError(noSuchMethodException);
		}
	}

	private static final Map<String, Function<Layout, Object>>
		_attributeGetterFunctions;
	private static final Map<String, BiConsumer<Layout, Object>>
		_attributeSetterBiConsumers;

	static {
		Map<String, Function<Layout, Object>> attributeGetterFunctions =
			new LinkedHashMap<String, Function<Layout, Object>>();
		Map<String, BiConsumer<Layout, ?>> attributeSetterBiConsumers =
			new LinkedHashMap<String, BiConsumer<Layout, ?>>();

		attributeGetterFunctions.put("mvccVersion", Layout::getMvccVersion);
		attributeSetterBiConsumers.put(
			"mvccVersion", (BiConsumer<Layout, Long>)Layout::setMvccVersion);
		attributeGetterFunctions.put(
			"ctCollectionId", Layout::getCtCollectionId);
		attributeSetterBiConsumers.put(
			"ctCollectionId",
			(BiConsumer<Layout, Long>)Layout::setCtCollectionId);
		attributeGetterFunctions.put("uuid", Layout::getUuid);
		attributeSetterBiConsumers.put(
			"uuid", (BiConsumer<Layout, String>)Layout::setUuid);
		attributeGetterFunctions.put("plid", Layout::getPlid);
		attributeSetterBiConsumers.put(
			"plid", (BiConsumer<Layout, Long>)Layout::setPlid);
		attributeGetterFunctions.put("groupId", Layout::getGroupId);
		attributeSetterBiConsumers.put(
			"groupId", (BiConsumer<Layout, Long>)Layout::setGroupId);
		attributeGetterFunctions.put("companyId", Layout::getCompanyId);
		attributeSetterBiConsumers.put(
			"companyId", (BiConsumer<Layout, Long>)Layout::setCompanyId);
		attributeGetterFunctions.put("userId", Layout::getUserId);
		attributeSetterBiConsumers.put(
			"userId", (BiConsumer<Layout, Long>)Layout::setUserId);
		attributeGetterFunctions.put("userName", Layout::getUserName);
		attributeSetterBiConsumers.put(
			"userName", (BiConsumer<Layout, String>)Layout::setUserName);
		attributeGetterFunctions.put("createDate", Layout::getCreateDate);
		attributeSetterBiConsumers.put(
			"createDate", (BiConsumer<Layout, Date>)Layout::setCreateDate);
		attributeGetterFunctions.put("modifiedDate", Layout::getModifiedDate);
		attributeSetterBiConsumers.put(
			"modifiedDate", (BiConsumer<Layout, Date>)Layout::setModifiedDate);
		attributeGetterFunctions.put("parentPlid", Layout::getParentPlid);
		attributeSetterBiConsumers.put(
			"parentPlid", (BiConsumer<Layout, Long>)Layout::setParentPlid);
		attributeGetterFunctions.put("privateLayout", Layout::getPrivateLayout);
		attributeSetterBiConsumers.put(
			"privateLayout",
			(BiConsumer<Layout, Boolean>)Layout::setPrivateLayout);
		attributeGetterFunctions.put("layoutId", Layout::getLayoutId);
		attributeSetterBiConsumers.put(
			"layoutId", (BiConsumer<Layout, Long>)Layout::setLayoutId);
		attributeGetterFunctions.put(
			"parentLayoutId", Layout::getParentLayoutId);
		attributeSetterBiConsumers.put(
			"parentLayoutId",
			(BiConsumer<Layout, Long>)Layout::setParentLayoutId);
		attributeGetterFunctions.put("classNameId", Layout::getClassNameId);
		attributeSetterBiConsumers.put(
			"classNameId", (BiConsumer<Layout, Long>)Layout::setClassNameId);
		attributeGetterFunctions.put("classPK", Layout::getClassPK);
		attributeSetterBiConsumers.put(
			"classPK", (BiConsumer<Layout, Long>)Layout::setClassPK);
		attributeGetterFunctions.put("name", Layout::getName);
		attributeSetterBiConsumers.put(
			"name", (BiConsumer<Layout, String>)Layout::setName);
		attributeGetterFunctions.put("title", Layout::getTitle);
		attributeSetterBiConsumers.put(
			"title", (BiConsumer<Layout, String>)Layout::setTitle);
		attributeGetterFunctions.put("description", Layout::getDescription);
		attributeSetterBiConsumers.put(
			"description", (BiConsumer<Layout, String>)Layout::setDescription);
		attributeGetterFunctions.put("keywords", Layout::getKeywords);
		attributeSetterBiConsumers.put(
			"keywords", (BiConsumer<Layout, String>)Layout::setKeywords);
		attributeGetterFunctions.put("robots", Layout::getRobots);
		attributeSetterBiConsumers.put(
			"robots", (BiConsumer<Layout, String>)Layout::setRobots);
		attributeGetterFunctions.put("type", Layout::getType);
		attributeSetterBiConsumers.put(
			"type", (BiConsumer<Layout, String>)Layout::setType);
		attributeGetterFunctions.put("typeSettings", Layout::getTypeSettings);
		attributeSetterBiConsumers.put(
			"typeSettings",
			(BiConsumer<Layout, String>)Layout::setTypeSettings);
		attributeGetterFunctions.put("hidden", Layout::getHidden);
		attributeSetterBiConsumers.put(
			"hidden", (BiConsumer<Layout, Boolean>)Layout::setHidden);
		attributeGetterFunctions.put("system", Layout::getSystem);
		attributeSetterBiConsumers.put(
			"system", (BiConsumer<Layout, Boolean>)Layout::setSystem);
		attributeGetterFunctions.put("friendlyURL", Layout::getFriendlyURL);
		attributeSetterBiConsumers.put(
			"friendlyURL", (BiConsumer<Layout, String>)Layout::setFriendlyURL);
		attributeGetterFunctions.put("iconImageId", Layout::getIconImageId);
		attributeSetterBiConsumers.put(
			"iconImageId", (BiConsumer<Layout, Long>)Layout::setIconImageId);
		attributeGetterFunctions.put("themeId", Layout::getThemeId);
		attributeSetterBiConsumers.put(
			"themeId", (BiConsumer<Layout, String>)Layout::setThemeId);
		attributeGetterFunctions.put("colorSchemeId", Layout::getColorSchemeId);
		attributeSetterBiConsumers.put(
			"colorSchemeId",
			(BiConsumer<Layout, String>)Layout::setColorSchemeId);
		attributeGetterFunctions.put(
			"styleBookEntryId", Layout::getStyleBookEntryId);
		attributeSetterBiConsumers.put(
			"styleBookEntryId",
			(BiConsumer<Layout, Long>)Layout::setStyleBookEntryId);
		attributeGetterFunctions.put("css", Layout::getCss);
		attributeSetterBiConsumers.put(
			"css", (BiConsumer<Layout, String>)Layout::setCss);
		attributeGetterFunctions.put("priority", Layout::getPriority);
		attributeSetterBiConsumers.put(
			"priority", (BiConsumer<Layout, Integer>)Layout::setPriority);
		attributeGetterFunctions.put(
			"masterLayoutPlid", Layout::getMasterLayoutPlid);
		attributeSetterBiConsumers.put(
			"masterLayoutPlid",
			(BiConsumer<Layout, Long>)Layout::setMasterLayoutPlid);
		attributeGetterFunctions.put(
			"layoutPrototypeUuid", Layout::getLayoutPrototypeUuid);
		attributeSetterBiConsumers.put(
			"layoutPrototypeUuid",
			(BiConsumer<Layout, String>)Layout::setLayoutPrototypeUuid);
		attributeGetterFunctions.put(
			"layoutPrototypeLinkEnabled",
			Layout::getLayoutPrototypeLinkEnabled);
		attributeSetterBiConsumers.put(
			"layoutPrototypeLinkEnabled",
			(BiConsumer<Layout, Boolean>)Layout::setLayoutPrototypeLinkEnabled);
		attributeGetterFunctions.put(
			"sourcePrototypeLayoutUuid", Layout::getSourcePrototypeLayoutUuid);
		attributeSetterBiConsumers.put(
			"sourcePrototypeLayoutUuid",
			(BiConsumer<Layout, String>)Layout::setSourcePrototypeLayoutUuid);
		attributeGetterFunctions.put("publishDate", Layout::getPublishDate);
		attributeSetterBiConsumers.put(
			"publishDate", (BiConsumer<Layout, Date>)Layout::setPublishDate);
		attributeGetterFunctions.put(
			"lastPublishDate", Layout::getLastPublishDate);
		attributeSetterBiConsumers.put(
			"lastPublishDate",
			(BiConsumer<Layout, Date>)Layout::setLastPublishDate);
		attributeGetterFunctions.put("status", Layout::getStatus);
		attributeSetterBiConsumers.put(
			"status", (BiConsumer<Layout, Integer>)Layout::setStatus);
		attributeGetterFunctions.put(
			"statusByUserId", Layout::getStatusByUserId);
		attributeSetterBiConsumers.put(
			"statusByUserId",
			(BiConsumer<Layout, Long>)Layout::setStatusByUserId);
		attributeGetterFunctions.put(
			"statusByUserName", Layout::getStatusByUserName);
		attributeSetterBiConsumers.put(
			"statusByUserName",
			(BiConsumer<Layout, String>)Layout::setStatusByUserName);
		attributeGetterFunctions.put("statusDate", Layout::getStatusDate);
		attributeSetterBiConsumers.put(
			"statusDate", (BiConsumer<Layout, Date>)Layout::setStatusDate);

		_attributeGetterFunctions = Collections.unmodifiableMap(
			attributeGetterFunctions);
		_attributeSetterBiConsumers = Collections.unmodifiableMap(
			(Map)attributeSetterBiConsumers);
	}

	@JSON
	@Override
	public long getMvccVersion() {
		return _mvccVersion;
	}

	@Override
	public void setMvccVersion(long mvccVersion) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_mvccVersion = mvccVersion;
	}

	@JSON
	@Override
	public long getCtCollectionId() {
		return _ctCollectionId;
	}

	@Override
	public void setCtCollectionId(long ctCollectionId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_ctCollectionId = ctCollectionId;
	}

	@JSON
	@Override
	public String getUuid() {
		if (_uuid == null) {
			return "";
		}
		else {
			return _uuid;
		}
	}

	@Override
	public void setUuid(String uuid) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_uuid = uuid;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalUuid() {
		return getColumnOriginalValue("uuid_");
	}

	@JSON
	@Override
	public long getPlid() {
		return _plid;
	}

	@Override
	public void setPlid(long plid) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_plid = plid;
	}

	@JSON
	@Override
	public long getGroupId() {
		return _groupId;
	}

	@Override
	public void setGroupId(long groupId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_groupId = groupId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalGroupId() {
		return GetterUtil.getLong(this.<Long>getColumnOriginalValue("groupId"));
	}

	@JSON
	@Override
	public long getCompanyId() {
		return _companyId;
	}

	@Override
	public void setCompanyId(long companyId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_companyId = companyId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalCompanyId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("companyId"));
	}

	@JSON
	@Override
	public long getUserId() {
		return _userId;
	}

	@Override
	public void setUserId(long userId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_userId = userId;
	}

	@Override
	public String getUserUuid() {
		try {
			User user = UserLocalServiceUtil.getUserById(getUserId());

			return user.getUuid();
		}
		catch (PortalException portalException) {
			return "";
		}
	}

	@Override
	public void setUserUuid(String userUuid) {
	}

	@JSON
	@Override
	public String getUserName() {
		if (_userName == null) {
			return "";
		}
		else {
			return _userName;
		}
	}

	@Override
	public void setUserName(String userName) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_userName = userName;
	}

	@JSON
	@Override
	public Date getCreateDate() {
		return _createDate;
	}

	@Override
	public void setCreateDate(Date createDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_createDate = createDate;
	}

	@JSON
	@Override
	public Date getModifiedDate() {
		return _modifiedDate;
	}

	public boolean hasSetModifiedDate() {
		return _setModifiedDate;
	}

	@Override
	public void setModifiedDate(Date modifiedDate) {
		_setModifiedDate = true;

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_modifiedDate = modifiedDate;
	}

	@JSON
	@Override
	public long getParentPlid() {
		return _parentPlid;
	}

	@Override
	public void setParentPlid(long parentPlid) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_parentPlid = parentPlid;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalParentPlid() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("parentPlid"));
	}

	@JSON
	@Override
	public boolean getPrivateLayout() {
		return _privateLayout;
	}

	@JSON
	@Override
	public boolean isPrivateLayout() {
		return _privateLayout;
	}

	@Override
	public void setPrivateLayout(boolean privateLayout) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_privateLayout = privateLayout;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public boolean getOriginalPrivateLayout() {
		return GetterUtil.getBoolean(
			this.<Boolean>getColumnOriginalValue("privateLayout"));
	}

	@JSON
	@Override
	public long getLayoutId() {
		return _layoutId;
	}

	@Override
	public void setLayoutId(long layoutId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_layoutId = layoutId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalLayoutId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("layoutId"));
	}

	@JSON
	@Override
	public long getParentLayoutId() {
		return _parentLayoutId;
	}

	@Override
	public void setParentLayoutId(long parentLayoutId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_parentLayoutId = parentLayoutId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalParentLayoutId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("parentLayoutId"));
	}

	@Override
	public String getClassName() {
		if (getClassNameId() <= 0) {
			return "";
		}

		return PortalUtil.getClassName(getClassNameId());
	}

	@Override
	public void setClassName(String className) {
		long classNameId = 0;

		if (Validator.isNotNull(className)) {
			classNameId = PortalUtil.getClassNameId(className);
		}

		setClassNameId(classNameId);
	}

	@JSON
	@Override
	public long getClassNameId() {
		return _classNameId;
	}

	@Override
	public void setClassNameId(long classNameId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_classNameId = classNameId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalClassNameId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("classNameId"));
	}

	@JSON
	@Override
	public long getClassPK() {
		return _classPK;
	}

	@Override
	public void setClassPK(long classPK) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_classPK = classPK;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalClassPK() {
		return GetterUtil.getLong(this.<Long>getColumnOriginalValue("classPK"));
	}

	@JSON
	@Override
	public String getName() {
		if (_name == null) {
			return "";
		}
		else {
			return _name;
		}
	}

	@Override
	public String getName(Locale locale) {
		String languageId = LocaleUtil.toLanguageId(locale);

		return getName(languageId);
	}

	@Override
	public String getName(Locale locale, boolean useDefault) {
		String languageId = LocaleUtil.toLanguageId(locale);

		return getName(languageId, useDefault);
	}

	@Override
	public String getName(String languageId) {
		return LocalizationUtil.getLocalization(getName(), languageId);
	}

	@Override
	public String getName(String languageId, boolean useDefault) {
		return LocalizationUtil.getLocalization(
			getName(), languageId, useDefault);
	}

	@Override
	public String getNameCurrentLanguageId() {
		return _nameCurrentLanguageId;
	}

	@JSON
	@Override
	public String getNameCurrentValue() {
		Locale locale = getLocale(_nameCurrentLanguageId);

		return getName(locale);
	}

	@Override
	public Map<Locale, String> getNameMap() {
		return LocalizationUtil.getLocalizationMap(getName());
	}

	@Override
	public void setName(String name) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_name = name;
	}

	@Override
	public void setName(String name, Locale locale) {
		setName(name, locale, LocaleUtil.getSiteDefault());
	}

	@Override
	public void setName(String name, Locale locale, Locale defaultLocale) {
		String languageId = LocaleUtil.toLanguageId(locale);
		String defaultLanguageId = LocaleUtil.toLanguageId(defaultLocale);

		if (Validator.isNotNull(name)) {
			setName(
				LocalizationUtil.updateLocalization(
					getName(), "Name", name, languageId, defaultLanguageId));
		}
		else {
			setName(
				LocalizationUtil.removeLocalization(
					getName(), "Name", languageId));
		}
	}

	@Override
	public void setNameCurrentLanguageId(String languageId) {
		_nameCurrentLanguageId = languageId;
	}

	@Override
	public void setNameMap(Map<Locale, String> nameMap) {
		setNameMap(nameMap, LocaleUtil.getSiteDefault());
	}

	@Override
	public void setNameMap(Map<Locale, String> nameMap, Locale defaultLocale) {
		if (nameMap == null) {
			return;
		}

		setName(
			LocalizationUtil.updateLocalization(
				nameMap, getName(), "Name",
				LocaleUtil.toLanguageId(defaultLocale)));
	}

	@JSON
	@Override
	public String getTitle() {
		if (_title == null) {
			return "";
		}
		else {
			return _title;
		}
	}

	@Override
	public String getTitle(Locale locale) {
		String languageId = LocaleUtil.toLanguageId(locale);

		return getTitle(languageId);
	}

	@Override
	public String getTitle(Locale locale, boolean useDefault) {
		String languageId = LocaleUtil.toLanguageId(locale);

		return getTitle(languageId, useDefault);
	}

	@Override
	public String getTitle(String languageId) {
		return LocalizationUtil.getLocalization(getTitle(), languageId);
	}

	@Override
	public String getTitle(String languageId, boolean useDefault) {
		return LocalizationUtil.getLocalization(
			getTitle(), languageId, useDefault);
	}

	@Override
	public String getTitleCurrentLanguageId() {
		return _titleCurrentLanguageId;
	}

	@JSON
	@Override
	public String getTitleCurrentValue() {
		Locale locale = getLocale(_titleCurrentLanguageId);

		return getTitle(locale);
	}

	@Override
	public Map<Locale, String> getTitleMap() {
		return LocalizationUtil.getLocalizationMap(getTitle());
	}

	@Override
	public void setTitle(String title) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_title = title;
	}

	@Override
	public void setTitle(String title, Locale locale) {
		setTitle(title, locale, LocaleUtil.getSiteDefault());
	}

	@Override
	public void setTitle(String title, Locale locale, Locale defaultLocale) {
		String languageId = LocaleUtil.toLanguageId(locale);
		String defaultLanguageId = LocaleUtil.toLanguageId(defaultLocale);

		if (Validator.isNotNull(title)) {
			setTitle(
				LocalizationUtil.updateLocalization(
					getTitle(), "Title", title, languageId, defaultLanguageId));
		}
		else {
			setTitle(
				LocalizationUtil.removeLocalization(
					getTitle(), "Title", languageId));
		}
	}

	@Override
	public void setTitleCurrentLanguageId(String languageId) {
		_titleCurrentLanguageId = languageId;
	}

	@Override
	public void setTitleMap(Map<Locale, String> titleMap) {
		setTitleMap(titleMap, LocaleUtil.getSiteDefault());
	}

	@Override
	public void setTitleMap(
		Map<Locale, String> titleMap, Locale defaultLocale) {

		if (titleMap == null) {
			return;
		}

		setTitle(
			LocalizationUtil.updateLocalization(
				titleMap, getTitle(), "Title",
				LocaleUtil.toLanguageId(defaultLocale)));
	}

	@JSON
	@Override
	public String getDescription() {
		if (_description == null) {
			return "";
		}
		else {
			return _description;
		}
	}

	@Override
	public String getDescription(Locale locale) {
		String languageId = LocaleUtil.toLanguageId(locale);

		return getDescription(languageId);
	}

	@Override
	public String getDescription(Locale locale, boolean useDefault) {
		String languageId = LocaleUtil.toLanguageId(locale);

		return getDescription(languageId, useDefault);
	}

	@Override
	public String getDescription(String languageId) {
		return LocalizationUtil.getLocalization(getDescription(), languageId);
	}

	@Override
	public String getDescription(String languageId, boolean useDefault) {
		return LocalizationUtil.getLocalization(
			getDescription(), languageId, useDefault);
	}

	@Override
	public String getDescriptionCurrentLanguageId() {
		return _descriptionCurrentLanguageId;
	}

	@JSON
	@Override
	public String getDescriptionCurrentValue() {
		Locale locale = getLocale(_descriptionCurrentLanguageId);

		return getDescription(locale);
	}

	@Override
	public Map<Locale, String> getDescriptionMap() {
		return LocalizationUtil.getLocalizationMap(getDescription());
	}

	@Override
	public void setDescription(String description) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_description = description;
	}

	@Override
	public void setDescription(String description, Locale locale) {
		setDescription(description, locale, LocaleUtil.getSiteDefault());
	}

	@Override
	public void setDescription(
		String description, Locale locale, Locale defaultLocale) {

		String languageId = LocaleUtil.toLanguageId(locale);
		String defaultLanguageId = LocaleUtil.toLanguageId(defaultLocale);

		if (Validator.isNotNull(description)) {
			setDescription(
				LocalizationUtil.updateLocalization(
					getDescription(), "Description", description, languageId,
					defaultLanguageId));
		}
		else {
			setDescription(
				LocalizationUtil.removeLocalization(
					getDescription(), "Description", languageId));
		}
	}

	@Override
	public void setDescriptionCurrentLanguageId(String languageId) {
		_descriptionCurrentLanguageId = languageId;
	}

	@Override
	public void setDescriptionMap(Map<Locale, String> descriptionMap) {
		setDescriptionMap(descriptionMap, LocaleUtil.getSiteDefault());
	}

	@Override
	public void setDescriptionMap(
		Map<Locale, String> descriptionMap, Locale defaultLocale) {

		if (descriptionMap == null) {
			return;
		}

		setDescription(
			LocalizationUtil.updateLocalization(
				descriptionMap, getDescription(), "Description",
				LocaleUtil.toLanguageId(defaultLocale)));
	}

	@JSON
	@Override
	public String getKeywords() {
		if (_keywords == null) {
			return "";
		}
		else {
			return _keywords;
		}
	}

	@Override
	public String getKeywords(Locale locale) {
		String languageId = LocaleUtil.toLanguageId(locale);

		return getKeywords(languageId);
	}

	@Override
	public String getKeywords(Locale locale, boolean useDefault) {
		String languageId = LocaleUtil.toLanguageId(locale);

		return getKeywords(languageId, useDefault);
	}

	@Override
	public String getKeywords(String languageId) {
		return LocalizationUtil.getLocalization(getKeywords(), languageId);
	}

	@Override
	public String getKeywords(String languageId, boolean useDefault) {
		return LocalizationUtil.getLocalization(
			getKeywords(), languageId, useDefault);
	}

	@Override
	public String getKeywordsCurrentLanguageId() {
		return _keywordsCurrentLanguageId;
	}

	@JSON
	@Override
	public String getKeywordsCurrentValue() {
		Locale locale = getLocale(_keywordsCurrentLanguageId);

		return getKeywords(locale);
	}

	@Override
	public Map<Locale, String> getKeywordsMap() {
		return LocalizationUtil.getLocalizationMap(getKeywords());
	}

	@Override
	public void setKeywords(String keywords) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_keywords = keywords;
	}

	@Override
	public void setKeywords(String keywords, Locale locale) {
		setKeywords(keywords, locale, LocaleUtil.getSiteDefault());
	}

	@Override
	public void setKeywords(
		String keywords, Locale locale, Locale defaultLocale) {

		String languageId = LocaleUtil.toLanguageId(locale);
		String defaultLanguageId = LocaleUtil.toLanguageId(defaultLocale);

		if (Validator.isNotNull(keywords)) {
			setKeywords(
				LocalizationUtil.updateLocalization(
					getKeywords(), "Keywords", keywords, languageId,
					defaultLanguageId));
		}
		else {
			setKeywords(
				LocalizationUtil.removeLocalization(
					getKeywords(), "Keywords", languageId));
		}
	}

	@Override
	public void setKeywordsCurrentLanguageId(String languageId) {
		_keywordsCurrentLanguageId = languageId;
	}

	@Override
	public void setKeywordsMap(Map<Locale, String> keywordsMap) {
		setKeywordsMap(keywordsMap, LocaleUtil.getSiteDefault());
	}

	@Override
	public void setKeywordsMap(
		Map<Locale, String> keywordsMap, Locale defaultLocale) {

		if (keywordsMap == null) {
			return;
		}

		setKeywords(
			LocalizationUtil.updateLocalization(
				keywordsMap, getKeywords(), "Keywords",
				LocaleUtil.toLanguageId(defaultLocale)));
	}

	@JSON
	@Override
	public String getRobots() {
		if (_robots == null) {
			return "";
		}
		else {
			return _robots;
		}
	}

	@Override
	public String getRobots(Locale locale) {
		String languageId = LocaleUtil.toLanguageId(locale);

		return getRobots(languageId);
	}

	@Override
	public String getRobots(Locale locale, boolean useDefault) {
		String languageId = LocaleUtil.toLanguageId(locale);

		return getRobots(languageId, useDefault);
	}

	@Override
	public String getRobots(String languageId) {
		return LocalizationUtil.getLocalization(getRobots(), languageId);
	}

	@Override
	public String getRobots(String languageId, boolean useDefault) {
		return LocalizationUtil.getLocalization(
			getRobots(), languageId, useDefault);
	}

	@Override
	public String getRobotsCurrentLanguageId() {
		return _robotsCurrentLanguageId;
	}

	@JSON
	@Override
	public String getRobotsCurrentValue() {
		Locale locale = getLocale(_robotsCurrentLanguageId);

		return getRobots(locale);
	}

	@Override
	public Map<Locale, String> getRobotsMap() {
		return LocalizationUtil.getLocalizationMap(getRobots());
	}

	@Override
	public void setRobots(String robots) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_robots = robots;
	}

	@Override
	public void setRobots(String robots, Locale locale) {
		setRobots(robots, locale, LocaleUtil.getSiteDefault());
	}

	@Override
	public void setRobots(String robots, Locale locale, Locale defaultLocale) {
		String languageId = LocaleUtil.toLanguageId(locale);
		String defaultLanguageId = LocaleUtil.toLanguageId(defaultLocale);

		if (Validator.isNotNull(robots)) {
			setRobots(
				LocalizationUtil.updateLocalization(
					getRobots(), "Robots", robots, languageId,
					defaultLanguageId));
		}
		else {
			setRobots(
				LocalizationUtil.removeLocalization(
					getRobots(), "Robots", languageId));
		}
	}

	@Override
	public void setRobotsCurrentLanguageId(String languageId) {
		_robotsCurrentLanguageId = languageId;
	}

	@Override
	public void setRobotsMap(Map<Locale, String> robotsMap) {
		setRobotsMap(robotsMap, LocaleUtil.getSiteDefault());
	}

	@Override
	public void setRobotsMap(
		Map<Locale, String> robotsMap, Locale defaultLocale) {

		if (robotsMap == null) {
			return;
		}

		setRobots(
			LocalizationUtil.updateLocalization(
				robotsMap, getRobots(), "Robots",
				LocaleUtil.toLanguageId(defaultLocale)));
	}

	@JSON
	@Override
	public String getType() {
		if (_type == null) {
			return "";
		}
		else {
			return _type;
		}
	}

	@Override
	public void setType(String type) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_type = type;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalType() {
		return getColumnOriginalValue("type_");
	}

	@JSON
	@Override
	public String getTypeSettings() {
		if (_typeSettings == null) {
			return "";
		}
		else {
			return _typeSettings;
		}
	}

	@Override
	public void setTypeSettings(String typeSettings) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_typeSettings = typeSettings;
	}

	@JSON
	@Override
	public boolean getHidden() {
		return _hidden;
	}

	@JSON
	@Override
	public boolean isHidden() {
		return _hidden;
	}

	@Override
	public void setHidden(boolean hidden) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_hidden = hidden;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public boolean getOriginalHidden() {
		return GetterUtil.getBoolean(
			this.<Boolean>getColumnOriginalValue("hidden_"));
	}

	@JSON
	@Override
	public boolean getSystem() {
		return _system;
	}

	@JSON
	@Override
	public boolean isSystem() {
		return _system;
	}

	@Override
	public void setSystem(boolean system) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_system = system;
	}

	@JSON
	@Override
	public String getFriendlyURL() {
		if (_friendlyURL == null) {
			return "";
		}
		else {
			return _friendlyURL;
		}
	}

	@Override
	public void setFriendlyURL(String friendlyURL) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_friendlyURL = friendlyURL;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalFriendlyURL() {
		return getColumnOriginalValue("friendlyURL");
	}

	@JSON
	@Override
	public long getIconImageId() {
		return _iconImageId;
	}

	@Override
	public void setIconImageId(long iconImageId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_iconImageId = iconImageId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalIconImageId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("iconImageId"));
	}

	@JSON
	@Override
	public String getThemeId() {
		if (_themeId == null) {
			return "";
		}
		else {
			return _themeId;
		}
	}

	@Override
	public void setThemeId(String themeId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_themeId = themeId;
	}

	@JSON
	@Override
	public String getColorSchemeId() {
		if (_colorSchemeId == null) {
			return "";
		}
		else {
			return _colorSchemeId;
		}
	}

	@Override
	public void setColorSchemeId(String colorSchemeId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_colorSchemeId = colorSchemeId;
	}

	@JSON
	@Override
	public long getStyleBookEntryId() {
		return _styleBookEntryId;
	}

	@Override
	public void setStyleBookEntryId(long styleBookEntryId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_styleBookEntryId = styleBookEntryId;
	}

	@JSON
	@Override
	public String getCss() {
		if (_css == null) {
			return "";
		}
		else {
			return _css;
		}
	}

	@Override
	public void setCss(String css) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_css = css;
	}

	@JSON
	@Override
	public int getPriority() {
		return _priority;
	}

	@Override
	public void setPriority(int priority) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_priority = priority;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public int getOriginalPriority() {
		return GetterUtil.getInteger(
			this.<Integer>getColumnOriginalValue("priority"));
	}

	@JSON
	@Override
	public long getMasterLayoutPlid() {
		return _masterLayoutPlid;
	}

	@Override
	public void setMasterLayoutPlid(long masterLayoutPlid) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_masterLayoutPlid = masterLayoutPlid;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalMasterLayoutPlid() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("masterLayoutPlid"));
	}

	@JSON
	@Override
	public String getLayoutPrototypeUuid() {
		if (_layoutPrototypeUuid == null) {
			return "";
		}
		else {
			return _layoutPrototypeUuid;
		}
	}

	@Override
	public void setLayoutPrototypeUuid(String layoutPrototypeUuid) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_layoutPrototypeUuid = layoutPrototypeUuid;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalLayoutPrototypeUuid() {
		return getColumnOriginalValue("layoutPrototypeUuid");
	}

	@JSON
	@Override
	public boolean getLayoutPrototypeLinkEnabled() {
		return _layoutPrototypeLinkEnabled;
	}

	@JSON
	@Override
	public boolean isLayoutPrototypeLinkEnabled() {
		return _layoutPrototypeLinkEnabled;
	}

	@Override
	public void setLayoutPrototypeLinkEnabled(
		boolean layoutPrototypeLinkEnabled) {

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_layoutPrototypeLinkEnabled = layoutPrototypeLinkEnabled;
	}

	@JSON
	@Override
	public String getSourcePrototypeLayoutUuid() {
		if (_sourcePrototypeLayoutUuid == null) {
			return "";
		}
		else {
			return _sourcePrototypeLayoutUuid;
		}
	}

	@Override
	public void setSourcePrototypeLayoutUuid(String sourcePrototypeLayoutUuid) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_sourcePrototypeLayoutUuid = sourcePrototypeLayoutUuid;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalSourcePrototypeLayoutUuid() {
		return getColumnOriginalValue("sourcePrototypeLayoutUuid");
	}

	@JSON
	@Override
	public Date getPublishDate() {
		return _publishDate;
	}

	@Override
	public void setPublishDate(Date publishDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_publishDate = publishDate;
	}

	@JSON
	@Override
	public Date getLastPublishDate() {
		return _lastPublishDate;
	}

	@Override
	public void setLastPublishDate(Date lastPublishDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_lastPublishDate = lastPublishDate;
	}

	@JSON
	@Override
	public int getStatus() {
		return _status;
	}

	@Override
	public void setStatus(int status) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_status = status;
	}

	@JSON
	@Override
	public long getStatusByUserId() {
		return _statusByUserId;
	}

	@Override
	public void setStatusByUserId(long statusByUserId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_statusByUserId = statusByUserId;
	}

	@Override
	public String getStatusByUserUuid() {
		try {
			User user = UserLocalServiceUtil.getUserById(getStatusByUserId());

			return user.getUuid();
		}
		catch (PortalException portalException) {
			return "";
		}
	}

	@Override
	public void setStatusByUserUuid(String statusByUserUuid) {
	}

	@JSON
	@Override
	public String getStatusByUserName() {
		if (_statusByUserName == null) {
			return "";
		}
		else {
			return _statusByUserName;
		}
	}

	@Override
	public void setStatusByUserName(String statusByUserName) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_statusByUserName = statusByUserName;
	}

	@JSON
	@Override
	public Date getStatusDate() {
		return _statusDate;
	}

	@Override
	public void setStatusDate(Date statusDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_statusDate = statusDate;
	}

	@Override
	public StagedModelType getStagedModelType() {
		return new StagedModelType(
			PortalUtil.getClassNameId(Layout.class.getName()),
			getClassNameId());
	}

	@Override
	public boolean isApproved() {
		if (getStatus() == WorkflowConstants.STATUS_APPROVED) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isDenied() {
		if (getStatus() == WorkflowConstants.STATUS_DENIED) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isDraft() {
		if (getStatus() == WorkflowConstants.STATUS_DRAFT) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isExpired() {
		if (getStatus() == WorkflowConstants.STATUS_EXPIRED) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isInactive() {
		if (getStatus() == WorkflowConstants.STATUS_INACTIVE) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isIncomplete() {
		if (getStatus() == WorkflowConstants.STATUS_INCOMPLETE) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isPending() {
		if (getStatus() == WorkflowConstants.STATUS_PENDING) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isScheduled() {
		if (getStatus() == WorkflowConstants.STATUS_SCHEDULED) {
			return true;
		}
		else {
			return false;
		}
	}

	public long getColumnBitmask() {
		if (_columnBitmask > 0) {
			return _columnBitmask;
		}

		if ((_columnOriginalValues == null) ||
			(_columnOriginalValues == Collections.EMPTY_MAP)) {

			return 0;
		}

		for (Map.Entry<String, Object> entry :
				_columnOriginalValues.entrySet()) {

			if (entry.getValue() != getColumnValue(entry.getKey())) {
				_columnBitmask |= _columnBitmasks.get(entry.getKey());
			}
		}

		return _columnBitmask;
	}

	@Override
	public ExpandoBridge getExpandoBridge() {
		return ExpandoBridgeFactoryUtil.getExpandoBridge(
			getCompanyId(), Layout.class.getName(), getPrimaryKey());
	}

	@Override
	public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
		ExpandoBridge expandoBridge = getExpandoBridge();

		expandoBridge.setAttributes(serviceContext);
	}

	@Override
	public String[] getAvailableLanguageIds() {
		Set<String> availableLanguageIds = new TreeSet<String>();

		Map<Locale, String> nameMap = getNameMap();

		for (Map.Entry<Locale, String> entry : nameMap.entrySet()) {
			Locale locale = entry.getKey();
			String value = entry.getValue();

			if (Validator.isNotNull(value)) {
				availableLanguageIds.add(LocaleUtil.toLanguageId(locale));
			}
		}

		Map<Locale, String> titleMap = getTitleMap();

		for (Map.Entry<Locale, String> entry : titleMap.entrySet()) {
			Locale locale = entry.getKey();
			String value = entry.getValue();

			if (Validator.isNotNull(value)) {
				availableLanguageIds.add(LocaleUtil.toLanguageId(locale));
			}
		}

		Map<Locale, String> descriptionMap = getDescriptionMap();

		for (Map.Entry<Locale, String> entry : descriptionMap.entrySet()) {
			Locale locale = entry.getKey();
			String value = entry.getValue();

			if (Validator.isNotNull(value)) {
				availableLanguageIds.add(LocaleUtil.toLanguageId(locale));
			}
		}

		Map<Locale, String> keywordsMap = getKeywordsMap();

		for (Map.Entry<Locale, String> entry : keywordsMap.entrySet()) {
			Locale locale = entry.getKey();
			String value = entry.getValue();

			if (Validator.isNotNull(value)) {
				availableLanguageIds.add(LocaleUtil.toLanguageId(locale));
			}
		}

		Map<Locale, String> robotsMap = getRobotsMap();

		for (Map.Entry<Locale, String> entry : robotsMap.entrySet()) {
			Locale locale = entry.getKey();
			String value = entry.getValue();

			if (Validator.isNotNull(value)) {
				availableLanguageIds.add(LocaleUtil.toLanguageId(locale));
			}
		}

		return availableLanguageIds.toArray(
			new String[availableLanguageIds.size()]);
	}

	@Override
	public String getDefaultLanguageId() {
		String xml = getName();

		if (xml == null) {
			return "";
		}

		Locale defaultLocale = LocaleUtil.getSiteDefault();

		return LocalizationUtil.getDefaultLanguageId(xml, defaultLocale);
	}

	@Override
	public void prepareLocalizedFieldsForImport() throws LocaleException {
		Locale defaultLocale = LocaleUtil.fromLanguageId(
			getDefaultLanguageId());

		Locale[] availableLocales = LocaleUtil.fromLanguageIds(
			getAvailableLanguageIds());

		Locale defaultImportLocale = LocalizationUtil.getDefaultImportLocale(
			Layout.class.getName(), getPrimaryKey(), defaultLocale,
			availableLocales);

		prepareLocalizedFieldsForImport(defaultImportLocale);
	}

	@Override
	@SuppressWarnings("unused")
	public void prepareLocalizedFieldsForImport(Locale defaultImportLocale)
		throws LocaleException {

		Locale defaultLocale = LocaleUtil.getSiteDefault();

		String modelDefaultLanguageId = getDefaultLanguageId();

		String name = getName(defaultLocale);

		if (Validator.isNull(name)) {
			setName(getName(modelDefaultLanguageId), defaultLocale);
		}
		else {
			setName(getName(defaultLocale), defaultLocale, defaultLocale);
		}

		String title = getTitle(defaultLocale);

		if (Validator.isNull(title)) {
			setTitle(getTitle(modelDefaultLanguageId), defaultLocale);
		}
		else {
			setTitle(getTitle(defaultLocale), defaultLocale, defaultLocale);
		}

		String description = getDescription(defaultLocale);

		if (Validator.isNull(description)) {
			setDescription(
				getDescription(modelDefaultLanguageId), defaultLocale);
		}
		else {
			setDescription(
				getDescription(defaultLocale), defaultLocale, defaultLocale);
		}

		String keywords = getKeywords(defaultLocale);

		if (Validator.isNull(keywords)) {
			setKeywords(getKeywords(modelDefaultLanguageId), defaultLocale);
		}
		else {
			setKeywords(
				getKeywords(defaultLocale), defaultLocale, defaultLocale);
		}

		String robots = getRobots(defaultLocale);

		if (Validator.isNull(robots)) {
			setRobots(getRobots(modelDefaultLanguageId), defaultLocale);
		}
		else {
			setRobots(getRobots(defaultLocale), defaultLocale, defaultLocale);
		}
	}

	@Override
	public Layout toEscapedModel() {
		if (_escapedModel == null) {
			Function<InvocationHandler, Layout>
				escapedModelProxyProviderFunction =
					EscapedModelProxyProviderFunctionHolder.
						_escapedModelProxyProviderFunction;

			_escapedModel = escapedModelProxyProviderFunction.apply(
				new AutoEscapeBeanHandler(this));
		}

		return _escapedModel;
	}

	@Override
	public Object clone() {
		LayoutImpl layoutImpl = new LayoutImpl();

		layoutImpl.setMvccVersion(getMvccVersion());
		layoutImpl.setCtCollectionId(getCtCollectionId());
		layoutImpl.setUuid(getUuid());
		layoutImpl.setPlid(getPlid());
		layoutImpl.setGroupId(getGroupId());
		layoutImpl.setCompanyId(getCompanyId());
		layoutImpl.setUserId(getUserId());
		layoutImpl.setUserName(getUserName());
		layoutImpl.setCreateDate(getCreateDate());
		layoutImpl.setModifiedDate(getModifiedDate());
		layoutImpl.setParentPlid(getParentPlid());
		layoutImpl.setPrivateLayout(isPrivateLayout());
		layoutImpl.setLayoutId(getLayoutId());
		layoutImpl.setParentLayoutId(getParentLayoutId());
		layoutImpl.setClassNameId(getClassNameId());
		layoutImpl.setClassPK(getClassPK());
		layoutImpl.setName(getName());
		layoutImpl.setTitle(getTitle());
		layoutImpl.setDescription(getDescription());
		layoutImpl.setKeywords(getKeywords());
		layoutImpl.setRobots(getRobots());
		layoutImpl.setType(getType());
		layoutImpl.setTypeSettings(getTypeSettings());
		layoutImpl.setHidden(isHidden());
		layoutImpl.setSystem(isSystem());
		layoutImpl.setFriendlyURL(getFriendlyURL());
		layoutImpl.setIconImageId(getIconImageId());
		layoutImpl.setThemeId(getThemeId());
		layoutImpl.setColorSchemeId(getColorSchemeId());
		layoutImpl.setStyleBookEntryId(getStyleBookEntryId());
		layoutImpl.setCss(getCss());
		layoutImpl.setPriority(getPriority());
		layoutImpl.setMasterLayoutPlid(getMasterLayoutPlid());
		layoutImpl.setLayoutPrototypeUuid(getLayoutPrototypeUuid());
		layoutImpl.setLayoutPrototypeLinkEnabled(
			isLayoutPrototypeLinkEnabled());
		layoutImpl.setSourcePrototypeLayoutUuid(getSourcePrototypeLayoutUuid());
		layoutImpl.setPublishDate(getPublishDate());
		layoutImpl.setLastPublishDate(getLastPublishDate());
		layoutImpl.setStatus(getStatus());
		layoutImpl.setStatusByUserId(getStatusByUserId());
		layoutImpl.setStatusByUserName(getStatusByUserName());
		layoutImpl.setStatusDate(getStatusDate());

		layoutImpl.resetOriginalValues();

		return layoutImpl;
	}

	@Override
	public int compareTo(Layout layout) {
		int value = 0;

		if (getParentLayoutId() < layout.getParentLayoutId()) {
			value = -1;
		}
		else if (getParentLayoutId() > layout.getParentLayoutId()) {
			value = 1;
		}
		else {
			value = 0;
		}

		if (value != 0) {
			return value;
		}

		if (getPriority() < layout.getPriority()) {
			value = -1;
		}
		else if (getPriority() > layout.getPriority()) {
			value = 1;
		}
		else {
			value = 0;
		}

		if (value != 0) {
			return value;
		}

		return 0;
	}

	@Override
	public boolean equals(Object object) {
		if (this == object) {
			return true;
		}

		if (!(object instanceof Layout)) {
			return false;
		}

		Layout layout = (Layout)object;

		long primaryKey = layout.getPrimaryKey();

		if (getPrimaryKey() == primaryKey) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public int hashCode() {
		return (int)getPrimaryKey();
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isEntityCacheEnabled() {
		return ENTITY_CACHE_ENABLED;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isFinderCacheEnabled() {
		return FINDER_CACHE_ENABLED;
	}

	@Override
	public void resetOriginalValues() {
		_columnOriginalValues = Collections.emptyMap();

		_setModifiedDate = false;

		_columnBitmask = 0;
	}

	@Override
	public CacheModel<Layout> toCacheModel() {
		LayoutCacheModel layoutCacheModel = new LayoutCacheModel();

		layoutCacheModel.mvccVersion = getMvccVersion();

		layoutCacheModel.ctCollectionId = getCtCollectionId();

		layoutCacheModel.uuid = getUuid();

		String uuid = layoutCacheModel.uuid;

		if ((uuid != null) && (uuid.length() == 0)) {
			layoutCacheModel.uuid = null;
		}

		layoutCacheModel.plid = getPlid();

		layoutCacheModel.groupId = getGroupId();

		layoutCacheModel.companyId = getCompanyId();

		layoutCacheModel.userId = getUserId();

		layoutCacheModel.userName = getUserName();

		String userName = layoutCacheModel.userName;

		if ((userName != null) && (userName.length() == 0)) {
			layoutCacheModel.userName = null;
		}

		Date createDate = getCreateDate();

		if (createDate != null) {
			layoutCacheModel.createDate = createDate.getTime();
		}
		else {
			layoutCacheModel.createDate = Long.MIN_VALUE;
		}

		Date modifiedDate = getModifiedDate();

		if (modifiedDate != null) {
			layoutCacheModel.modifiedDate = modifiedDate.getTime();
		}
		else {
			layoutCacheModel.modifiedDate = Long.MIN_VALUE;
		}

		layoutCacheModel.parentPlid = getParentPlid();

		layoutCacheModel.privateLayout = isPrivateLayout();

		layoutCacheModel.layoutId = getLayoutId();

		layoutCacheModel.parentLayoutId = getParentLayoutId();

		layoutCacheModel.classNameId = getClassNameId();

		layoutCacheModel.classPK = getClassPK();

		layoutCacheModel.name = getName();

		String name = layoutCacheModel.name;

		if ((name != null) && (name.length() == 0)) {
			layoutCacheModel.name = null;
		}

		layoutCacheModel.title = getTitle();

		String title = layoutCacheModel.title;

		if ((title != null) && (title.length() == 0)) {
			layoutCacheModel.title = null;
		}

		layoutCacheModel.description = getDescription();

		String description = layoutCacheModel.description;

		if ((description != null) && (description.length() == 0)) {
			layoutCacheModel.description = null;
		}

		layoutCacheModel.keywords = getKeywords();

		String keywords = layoutCacheModel.keywords;

		if ((keywords != null) && (keywords.length() == 0)) {
			layoutCacheModel.keywords = null;
		}

		layoutCacheModel.robots = getRobots();

		String robots = layoutCacheModel.robots;

		if ((robots != null) && (robots.length() == 0)) {
			layoutCacheModel.robots = null;
		}

		layoutCacheModel.type = getType();

		String type = layoutCacheModel.type;

		if ((type != null) && (type.length() == 0)) {
			layoutCacheModel.type = null;
		}

		layoutCacheModel.typeSettings = getTypeSettings();

		String typeSettings = layoutCacheModel.typeSettings;

		if ((typeSettings != null) && (typeSettings.length() == 0)) {
			layoutCacheModel.typeSettings = null;
		}

		layoutCacheModel.hidden = isHidden();

		layoutCacheModel.system = isSystem();

		layoutCacheModel.friendlyURL = getFriendlyURL();

		String friendlyURL = layoutCacheModel.friendlyURL;

		if ((friendlyURL != null) && (friendlyURL.length() == 0)) {
			layoutCacheModel.friendlyURL = null;
		}

		layoutCacheModel.iconImageId = getIconImageId();

		layoutCacheModel.themeId = getThemeId();

		String themeId = layoutCacheModel.themeId;

		if ((themeId != null) && (themeId.length() == 0)) {
			layoutCacheModel.themeId = null;
		}

		layoutCacheModel.colorSchemeId = getColorSchemeId();

		String colorSchemeId = layoutCacheModel.colorSchemeId;

		if ((colorSchemeId != null) && (colorSchemeId.length() == 0)) {
			layoutCacheModel.colorSchemeId = null;
		}

		layoutCacheModel.styleBookEntryId = getStyleBookEntryId();

		layoutCacheModel.css = getCss();

		String css = layoutCacheModel.css;

		if ((css != null) && (css.length() == 0)) {
			layoutCacheModel.css = null;
		}

		layoutCacheModel.priority = getPriority();

		layoutCacheModel.masterLayoutPlid = getMasterLayoutPlid();

		layoutCacheModel.layoutPrototypeUuid = getLayoutPrototypeUuid();

		String layoutPrototypeUuid = layoutCacheModel.layoutPrototypeUuid;

		if ((layoutPrototypeUuid != null) &&
			(layoutPrototypeUuid.length() == 0)) {

			layoutCacheModel.layoutPrototypeUuid = null;
		}

		layoutCacheModel.layoutPrototypeLinkEnabled =
			isLayoutPrototypeLinkEnabled();

		layoutCacheModel.sourcePrototypeLayoutUuid =
			getSourcePrototypeLayoutUuid();

		String sourcePrototypeLayoutUuid =
			layoutCacheModel.sourcePrototypeLayoutUuid;

		if ((sourcePrototypeLayoutUuid != null) &&
			(sourcePrototypeLayoutUuid.length() == 0)) {

			layoutCacheModel.sourcePrototypeLayoutUuid = null;
		}

		Date publishDate = getPublishDate();

		if (publishDate != null) {
			layoutCacheModel.publishDate = publishDate.getTime();
		}
		else {
			layoutCacheModel.publishDate = Long.MIN_VALUE;
		}

		Date lastPublishDate = getLastPublishDate();

		if (lastPublishDate != null) {
			layoutCacheModel.lastPublishDate = lastPublishDate.getTime();
		}
		else {
			layoutCacheModel.lastPublishDate = Long.MIN_VALUE;
		}

		layoutCacheModel.status = getStatus();

		layoutCacheModel.statusByUserId = getStatusByUserId();

		layoutCacheModel.statusByUserName = getStatusByUserName();

		String statusByUserName = layoutCacheModel.statusByUserName;

		if ((statusByUserName != null) && (statusByUserName.length() == 0)) {
			layoutCacheModel.statusByUserName = null;
		}

		Date statusDate = getStatusDate();

		if (statusDate != null) {
			layoutCacheModel.statusDate = statusDate.getTime();
		}
		else {
			layoutCacheModel.statusDate = Long.MIN_VALUE;
		}

		return layoutCacheModel;
	}

	@Override
	public String toString() {
		Map<String, Function<Layout, Object>> attributeGetterFunctions =
			getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(4 * attributeGetterFunctions.size()) + 2);

		sb.append("{");

		for (Map.Entry<String, Function<Layout, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<Layout, Object> attributeGetterFunction = entry.getValue();

			sb.append(attributeName);
			sb.append("=");
			sb.append(attributeGetterFunction.apply((Layout)this));
			sb.append(", ");
		}

		if (sb.index() > 1) {
			sb.setIndex(sb.index() - 1);
		}

		sb.append("}");

		return sb.toString();
	}

	@Override
	public String toXmlString() {
		Map<String, Function<Layout, Object>> attributeGetterFunctions =
			getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(5 * attributeGetterFunctions.size()) + 4);

		sb.append("<model><model-name>");
		sb.append(getModelClassName());
		sb.append("</model-name>");

		for (Map.Entry<String, Function<Layout, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<Layout, Object> attributeGetterFunction = entry.getValue();

			sb.append("<column><column-name>");
			sb.append(attributeName);
			sb.append("</column-name><column-value><![CDATA[");
			sb.append(attributeGetterFunction.apply((Layout)this));
			sb.append("]]></column-value></column>");
		}

		sb.append("</model>");

		return sb.toString();
	}

	private static class EscapedModelProxyProviderFunctionHolder {

		private static final Function<InvocationHandler, Layout>
			_escapedModelProxyProviderFunction = _getProxyProviderFunction();

	}

	private long _mvccVersion;
	private long _ctCollectionId;
	private String _uuid;
	private long _plid;
	private long _groupId;
	private long _companyId;
	private long _userId;
	private String _userName;
	private Date _createDate;
	private Date _modifiedDate;
	private boolean _setModifiedDate;
	private long _parentPlid;
	private boolean _privateLayout;
	private long _layoutId;
	private long _parentLayoutId;
	private long _classNameId;
	private long _classPK;
	private String _name;
	private String _nameCurrentLanguageId;
	private String _title;
	private String _titleCurrentLanguageId;
	private String _description;
	private String _descriptionCurrentLanguageId;
	private String _keywords;
	private String _keywordsCurrentLanguageId;
	private String _robots;
	private String _robotsCurrentLanguageId;
	private String _type;
	private String _typeSettings;
	private boolean _hidden;
	private boolean _system;
	private String _friendlyURL;
	private long _iconImageId;
	private String _themeId;
	private String _colorSchemeId;
	private long _styleBookEntryId;
	private String _css;
	private int _priority;
	private long _masterLayoutPlid;
	private String _layoutPrototypeUuid;
	private boolean _layoutPrototypeLinkEnabled;
	private String _sourcePrototypeLayoutUuid;
	private Date _publishDate;
	private Date _lastPublishDate;
	private int _status;
	private long _statusByUserId;
	private String _statusByUserName;
	private Date _statusDate;

	public <T> T getColumnValue(String columnName) {
		columnName = _attributeNames.getOrDefault(columnName, columnName);

		Function<Layout, Object> function = _attributeGetterFunctions.get(
			columnName);

		if (function == null) {
			throw new IllegalArgumentException(
				"No attribute getter function found for " + columnName);
		}

		return (T)function.apply((Layout)this);
	}

	public <T> T getColumnOriginalValue(String columnName) {
		if (_columnOriginalValues == null) {
			return null;
		}

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		return (T)_columnOriginalValues.get(columnName);
	}

	private void _setColumnOriginalValues() {
		_columnOriginalValues = new HashMap<String, Object>();

		_columnOriginalValues.put("mvccVersion", _mvccVersion);
		_columnOriginalValues.put("ctCollectionId", _ctCollectionId);
		_columnOriginalValues.put("uuid_", _uuid);
		_columnOriginalValues.put("plid", _plid);
		_columnOriginalValues.put("groupId", _groupId);
		_columnOriginalValues.put("companyId", _companyId);
		_columnOriginalValues.put("userId", _userId);
		_columnOriginalValues.put("userName", _userName);
		_columnOriginalValues.put("createDate", _createDate);
		_columnOriginalValues.put("modifiedDate", _modifiedDate);
		_columnOriginalValues.put("parentPlid", _parentPlid);
		_columnOriginalValues.put("privateLayout", _privateLayout);
		_columnOriginalValues.put("layoutId", _layoutId);
		_columnOriginalValues.put("parentLayoutId", _parentLayoutId);
		_columnOriginalValues.put("classNameId", _classNameId);
		_columnOriginalValues.put("classPK", _classPK);
		_columnOriginalValues.put("name", _name);
		_columnOriginalValues.put("title", _title);
		_columnOriginalValues.put("description", _description);
		_columnOriginalValues.put("keywords", _keywords);
		_columnOriginalValues.put("robots", _robots);
		_columnOriginalValues.put("type_", _type);
		_columnOriginalValues.put("typeSettings", _typeSettings);
		_columnOriginalValues.put("hidden_", _hidden);
		_columnOriginalValues.put("system_", _system);
		_columnOriginalValues.put("friendlyURL", _friendlyURL);
		_columnOriginalValues.put("iconImageId", _iconImageId);
		_columnOriginalValues.put("themeId", _themeId);
		_columnOriginalValues.put("colorSchemeId", _colorSchemeId);
		_columnOriginalValues.put("styleBookEntryId", _styleBookEntryId);
		_columnOriginalValues.put("css", _css);
		_columnOriginalValues.put("priority", _priority);
		_columnOriginalValues.put("masterLayoutPlid", _masterLayoutPlid);
		_columnOriginalValues.put("layoutPrototypeUuid", _layoutPrototypeUuid);
		_columnOriginalValues.put(
			"layoutPrototypeLinkEnabled", _layoutPrototypeLinkEnabled);
		_columnOriginalValues.put(
			"sourcePrototypeLayoutUuid", _sourcePrototypeLayoutUuid);
		_columnOriginalValues.put("publishDate", _publishDate);
		_columnOriginalValues.put("lastPublishDate", _lastPublishDate);
		_columnOriginalValues.put("status", _status);
		_columnOriginalValues.put("statusByUserId", _statusByUserId);
		_columnOriginalValues.put("statusByUserName", _statusByUserName);
		_columnOriginalValues.put("statusDate", _statusDate);
	}

	private static final Map<String, String> _attributeNames;

	static {
		Map<String, String> attributeNames = new HashMap<>();

		attributeNames.put("uuid_", "uuid");
		attributeNames.put("type_", "type");
		attributeNames.put("hidden_", "hidden");
		attributeNames.put("system_", "system");

		_attributeNames = Collections.unmodifiableMap(attributeNames);
	}

	private transient Map<String, Object> _columnOriginalValues;

	public static long getColumnBitmask(String columnName) {
		return _columnBitmasks.get(columnName);
	}

	private static final Map<String, Long> _columnBitmasks;

	static {
		Map<String, Long> columnBitmasks = new HashMap<>();

		columnBitmasks.put("mvccVersion", 1L);

		columnBitmasks.put("ctCollectionId", 2L);

		columnBitmasks.put("uuid_", 4L);

		columnBitmasks.put("plid", 8L);

		columnBitmasks.put("groupId", 16L);

		columnBitmasks.put("companyId", 32L);

		columnBitmasks.put("userId", 64L);

		columnBitmasks.put("userName", 128L);

		columnBitmasks.put("createDate", 256L);

		columnBitmasks.put("modifiedDate", 512L);

		columnBitmasks.put("parentPlid", 1024L);

		columnBitmasks.put("privateLayout", 2048L);

		columnBitmasks.put("layoutId", 4096L);

		columnBitmasks.put("parentLayoutId", 8192L);

		columnBitmasks.put("classNameId", 16384L);

		columnBitmasks.put("classPK", 32768L);

		columnBitmasks.put("name", 65536L);

		columnBitmasks.put("title", 131072L);

		columnBitmasks.put("description", 262144L);

		columnBitmasks.put("keywords", 524288L);

		columnBitmasks.put("robots", 1048576L);

		columnBitmasks.put("type_", 2097152L);

		columnBitmasks.put("typeSettings", 4194304L);

		columnBitmasks.put("hidden_", 8388608L);

		columnBitmasks.put("system_", 16777216L);

		columnBitmasks.put("friendlyURL", 33554432L);

		columnBitmasks.put("iconImageId", 67108864L);

		columnBitmasks.put("themeId", 134217728L);

		columnBitmasks.put("colorSchemeId", 268435456L);

		columnBitmasks.put("styleBookEntryId", 536870912L);

		columnBitmasks.put("css", 1073741824L);

		columnBitmasks.put("priority", 2147483648L);

		columnBitmasks.put("masterLayoutPlid", 4294967296L);

		columnBitmasks.put("layoutPrototypeUuid", 8589934592L);

		columnBitmasks.put("layoutPrototypeLinkEnabled", 17179869184L);

		columnBitmasks.put("sourcePrototypeLayoutUuid", 34359738368L);

		columnBitmasks.put("publishDate", 68719476736L);

		columnBitmasks.put("lastPublishDate", 137438953472L);

		columnBitmasks.put("status", 274877906944L);

		columnBitmasks.put("statusByUserId", 549755813888L);

		columnBitmasks.put("statusByUserName", 1099511627776L);

		columnBitmasks.put("statusDate", 2199023255552L);

		_columnBitmasks = Collections.unmodifiableMap(columnBitmasks);
	}

	private long _columnBitmask;
	private Layout _escapedModel;

}