/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.oauth2.provider.model;

import com.liferay.portal.kernel.bean.AutoEscape;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.ShardedModel;

import java.util.Date;

import org.osgi.annotation.versioning.ProviderType;

/**
 * The base model interface for the OAuth2Authorization service. Represents a row in the &quot;OAuth2Authorization&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This interface and its corresponding implementation <code>com.liferay.oauth2.provider.model.impl.OAuth2AuthorizationModelImpl</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in <code>com.liferay.oauth2.provider.model.impl.OAuth2AuthorizationImpl</code>.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see OAuth2Authorization
 * @generated
 */
@ProviderType
public interface OAuth2AuthorizationModel
	extends BaseModel<OAuth2Authorization>, ShardedModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this interface directly. All methods that expect a o auth2 authorization model instance should use the {@link OAuth2Authorization} interface instead.
	 */

	/**
	 * Returns the primary key of this o auth2 authorization.
	 *
	 * @return the primary key of this o auth2 authorization
	 */
	public long getPrimaryKey();

	/**
	 * Sets the primary key of this o auth2 authorization.
	 *
	 * @param primaryKey the primary key of this o auth2 authorization
	 */
	public void setPrimaryKey(long primaryKey);

	/**
	 * Returns the o auth2 authorization ID of this o auth2 authorization.
	 *
	 * @return the o auth2 authorization ID of this o auth2 authorization
	 */
	public long getOAuth2AuthorizationId();

	/**
	 * Sets the o auth2 authorization ID of this o auth2 authorization.
	 *
	 * @param oAuth2AuthorizationId the o auth2 authorization ID of this o auth2 authorization
	 */
	public void setOAuth2AuthorizationId(long oAuth2AuthorizationId);

	/**
	 * Returns the company ID of this o auth2 authorization.
	 *
	 * @return the company ID of this o auth2 authorization
	 */
	@Override
	public long getCompanyId();

	/**
	 * Sets the company ID of this o auth2 authorization.
	 *
	 * @param companyId the company ID of this o auth2 authorization
	 */
	@Override
	public void setCompanyId(long companyId);

	/**
	 * Returns the user ID of this o auth2 authorization.
	 *
	 * @return the user ID of this o auth2 authorization
	 */
	public long getUserId();

	/**
	 * Sets the user ID of this o auth2 authorization.
	 *
	 * @param userId the user ID of this o auth2 authorization
	 */
	public void setUserId(long userId);

	/**
	 * Returns the user uuid of this o auth2 authorization.
	 *
	 * @return the user uuid of this o auth2 authorization
	 */
	public String getUserUuid();

	/**
	 * Sets the user uuid of this o auth2 authorization.
	 *
	 * @param userUuid the user uuid of this o auth2 authorization
	 */
	public void setUserUuid(String userUuid);

	/**
	 * Returns the user name of this o auth2 authorization.
	 *
	 * @return the user name of this o auth2 authorization
	 */
	@AutoEscape
	public String getUserName();

	/**
	 * Sets the user name of this o auth2 authorization.
	 *
	 * @param userName the user name of this o auth2 authorization
	 */
	public void setUserName(String userName);

	/**
	 * Returns the create date of this o auth2 authorization.
	 *
	 * @return the create date of this o auth2 authorization
	 */
	public Date getCreateDate();

	/**
	 * Sets the create date of this o auth2 authorization.
	 *
	 * @param createDate the create date of this o auth2 authorization
	 */
	public void setCreateDate(Date createDate);

	/**
	 * Returns the o auth2 application ID of this o auth2 authorization.
	 *
	 * @return the o auth2 application ID of this o auth2 authorization
	 */
	public long getOAuth2ApplicationId();

	/**
	 * Sets the o auth2 application ID of this o auth2 authorization.
	 *
	 * @param oAuth2ApplicationId the o auth2 application ID of this o auth2 authorization
	 */
	public void setOAuth2ApplicationId(long oAuth2ApplicationId);

	/**
	 * Returns the o auth2 application scope aliases ID of this o auth2 authorization.
	 *
	 * @return the o auth2 application scope aliases ID of this o auth2 authorization
	 */
	public long getOAuth2ApplicationScopeAliasesId();

	/**
	 * Sets the o auth2 application scope aliases ID of this o auth2 authorization.
	 *
	 * @param oAuth2ApplicationScopeAliasesId the o auth2 application scope aliases ID of this o auth2 authorization
	 */
	public void setOAuth2ApplicationScopeAliasesId(
		long oAuth2ApplicationScopeAliasesId);

	/**
	 * Returns the access token content of this o auth2 authorization.
	 *
	 * @return the access token content of this o auth2 authorization
	 */
	@AutoEscape
	public String getAccessTokenContent();

	/**
	 * Sets the access token content of this o auth2 authorization.
	 *
	 * @param accessTokenContent the access token content of this o auth2 authorization
	 */
	public void setAccessTokenContent(String accessTokenContent);

	/**
	 * Returns the access token content hash of this o auth2 authorization.
	 *
	 * @return the access token content hash of this o auth2 authorization
	 */
	public long getAccessTokenContentHash();

	/**
	 * Sets the access token content hash of this o auth2 authorization.
	 *
	 * @param accessTokenContentHash the access token content hash of this o auth2 authorization
	 */
	public void setAccessTokenContentHash(long accessTokenContentHash);

	/**
	 * Returns the access token create date of this o auth2 authorization.
	 *
	 * @return the access token create date of this o auth2 authorization
	 */
	public Date getAccessTokenCreateDate();

	/**
	 * Sets the access token create date of this o auth2 authorization.
	 *
	 * @param accessTokenCreateDate the access token create date of this o auth2 authorization
	 */
	public void setAccessTokenCreateDate(Date accessTokenCreateDate);

	/**
	 * Returns the access token expiration date of this o auth2 authorization.
	 *
	 * @return the access token expiration date of this o auth2 authorization
	 */
	public Date getAccessTokenExpirationDate();

	/**
	 * Sets the access token expiration date of this o auth2 authorization.
	 *
	 * @param accessTokenExpirationDate the access token expiration date of this o auth2 authorization
	 */
	public void setAccessTokenExpirationDate(Date accessTokenExpirationDate);

	/**
	 * Returns the remote host info of this o auth2 authorization.
	 *
	 * @return the remote host info of this o auth2 authorization
	 */
	@AutoEscape
	public String getRemoteHostInfo();

	/**
	 * Sets the remote host info of this o auth2 authorization.
	 *
	 * @param remoteHostInfo the remote host info of this o auth2 authorization
	 */
	public void setRemoteHostInfo(String remoteHostInfo);

	/**
	 * Returns the remote ip info of this o auth2 authorization.
	 *
	 * @return the remote ip info of this o auth2 authorization
	 */
	@AutoEscape
	public String getRemoteIPInfo();

	/**
	 * Sets the remote ip info of this o auth2 authorization.
	 *
	 * @param remoteIPInfo the remote ip info of this o auth2 authorization
	 */
	public void setRemoteIPInfo(String remoteIPInfo);

	/**
	 * Returns the refresh token content of this o auth2 authorization.
	 *
	 * @return the refresh token content of this o auth2 authorization
	 */
	@AutoEscape
	public String getRefreshTokenContent();

	/**
	 * Sets the refresh token content of this o auth2 authorization.
	 *
	 * @param refreshTokenContent the refresh token content of this o auth2 authorization
	 */
	public void setRefreshTokenContent(String refreshTokenContent);

	/**
	 * Returns the refresh token content hash of this o auth2 authorization.
	 *
	 * @return the refresh token content hash of this o auth2 authorization
	 */
	public long getRefreshTokenContentHash();

	/**
	 * Sets the refresh token content hash of this o auth2 authorization.
	 *
	 * @param refreshTokenContentHash the refresh token content hash of this o auth2 authorization
	 */
	public void setRefreshTokenContentHash(long refreshTokenContentHash);

	/**
	 * Returns the refresh token create date of this o auth2 authorization.
	 *
	 * @return the refresh token create date of this o auth2 authorization
	 */
	public Date getRefreshTokenCreateDate();

	/**
	 * Sets the refresh token create date of this o auth2 authorization.
	 *
	 * @param refreshTokenCreateDate the refresh token create date of this o auth2 authorization
	 */
	public void setRefreshTokenCreateDate(Date refreshTokenCreateDate);

	/**
	 * Returns the refresh token expiration date of this o auth2 authorization.
	 *
	 * @return the refresh token expiration date of this o auth2 authorization
	 */
	public Date getRefreshTokenExpirationDate();

	/**
	 * Sets the refresh token expiration date of this o auth2 authorization.
	 *
	 * @param refreshTokenExpirationDate the refresh token expiration date of this o auth2 authorization
	 */
	public void setRefreshTokenExpirationDate(Date refreshTokenExpirationDate);

}