"use strict";

AUI.add('liferay-sidebar-panel', function (A) {
  var Lang = A.Lang;
  var SidebarPanel = A.Component.create({
    ATTRS: {
      resourceUrl: {
        validator: Lang.isString
      },
      searchContainerId: {
        validator: Lang.isString
      },
      targetNode: {
        setter: A.one
      }
    },
    AUGMENTS: [Liferay.PortletBase],
    EXTENDS: A.Base,
    NAME: 'liferaysidebarpanel',
    prototype: {
      initializer: function initializer(config) {
        var instance = this;
        instance._searchContainerRegisterHandle = Liferay.on('search-container:registered', instance._onSearchContainerRegistered, instance);
      },
      destructor: function destructor() {
        var instance = this;

        instance._detachSearchContainerRegisterHandle();

        new A.EventHandle(instance._eventHandles).detach();
      },
      _bindUI: function _bindUI() {
        var instance = this;
        instance._eventHandles = [instance._searchContainer.on('rowToggled', A.debounce(instance._getSidebarContent, 50, instance), instance), Liferay.after('refreshInfoPanel', function () {
          setTimeout(function () {
            instance._getSidebarContent();
          }, 0);
        })];
      },
      _detachSearchContainerRegisterHandle: function _detachSearchContainerRegisterHandle() {
        var instance = this;
        var searchContainerRegisterHandle = instance._searchContainerRegisterHandle;

        if (searchContainerRegisterHandle) {
          searchContainerRegisterHandle.detach();
          instance._searchContainerRegisterHandle = null;
        }
      },
      _getSidebarContent: function _getSidebarContent(event) {
        var instance = this;
        A.io.request(instance.get('resourceUrl'), {
          form: instance._searchContainer.getForm().getDOM(),
          on: {
            success: function success(event, id, xhr) {
              var response = xhr.responseText;
              instance.get('targetNode').setContent(response);
            }
          }
        });
      },
      _onSearchContainerRegistered: function _onSearchContainerRegistered(event) {
        var instance = this;
        var searchContainer = event.searchContainer;

        if (searchContainer.get('id') === instance.get('searchContainerId')) {
          instance._searchContainer = searchContainer;

          instance._detachSearchContainerRegisterHandle();

          instance.get('targetNode').plug(A.Plugin.ParseContent);

          instance._bindUI();
        }
      }
    }
  });
  Liferay.SidebarPanel = SidebarPanel;
}, '', {
  requires: ['aui-base', 'aui-debounce', 'aui-io-request', 'aui-parse-content', 'liferay-portlet-base']
});
//# sourceMappingURL=sidebar_panel.js.map