'use strict';

Liferay.Loader.define("frontend-taglib-clay$clay-table@2.15.1/lib/ClayTable", ['module', 'exports', 'require', 'frontend-taglib-clay$clay-button', 'frontend-taglib-clay$clay-checkbox', 'frontend-taglib-clay$clay-label', 'frontend-taglib-clay$clay-link', 'frontend-taglib-clay$clay-progress-bar', 'frontend-taglib-clay$clay-dropdown', 'frontend-js-metal-web$metal-state', 'frontend-js-metal-web$metal-events', 'frontend-taglib-clay$clay-component', 'frontend-js-metal-web$metal-web-component', 'frontend-js-metal-web$metal-dom', 'frontend-js-metal-web$metal-soy', './ClayTable.soy'], function (module, exports, require) {
	var define = undefined;
	Object.defineProperty(exports, "__esModule", {
		value: true
	});
	exports.ClayTable = undefined;

	var _createClass = function () {
		function defineProperties(target, props) {
			for (var i = 0; i < props.length; i++) {
				var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
			}
		}return function (Constructor, protoProps, staticProps) {
			if (protoProps) defineProperties(Constructor.prototype, protoProps);if (staticProps) defineProperties(Constructor, staticProps);return Constructor;
		};
	}();

	var _get = function get(object, property, receiver) {
		if (object === null) object = Function.prototype;var desc = Object.getOwnPropertyDescriptor(object, property);if (desc === undefined) {
			var parent = Object.getPrototypeOf(object);if (parent === null) {
				return undefined;
			} else {
				return get(parent, property, receiver);
			}
		} else if ("value" in desc) {
			return desc.value;
		} else {
			var getter = desc.get;if (getter === undefined) {
				return undefined;
			}return getter.call(receiver);
		}
	};

	require("frontend-taglib-clay$clay-button");

	require("frontend-taglib-clay$clay-checkbox");

	require("frontend-taglib-clay$clay-label");

	require("frontend-taglib-clay$clay-link");

	require("frontend-taglib-clay$clay-progress-bar");

	var _clayDropdown = require("frontend-taglib-clay$clay-dropdown");

	var _metalState = require("frontend-js-metal-web$metal-state");

	var _metalEvents = require("frontend-js-metal-web$metal-events");

	var _clayComponent = require("frontend-taglib-clay$clay-component");

	var _clayComponent2 = _interopRequireDefault(_clayComponent);

	var _metalWebComponent = require("frontend-js-metal-web$metal-web-component");

	var _metalWebComponent2 = _interopRequireDefault(_metalWebComponent);

	var _metalDom = require("frontend-js-metal-web$metal-dom");

	var _metalDom2 = _interopRequireDefault(_metalDom);

	var _metalSoy = require("frontend-js-metal-web$metal-soy");

	var _metalSoy2 = _interopRequireDefault(_metalSoy);

	var _ClayTableSoy = require("./ClayTable.soy");

	var _ClayTableSoy2 = _interopRequireDefault(_ClayTableSoy);

	function _interopRequireDefault(obj) {
		return obj && obj.__esModule ? obj : { default: obj };
	}

	function _classCallCheck(instance, Constructor) {
		if (!(instance instanceof Constructor)) {
			throw new TypeError("Cannot call a class as a function");
		}
	}

	function _possibleConstructorReturn(self, call) {
		if (!self) {
			throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
		}return call && (typeof call === "object" || typeof call === "function") ? call : self;
	}

	function _inherits(subClass, superClass) {
		if (typeof superClass !== "function" && superClass !== null) {
			throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
		}subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } });if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
	}
	// eslint-disable-next-line


	/**
  * Metal ClayTable component.
  * @extends ClayComponent
  */
	var ClayTable = function (_ClayComponent) {
		_inherits(ClayTable, _ClayComponent);

		function ClayTable() {
			_classCallCheck(this, ClayTable);

			return _possibleConstructorReturn(this, (ClayTable.__proto__ || Object.getPrototypeOf(ClayTable)).apply(this, arguments));
		}

		_createClass(ClayTable, [{
			key: 'attached',

			/**
    * @inheritDoc
    */
			value: function attached() {
				this._eventHandler.add(_metalDom2.default.on(document, 'click', this._handleDocClick.bind(this)), _metalDom2.default.delegate(this.element, 'focus', 'tr', this._handleRowFocus.bind(this)));
			}

			/**
    * @inheritDoc
    */

		}, {
			key: 'created',
			value: function created() {
				this._eventHandler = new _metalEvents.EventHandler();
			}

			/**
    * @inheritDoc
    */

		}, {
			key: 'detached',
			value: function detached() {
				_get(ClayTable.prototype.__proto__ || Object.getPrototypeOf(ClayTable.prototype), 'detached', this).call(this);
				this._eventHandler.removeAllListeners();
			}

			/**
    * Returns the index of the element.
    * @param {!Node} element
    * @private
    * @return {?(number|undefined)} the index.
    */

		}, {
			key: '_getItemIndex',
			value: function _getItemIndex(element) {
				return Array.prototype.indexOf.call(Array.prototype.filter.call(element.parentElement.children, function (childrenElement) {
					return !childrenElement.getAttribute('id');
				}), element);
			}

			/**
    * Continues the propagation of the cell content click event
    * @param {!Event} event
    * @private
    * @return {Boolean} If the event has been prevented or not.
    */

		}, {
			key: '_handleCellContentClick',
			value: function _handleCellContentClick(event) {
				var element = _metalDom2.default.closest(event.target, 'tr');
				var elementIndex = this._getItemIndex(element);
				var flattenItems = (0, _clayDropdown.flatten)(this.items);
				var item = flattenItems[elementIndex];

				return !this.emit({
					data: {
						item: item
					},
					name: 'cellContentClicked',
					originalEvent: event
				});
			}

			/**
    * Handles document click in order to remove the class `table-focus` from
    * the focused table row. This is to handle quickMenu accessibility.
    * @private
    */

		}, {
			key: '_handleDocClick',
			value: function _handleDocClick() {
				_metalDom2.default.removeClasses(this.element.querySelectorAll('tr'), 'table-focus');
			}

			/**
    * Continues the propagation of the checkbox changed event
    * @param {!Event} event
    * @private
    * @return {Boolean} If the event has been prevented or not.
    */

		}, {
			key: '_handleItemToggled',
			value: function _handleItemToggled(event) {
				return !this.emit({
					data: {
						event: event
					},
					name: 'itemToggled',
					originalEvent: event
				});
			}

			/**
    * Continues the propagation of the row content click event
    * @param {!Event} event
    * @private
    * @return {Boolean} If the event has been prevented or not.
    */

		}, {
			key: '_handleRowContentClick',
			value: function _handleRowContentClick(event) {
				var elementIndex = this._getItemIndex(event.delegateTarget);
				var flattenItems = (0, _clayDropdown.flatten)(this.items);
				var item = flattenItems[elementIndex];

				return !this.emit({
					data: {
						item: item
					},
					name: 'rowContentClicked',
					originalEvent: event
				});
			}

			/**
    * Handles each row focus in order to add the class `table-focus` to the row.
    * This is to handle quickMenu accessibility.
    * @param {!Event} event
    * @private
    */

		}, {
			key: '_handleRowFocus',
			value: function _handleRowFocus(event) {
				_metalDom2.default.removeClasses(this.element.querySelector('.table-focus'), 'table-focus');
				_metalDom2.default.addClasses(_metalDom2.default.closest(event.target, 'tr'), 'table-focus');
			}

			/**
    * Continues the propagation of the column sorting button click event
    * @param {!Event} event
    * @private
    */

		}, {
			key: '_handleSortingClick',
			value: function _handleSortingClick(event) {
				this.emit('sortingButtonClicked', event);
			}
		}]);

		return ClayTable;
	}(_clayComponent2.default);

	/**
  * State definition.
  * @static
  * @type {!Object}
  */

	ClayTable.STATE = {
		/**
   * Variant name to render the actions menu
   * @default undefined
   * @instance
   * @memberof ClayTable
   * @type {?(string|undefined)}
   */
		actionsMenuVariant: _metalState.Config.string(),

		/**
   * Data to add to the element.
   * @default undefined
   * @instance
   * @memberof ClayTable
   * @type {?object}
   */
		data: _metalState.Config.object(),

		/**
   * Object that wires events with default listeners
   * @default undefined
   * @instance
   * @memberof ClayTable
   * @review
   * @type {?(object|undefined)}
   */
		defaultEventHandler: _metalState.Config.object(),

		/**
   * CSS classes to be applied to the element.
   * @default undefined
   * @instance
   * @memberof ClayTable
   * @type {?(string|undefined)}
   */
		elementClasses: _metalState.Config.string(),

		/**
   * Id to be applied to the element.
   * @default undefined
   * @instance
   * @memberof ClayTable
   * @type {?(string|undefined)}
   */
		id: _metalState.Config.string(),

		/**
   * List of items to display in the table.
   * @default undefined
   * @instance
   * @memberof ClayTable
   * @type {?(array|undefined)}
   */
		items: _metalState.Config.array(),

		/**
   * Schema of the table containing an element per column with label and the
   * name of the field with the value.
   * @default undefined
   * @instance
   * @memberof ClayTable
   * @type {!object}
   */
		schema: _metalState.Config.shapeOf({
			fields: _metalState.Config.arrayOf(_metalState.Config.shapeOf({
				contentRenderer: _metalState.Config.string(),
				contentRendererMap: _metalState.Config.object(),
				fieldName: _metalState.Config.string().required(),
				fieldsMap: _metalState.Config.object(),
				label: _metalState.Config.string(),
				sortable: _metalState.Config.bool(),
				sortingOrder: _metalState.Config.oneOf(['asc', 'desc'])
			})),
			inputNameField: _metalState.Config.string(),
			inputNamesMap: _metalState.Config.object(),
			inputValueField: _metalState.Config.string()
		}).required(),

		/**
   * Flag to indicate if the table items are selectable or not.
   * @default false
   * @instance
   * @memberof ClayTable
   * @type {?bool}
   */
		selectable: _metalState.Config.bool().value(false),

		/**
   * Flag to indicate if the rows will show an actions menu or not.
   * @default false
   * @instance
   * @memberof ClayTable
   * @type {?bool}
   */
		showActionsMenu: _metalState.Config.bool().value(false),

		/**
   * Flag to indicate if the checkbox is show or not when selectable is true.
   * @default false
   * @instance
   * @memberof ClayTable
   * @type {?bool}
   */
		showCheckbox: _metalState.Config.bool().value(false),

		/**
   * Table responsive sizes. Available `lg`, `md`, `sm` and `xl`.
   * @default undefined
   * @instance
   * @memberof ClayTable
   * @type {?(string|undefined)}
   */
		size: _metalState.Config.oneOf(['lg', 'md', 'sm', 'xl']),

		/**
   * The path to the SVG spritemap file containing the icons.
   * @default undefined
   * @instance
   * @memberof ClayTable
   * @type {?(string|undefined)}
   */
		spritemap: _metalState.Config.string(),

		/**
   * CSS classes to be applied to the table.
   * @default undefined
   * @instance
   * @memberof ClayTable
   * @type {?(string|undefined)}
   */
		tableClasses: _metalState.Config.string(),

		/**
   * Flag to indicate if the wrapper and the table should use default css
   * classes or not.
   * @default true
   * @instance
   * @memberof ClayTable
   * @type {?string}
   */
		useDefaultClasses: _metalState.Config.bool().value(true),

		/**
   * Flag to indicate if the table is wrapped inside a div or not.
   * @default true
   * @instance
   * @memberof ClayTable
   * @type {?string}
   */
		wrapTable: _metalState.Config.bool().value(true)
	};

	(0, _metalWebComponent2.default)('clay-table', ClayTable);

	_metalSoy2.default.register(ClayTable, _ClayTableSoy2.default);

	exports.ClayTable = ClayTable;
	exports.default = ClayTable;
	//# sourceMappingURL=ClayTable.js.map
});
//# sourceMappingURL=ClayTable.js.map