'use strict';

Liferay.Loader.define('frontend-taglib-clay$clay-sticker@2.15.1/lib/ClaySticker', ['module', 'exports', 'require', 'frontend-taglib-clay$clay-icon', 'frontend-taglib-clay$clay-component', 'frontend-js-metal-web$metal-web-component', 'frontend-js-metal-web$metal-soy', 'frontend-js-metal-web$metal-state', './ClaySticker.soy'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.ClaySticker = undefined;

  require('frontend-taglib-clay$clay-icon');

  var _clayComponent = require('frontend-taglib-clay$clay-component');

  var _clayComponent2 = _interopRequireDefault(_clayComponent);

  var _metalWebComponent = require('frontend-js-metal-web$metal-web-component');

  var _metalWebComponent2 = _interopRequireDefault(_metalWebComponent);

  var _metalSoy = require('frontend-js-metal-web$metal-soy');

  var _metalSoy2 = _interopRequireDefault(_metalSoy);

  var _metalState = require('frontend-js-metal-web$metal-state');

  var _ClayStickerSoy = require('./ClaySticker.soy');

  var _ClayStickerSoy2 = _interopRequireDefault(_ClayStickerSoy);

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { default: obj };
  }

  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _possibleConstructorReturn(self, call) {
    if (!self) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }return call && (typeof call === "object" || typeof call === "function") ? call : self;
  }

  function _inherits(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
    }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } });if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
  }

  /**
   * Implementation of the Metal Clay Link.
   * @extends ClayComponent
   */
  var ClaySticker = function (_ClayComponent) {
    _inherits(ClaySticker, _ClayComponent);

    function ClaySticker() {
      _classCallCheck(this, ClaySticker);

      return _possibleConstructorReturn(this, (ClaySticker.__proto__ || Object.getPrototypeOf(ClaySticker)).apply(this, arguments));
    }

    return ClaySticker;
  }(_clayComponent2.default);

  /**
   * State definition.
   * @static
   * @type {!Object}
   */

  ClaySticker.STATE = {
    /**
     * Data to add to the element.
     * @default undefined
     * @instance
     * @memberof ClaySticker
     * @type {?object}
     */
    data: _metalState.Config.object(),

    /**
     * Object that wires events with default listeners
     * @default undefined
     * @instance
     * @memberof ClaySticker
     * @review
     * @type {?(object|undefined)}
     */
    defaultEventHandler: _metalState.Config.object(),

    /**
     * CSS classes to be applied to the element.
     * @default undefined
     * @instance
     * @memberof ClaySticker
     * @type {?(string|undefined)}
     */
    elementClasses: _metalState.Config.string(),

    /**
     * Render ClayIcon in the ClaySticker element.
     * @default undefined
     * @instance
     * @memberof ClaySticker
     * @type {?(string|undefined)}
     */
    icon: _metalState.Config.string(),

    /**
     * Id to be applied to the sticker element.
     * @default undefined
     * @instance
     * @memberof ClaySticker
     * @type {?(string|undefined)}
     */
    id: _metalState.Config.string(),

    /**
     * Alternate text of the image.
     * @default undefined
     * @instance
     * @memberof ClaySticker
     * @type {?(string|undefined)}
     */
    imageAlt: _metalState.Config.string(),

    /**
     * Source of the image to be rendered inside the sticker.
     * @default undefined
     * @instance
     * @memberof ClaySticker
     * @type {?(string|undefined)}
     */
    imageSrc: _metalState.Config.string(),

    /**
     * Sets the text or HTML to be rendered inside sticker.
     * @default undefined
     * @instance
     * @memberof ClaySticker
     * @type {?(html|string|undefined)}
     */
    label: _metalState.Config.any(),

    /**
     * Flag to indicate if the sticker should be positioned on the outside
     * corners when position is defined.
     * @default false
     * @instance
     * @memberof ClaySticker
     * @type {?bool}
     */
    outside: _metalState.Config.bool().value(false),

    /**
     * Position of the sticker in relation to the contents.
     * Available positions are `bottom-left`, `bottom-right`, `top-left`
     * and `top-right`.
     * @default undefined
     * @instance
     * @memberof ClaySticker
     * @type {?(string|undefined)}
     */
    position: _metalState.Config.oneOf(['bottom-left', 'bottom-right', 'top-left', 'top-right']),

    /**
     * Sticker size. Available sizes are `sm`, `lg`, `xl`.
     * @default undefined
     * @instance
     * @memberof ClaySticker
     * @type {?(string|undefined)}
     */
    size: _metalState.Config.oneOf(['lg', 'sm', 'xl']),

    /**
     * Shape of the sticker. Available shapes are `circle`, `rounded`.
     * @default rounded
     * @instance
     * @memberof ClaySticker
     * @type {?string}
     */
    shape: _metalState.Config.oneOf(['circle', 'rounded']).value('rounded'),

    /**
     * The path to the SVG spritemap file containing the icons.
     * @default undefined
     * @instance
     * @memberof ClaySticker
     * @type {?(string|undefined)}
     */
    spritemap: _metalState.Config.string(),

    /**
     * Sticker style. Available sizes are: `danger`, `dark`, `info`, `light`,
     * `primary`, `secondary`, `success`, `warning`.
     * @default primary
     * @instance
     * @memberof ClaySticker
     * @type {?string}
     */
    style: _metalState.Config.oneOf(['danger', 'dark', 'info', 'light', 'primary', 'secondary', 'success', 'unstyled', 'warning']).value('primary'),

    /**
     * Title to be applied to the sticker element.
     * @default undefined
     * @instance
     * @memberof ClaySticker
     * @type {?(string|undefined)}
     */
    title: _metalState.Config.string()
  };

  (0, _metalWebComponent2.default)('clay-sticker', ClaySticker);

  _metalSoy2.default.register(ClaySticker, _ClayStickerSoy2.default);

  exports.ClaySticker = ClaySticker;
  exports.default = ClaySticker;
  //# sourceMappingURL=ClaySticker.js.map
});
//# sourceMappingURL=ClaySticker.js.map