'use strict';

Liferay.Loader.define('frontend-taglib-clay$clay-select@2.15.1/lib/ClaySelect', ['module', 'exports', 'require', 'frontend-taglib-clay$clay-component', 'frontend-js-metal-web$metal-web-component', 'frontend-js-metal-web$metal-soy', 'frontend-js-metal-web$metal-state', './ClaySelect.soy'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.ClaySelect = undefined;

  var _clayComponent = require('frontend-taglib-clay$clay-component');

  var _clayComponent2 = _interopRequireDefault(_clayComponent);

  var _metalWebComponent = require('frontend-js-metal-web$metal-web-component');

  var _metalWebComponent2 = _interopRequireDefault(_metalWebComponent);

  var _metalSoy = require('frontend-js-metal-web$metal-soy');

  var _metalSoy2 = _interopRequireDefault(_metalSoy);

  var _metalState = require('frontend-js-metal-web$metal-state');

  var _ClaySelectSoy = require('./ClaySelect.soy');

  var _ClaySelectSoy2 = _interopRequireDefault(_ClaySelectSoy);

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { default: obj };
  }

  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _possibleConstructorReturn(self, call) {
    if (!self) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }return call && (typeof call === "object" || typeof call === "function") ? call : self;
  }

  function _inherits(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
    }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } });if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
  }

  /**
   * Metal Clay Select component.
   * @extends ClayComponent
   */
  var ClaySelect = function (_ClayComponent) {
    _inherits(ClaySelect, _ClayComponent);

    function ClaySelect() {
      _classCallCheck(this, ClaySelect);

      return _possibleConstructorReturn(this, (ClaySelect.__proto__ || Object.getPrototypeOf(ClaySelect)).apply(this, arguments));
    }

    return ClaySelect;
  }(_clayComponent2.default);

  /**
   * State definition.
   * @static
   * @type {!Object}
   */

  ClaySelect.STATE = {
    /**
     * Data to add to the element.
     * @default undefined
     * @instance
     * @memberof ClaySelect
     * @type {?object}
     */
    data: _metalState.Config.object(),

    /**
     * Object that wires events with default listeners
     * @default undefined
     * @instance
     * @memberof ClaySelect
     * @review
     * @type {?(object|undefined)}
     */
    defaultEventHandler: _metalState.Config.object(),

    /**
     * The select disabled attribute.
     * @default false
     * @instance
     * @memberof ClaySelect
     * @type {?boolean}
     */
    disabled: _metalState.Config.bool().value(false),

    /**
     * CSS classes to be applied to the element.
     * @default undefined
     * @instance
     * @memberof ClaySelect
     * @type {?(string|undefined)}
     */
    elementClasses: _metalState.Config.string(),

    /**
     * Id to be applied to the element.
     * @default undefined
     * @instance
     * @memberof ClaySelect
     * @type {?(string|undefined)}
     */
    id: _metalState.Config.string(),

    /**
     * Flag to indicate if select should be wrapped to be inline or not.
     * In order to make inline work properly you may place it inside
     * a .form-group-autofit container.
     * @default false
     * @instance
     * @memberof ClaySelect
     * @type {?bool}
     */
    inline: _metalState.Config.bool().value(false),

    /**
     * Label of the select element.
     * @default undefined
     * @instance
     * @memberof ClaySelect
     * @type {?(string|undefined)}
     */
    label: _metalState.Config.string(),

    /**
     * Flag to indicate if the select element should be placed inline.
     * @default false
     * @instance
     * @memberof ClaySelect
     * @type {?bool}
     */
    multiple: _metalState.Config.bool().value(false),

    /**
     * Name of the select element.
     * @default undefined
     * @instance
     * @memberof ClaySelect
     * @type {?(string|undefined)}
     */
    name: _metalState.Config.string(),

    /**
     * Options of the select element.
     * @default undefined
     * @instance
     * @memberof ClaySelect
     * @type {!array}
     */
    options: _metalState.Config.arrayOf(_metalState.Config.shapeOf({
      label: _metalState.Config.string().required(),
      selected: _metalState.Config.bool().value(false),
      value: _metalState.Config.string().required()
    })).required()
  };

  (0, _metalWebComponent2.default)('clay-select', ClaySelect);

  _metalSoy2.default.register(ClaySelect, _ClaySelectSoy2.default);

  exports.ClaySelect = ClaySelect;
  exports.default = ClaySelect;
  //# sourceMappingURL=ClaySelect.js.map
});
//# sourceMappingURL=ClaySelect.js.map