'use strict';

Liferay.Loader.define('frontend-taglib-clay$clay-progress-bar@2.15.1/lib/ClayProgressBar', ['module', 'exports', 'require', 'frontend-taglib-clay$clay-icon', 'frontend-taglib-clay$clay-component', 'frontend-js-metal-web$metal-web-component', 'frontend-js-metal-web$metal-soy', 'frontend-js-metal-web$metal-state', './ClayProgressBar.soy'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.ClayProgressBar = undefined;

  require('frontend-taglib-clay$clay-icon');

  var _clayComponent = require('frontend-taglib-clay$clay-component');

  var _clayComponent2 = _interopRequireDefault(_clayComponent);

  var _metalWebComponent = require('frontend-js-metal-web$metal-web-component');

  var _metalWebComponent2 = _interopRequireDefault(_metalWebComponent);

  var _metalSoy = require('frontend-js-metal-web$metal-soy');

  var _metalSoy2 = _interopRequireDefault(_metalSoy);

  var _metalState = require('frontend-js-metal-web$metal-state');

  var _ClayProgressBarSoy = require('./ClayProgressBar.soy');

  var _ClayProgressBarSoy2 = _interopRequireDefault(_ClayProgressBarSoy);

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { default: obj };
  }

  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _possibleConstructorReturn(self, call) {
    if (!self) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }return call && (typeof call === "object" || typeof call === "function") ? call : self;
  }

  function _inherits(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
    }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } });if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
  }

  /**
   * Metal Clay Button component.
   * @extends ClayComponent
   */
  var ClayProgressBar = function (_ClayComponent) {
    _inherits(ClayProgressBar, _ClayComponent);

    function ClayProgressBar() {
      _classCallCheck(this, ClayProgressBar);

      return _possibleConstructorReturn(this, (ClayProgressBar.__proto__ || Object.getPrototypeOf(ClayProgressBar)).apply(this, arguments));
    }

    return ClayProgressBar;
  }(_clayComponent2.default);

  /**
   * State definition.
   * @static
   * @type {!Object}
   */

  ClayProgressBar.STATE = {
    /**
     * Data to add to the element.
     * @default undefined
     * @instance
     * @memberof ClayProgressBar
     * @type {?object}
     */
    data: _metalState.Config.object(),

    /**
     * Object that wires events with default listeners
     * @default undefined
     * @instance
     * @memberof ClayProgressBar
     * @review
     * @type {?(object|undefined)}
     */
    defaultEventHandler: _metalState.Config.object(),

    /**
     * CSS classes to be applied to the element.
     * @default undefined
     * @instance
     * @memberof ClayProgressBar
     * @type {?(string|undefined)}
     */
    elementClasses: _metalState.Config.string(),

    /**
     * Id to be applied to the element.
     * @default undefined
     * @instance
     * @memberof ClayProgressBar
     * @type {?(string|undefined)}
     */
    id: _metalState.Config.string(),

    /**
     * The path to the SVG spritemap file containing the icons.
     * @default undefined
     * @instance
     * @memberof ClayProgressBar
     * @type {!string}
     */
    spritemap: _metalState.Config.string(),

    /**
     * Progress bar state. Completed state can be defined here but also is
     * automatically set if value is equal to maxValue.
     * @default undefined
     * @instance
     * @memberof ClayProgressBar
     * @type {?string}
     */
    status: _metalState.Config.oneOf(['complete', 'warning']),

    /**
     * The progress value of the bar.
     * @default undefined
     * @instance
     * @memberof ClayProgressBar
     * @type {?number}
     */
    value: {
      validator: function validator(value) {
        return value >= 0 && value <= 100;
      },
      value: 0
    }
  };

  (0, _metalWebComponent2.default)('clay-progress-bar', ClayProgressBar);

  _metalSoy2.default.register(ClayProgressBar, _ClayProgressBarSoy2.default);

  exports.ClayProgressBar = ClayProgressBar;
  exports.default = ClayProgressBar;
  //# sourceMappingURL=ClayProgressBar.js.map
});
//# sourceMappingURL=ClayProgressBar.js.map