'use strict';

Liferay.Loader.define("frontend-taglib-clay$clay-pagination@2.15.1/lib/ClayPagination", ['module', 'exports', 'require', 'frontend-taglib-clay$clay-dropdown', 'frontend-taglib-clay$clay-link', 'frontend-taglib-clay$clay-component', 'frontend-js-metal-web$metal-state', 'frontend-js-metal-web$metal-web-component', 'frontend-js-metal-web$metal-soy', './ClayPagination.soy'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.ClayPagination = undefined;

  var _createClass = function () {
    function defineProperties(target, props) {
      for (var i = 0; i < props.length; i++) {
        var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
      }
    }return function (Constructor, protoProps, staticProps) {
      if (protoProps) defineProperties(Constructor.prototype, protoProps);if (staticProps) defineProperties(Constructor, staticProps);return Constructor;
    };
  }();

  var _clayDropdown = require("frontend-taglib-clay$clay-dropdown");

  require("frontend-taglib-clay$clay-link");

  var _clayComponent = require("frontend-taglib-clay$clay-component");

  var _clayComponent2 = _interopRequireDefault(_clayComponent);

  var _metalState = require("frontend-js-metal-web$metal-state");

  var _metalWebComponent = require("frontend-js-metal-web$metal-web-component");

  var _metalWebComponent2 = _interopRequireDefault(_metalWebComponent);

  var _metalSoy = require("frontend-js-metal-web$metal-soy");

  var _metalSoy2 = _interopRequireDefault(_metalSoy);

  var _ClayPaginationSoy = require("./ClayPagination.soy");

  var _ClayPaginationSoy2 = _interopRequireDefault(_ClayPaginationSoy);

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { default: obj };
  }

  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _possibleConstructorReturn(self, call) {
    if (!self) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }return call && (typeof call === "object" || typeof call === "function") ? call : self;
  }

  function _inherits(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
    }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } });if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
  }
  // eslint-disable-next-line


  /**
   * Metal ClayPagination component.
   * @extends ClayComponent
   */
  var ClayPagination = function (_ClayComponent) {
    _inherits(ClayPagination, _ClayComponent);

    function ClayPagination() {
      _classCallCheck(this, ClayPagination);

      return _possibleConstructorReturn(this, (ClayPagination.__proto__ || Object.getPrototypeOf(ClayPagination)).apply(this, arguments));
    }

    _createClass(ClayPagination, [{
      key: '_handlePageClick',

      /**
       * Continues the propagation of the page clicked event
       * @param {!Event} event
       * @protected
       * @return {Boolean} If the event has been prevented or not.
       */
      value: function _handlePageClick(event) {
        return !this.emit({
          data: {
            page: event.delegateTarget.getAttribute('data-page')
          },
          name: 'pageClicked',
          originalEvent: event
        });
      }
    }]);

    return ClayPagination;
  }(_clayComponent2.default);

  /**
   * State definition.
   * @static
   * @type {!Object}
   */

  ClayPagination.STATE = {
    /**
     * Href to create each page complete href.
     * @default undefined
     * @instance
     * @memberof ClayPagination
     * @type {?(string|undefined)}
     */
    baseHref: _metalState.Config.string(),

    /**
     * Current page number.
     * @default undefined
     * @instance
     * @memberof ClayPagination
     * @type {!number}
     */
    currentPage: _metalState.Config.number().required(),

    /**
     * Data to add to the element.
     * @default undefined
     * @instance
     * @memberof ClayPagination
     * @type {?object}
     */
    data: _metalState.Config.object(),

    /**
     * Object that wires events with default listeners
     * @default undefined
     * @instance
     * @memberof ClayPagination
     * @review
     * @type {?(object|undefined)}
     */
    defaultEventHandler: _metalState.Config.object(),

    /**
     * CSS classes to be applied to the element.
     * @default undefined
     * @instance
     * @memberof ClayPagination
     * @type {?(string|undefined)}
     */
    elementClasses: _metalState.Config.string(),

    /**
     * Id to be applied to the element.
     * @default undefined
     * @instance
     * @memberof ClayPagination
     * @type {?(string|undefined)}
     */
    id: _metalState.Config.string(),

    /**
     * The path to the SVG spritemap file containing the icons.
     * @default undefined
     * @instance
     * @memberof ClayPagination
     * @type {!string}
     */
    spritemap: _metalState.Config.string().required(),

    /**
     * Total number of pages to show.
     * @default undefined
     * @instance
     * @memberof ClayPagination
     * @type {!number}
     */
    totalPages: _metalState.Config.number().required()
  };

  (0, _metalWebComponent2.default)('clay-pagination', ClayPagination);

  _metalSoy2.default.register(ClayPagination, _ClayPaginationSoy2.default);

  exports.ClayPagination = ClayPagination;
  exports.default = ClayPagination;
  //# sourceMappingURL=ClayPagination.js.map
});
//# sourceMappingURL=ClayPagination.js.map