'use strict';

Liferay.Loader.define("frontend-taglib-clay$clay-pagination-bar@2.15.1/lib/ClayPaginationBar", ['module', 'exports', 'require', 'frontend-taglib-clay$clay-dropdown', 'frontend-taglib-clay$clay-pagination', 'frontend-js-metal-web$metal-state', 'frontend-taglib-clay$clay-component', 'frontend-js-metal-web$metal-web-component', 'frontend-js-metal-web$metal-soy', './ClayPaginationBar.soy'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.ClayPaginationBar = undefined;

  var _createClass = function () {
    function defineProperties(target, props) {
      for (var i = 0; i < props.length; i++) {
        var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
      }
    }return function (Constructor, protoProps, staticProps) {
      if (protoProps) defineProperties(Constructor.prototype, protoProps);if (staticProps) defineProperties(Constructor, staticProps);return Constructor;
    };
  }();

  require("frontend-taglib-clay$clay-dropdown");

  require("frontend-taglib-clay$clay-pagination");

  var _metalState = require("frontend-js-metal-web$metal-state");

  var _clayComponent = require("frontend-taglib-clay$clay-component");

  var _clayComponent2 = _interopRequireDefault(_clayComponent);

  var _metalWebComponent = require("frontend-js-metal-web$metal-web-component");

  var _metalWebComponent2 = _interopRequireDefault(_metalWebComponent);

  var _metalSoy = require("frontend-js-metal-web$metal-soy");

  var _metalSoy2 = _interopRequireDefault(_metalSoy);

  var _ClayPaginationBarSoy = require("./ClayPaginationBar.soy");

  var _ClayPaginationBarSoy2 = _interopRequireDefault(_ClayPaginationBarSoy);

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { default: obj };
  }

  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _possibleConstructorReturn(self, call) {
    if (!self) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }return call && (typeof call === "object" || typeof call === "function") ? call : self;
  }

  function _inherits(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
    }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } });if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
  }

  /**
   * Metal ClayPaginationBar component.
   * @extends ClayComponent
   */
  var ClayPaginationBar = function (_ClayComponent) {
    _inherits(ClayPaginationBar, _ClayComponent);

    function ClayPaginationBar() {
      _classCallCheck(this, ClayPaginationBar);

      return _possibleConstructorReturn(this, (ClayPaginationBar.__proto__ || Object.getPrototypeOf(ClayPaginationBar)).apply(this, arguments));
    }

    _createClass(ClayPaginationBar, [{
      key: '_handlePageClick',

      /**
       * Continues the propagation of the page clicked event
       * @param {!Event} event
       * @protected
       * @return {Boolean} If the event has been prevented or not.
       */
      value: function _handlePageClick(event) {
        return !this.emit({
          data: {
            page: event.data.page
          },
          name: 'pageClicked',
          originalEvent: event
        });
      }

      /**
       * Continues the propagation of the item per page clicked event
       * @param {!Event} event
       * @protected
       * @return {Boolean} If the event has been prevented or not.
       */

    }, {
      key: '_handleItemsPerPageClicked',
      value: function _handleItemsPerPageClicked(event) {
        return !this.emit({
          data: {
            item: event.data.item
          },
          name: 'itemsPerPageClicked',
          originalEvent: event
        });
      }
    }]);

    return ClayPaginationBar;
  }(_clayComponent2.default);

  /**
   * State definition.
   * @static
   * @type {!Object}
   */

  ClayPaginationBar.STATE = {
    /**
     * Href to create each pagination page complete href.
     * @default undefined
     * @instance
     * @memberof ClayPaginationBar
     * @type {?(string|undefined)}
     */
    baseHref: _metalState.Config.string(),

    /**
     * Current pagination page number.
     * @default undefined
     * @instance
     * @memberof ClayPaginationBar
     * @type {!number}
     */
    currentPage: _metalState.Config.number().required(),

    /**
     * Data to add to the element.
     * @default undefined
     * @instance
     * @memberof ClayPaginationBar
     * @type {?object}
     */
    data: _metalState.Config.object(),

    /**
     * Object that wires events with default listeners
     * @default undefined
     * @instance
     * @memberof ClayPaginationBar
     * @review
     * @type {?(object|undefined)}
     */
    defaultEventHandler: _metalState.Config.object(),

    /**
     * CSS classes to be applied to the element.
     * @default undefined
     * @instance
     * @memberof ClayPaginationBar
     * @type {?(string|undefined)}
     */
    elementClasses: _metalState.Config.string(),

    /**
     * List of available number of entries.
     * @default undefined
     * @instance
     * @memberof ClayPaginationBar
     * @type {!array}
     */
    entries: _metalState.Config.arrayOf(_metalState.Config.shapeOf({
      active: _metalState.Config.bool(),
      href: _metalState.Config.string().required(),
      label: _metalState.Config.number().required()
    })).required(),

    /**
     * Id to be applied to the element.
     * @default undefined
     * @instance
     * @memberof ClayPaginationBar
     * @type {?(string|undefined)}
     */
    id: _metalState.Config.string(),

    /**
     * Entries index that points to selected entry.
     * @default undefined
     * @instance
     * @memberof ClayPaginationBar
     * @type {?(number|undefined)}
     */
    selectedEntry: _metalState.Config.number().required(),

    /**
     * The path to the SVG spritemap file containing the icons.
     * @default undefined
     * @instance
     * @memberof ClayPaginationBar
     * @type {!string}
     */
    spritemap: _metalState.Config.string().required(),

    /**
     * Total number of entries.
     * @default undefined
     * @instance
     * @memberof ClayPaginationBar
     * @type {!number}
     */
    totalEntries: _metalState.Config.number().required()
  };

  (0, _metalWebComponent2.default)('clay-pagination-bar', ClayPaginationBar);

  _metalSoy2.default.register(ClayPaginationBar, _ClayPaginationBarSoy2.default);

  exports.ClayPaginationBar = ClayPaginationBar;
  exports.default = ClayPaginationBar;
  //# sourceMappingURL=ClayPaginationBar.js.map
});
//# sourceMappingURL=ClayPaginationBar.js.map