'use strict';

Liferay.Loader.define("frontend-taglib-clay$clay-navigation-bar@2.15.1/lib/ClayNavigationBar", ['module', 'exports', 'require', 'frontend-taglib-clay$clay-link', 'frontend-taglib-clay$clay-component', 'frontend-js-metal-web$metal-state', 'frontend-js-metal-web$metal-web-component', 'frontend-js-metal-web$metal-soy', './ClayNavigationBar.soy'], function (module, exports, require) {
	var define = undefined;
	Object.defineProperty(exports, "__esModule", {
		value: true
	});
	exports.ClayNavigationBar = undefined;

	var _createClass = function () {
		function defineProperties(target, props) {
			for (var i = 0; i < props.length; i++) {
				var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
			}
		}return function (Constructor, protoProps, staticProps) {
			if (protoProps) defineProperties(Constructor.prototype, protoProps);if (staticProps) defineProperties(Constructor, staticProps);return Constructor;
		};
	}();

	require("frontend-taglib-clay$clay-link");

	var _clayComponent = require("frontend-taglib-clay$clay-component");

	var _clayComponent2 = _interopRequireDefault(_clayComponent);

	var _metalState = require("frontend-js-metal-web$metal-state");

	var _metalWebComponent = require("frontend-js-metal-web$metal-web-component");

	var _metalWebComponent2 = _interopRequireDefault(_metalWebComponent);

	var _metalSoy = require("frontend-js-metal-web$metal-soy");

	var _metalSoy2 = _interopRequireDefault(_metalSoy);

	var _ClayNavigationBarSoy = require("./ClayNavigationBar.soy");

	var _ClayNavigationBarSoy2 = _interopRequireDefault(_ClayNavigationBarSoy);

	function _interopRequireDefault(obj) {
		return obj && obj.__esModule ? obj : { default: obj };
	}

	function _classCallCheck(instance, Constructor) {
		if (!(instance instanceof Constructor)) {
			throw new TypeError("Cannot call a class as a function");
		}
	}

	function _possibleConstructorReturn(self, call) {
		if (!self) {
			throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
		}return call && (typeof call === "object" || typeof call === "function") ? call : self;
	}

	function _inherits(subClass, superClass) {
		if (typeof superClass !== "function" && superClass !== null) {
			throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
		}subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } });if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
	}

	/**
  * Metal Clay Navbar component.
  * @extends ClayComponent
  */
	var ClayNavigationBar = function (_ClayComponent) {
		_inherits(ClayNavigationBar, _ClayComponent);

		function ClayNavigationBar() {
			_classCallCheck(this, ClayNavigationBar);

			return _possibleConstructorReturn(this, (ClayNavigationBar.__proto__ || Object.getPrototypeOf(ClayNavigationBar)).apply(this, arguments));
		}

		_createClass(ClayNavigationBar, [{
			key: 'attached',

			/**
    * @inheritDoc
    */
			value: function attached() {
				this.addListener('transitionend', this._handleTransitionEnd, true);
			}

			/**
    * @inheritDoc
    */
			// eslint-disable-next-line

		}, {
			key: 'sync_isTransitioning',
			value: function sync_isTransitioning() {
				if (this._isTransitioning) {
					this._setCollapseHeight();
					if (this._visible) {
						this._removeCollapseHeight();
					}
				}
			}

			/**
    * Check the click and set transition true.
    * @param {!Event} event
    * @private
    */

		}, {
			key: '_handleClickToggler',
			value: function _handleClickToggler(event) {
				event.preventDefault();

				if (this._visible && !this._isTransitioning) {
					this._setCollapseHeight();
				}

				if (!this._isTransitioning) {
					this._isTransitioning = true;
				}
			}

			/**
    * Continues the propagation of the item click event
    * @param {!Event} event
    * @private
    * @return {Boolean} If the event has been prevented or not.
    */

		}, {
			key: '_handleNavItemClicked',
			value: function _handleNavItemClicked(event) {
				var element = event.delegateTarget;
				var index = element.getAttribute('data-nav-item-index');
				var item = this.items[index];

				return !this.emit({
					data: {
						item: item
					},
					name: 'itemClicked',
					originalEvent: event
				});
			}

			/**
    * Handle css transition end.
    * @param {!Event} event
    * @private
    */

		}, {
			key: '_handleTransitionEnd',
			value: function _handleTransitionEnd(event) {
				var element = this.refs.content;
				if (element == event.target && this._isTransitioning && !this._visible) {
					this._visible = true;
					this._isTransitioning = false;
					this._removeCollapseHeight();
				} else if (element == event.target) {
					this._visible = false;
					this._isTransitioning = false;
				}
			}

			/**
    * Removes height css property on `.navbar-collapse`
    * @private
    */

		}, {
			key: '_removeCollapseHeight',
			value: function _removeCollapseHeight() {
				this.refs.content.style.removeProperty('height');
			}

			/**
    * Sets the height css property on `.navbar-collapse`
    * @private
    */

		}, {
			key: '_setCollapseHeight',
			value: function _setCollapseHeight() {
				var elementCollapse = this.refs.content;

				elementCollapse.setAttribute('style', 'height: ' + elementCollapse.children[0].clientHeight + 'px');
			}
		}]);

		return ClayNavigationBar;
	}(_clayComponent2.default);

	/**
  * State definition.
  * @static
  * @type {!Object}
  */

	ClayNavigationBar.STATE = {
		/**
   * The toggle animation.
   * @default false
   * @instance
   * @memberof ClayNavigationBar
   * @private
   * @type {?boolean}
   */
		_isTransitioning: _metalState.Config.bool().value(false).internal(),

		/**
   * Navmenus visible in mobile when click in the button.
   * @default false
   * @instance
   * @memberof ClayNavigationBar
   * @private
   * @type {?bool}
   */
		_visible: _metalState.Config.bool().value(false).internal(),

		/**
   * Data to add to the element.
   * @default undefined
   * @instance
   * @memberof ClayNavigationBar
   * @type {?object}
   */
		data: _metalState.Config.object(),

		/**
   * Object that wires events with default listeners
   * @default undefined
   * @instance
   * @memberof ClayNavigationBar
   * @review
   * @type {?(object|undefined)}
   */
		defaultEventHandler: _metalState.Config.object(),

		/**
   * CSS classes to be applied to the element.
   * @default undefined
   * @instance
   * @memberof ClayNavigationBar
   * @type {?(string|undefined)}
   */
		elementClasses: _metalState.Config.string(),

		/**
   * Id to be applied to the element.
   * @default undefined
   * @instance
   * @memberof ClayNavigationBar
   * @type {?(string|undefined)}
   */
		id: _metalState.Config.string(),

		/**
   * The display style attribute.
   * @default false
   * @instance
   * @memberof ClayNavigationBar
   * @type {?boolean}
   */
		inverted: _metalState.Config.bool().value(false),

		/**
   * List of items to show in the Navbar.
   * @default undefined
   * @instance
   * @memberof ClayNavigationBar
   * @type {!Array}
   */
		items: _metalState.Config.arrayOf(_metalState.Config.shapeOf({
			active: _metalState.Config.bool().value(false),
			href: _metalState.Config.string().required(),
			label: _metalState.Config.string().required()
		})).required(),

		/**
   * The path to the SVG spritemap file containing the icons.
   * @default undefined
   * @instance
   * @memberof ClayNavigationBar
   * @type {!string}
   */
		spritemap: _metalState.Config.string().required()
	};

	(0, _metalWebComponent2.default)('clay-navigation-bar', ClayNavigationBar);

	_metalSoy2.default.register(ClayNavigationBar, _ClayNavigationBarSoy2.default);

	exports.ClayNavigationBar = ClayNavigationBar;
	exports.default = ClayNavigationBar;
	//# sourceMappingURL=ClayNavigationBar.js.map
});
//# sourceMappingURL=ClayNavigationBar.js.map