'use strict';

Liferay.Loader.define("frontend-taglib-clay$clay-management-toolbar@2.15.1/lib/ClayResultsBar", ['module', 'exports', 'require', './ClayFilterLabel', 'frontend-taglib-clay$clay-button', 'frontend-taglib-clay$clay-label', 'frontend-taglib-clay$clay-link', 'frontend-js-metal-web$metal-state', 'frontend-taglib-clay$clay-component', 'frontend-js-metal-web$metal-web-component', 'frontend-js-metal-web$metal-soy', './validators', './ClayResultsBar.soy'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.ClayResultsBar = undefined;

  var _createClass = function () {
    function defineProperties(target, props) {
      for (var i = 0; i < props.length; i++) {
        var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
      }
    }return function (Constructor, protoProps, staticProps) {
      if (protoProps) defineProperties(Constructor.prototype, protoProps);if (staticProps) defineProperties(Constructor, staticProps);return Constructor;
    };
  }();

  require('./ClayFilterLabel');

  require("frontend-taglib-clay$clay-button");

  require("frontend-taglib-clay$clay-label");

  require("frontend-taglib-clay$clay-link");

  var _metalState = require("frontend-js-metal-web$metal-state");

  var _clayComponent = require("frontend-taglib-clay$clay-component");

  var _clayComponent2 = _interopRequireDefault(_clayComponent);

  var _metalWebComponent = require("frontend-js-metal-web$metal-web-component");

  var _metalWebComponent2 = _interopRequireDefault(_metalWebComponent);

  var _metalSoy = require("frontend-js-metal-web$metal-soy");

  var _metalSoy2 = _interopRequireDefault(_metalSoy);

  var _validators = require('./validators');

  var _ClayResultsBarSoy = require("./ClayResultsBar.soy");

  var _ClayResultsBarSoy2 = _interopRequireDefault(_ClayResultsBarSoy);

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { default: obj };
  }

  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _possibleConstructorReturn(self, call) {
    if (!self) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }return call && (typeof call === "object" || typeof call === "function") ? call : self;
  }

  function _inherits(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
    }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } });if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
  }

  /**
   * Metal ClayResultsBar component.
   * @extends ClayComponent
   */
  var ClayResultsBar = function (_ClayComponent) {
    _inherits(ClayResultsBar, _ClayComponent);

    function ClayResultsBar() {
      _classCallCheck(this, ClayResultsBar);

      return _possibleConstructorReturn(this, (ClayResultsBar.__proto__ || Object.getPrototypeOf(ClayResultsBar)).apply(this, arguments));
    }

    _createClass(ClayResultsBar, [{
      key: '_handleClearResultsClick',

      /**
       * Continues the propagation of the clear button clicked event
       * @param {!Event} event
       * @private
       * @return {Boolean} If the event has been prevented or not.
       */
      value: function _handleClearResultsClick(event) {
        return !this.emit({
          name: 'clearButtonClicked',
          originalEvent: event
        });
      }

      /**
       * Continues the propagation of the filter label close clicked event
       * @param {!Event} event
       * @private
       * @return {Boolean} If the event has been prevented or not.
       */

    }, {
      key: '_handleFilterLabelCloseClicked',
      value: function _handleFilterLabelCloseClicked(event) {
        return !this.emit({
          data: {
            label: this.filterLabels[event.target.data.labelId]
          },
          name: 'filterLabelCloseClicked',
          originalEvent: event
        });
      }
    }]);

    return ClayResultsBar;
  }(_clayComponent2.default);

  /**
   * State definition.
   * @static
   * @type {!Object}
   */

  ClayResultsBar.STATE = {
    /**
     * Url for clear results link.
     * @default undefined
     * @instance
     * @memberof ClayResultsBar
     * @type {?(string|undefined)}
     */
    clearResultsURL: _metalState.Config.string(),

    /**
     * Data to add to the element.
     * @default undefined
     * @instance
     * @memberof ClayResultsBar
     * @type {?object}
     */
    data: _metalState.Config.object(),

    /**
     * List of filter label items.
     * @default undefined
     * @instance
     * @memberof ClayResultsBar
     * @type {?(array|undefined)}
     */
    filterLabels: _validators.filterLabelsValidator.required(),

    /**
     * Value of the search input.
     * @default undefined
     * @instance
     * @memberof ClayResultsBar
     * @type {?(string|undefined)}
     */
    searchValue: _metalState.Config.string(),

    /**
     * The path to the SVG spritemap file containing the icons.
     * @default undefined
     * @instance
     * @memberof ClayResultsBar
     * @type {?(string|undefined)}
     */
    spritemap: _metalState.Config.string().required(),

    /**
     * Total number of items. If totalItems is 0 most of the elements in the bar
     * will appear disabled.
     * @default undefined
     * @instance
     * @memberof ClayResultsBar
     * @type {!number}
     */
    totalItems: _metalState.Config.number().required()
  };

  (0, _metalWebComponent2.default)('clay-results-bar', ClayResultsBar);

  _metalSoy2.default.register(ClayResultsBar, _ClayResultsBarSoy2.default);

  exports.ClayResultsBar = ClayResultsBar;
  exports.default = ClayResultsBar;
  //# sourceMappingURL=ClayResultsBar.js.map
});
//# sourceMappingURL=ClayResultsBar.js.map