'use strict';

Liferay.Loader.define("frontend-taglib-clay$clay-management-toolbar@2.15.1/lib/ClayManagementToolbar", ['module', 'exports', 'require', './ClayResultsBar', 'frontend-taglib-clay$clay-button', 'frontend-taglib-clay$clay-checkbox', 'frontend-taglib-clay$clay-icon', 'frontend-taglib-clay$clay-link', 'frontend-taglib-clay$clay-dropdown', 'frontend-js-metal-web$metal-state', 'frontend-taglib-clay$clay-component', 'frontend-js-metal-web$metal-web-component', 'frontend-js-metal-web$metal-soy', './validators', './ClayManagementToolbar.soy'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.ClayManagementToolbar = undefined;

  var _createClass = function () {
    function defineProperties(target, props) {
      for (var i = 0; i < props.length; i++) {
        var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
      }
    }return function (Constructor, protoProps, staticProps) {
      if (protoProps) defineProperties(Constructor.prototype, protoProps);if (staticProps) defineProperties(Constructor, staticProps);return Constructor;
    };
  }();

  require('./ClayResultsBar');

  require("frontend-taglib-clay$clay-button");

  require("frontend-taglib-clay$clay-checkbox");

  require("frontend-taglib-clay$clay-icon");

  require("frontend-taglib-clay$clay-link");

  var _clayDropdown = require("frontend-taglib-clay$clay-dropdown");

  var _metalState = require("frontend-js-metal-web$metal-state");

  var _clayComponent = require("frontend-taglib-clay$clay-component");

  var _clayComponent2 = _interopRequireDefault(_clayComponent);

  var _metalWebComponent = require("frontend-js-metal-web$metal-web-component");

  var _metalWebComponent2 = _interopRequireDefault(_metalWebComponent);

  var _metalSoy = require("frontend-js-metal-web$metal-soy");

  var _metalSoy2 = _interopRequireDefault(_metalSoy);

  var _validators = require('./validators');

  var _ClayManagementToolbarSoy = require("./ClayManagementToolbar.soy");

  var _ClayManagementToolbarSoy2 = _interopRequireDefault(_ClayManagementToolbarSoy);

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { default: obj };
  }

  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _possibleConstructorReturn(self, call) {
    if (!self) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }return call && (typeof call === "object" || typeof call === "function") ? call : self;
  }

  function _inherits(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
    }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } });if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
  }
  /* eslint-disable */

  /* eslint-enable */

  /**
   * Metal ClayManagementToolbar component.
   * @extends ClayComponent
   */
  var ClayManagementToolbar = function (_ClayComponent) {
    _inherits(ClayManagementToolbar, _ClayComponent);

    function ClayManagementToolbar() {
      _classCallCheck(this, ClayManagementToolbar);

      return _possibleConstructorReturn(this, (ClayManagementToolbar.__proto__ || Object.getPrototypeOf(ClayManagementToolbar)).apply(this, arguments));
    }

    _createClass(ClayManagementToolbar, [{
      key: '_handleActionItemClicked',

      /**
       * Continues the propagation of the action item clicked event
       * @param {!Event} event
       * @private
       * @return {Boolean} If the event has been prevented or not.
       */
      value: function _handleActionItemClicked(event) {
        return !this.emit({
          data: event.data,
          name: 'actionItemClicked',
          originalEvent: event
        });
      }

      /**
       * Continues the propagation of the clear button clicked event
       * @param {!Event} event
       * @private
       * @return {Boolean} If the event has been prevented or not.
       */

    }, {
      key: '_handleClearResultsClick',
      value: function _handleClearResultsClick(event) {
        return !this.emit({
          name: 'clearButtonClicked',
          originalEvent: event
        });
      }

      /**
       * Continues the propagation of the clear selection button clicked event
       * @param {!Event} event
       * @private
       * @return {Boolean} If the event has been prevented or not.
       */

    }, {
      key: '_handleClearSelectionButtonClick',
      value: function _handleClearSelectionButtonClick(event) {
        return !this.emit({
          name: 'clearSelectionButtonClicked',
          originalEvent: event
        });
      }

      /**
       * Hides the search in mobile devices
       * @private
       */

    }, {
      key: '_handleCloseMobileSearchClick',
      value: function _handleCloseMobileSearchClick() {
        this._showSearchMobile = false;
      }

      /**
       * Continues the propagation of the plus button clicked event. This path only
       * happens when there's a single primary item. Thus, the data payload associated
       * with the event is simply the first primary item.
       * @param {!Event} event
       * @private
       * @return {Boolean} If the event has been prevented or not.
       */

    }, {
      key: '_handleCreationButtonClicked',
      value: function _handleCreationButtonClicked(event) {
        var defaultCreationMenu = {
          primaryItems: null,
          secondaryItems: null
        };

        var _ref = this.creationMenu || defaultCreationMenu,
            primaryItems = _ref.primaryItems,
            secondaryItems = _ref.secondaryItems;

        var payload = primaryItems ? primaryItems[0] : secondaryItems ? secondaryItems[0].items ? secondaryItems[0].items[0] : secondaryItems[0] : null;

        return !this.emit({
          data: payload,
          name: 'creationButtonClicked',
          originalEvent: event
        });
      }

      /**
       * Continues the propagation of the creation menu item clicked event
       * @param {!Event} event
       * @private
       * @return {Boolean} If the event has been prevented or not.
       */

    }, {
      key: '_handleCreationMenuItemClicked',
      value: function _handleCreationMenuItemClicked(event) {
        return !this.emit({
          data: event.data,
          name: 'creationMenuItemClicked',
          originalEvent: event
        });
      }

      /**
       * Continues the propagation of the creation menu more button clicked event
       * @param {!Event} event
       * @private
       * @return {Boolean} If the event has been prevented or not.
       */

    }, {
      key: '_handleCreationMenuMoreButtonClicked',
      value: function _handleCreationMenuMoreButtonClicked(event) {
        return !this.emit({
          name: 'creationMenuMoreButtonClicked',
          originalEvent: event
        });
      }

      /**
       * Continues the propagation of the checkbox changed event
       * @param {!Event} event
       * @private
       * @return {Boolean} If the event has been prevented or not.
       */

    }, {
      key: '_handleFilterDoneButtonClick',
      value: function _handleFilterDoneButtonClick(event) {
        return !this.emit({
          name: 'filterDoneClicked',
          originalEvent: event
        });
      }

      /**
       * Continues the propagation of the filter item click event
       * @param {!Event} event
       * @private
       * @return {Boolean} If the event has been prevented or not.
       */

    }, {
      key: '_handleFilterItemClicked',
      value: function _handleFilterItemClicked(event) {
        return !this.emit({
          data: event.data,
          name: 'filterItemClicked',
          originalEvent: event
        });
      }

      /**
       * Continues the propagation of the filter label close clicked event
       * @param {!Event} event
       * @private
       * @return {Boolean} If the event has been prevented or not.
       */

    }, {
      key: '_handleFilterLabelCloseClicked',
      value: function _handleFilterLabelCloseClicked(event) {
        return !this.emit({
          data: event.data,
          name: 'filterLabelCloseClicked',
          originalEvent: event
        });
      }

      /**
       * Continues the propagation of the Info button clicked event
       * @param {!Event} event
       * @private
       * @return {Boolean} If the event has been prevented or not.
       */

    }, {
      key: '_handleInfoButtonClicked',
      value: function _handleInfoButtonClicked(event) {
        return !this.emit({
          name: 'infoButtonClicked',
          originalEvent: event
        });
      }

      /**
       * Shows the search in mobile devices
       * @private
       */

    }, {
      key: '_handleOpenMobileSearchClick',
      value: function _handleOpenMobileSearchClick() {
        this._showSearchMobile = true;
      }

      /**
       * Continues the propagation of the action item clicked event
       * @param {!MouseEvent} event
       * @private
       * @return {Boolean} If the event has been prevented or not.
       */

    }, {
      key: '_handleQuickActionClicked',
      value: function _handleQuickActionClicked(event) {
        var element = event.delegateTarget;
        var elementIndex = element.getAttribute('data-quick-action-index');
        var item = this.actionItems[elementIndex];

        return !this.emit({
          data: {
            item: item
          },
          name: 'actionItemClicked',
          originalEvent: event
        });
      }

      /**
       * Continues the propagation of the search button clicked event
       * @param {!Event} event
       * @private
       * @return {Boolean} If the event has been prevented or not.
       */

    }, {
      key: '_handleSearchSearchClick',
      value: function _handleSearchSearchClick(event) {
        return !this.emit({
          name: 'search',
          originalEvent: event
        });
      }

      /**
       * Continues the propagation of the select all button clicked event
       * @param {!Event} event
       * @private
       * @return {Boolean} If the event has been prevented or not.
       */

    }, {
      key: '_handleSelectAllButtonClick',
      value: function _handleSelectAllButtonClick(event) {
        return !this.emit({
          name: 'selectAllButtonClicked',
          originalEvent: event
        });
      }

      /**
       * Continues the propagation of the checkbox changed event
       * @param {!Event} event
       * @private
       * @return {Boolean} If the event has been prevented or not.
       */

    }, {
      key: '_handleSelectPageCheckboxChanged',
      value: function _handleSelectPageCheckboxChanged(event) {
        return !this.emit({
          data: {
            checked: event.target.checked
          },
          name: 'selectPageCheckboxChanged',
          originalEvent: event
        });
      }

      /**
       * Continues the propagation of the sorting button clicked event
       * @param {!Event} event
       * @private
       * @return {Boolean} If the event has been prevented or not.
       */

    }, {
      key: '_handleSortingButtonClicked',
      value: function _handleSortingButtonClicked(event) {
        return !this.emit({
          data: {
            sortingOrder: this.sortingOrder
          },
          name: 'sortingButtonClicked',
          originalEvent: event
        });
      }

      /**
       * Continues the propagation of the view type item clicked event
       * @param {!Event} event
       * @private
       * @return {Boolean} If the event has been prevented or not.
       */

    }, {
      key: '_handleViewTypeClicked',
      value: function _handleViewTypeClicked(event) {
        return !this.emit({
          data: event.data,
          name: 'viewTypeItemClicked',
          originalEvent: event
        });
      }
    }]);

    return ClayManagementToolbar;
  }(_clayComponent2.default);

  /**
   * State definition.
   * @static
   * @type {!Object}
   */

  ClayManagementToolbar.STATE = {
    /**
     * Flag to indicate if search should be shown or not. This is for the
     * hide/show interaction in small devices.
     * @default false
     * @instance
     * @memberof ClayManagementToolbar
     * @type {?bool}
     */
    _showSearchMobile: _metalState.Config.bool().internal().value(false),

    /**
     * List of items to display in the actions menu on active state.
     * @default []
     * @instance
     * @memberof ClayManagementToolbar
     * @type {?(array|undefined)}
     */
    actionItems: _validators.actionItemsValidator,

    /**
     * Active status is visible
     * @default false
     * @instance
     * @memberof ClayManagementToolbar
     * @type {?(boolean|undefined)}
     */
    active: _metalState.Config.bool(),

    /**
     * Satus of the select items checkbox. If checkboxStatus is checked or
     * indeterminate the toolbar will be in active state.
     * @default unchecked
     * @instance
     * @memberof ClayManagementToolbar
     * @type {?(string|undefined)}
     */
    checkboxStatus: _metalState.Config.oneOf(['checked', 'indeterminate', 'unchecked']).value('unchecked'),

    /**
     * Url for clear results link.
     * @default undefined
     * @instance
     * @memberof ClayManagementToolbar
     * @type {?(string|undefined)}
     */
    clearResultsURL: _metalState.Config.string(),

    /**
     * Url for clear selection link.
     * @default undefined
     * @instance
     * @memberof ClayManagementToolbar
     * @type {?(string|undefined)}
     */
    clearSelectionURL: _metalState.Config.string(),

    /**
     * Name of the content renderer to use template variants.
     * @default undefined
     * @instance
     * @memberof ClayManagementToolbar
     * @type {?(string|undefined)}
     */
    contentRenderer: _metalState.Config.string(),

    /**
     * Configuration of the creation menu.
     * Set `true` to render a plain button that will emit an event onclick.
     * Set `string` to use it as link href to render a link styled button.
     * Set `object` to render a dropdown menu with items.
     * @default undefined
     * @instance
     * @memberof ClayManagementToolbar
     * @type {?(object|string|bool|undefined)}
     */
    creationMenu: _metalState.Config.shapeOf({
      caption: _metalState.Config.string(),
      helpText: _metalState.Config.string(),
      maxPrimaryItems: _metalState.Config.number(),
      maxSecondaryItems: _metalState.Config.number(),
      maxTotalItems: _metalState.Config.number(),
      primaryItems: _validators.creationMenuItemsValidator,
      secondaryItems: _validators.creationMenuItemsValidator,
      viewMoreURL: _metalState.Config.string()
    }),

    /**
     * Data that will be passed to deltemplates.
     * @default undefined
     * @instance
     * @memberof ClayManagementToolbar
     * @type {?object}
     */
    customData: _metalState.Config.object(),

    /**
     * Data to add to the element.
     * @default undefined
     * @instance
     * @memberof ClayManagementToolbar
     * @type {?object}
     */
    data: _metalState.Config.object(),

    /**
     * Object that wires events with default listeners
     * @default undefined
     * @instance
     * @memberof ClayManagementToolbar
     * @review
     * @type {?(object|undefined)}
     */
    defaultEventHandler: _metalState.Config.object(),

    /**
     * Flag to indicate if the management toolbar is disabled or not.
     * @default false
     * @instance
     * @memberof ClayManagementToolbar
     * @type {?bool}
     */
    disabled: _metalState.Config.bool().value(false),

    /**
     * CSS classes to be applied to the element.
     * @default undefined
     * @instance
     * @memberof ClayManagementToolbar
     * @type {?(string|undefined)}
     */
    elementClasses: _metalState.Config.string(),

    /**
     * List of filter menu items.
     * @default undefined
     * @instance
     * @memberof ClayManagementToolbar
     * @type {?(array|undefined)}
     */
    filterItems: _validators.filterItemsValidator,

    /**
     * List of filter label items.
     * @default []
     * @instance
     * @memberof ClayManagementToolbar
     * @type {?array}
     */
    filterLabels: _validators.filterLabelsValidator.value([]),

    /**
     * Id to be applied to the element.
     * @default undefined
     * @instance
     * @memberof ClayManagementToolbar
     * @type {?(string|undefined)}
     */
    id: _metalState.Config.string(),

    /**
     * URL of the search form action
     * @default undefined
     * @instance
     * @memberof ClayManagementToolbar
     * @type {?(string|undefined)}
     */
    searchActionURL: _metalState.Config.string(),

    /**
     * Method of the search form.
     * @default GET
     * @instance
     * @memberof ClayManagementToolbar
     * @type {?(string|undefined)}
     */
    searchFormMethod: _metalState.Config.oneOf(['GET', 'POST']).value('GET'),

    /**
     * Name of the search form.
     * @default undefined
     * @instance
     * @memberof ClayManagementToolbar
     * @type {?(string|undefined)}
     */
    searchFormName: _metalState.Config.string(),

    /**
     * Name of the search input.
     * @default undefined
     * @instance
     * @memberof ClayManagementToolbar
     * @type {?(string|undefined)}
     */
    searchInputName: _metalState.Config.string(),

    /**
     * Text of the search placeholder.
     * @default undefined
     * @instance
     * @memberof ClayManagementToolbar
     * @type {?(string|undefined)}
     */
    searchInputPlaceholder: _metalState.Config.string(),

    /**
     * Value of the search input.
     * @default undefined
     * @instance
     * @memberof ClayManagementToolbar
     * @type {?(string|undefined)}
     */
    searchValue: _metalState.Config.string(),

    /**
     * Flag to indicate if the management toolbar will control the selection of
     * elements.
     * @default undefined
     * @instance
     * @memberof ClayManagementToolbar
     * @type {?(bool|undefined)}
     */
    selectable: _metalState.Config.bool().value(false),

    /**
     * Url for select all link.
     * @default undefined
     * @instance
     * @memberof ClayManagementToolbar
     * @type {?(string|undefined)}
     */
    selectAllURL: _metalState.Config.string(),

    /**
     * Number of selected items.
     * @default undefined
     * @instance
     * @memberof ClayManagementToolbar
     * @type {?(number|undefined)}
     */
    selectedItems: _metalState.Config.number(),

    /**
     * Flag to indicate if advanced search should be shown or not.
     * @default false
     * @instance
     * @memberof ClayManagementToolbar
     * @type {?bool}
     */
    showAdvancedSearch: _metalState.Config.bool().value(false),

    /**
     * Flag to indicate if creation menu button should be shown or not.
     * @default true
     * @instance
     * @memberof ClayManagementToolbar
     * @type {?bool}
     */
    showCreationMenu: _metalState.Config.bool().value(true),

    /**
     * Flag to indicate if the `Done` button in filter dropdown should be shown or
     * not.
     * @default true
     * @instance
     * @memberof ClayManagementToolbar
     * @type {?bool}
     */
    showFiltersDoneButton: _metalState.Config.bool().value(true),

    /**
     * Flag to indicate if the Info button should be shown or not.
     * @default false
     * @instance
     * @memberof ClayManagementToolbar
     * @type {?bool}
     */
    showInfoButton: _metalState.Config.bool().value(false),

    /**
     * Flag to indicate if the results bar should be shown or not.
     * @default false
     * @instance
     * @memberof ClayManagementToolbar
     * @type {?bool}
     */
    showResultsBar: _metalState.Config.bool().value(false),

    /**
     * Flag to indicate if search should be shown or not.
     * @default true
     * @instance
     * @memberof ClayManagementToolbar
     * @type {?bool}
     */
    showSearch: _metalState.Config.bool().value(true),

    /**
     * Flag to indicate if select all button should be shown or not.
     * @default false
     * @instance
     * @memberof ClayManagementToolbar
     * @type {?bool}
     */
    showSelectAllButton: _metalState.Config.bool().value(false),

    /**
     * Sorting url.
     * @default undefined
     * @instance
     * @memberof ClayManagementToolbar
     * @type {?(string|undefined)}
     */
    sortingURL: _metalState.Config.string(),

    /**
     * Sorting order.
     * @default undefined
     * @instance
     * @memberof ClayManagementToolbar
     * @type {?(string|undefined)}
     */
    sortingOrder: _metalState.Config.oneOf(['asc', 'desc']),

    /**
     * The path to the SVG spritemap file containing the icons.
     * @default undefined
     * @instance
     * @memberof ClayManagementToolbar
     * @type {?(string|undefined)}
     */
    spritemap: _metalState.Config.string().required(),

    /**
     * Flag to indicate that the toolbar supports bulk selection.
     * @default false
     * @instance
     * @memberof ClayManagementToolbar
     * @type {boolean}
     */
    supportsBulkActions: _metalState.Config.bool().value(false),

    /**
     * Total number of items. If totalItems is 0 most of the elements in the bar
     * will appear disabled.
     * @default undefined
     * @instance
     * @memberof ClayManagementToolbar
     * @type {?(number|undefined)}
     */
    totalItems: _metalState.Config.number(),

    /**
     * List of view items.
     * @default undefined
     * @instance
     * @memberof ClayManagementToolbar
     * @type {?(array|undefined)}
     */
    viewTypes: _metalState.Config.arrayOf(_metalState.Config.shapeOf({
      active: _metalState.Config.bool().value(false),
      disabled: _metalState.Config.bool().value(false),
      href: _metalState.Config.string(),
      icon: _metalState.Config.string().required(),
      label: _metalState.Config.string().required()
    }))
  };

  (0, _metalWebComponent2.default)('clay-management-toolbar', ClayManagementToolbar);

  _metalSoy2.default.register(ClayManagementToolbar, _ClayManagementToolbarSoy2.default);

  exports.ClayManagementToolbar = ClayManagementToolbar;
  exports.default = ClayManagementToolbar;
  //# sourceMappingURL=ClayManagementToolbar.js.map
});
//# sourceMappingURL=ClayManagementToolbar.js.map