'use strict';

Liferay.Loader.define("frontend-taglib-clay$clay-management-toolbar@2.15.1/lib/ClayFilterLabel", ['module', 'exports', 'require', 'frontend-taglib-clay$clay-label', 'frontend-js-metal-web$metal-state', 'frontend-taglib-clay$clay-component', 'frontend-js-metal-web$metal-soy', './ClayFilterLabel.soy'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.ClayFilterLabel = undefined;

  var _createClass = function () {
    function defineProperties(target, props) {
      for (var i = 0; i < props.length; i++) {
        var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
      }
    }return function (Constructor, protoProps, staticProps) {
      if (protoProps) defineProperties(Constructor.prototype, protoProps);if (staticProps) defineProperties(Constructor, staticProps);return Constructor;
    };
  }();

  require("frontend-taglib-clay$clay-label");

  var _metalState = require("frontend-js-metal-web$metal-state");

  var _clayComponent = require("frontend-taglib-clay$clay-component");

  var _clayComponent2 = _interopRequireDefault(_clayComponent);

  var _metalSoy = require("frontend-js-metal-web$metal-soy");

  var _metalSoy2 = _interopRequireDefault(_metalSoy);

  var _ClayFilterLabelSoy = require("./ClayFilterLabel.soy");

  var _ClayFilterLabelSoy2 = _interopRequireDefault(_ClayFilterLabelSoy);

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { default: obj };
  }

  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _possibleConstructorReturn(self, call) {
    if (!self) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }return call && (typeof call === "object" || typeof call === "function") ? call : self;
  }

  function _inherits(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
    }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } });if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
  }

  /**
   * Metal ClayFilterLabel component.
   * @extends ClayComponent
   */
  var ClayFilterLabel = function (_ClayComponent) {
    _inherits(ClayFilterLabel, _ClayComponent);

    function ClayFilterLabel() {
      _classCallCheck(this, ClayFilterLabel);

      return _possibleConstructorReturn(this, (ClayFilterLabel.__proto__ || Object.getPrototypeOf(ClayFilterLabel)).apply(this, arguments));
    }

    _createClass(ClayFilterLabel, [{
      key: '_handleFilterLabelCloseClicked',

      /**
       * Continues the propagation of the filter label close clicked event
       * @param {!Event} event
       * @private
       * @return {Boolean} If the event has been prevented or not.
       */
      value: function _handleFilterLabelCloseClicked(event) {
        return !this.emit({
          name: 'filterLabelCloseClicked',
          originalEvent: event
        });
      }
    }]);

    return ClayFilterLabel;
  }(_clayComponent2.default);

  /**
   * State definition.
   * @static
   * @type {!Object}
   */

  ClayFilterLabel.STATE = {
    /**
     * Flag to indicate if the label is closeable.
     * @default false
     * @instance
     * @memberof ClayLabel
     * @type {?bool}
     */
    closeable: _metalState.Config.bool().value(false),

    /**
     * Data to add to the element.
     * @default undefined
     * @instance
     * @memberof ClayLabel
     * @type {?object}
     */
    data: _metalState.Config.object(),

    /**
     * Data to add pass to label component.
     * @default undefined
     * @instance
     * @memberof ClayLabel
     * @type {?object}
     */
    filterData: _metalState.Config.object(),

    /**
     * CSS classes to be applied to the element.
     * @default undefined
     * @instance
     * @memberof ClayLabel
     * @type {?(string|undefined)}
     */
    elementClasses: _metalState.Config.string(),

    /**
     * The label of the badge element.
     * @default undefined
     * @instance
     * @memberof ClayLabel
     * @type {?(html|string|undefined)}
     */
    label: _metalState.Config.any().required(),

    /**
     * The path to the SVG spritemap file containing the icons.
     * @default undefined
     * @instance
     * @memberof ClayLabel
     * @type {?(string|undefined)}
     */
    spritemap: _metalState.Config.string().required()
  };

  _metalSoy2.default.register(ClayFilterLabel, _ClayFilterLabelSoy2.default);

  exports.ClayFilterLabel = ClayFilterLabel;
  exports.default = ClayFilterLabel;
  //# sourceMappingURL=ClayFilterLabel.js.map
});
//# sourceMappingURL=ClayFilterLabel.js.map