'use strict';

Liferay.Loader.define('frontend-taglib-clay$clay-link@2.15.1/lib/ClayLink', ['module', 'exports', 'require', 'frontend-taglib-clay$clay-icon', 'frontend-taglib-clay$clay-component', 'frontend-js-metal-web$metal-web-component', 'frontend-js-metal-web$metal-soy', 'frontend-js-metal-web$metal-state', './ClayLink.soy'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.ClayLink = undefined;

  require('frontend-taglib-clay$clay-icon');

  var _clayComponent = require('frontend-taglib-clay$clay-component');

  var _clayComponent2 = _interopRequireDefault(_clayComponent);

  var _metalWebComponent = require('frontend-js-metal-web$metal-web-component');

  var _metalWebComponent2 = _interopRequireDefault(_metalWebComponent);

  var _metalSoy = require('frontend-js-metal-web$metal-soy');

  var _metalSoy2 = _interopRequireDefault(_metalSoy);

  var _metalState = require('frontend-js-metal-web$metal-state');

  var _ClayLinkSoy = require('./ClayLink.soy');

  var _ClayLinkSoy2 = _interopRequireDefault(_ClayLinkSoy);

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { default: obj };
  }

  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _possibleConstructorReturn(self, call) {
    if (!self) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }return call && (typeof call === "object" || typeof call === "function") ? call : self;
  }

  function _inherits(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
    }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } });if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
  }

  /**
   * Implementation of the Metal Clay Link.
   * @extends ClayComponent
   */
  var ClayLink = function (_ClayComponent) {
    _inherits(ClayLink, _ClayComponent);

    function ClayLink() {
      _classCallCheck(this, ClayLink);

      return _possibleConstructorReturn(this, (ClayLink.__proto__ || Object.getPrototypeOf(ClayLink)).apply(this, arguments));
    }

    return ClayLink;
  }(_clayComponent2.default);

  /**
   * State definition.
   * @static
   * @type {!Object}
   */

  ClayLink.STATE = {
    /**
     * Aria label attribute for the anchor element.
     * @default undefined
     * @instance
     * @memberof ClayLink
     * @type {?(string|undefined)}
     */
    ariaLabel: _metalState.Config.string(),

    /**
     * Aria Expanded attribute for the anchor element.
     * @default undefined
     * @instance
     * @memberof ClayLink
     * @type {?(bool|undefined)}
     */
    ariaExpanded: _metalState.Config.bool(),

    /**
     * The css class to act as a button. If this is defined `style` param is
     * ignored.
     * @default undefined
     * @instance
     * @memberof ClayLink
     * @type {?(string|undefined)}
     */
    buttonStyle: _metalState.Config.oneOf(['link', 'primary', 'secondary']),

    /**
     * Data to add to the element.
     * @default undefined
     * @instance
     * @memberof ClayLink
     * @type {?object}
     */
    data: _metalState.Config.object(),

    /**
     * Object that wires events with default listeners
     * @default undefined
     * @instance
     * @memberof ClayLink
     * @review
     * @type {?(object|undefined)}
     */
    defaultEventHandler: _metalState.Config.object(),

    /**
     * Sets the download attribute on the anchor tag.
     * @default undefined
     * @instance
     * @memberof ClayLink
     * @type {?(string|undefined)}
     */
    download: _metalState.Config.string(),

    /**
     * CSS classes to be applied to the element.
     * @default undefined
     * @instance
     * @memberof ClayLink
     * @type {?(string|undefined)}
     */
    elementClasses: _metalState.Config.string(),

    /**
     * Sets the HTML attribute href on the anchor tag.
     * @default undefined
     * @instance
     * @memberof ClayLink
     * @type {?(string|undefined)}
     */
    href: _metalState.Config.string(),

    /**
     * Icon to be rendered in the link.
     * @default undefined
     * @instance
     * @memberof ClayLink
     * @type {?(string|undefined)}
     */
    icon: _metalState.Config.string(),

    /**
     * Render position of the ClayIcon in the ClayLink element.
     * @default left
     * @instance
     * @memberof ClayLink
     * @type {?string}
     */
    iconAlignment: _metalState.Config.oneOf(['left', 'right']).value('left'),

    /**
     * Id to be applied to the element.
     * @default undefined
     * @instance
     * @memberof ClayLink
     * @type {?(string|undefined)}
     */
    id: _metalState.Config.string(),

    /**
     * Alternative text of the image to be rendered inside the link.
     * @default undefined
     * @instance
     * @memberof ClayLink
     * @type {?(string|undefined)}
     */
    imageAlt: _metalState.Config.string(),

    /**
     * Source of the image to be rendered inside the link.
     * @default undefined
     * @instance
     * @memberof ClayLink
     * @type {?(string|undefined)}
     */
    imageSrc: _metalState.Config.string(),

    /**
     * Sets the text or HTML to be rendered inside the anchor tag.
     * @default undefined
     * @instance
     * @memberof ClayLink
     * @type {?(html|string|undefined)}
     */
    label: _metalState.Config.any(),

    /**
     * The path to the SVG spritemap file containing the icons.
     * @default undefined
     * @instance
     * @memberof ClayLink
     * @type {?string|undefined}
     */
    spritemap: _metalState.Config.string(),

    /**
     * The css class that colors the button.
     * @default undefined
     * @instance
     * @memberof ClayLink
     * @type {?(string|undefined)}
     */
    style: _metalState.Config.oneOf(['secondary']),

    /**
     * Sets the HTML attribute target on the anchor tag.
     * @default undefined
     * @instance
     * @memberof ClayLink
     * @type {?(string|undefined)}
     */
    target: _metalState.Config.oneOf(['_blank', '_self']),

    /**
     * Sets the HTML attribute title on the anchor tag.
     * @default undefined
     * @instance
     * @memberof ClayLink
     * @type {?(string|undefined)}
     */
    title: _metalState.Config.string()
  };

  (0, _metalWebComponent2.default)('clay-link', ClayLink);

  _metalSoy2.default.register(ClayLink, _ClayLinkSoy2.default);

  exports.ClayLink = ClayLink;
  exports.default = ClayLink;
  //# sourceMappingURL=ClayLink.js.map
});
//# sourceMappingURL=ClayLink.js.map