'use strict';

Liferay.Loader.define("frontend-taglib-clay$clay-label@2.15.1/lib/ClayLabel", ['module', 'exports', 'require', 'frontend-taglib-clay$clay-button', 'frontend-taglib-clay$clay-link', 'frontend-js-metal-web$metal-state', 'frontend-taglib-clay$clay-component', 'frontend-js-metal-web$metal-web-component', 'frontend-js-metal-web$metal-soy', './ClayLabel.soy'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.ClayLabel = undefined;

  var _createClass = function () {
    function defineProperties(target, props) {
      for (var i = 0; i < props.length; i++) {
        var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
      }
    }return function (Constructor, protoProps, staticProps) {
      if (protoProps) defineProperties(Constructor.prototype, protoProps);if (staticProps) defineProperties(Constructor, staticProps);return Constructor;
    };
  }();

  require("frontend-taglib-clay$clay-button");

  require("frontend-taglib-clay$clay-link");

  var _metalState = require("frontend-js-metal-web$metal-state");

  var _clayComponent = require("frontend-taglib-clay$clay-component");

  var _clayComponent2 = _interopRequireDefault(_clayComponent);

  var _metalWebComponent = require("frontend-js-metal-web$metal-web-component");

  var _metalWebComponent2 = _interopRequireDefault(_metalWebComponent);

  var _metalSoy = require("frontend-js-metal-web$metal-soy");

  var _metalSoy2 = _interopRequireDefault(_metalSoy);

  var _ClayLabelSoy = require("./ClayLabel.soy");

  var _ClayLabelSoy2 = _interopRequireDefault(_ClayLabelSoy);

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { default: obj };
  }

  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _possibleConstructorReturn(self, call) {
    if (!self) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }return call && (typeof call === "object" || typeof call === "function") ? call : self;
  }

  function _inherits(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
    }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } });if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
  }

  /**
   * Metal Clay Label component.
   * @extends ClayComponent
   */
  var ClayLabel = function (_ClayComponent) {
    _inherits(ClayLabel, _ClayComponent);

    function ClayLabel() {
      _classCallCheck(this, ClayLabel);

      return _possibleConstructorReturn(this, (ClayLabel.__proto__ || Object.getPrototypeOf(ClayLabel)).apply(this, arguments));
    }

    _createClass(ClayLabel, [{
      key: '_handleCloseButtonClick',

      /**
       * Handle `click` button and emit event `close`.
       * @param {!Event} event
       * @protected
       * @return {Boolean} If the event has been prevented or not.
       */
      value: function _handleCloseButtonClick(event) {
        return !this.emit({
          name: 'close',
          originalEvent: event
        });
      }
    }]);

    return ClayLabel;
  }(_clayComponent2.default);

  /**
   * State definition.
   * @static
   * @type {!Object}
   */

  ClayLabel.STATE = {
    /**
     * Flag to indicate if the label is closeable.
     * @default false
     * @instance
     * @memberof ClayLabel
     * @type {?bool}
     */
    closeable: _metalState.Config.bool().value(false),

    /**
     * Data to add to the element.
     * @default undefined
     * @instance
     * @memberof ClayLabel
     * @type {?object}
     */
    data: _metalState.Config.object(),

    /**
     * Object that wires events with default listeners
     * @default undefined
     * @instance
     * @memberof ClayLabel
     * @review
     * @type {?(object|undefined)}
     */
    defaultEventHandler: _metalState.Config.object(),

    /**
     * CSS classes to be applied to the element.
     * @default undefined
     * @instance
     * @memberof ClayLabel
     * @type {?(string|undefined)}
     */
    elementClasses: _metalState.Config.string(),

    /**
     * HREF in label.
     * @default undefined
     * @instance
     * @memberof ClayLabel
     * @type {?(string|undefined)}
     */
    href: _metalState.Config.string(),

    /**
     * Id to be applied to the element.
     * @default undefined
     * @instance
     * @memberof ClayLabel
     * @type {?(string|undefined)}
     */
    id: _metalState.Config.string(),

    /**
     * The label of the badge element.
     * @default undefined
     * @instance
     * @memberof ClayLabel
     * @type {?(html|string|undefined)}
     */
    label: _metalState.Config.any(),

    /**
     * The size of the label element.
     * @default undefined
     * @instance
     * @memberof ClayLabel
     * @type {?(string|undefined)}
     */
    size: _metalState.Config.oneOf(['lg']),

    /**
     * The path to the SVG spritemap file containing the icons.
     * @default undefined
     * @instance
     * @memberof ClayLabel
     * @type {?(string|undefined)}
     */
    spritemap: _metalState.Config.string(),

    /**
     * Label style color.
     * @default secondary
     * @instance
     * @memberof ClayLabel
     * @type {?(bool|string)}
     */
    style: _metalState.Config.oneOfType([_metalState.Config.bool(), _metalState.Config.oneOf(['danger', 'info', 'secondary', 'warning', 'success'])]).value('secondary'),

    /**
     * Flag to indicate if the element can be focused.
     * @default undefined
     * @instance
     * @memberof ClayLabel
     * @type {?(string|undefined)}
     */
    tabIndex: _metalState.Config.string()
  };

  (0, _metalWebComponent2.default)('clay-label', ClayLabel);

  _metalSoy2.default.register(ClayLabel, _ClayLabelSoy2.default);

  exports.ClayLabel = ClayLabel;
  exports.default = ClayLabel;
  //# sourceMappingURL=ClayLabel.js.map
});
//# sourceMappingURL=ClayLabel.js.map