'use strict';

Liferay.Loader.define("frontend-taglib-clay$clay-dropdown@2.15.1/lib/ClayDropdownItem", ['module', 'exports', 'require', 'frontend-taglib-clay$clay-button', 'frontend-taglib-clay$clay-checkbox', 'frontend-taglib-clay$clay-icon', 'frontend-taglib-clay$clay-link', 'frontend-taglib-clay$clay-radio', 'frontend-taglib-clay$clay-component', 'frontend-js-metal-web$metal-web-component', 'frontend-js-metal-web$metal-soy', 'frontend-js-metal-web$metal-state', './validators', './ClayDropdownItem.soy'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.ClayDropdownItem = undefined;

  var _createClass = function () {
    function defineProperties(target, props) {
      for (var i = 0; i < props.length; i++) {
        var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
      }
    }return function (Constructor, protoProps, staticProps) {
      if (protoProps) defineProperties(Constructor.prototype, protoProps);if (staticProps) defineProperties(Constructor, staticProps);return Constructor;
    };
  }();

  require("frontend-taglib-clay$clay-button");

  require("frontend-taglib-clay$clay-checkbox");

  require("frontend-taglib-clay$clay-icon");

  require("frontend-taglib-clay$clay-link");

  require("frontend-taglib-clay$clay-radio");

  var _clayComponent = require("frontend-taglib-clay$clay-component");

  var _clayComponent2 = _interopRequireDefault(_clayComponent);

  var _metalWebComponent = require("frontend-js-metal-web$metal-web-component");

  var _metalWebComponent2 = _interopRequireDefault(_metalWebComponent);

  var _metalSoy = require("frontend-js-metal-web$metal-soy");

  var _metalSoy2 = _interopRequireDefault(_metalSoy);

  var _metalState = require("frontend-js-metal-web$metal-state");

  var _validators = require('./validators');

  var _ClayDropdownItemSoy = require("./ClayDropdownItem.soy");

  var _ClayDropdownItemSoy2 = _interopRequireDefault(_ClayDropdownItemSoy);

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { default: obj };
  }

  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _possibleConstructorReturn(self, call) {
    if (!self) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }return call && (typeof call === "object" || typeof call === "function") ? call : self;
  }

  function _inherits(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
    }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } });if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
  }

  /**
   * Implementation of the Metal Clay Icon.
   * @extends ClayComponent
   */
  var ClayDropdownItem = function (_ClayComponent) {
    _inherits(ClayDropdownItem, _ClayComponent);

    function ClayDropdownItem() {
      _classCallCheck(this, ClayDropdownItem);

      return _possibleConstructorReturn(this, (ClayDropdownItem.__proto__ || Object.getPrototypeOf(ClayDropdownItem)).apply(this, arguments));
    }

    _createClass(ClayDropdownItem, [{
      key: '_handleItemClick',

      /**
       * Continues the propagation of the item clicked event
       * @param {!Event} event
       * @protected
       * @return {Boolean} If the event has been prevented or not.
       */
      value: function _handleItemClick(event) {
        return !this.emit('itemClicked', event);
      }

      /**
       * Continues the propagation of the item clicked event
       * @param {!Event} event
       * @protected
       * @return {Boolean} If the event has been prevented or not.
       */

    }, {
      key: '_handleItemKeyDown',
      value: function _handleItemKeyDown(event) {
        return !this.emit('itemKeyDown', event);
      }

      /**
       * @inheritDoc
       */

    }, {
      key: 'syncActive',
      value: function syncActive() {
        if (this.active) {
          this.element.focus();
        }
      }
    }]);

    return ClayDropdownItem;
  }(_clayComponent2.default);

  /**
   * State definition.
   * @static
   * @type {!Object}
   */

  ClayDropdownItem.STATE = {
    /**
     * Flag to indicate if the item is active or not.
     * @default false
     * @instance
     * @memberof ClayDropdownItem
     * @type {?bool}
     */
    active: _validators.itemShape.active,

    /**
     * Flag to indicate if the item is checked or not.
     * @default false
     * @instance
     * @memberof ClayDropdownItem
     * @type {?bool}
     */
    checked: _validators.itemShape.checked,

    /**
     * Name of the content renderer for the different deltempaltes.
     * @default undefined
     * @instance
     * @memberof ClayDropdownItem
     * @type {?(string|undefined)}
     */
    contentRenderer: _metalState.Config.string(),

    /**
     * Data to add to the element.
     * @default undefined
     * @instance
     * @memberof ClayDropdownItem
     * @type {?object}
     */
    data: _metalState.Config.object(),

    /**
     * Object that wires events with default listeners
     * @default undefined
     * @instance
     * @memberof ClayDropdownItem
     * @review
     * @type {?(object|undefined)}
     */
    defaultEventHandler: _metalState.Config.object(),

    /**
     * Flag to indicate if the item is disabled or not
     * @default false
     * @instance
     * @memberof ClayDropdownItem
     * @type {?bool}
     */
    disabled: _validators.itemShape.disabled,

    /**
     * Href of the item.
     * @default undefined
     * @instance
     * @memberof ClayDropdownItem
     * @type {?(string|undefined)}
     */
    href: _validators.itemShape.href,

    /**
     * Icon of the item.
     * @default undefined
     * @deprecated since version 2.13.x
     * @instance
     * @memberof ClayDropdownItem
     * @type {?(string|undefined)}
     */
    icon: _validators.itemShape.icon,

    /**
     * Icons of the item.
     * @default undefined
     * @instance
     * @memberof ClayDropdownItem
     * @type {?(object|undefined)}
     */
    icons: _validators.itemShape.icons,

    /**
     * Name of the item input in case is selectable.
     * @default undefined
     * @instance
     * @memberof ClayDropdownItem
     * @type {?(string|undefined)}
     */
    inputName: _validators.itemShape.inputName,

    /**
     * Value of the item input in case is selectable.
     * @default undefined
     * @instance
     * @memberof ClayDropdownItem
     * @type {?(string|undefined)}
     */
    inputValue: _validators.itemShape.inputValue,

    /**
     * List of child items of the item.
     * @default undefined
     * @instance
     * @memberof ClayDropdownItem
     * @type {?(array|undefined)}
     */
    items: _validators.itemShape.items,

    /**
     * Position in which item icons will be placed. Needed if any item has icons.
     * @default undefined
     * @instance
     * @memberof ClayDropdownBase
     * @type {?(string|undefined)}
     */
    itemsIconAlignment: _metalState.Config.oneOf(['left', 'right', 'left-right']),

    /**
     * Label of the item.
     * @default undefined
     * @instance
     * @memberof ClayDropdownItem
     * @type {?(string|undefined)}
     */
    label: _validators.itemShape.label,

    /**
     * Number of max child items of the item.
     * @default undefined
     * @instance
     * @memberof ClayDropdownItem
     * @type {?(number|undefined)}
     */
    maxItems: _validators.itemShape.maxItems,

    /**
     * Flag to indicate if the item has a separator or not.
     * @default undefined
     * @instance
     * @memberof ClayDropdownItem
     * @type {?(bool|undefined)}
     */
    separator: _validators.itemShape.separator,

    /**
     * The path to the SVG spritemap file containing the icons.
     * @default undefined
     * @instance
     * @memberof ClayDropdownItem
     * @type {?(string|undefined)}
     */
    spritemap: _metalState.Config.string(),

    /**
     * Sets the HTML attribute target on the anchor tag.
     * @default undefined
     * @instance
     * @memberof ClayDropdownItem
     * @type {?(string|undefined)}
     */
    target: _metalState.Config.oneOf(['_blank', '_self']),

    /**
     * Title of the item.
     * @default undefined
     * @instance
     * @memberof ClayDropdownItem
     * @type {?(string|undefined)}
     */
    title: _validators.itemShape.title,

    /**
     * Type of the item.
     * @default undefined
     * @instance
     * @memberof ClayDropdownItem
     * @type {?(string|undefined)}
     */
    type: _metalState.Config.string()
  };

  (0, _metalWebComponent2.default)('clay-dropdown-item', ClayDropdownItem);

  _metalSoy2.default.register(ClayDropdownItem, _ClayDropdownItemSoy2.default);

  exports.ClayDropdownItem = ClayDropdownItem;
  exports.default = ClayDropdownItem;
  //# sourceMappingURL=ClayDropdownItem.js.map
});
//# sourceMappingURL=ClayDropdownItem.js.map