'use strict';

Liferay.Loader.define("frontend-taglib-clay$clay-dropdown@2.15.1/lib/ClayCreationMenuDropdown", ['module', 'exports', 'require', 'frontend-taglib-clay$clay-icon', './ClayDropdownBase', 'frontend-taglib-clay$clay-component', 'frontend-js-metal-web$metal-web-component', 'frontend-js-metal-web$metal-soy', 'frontend-js-metal-web$metal-state', './validators', './ClayCreationMenuDropdown.soy'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.ClayCreationMenuDropdown = undefined;

  var _createClass = function () {
    function defineProperties(target, props) {
      for (var i = 0; i < props.length; i++) {
        var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
      }
    }return function (Constructor, protoProps, staticProps) {
      if (protoProps) defineProperties(Constructor.prototype, protoProps);if (staticProps) defineProperties(Constructor, staticProps);return Constructor;
    };
  }();

  require("frontend-taglib-clay$clay-icon");

  require('./ClayDropdownBase');

  var _clayComponent = require("frontend-taglib-clay$clay-component");

  var _clayComponent2 = _interopRequireDefault(_clayComponent);

  var _metalWebComponent = require("frontend-js-metal-web$metal-web-component");

  var _metalWebComponent2 = _interopRequireDefault(_metalWebComponent);

  var _metalSoy = require("frontend-js-metal-web$metal-soy");

  var _metalSoy2 = _interopRequireDefault(_metalSoy);

  var _metalState = require("frontend-js-metal-web$metal-state");

  var _validators = require('./validators');

  var _ClayCreationMenuDropdownSoy = require("./ClayCreationMenuDropdown.soy");

  var _ClayCreationMenuDropdownSoy2 = _interopRequireDefault(_ClayCreationMenuDropdownSoy);

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { default: obj };
  }

  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _possibleConstructorReturn(self, call) {
    if (!self) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }return call && (typeof call === "object" || typeof call === "function") ? call : self;
  }

  function _inherits(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
    }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } });if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
  }

  /**
   * Implementation for Metal Clay Action Dropdown.
   * @extends ClayComponent
   */
  var ClayCreationMenuDropdown = function (_ClayComponent) {
    _inherits(ClayCreationMenuDropdown, _ClayComponent);

    function ClayCreationMenuDropdown() {
      _classCallCheck(this, ClayCreationMenuDropdown);

      return _possibleConstructorReturn(this, (ClayCreationMenuDropdown.__proto__ || Object.getPrototypeOf(ClayCreationMenuDropdown)).apply(this, arguments));
    }

    _createClass(ClayCreationMenuDropdown, [{
      key: 'attached',

      /**
       * @inheritDoc
       */
      value: function attached() {
        this.addListener('toggle', this._defaultToggle, true);
      }

      /**
       * Toggles the dropdown, closing it when open or opening it when closed.
       * @param {!Event} event
       * @protected
       */

    }, {
      key: '_defaultToggle',
      value: function _defaultToggle(event) {
        event.preventDefault();

        this.expanded = !this.expanded;
      }

      /**
       * Handles footer button click.
       * @param {!Event} event
       * @protected
       */

    }, {
      key: '_handleButtonClick',
      value: function _handleButtonClick(event) {
        this.emit('moreButtonClicked', event);
      }

      /**
       * Continues the propagation of the item clicked event
       * @param {!Event} event
       * @protected
       * @return {Boolean} If the event has been prevented or not.
       */

    }, {
      key: '_handleItemClick',
      value: function _handleItemClick(event) {
        return !this.emit({
          data: event.data,
          name: 'itemClicked',
          originalEvent: event
        });
      }

      /**
       * Continues the propagation of the toggle event.
       * @param {!Event} event
       * @return {Boolean} If the event has been prevented or not.
       */

    }, {
      key: 'toggle',
      value: function toggle(event) {
        return !this.emit({
          name: 'toggle',
          originalEvent: event
        });
      }
    }]);

    return ClayCreationMenuDropdown;
  }(_clayComponent2.default);

  /**
   * State definition.
   * @static
   * @type {!Object}
   */

  ClayCreationMenuDropdown.STATE = {
    /**
     * Button configuration to place a button at dropdown footer.
     * @default undefined
     * @instance
     * @memberof ClayCreationMenuDropdown
     * @type {?(string|undefined)}
     */
    button: _metalState.Config.shapeOf({
      label: _metalState.Config.string().required(),
      style: _metalState.Config.oneOf(['primary', 'secondary']).value('primary'),
      type: _metalState.Config.oneOf(['button', 'reset', 'submit'])
    }),

    /**
     * Data to add to the element.
     * @default undefined
     * @instance
     * @memberof ClayCreationMenuDropdown
     * @type {?object}
     */
    data: _metalState.Config.object(),

    /**
     * Object that wires events with default listeners
     * @default undefined
     * @instance
     * @memberof ClayCreationMenuDropdown
     * @review
     * @type {?(object|undefined)}
     */
    defaultEventHandler: _metalState.Config.object(),

    /**
     * Flag to indicate if menu is disabled
     * @default false
     * @instance
     * @memberof ClayCreationMenuDropdown
     * @type {?bool}
     */
    disabled: _metalState.Config.bool().value(false),

    /**
     * CSS classes to be applied to the element.
     * @default undefined
     * @instance
     * @memberof ClayCreationMenuDropdown
     * @type {?(string|undefined)}
     */
    elementClasses: _metalState.Config.string(),

    /**
     * Flag to indicate if menu is expanded.
     * @default false
     * @instance
     * @memberof ClayCreationMenuDropdown
     * @type {?bool}
     */
    expanded: _metalState.Config.bool().value(false),

    /**
     * Help text to be shown on top of the open dropdown.
     * @default undefined
     * @instance
     * @memberof ClayCreationMenuDropdown
     * @type {?(string|undefined)}
     */
    helpText: _metalState.Config.string(),

    /**
     * Id to be applied to the element.
     * @default undefined
     * @instance
     * @memberof ClayCreationMenuDropdown
     * @type {?(string|undefined)}
     */
    id: _metalState.Config.string(),

    /**
     * Position in which item icon will be placed. Needed if any item has icons.
     * @default undefined
     * @instance
     * @memberof ClayCreationMenuDropdown
     * @type {?(string|undefined)}
     */
    itemsIconAlignment: _metalState.Config.oneOf(['left', 'right', 'left-right']),

    /**
     * Maximum number of primary items to show. Only take in account when
     * secondaryItems are passed, otherwise maxTotalItems is used.
     * @default 8
     * @instance
     * @memberof ClayCreationMenuDropdown
     * @type {?(number|undefined)}
     */
    maxPrimaryItems: _metalState.Config.number().value(8),

    /**
     * Maximum number of secondary items to show.
     * @default 7
     * @instance
     * @memberof ClayCreationMenuDropdown
     * @type {?(number|undefined)}
     */
    maxSecondaryItems: _metalState.Config.number().value(7),

    /**
     * Maximum number of total items to show.
     * @default 15
     * @instance
     * @memberof ClayCreationMenuDropdown
     * @type {?(number|undefined)}
     */
    maxTotalItems: _metalState.Config.number().value(15),

    /**
     * The preferred alignment for the dropdown content.
     * @default BottomLeft
     * @instance
     * @memberof ClayCreationMenuDropdown
     * @type {?(string|undefined)}
     */
    preferredAlign: _validators.preferredAlign.value('BottomLeft'),

    /**
     * List of primary menu items.
     * @default undefined
     * @instance
     * @memberof ClayCreationMenuDropdown
     * @type {!Array}
     */
    primaryItems: _validators.itemsValidator,

    /**
     * List of secondary menu items.
     * @default undefined
     * @instance
     * @memberof ClayCreationMenuDropdown
     * @type {?(Array|undefined)}
     */
    secondaryItems: _validators.itemsValidator,

    /**
     * The path to the SVG spritemap file containing the icons.
     * @default undefined
     * @instance
     * @memberof ClayCreationMenuDropdown
     * @type {!string}
     */
    spritemap: _metalState.Config.string().required(),

    /**
     * Aria label attribute for the trigger element.
     * @default undefined
     * @instance
     * @memberof ClayCreationMenuDropdown
     * @type {?(string|undefined)}
     */
    triggerAriaLabel: _metalState.Config.string(),

    /**
     * CSS classes to be applied to the trigger element.
     * @default undefined
     * @instance
     * @memberof ClayCreationMenuDropdown
     * @type {?(string|undefined)}
     */
    triggerClasses: _metalState.Config.string(),

    /**
     * The title attribute of the trigger element.
     * @default undefined
     * @instance
     * @memberof ClayCreationMenuDropdown
     * @type {?(string|undefined)}
     */
    triggerTitle: _metalState.Config.string(),

    /**
     * The url for the view more button in case is rendered.
     * @instance
     * @memberof ClayCreationMenuDropdown
     * @type {?(string|undefined)}
     * @default undefined
     */
    viewMoreURL: _metalState.Config.string()
  };

  (0, _metalWebComponent2.default)('clay-creation-menu-dropdown', ClayCreationMenuDropdown);

  _metalSoy2.default.register(ClayCreationMenuDropdown, _ClayCreationMenuDropdownSoy2.default);

  exports.ClayCreationMenuDropdown = ClayCreationMenuDropdown;
  exports.default = ClayCreationMenuDropdown;
  //# sourceMappingURL=ClayCreationMenuDropdown.js.map
});
//# sourceMappingURL=ClayCreationMenuDropdown.js.map