'use strict';

Liferay.Loader.define("frontend-taglib-clay$clay-dropdown@2.15.1/lib/ClayActionsDropdown", ['module', 'exports', 'require', 'frontend-taglib-clay$clay-icon', './ClayDropdownBase', 'frontend-taglib-clay$clay-component', 'frontend-js-metal-web$metal-web-component', 'frontend-js-metal-web$metal-soy', 'frontend-js-metal-web$metal-state', './validators', './ClayActionsDropdown.soy'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.ClayActionsDropdown = undefined;

  var _createClass = function () {
    function defineProperties(target, props) {
      for (var i = 0; i < props.length; i++) {
        var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
      }
    }return function (Constructor, protoProps, staticProps) {
      if (protoProps) defineProperties(Constructor.prototype, protoProps);if (staticProps) defineProperties(Constructor, staticProps);return Constructor;
    };
  }();

  require("frontend-taglib-clay$clay-icon");

  require('./ClayDropdownBase');

  var _clayComponent = require("frontend-taglib-clay$clay-component");

  var _clayComponent2 = _interopRequireDefault(_clayComponent);

  var _metalWebComponent = require("frontend-js-metal-web$metal-web-component");

  var _metalWebComponent2 = _interopRequireDefault(_metalWebComponent);

  var _metalSoy = require("frontend-js-metal-web$metal-soy");

  var _metalSoy2 = _interopRequireDefault(_metalSoy);

  var _metalState = require("frontend-js-metal-web$metal-state");

  var _validators = require('./validators');

  var _ClayActionsDropdownSoy = require("./ClayActionsDropdown.soy");

  var _ClayActionsDropdownSoy2 = _interopRequireDefault(_ClayActionsDropdownSoy);

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { default: obj };
  }

  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _possibleConstructorReturn(self, call) {
    if (!self) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }return call && (typeof call === "object" || typeof call === "function") ? call : self;
  }

  function _inherits(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
    }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } });if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
  }

  /**
   * Implementation for Metal Clay Action Dropdown.
   * @extends ClayComponent
   */
  var ClayActionsDropdown = function (_ClayComponent) {
    _inherits(ClayActionsDropdown, _ClayComponent);

    function ClayActionsDropdown() {
      _classCallCheck(this, ClayActionsDropdown);

      return _possibleConstructorReturn(this, (ClayActionsDropdown.__proto__ || Object.getPrototypeOf(ClayActionsDropdown)).apply(this, arguments));
    }

    _createClass(ClayActionsDropdown, [{
      key: 'attached',

      /**
       * @inheritDoc
       */
      value: function attached() {
        this.addListener('toggle', this._defaultToggle, true);
      }

      /**
       * Toggles the dropdown, closing it when open or opening it when closed.
       * @param {!Event} event
       * @protected
       */

    }, {
      key: '_defaultToggle',
      value: function _defaultToggle(event) {
        event.preventDefault();

        this.expanded = !this.expanded;
      }

      /**
       * Handles footer button click.
       * @param {!Event} event
       * @protected
       */

    }, {
      key: '_handleButtonClick',
      value: function _handleButtonClick(event) {
        this.emit('buttonClicked', event);
      }

      /**
       * Continues the propagation of the item clicked event
       * @param {!Event} event
       * @protected
       * @return {Boolean} If the event has been prevented or not.
       */

    }, {
      key: '_handleItemClick',
      value: function _handleItemClick(event) {
        return !this.emit({
          data: event.data,
          name: 'itemClicked',
          originalEvent: event
        });
      }

      /**
       * Continues the propagation of the toggle event.
       * @param {!Event} event
       * @return {Boolean} If the event has been prevented or not.
       */

    }, {
      key: 'toggle',
      value: function toggle(event) {
        return !this.emit({
          name: 'toggle',
          originalEvent: event
        });
      }
    }]);

    return ClayActionsDropdown;
  }(_clayComponent2.default);

  /**
   * State definition.
   * @static
   * @type {!Object}
   */

  ClayActionsDropdown.STATE = {
    /**
     * Button configuration to place a button at dropdown footer.
     * @default undefined
     * @instance
     * @memberof ClayActionsDropdown
     * @type {?(string|undefined)}
     */
    button: _metalState.Config.shapeOf({
      label: _metalState.Config.string().required(),
      style: _metalState.Config.oneOf(['primary', 'secondary']).value('primary'),
      type: _metalState.Config.oneOf(['button', 'reset', 'submit'])
    }),

    /**
     * Caption text of the dropdown.
     * @default undefined
     * @instance
     * @memberof ClayActionsDropdown
     * @type {?(string|undefined)}
     */
    caption: _metalState.Config.string(),

    /**
     * Data to add to the element.
     * @default undefined
     * @instance
     * @memberof ClayActionsDropdown
     * @type {?object}
     */
    data: _metalState.Config.object(),

    /**
     * Object that wires events with default listeners
     * @default undefined
     * @instance
     * @memberof ClayActionsDropdown
     * @review
     * @type {?(object|undefined)}
     */
    defaultEventHandler: _metalState.Config.object(),

    /**
     * Flag to indicate if menu is disabled
     * @default false
     * @instance
     * @memberof ClayActionsDropdown
     * @type {?bool}
     */
    disabled: _metalState.Config.bool().value(false),

    /**
     * CSS classes to be applied to the element.
     * @default undefined
     * @instance
     * @memberof ClayActionsDropdown
     * @type {?(string|undefined)}
     */
    elementClasses: _metalState.Config.string(),

    /**
     * Flag to indicate if menu is expanded.
     * @default false
     * @instance
     * @memberof ClayActionsDropdown
     * @type {?bool}
     */
    expanded: _metalState.Config.bool().value(false),

    /**
     * Help text to be shown on top of the open dropdown.
     * @default undefined
     * @instance
     * @memberof ClayActionsDropdown
     * @type {?(string|undefined)}
     */
    helpText: _metalState.Config.string(),

    /**
     * Id to be applied to the element.
     * @default undefined
     * @instance
     * @memberof ClayActionsDropdown
     * @type {?(string|undefined)}
     */
    id: _metalState.Config.string(),

    /**
     * List of menu items.
     * @default undefined
     * @instance
     * @memberof ClayActionsDropdown
     * @type {!Array}
     */
    items: _validators.itemsValidator.required(),

    /**
     * Position in which item icon will be placed. Needed if any item has icons.
     * @default undefined
     * @instance
     * @memberof ClayActionsDropdown
     * @type {?(string|undefined)}
     */
    itemsIconAlignment: _metalState.Config.oneOf(['left', 'right', 'left-right']),

    /**
     * The preferred alignment for the dropdown content.
     * @default BottomLeft
     * @instance
     * @memberof ClayActionsDropdown
     * @type {?(string|undefined)}
     */
    preferredAlign: _validators.preferredAlign.value('BottomLeft'),

    /**
     * The path to the SVG spritemap file containing the icons.
     * @default undefined
     * @instance
     * @memberof ClayActionsDropdown
     * @type {!string}
     */
    spritemap: _metalState.Config.string().required(),

    /**
     * Aria label attribute for the trigger element.
     * @default undefined
     * @instance
     * @memberof ClayActionsDropdown
     * @type {?(string|undefined)}
     */
    triggerAriaLabel: _metalState.Config.string(),

    /**
     * CSS classes to be applied to the trigger element.
     * @default undefined
     * @instance
     * @memberof ClayActionsDropdown
     * @type {?(string|undefined)}
     */
    triggerClasses: _metalState.Config.string(),

    /**
     * String to be used for title attribute of action dropdown
     * @default undefined
     * @instance
     * @memberof ClayActionsDropdown
     * @type {?(string|undefined)}
     */
    triggerTitle: _metalState.Config.string()
  };

  (0, _metalWebComponent2.default)('clay-actions-dropdown', ClayActionsDropdown);

  _metalSoy2.default.register(ClayActionsDropdown, _ClayActionsDropdownSoy2.default);

  exports.ClayActionsDropdown = ClayActionsDropdown;
  exports.default = ClayActionsDropdown;
  //# sourceMappingURL=ClayActionsDropdown.js.map
});
//# sourceMappingURL=ClayActionsDropdown.js.map