'use strict';

Liferay.Loader.define("frontend-taglib-clay$clay-dataset-display@2.15.1/lib/ClayDatasetDisplay", ['module', 'exports', 'require', 'frontend-taglib-clay$clay-card-grid', 'frontend-taglib-clay$clay-list', 'frontend-taglib-clay$clay-table', 'frontend-taglib-clay$clay-management-toolbar', 'frontend-js-metal-web$metal-state', 'frontend-taglib-clay$clay-component', 'frontend-js-metal-web$metal-web-component', 'frontend-js-metal-web$metal-soy', './ClayDatasetDisplay.soy'], function (module, exports, require) {
	var define = undefined;
	Object.defineProperty(exports, "__esModule", {
		value: true
	});
	exports.ClayDatasetDisplay = undefined;

	var _createClass = function () {
		function defineProperties(target, props) {
			for (var i = 0; i < props.length; i++) {
				var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
			}
		}return function (Constructor, protoProps, staticProps) {
			if (protoProps) defineProperties(Constructor.prototype, protoProps);if (staticProps) defineProperties(Constructor, staticProps);return Constructor;
		};
	}();

	require("frontend-taglib-clay$clay-card-grid");

	require("frontend-taglib-clay$clay-list");

	require("frontend-taglib-clay$clay-table");

	var _clayManagementToolbar = require("frontend-taglib-clay$clay-management-toolbar");

	var _metalState = require("frontend-js-metal-web$metal-state");

	var _clayComponent = require("frontend-taglib-clay$clay-component");

	var _clayComponent2 = _interopRequireDefault(_clayComponent);

	var _metalWebComponent = require("frontend-js-metal-web$metal-web-component");

	var _metalWebComponent2 = _interopRequireDefault(_metalWebComponent);

	var _metalSoy = require("frontend-js-metal-web$metal-soy");

	var _metalSoy2 = _interopRequireDefault(_metalSoy);

	var _ClayDatasetDisplaySoy = require("./ClayDatasetDisplay.soy");

	var _ClayDatasetDisplaySoy2 = _interopRequireDefault(_ClayDatasetDisplaySoy);

	function _interopRequireDefault(obj) {
		return obj && obj.__esModule ? obj : { default: obj };
	}

	function _classCallCheck(instance, Constructor) {
		if (!(instance instanceof Constructor)) {
			throw new TypeError("Cannot call a class as a function");
		}
	}

	function _possibleConstructorReturn(self, call) {
		if (!self) {
			throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
		}return call && (typeof call === "object" || typeof call === "function") ? call : self;
	}

	function _inherits(subClass, superClass) {
		if (typeof superClass !== "function" && superClass !== null) {
			throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
		}subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } });if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
	}

	/**
  * Metal ClayDatasetDisplay component.
  * @extends ClayComponent
  */
	var ClayDatasetDisplay = function (_ClayComponent) {
		_inherits(ClayDatasetDisplay, _ClayComponent);

		function ClayDatasetDisplay() {
			_classCallCheck(this, ClayDatasetDisplay);

			return _possibleConstructorReturn(this, (ClayDatasetDisplay.__proto__ || Object.getPrototypeOf(ClayDatasetDisplay)).apply(this, arguments));
		}

		_createClass(ClayDatasetDisplay, [{
			key: 'created',

			/**
    * @inheritDoc
    */
			value: function created() {
				var selectedItems = [];
				var totalItems = 0;

				if (this.items) {
					for (var i = 0, l = this.items.length; i < l; i++) {
						var item = this.items[i];

						if (item.items) {
							totalItems += item.items.length;

							for (var j = 0, k = item.items.length; j < k; j++) {
								var childrenItem = item.items[j];

								if (childrenItem.selected) {
									selectedItems.push(childrenItem);
								}
							}
						} else {
							totalItems++;

							if (item.selected) {
								selectedItems.push(item);
							}
						}
					}
				}

				this._selectedItems = selectedItems;
				this._totalItems = totalItems;
			}

			/**
    * Iterates over the selected items array, mark all as not selected and
    * removes them from the selectedItems array.
    * @private
    */

		}, {
			key: '_deselectAllItems',
			value: function _deselectAllItems() {
				this._selectedItems.map(function (item) {
					return item.selected = false;
				});

				this._selectedItems = [];
			}

			/**
    * Flattens an array of items.
    * @param {Array} items
    * @return {Array}
    */

		}, {
			key: '_flattenItems',
			value: function _flattenItems(items) {
				var _this2 = this;

				return items.reduce(function (list, value) {
					return list.concat(Array.isArray(value) ? _this2._flattenItems(value) : value);
				}, []);
			}

			/**
    * Returns the selected items.
    * @private
    * @return {?array|undefined} the items.
    */

		}, {
			key: 'getSelectedItems',
			value: function getSelectedItems() {
				return this._selectedItems;
			}

			/**
    * Continues the propagation of the action item clicked event
    * @param {!Event} event
    * @private
    * @return {Boolean} If the event has been prevented or not.
    */

		}, {
			key: '_handleActionItemClicked',
			value: function _handleActionItemClicked(event) {
				return !this.emit({
					data: event.data,
					name: 'actionItemClicked',
					originalEvent: event
				});
			}

			/**
    * Continues the propagation of the plus button clicked event
    * @param {!Event} event
    * @private
    * @return {Boolean} If the event has been prevented or not.
    */

		}, {
			key: '_handleCreationButtonClicked',
			value: function _handleCreationButtonClicked(event) {
				return !this.emit({
					name: 'creationButtonClicked',
					originalEvent: event
				});
			}

			/**
    * Continues the propagation of the creation menu item clicked event
    * @param {!Event} event
    * @private
    * @return {Boolean} If the event has been prevented or not.
    */

		}, {
			key: '_handleCreationMenuItemClicked',
			value: function _handleCreationMenuItemClicked(event) {
				return !this.emit({
					data: event.data,
					name: 'creationMenuItemClicked',
					originalEvent: event
				});
			}

			/**
    * Continues the propagation of the creation menu more button clicked event
    * @param {!Event} event
    * @private
    * @return {Boolean} If the event has been prevented or not.
    */

		}, {
			key: '_handleCreationMenuMoreButtonClicked',
			value: function _handleCreationMenuMoreButtonClicked(event) {
				return !this.emit({
					name: 'creationMenuMoreButtonClicked',
					originalEvent: event
				});
			}

			/**
    * Continues the propagation of the filter done clicked event
    * @param {!Event} event
    * @private
    * @return {Boolean} If the event has been prevented or not.
    */

		}, {
			key: '_handleFilterDoneClicked',
			value: function _handleFilterDoneClicked(event) {
				return !this.emit({
					name: 'filterDoneClicked',
					originalEvent: event
				});
			}

			/**
    * Continues the propagation of the filter item click event
    * @param {!Event} event
    * @private
    * @return {Boolean} If the event has been prevented or not.
    */

		}, {
			key: '_handleFilterItemClicked',
			value: function _handleFilterItemClicked(event) {
				return !this.emit({
					data: event.data,
					name: 'filterItemClicked',
					originalEvent: event
				});
			}

			/**
    * Toggles the selection of an item and adds or removes it from selected items
    * list.
    * @param {!Event} event
    * @private
    */

		}, {
			key: '_handleItemToggled',
			value: function _handleItemToggled(event) {
				var checkedStatus = event.target.checked;
				var itemId = event.target.getAttribute('value');

				if (!checkedStatus) {
					var entries = Object.entries(this._selectedItems);

					for (var i = 0, l = entries.length; i < l; i++) {
						var entry = entries[i];
						var index = entry[0];
						var item = entry[1];

						if (item[this.views[this.selectedView].schema.inputValueField] === itemId) {
							item.selected = false;
							this._selectedItems.splice(index, 1);
							break;
						}
					}
				} else {
					var found = false;

					if (this.items) {
						for (var _i = 0, _l = this.items.length; _i < _l; _i++) {
							var _item = this.items[_i];

							if (_item.items) {
								for (var j = 0, k = _item.items.length; j < k; j++) {
									var childrenItem = _item.items[j];

									if (childrenItem[this.views[this.selectedView].schema.inputValueField] === itemId) {
										childrenItem.selected = true;
										this._selectedItems.push(childrenItem);
										found = true;
										break;
									}
								}
							} else {
								if (_item[this.views[this.selectedView].schema.inputValueField] === itemId) {
									_item.selected = true;
									this._selectedItems.push(_item);
									found = true;
								}
							}

							if (found) {
								break;
							}
						}
					}
				}

				this.items = this.items;
				this._selectedItems = this._selectedItems;
			}

			/**
    * Continues the propagation of the search event
    * @param {!Event} event
    * @private
    * @return {Boolean} If the event has been prevented or not.
    */

		}, {
			key: '_handleSearch',
			value: function _handleSearch(event) {
				return !this.emit({
					name: 'search',
					originalEvent: event
				});
			}

			/**
    * Continues the propagation of the sorting button clicked event
    * @param {!Event} event
    * @private
    * @return {Boolean} If the event has been prevented or not.
    */

		}, {
			key: '_handleSortingButtonClicked',
			value: function _handleSortingButtonClicked(event) {
				return !this.emit({
					data: event.data,
					name: 'sortingButtonClicked',
					originalEvent: event
				});
			}

			/**
    * Changes the selection status of the dataset items on management toolbar
    * select page checkbox change.
    * @param {!Event} event
    * @private
    */

		}, {
			key: '_handleSelectPageCheckboxChanged',
			value: function _handleSelectPageCheckboxChanged(event) {
				var checkboxStatus = event.data.checked;

				if (checkboxStatus) {
					this._selectAllItems();
				} else {
					this._deselectAllItems();
				}
			}

			/**
    * Changes the view on management toolbar view type click.
    * @param {!Event} event
    * @private
    */

		}, {
			key: '_handleViewTypeItemClicked',
			value: function _handleViewTypeItemClicked(event) {
				var item = event.data.item;

				this.views[this.selectedView].active = false;

				for (var i = 0, l = this.views.length; i < l; i++) {
					var view = this.views[i];

					if (view === item) {
						this.views[i].active = true;
						this.selectedView = i;
						break;
					}
				}
			}

			/**
    * Iterates over the items array, mark all as selected and adds them to the
    * selectedItems array.
    * @private
    */

		}, {
			key: '_selectAllItems',
			value: function _selectAllItems() {
				var selectedItems = this.items.map(function (item) {
					if (Array.isArray(item.items)) {
						return item.items.map(function (item) {
							item.selected = true;
							return item;
						});
					} else {
						item.selected = true;
						return item;
					}
				});

				this._selectedItems = this._flattenItems(selectedItems);
			}
		}]);

		return ClayDatasetDisplay;
	}(_clayComponent2.default);

	/**
  * State definition.
  * @static
  * @type {!Object}
  */

	ClayDatasetDisplay.STATE = {
		/**
   * The selected items of the item list. For internal purposes.
   * @default undefined
   * @instance
   * @memberof ClayDatasetDisplay
   * @type {?(array|undefined)}
   */
		_selectedItems: _metalState.Config.array().internal(),

		/**
   * The total number of items in the item list. For internal purposes.
   * @default undefined
   * @instance
   * @memberof ClayDatasetDisplay
   * @type {?(number|undefined)}
   */
		_totalItems: _metalState.Config.number().internal(),

		/**
   * List of items to display in the management toolbar actions menu.
   * @default []
   * @instance
   * @memberof ClayDatasetDisplay
   * @type {?(array|undefined)}
   */
		actionItems: _clayManagementToolbar.actionItemsValidator,

		/**
   * Configuration of the management bar plus button.
   * @default undefined
   * @instance
   * @memberof ClayDatasetDisplay
   * @type {?(object|string|bool|undefined)}
   */
		creationMenu: _metalState.Config.shapeOf({
			caption: _metalState.Config.string(),
			helpText: _metalState.Config.string(),
			maxPrimaryItems: _metalState.Config.number(),
			maxSecondaryItems: _metalState.Config.number(),
			maxTotalItems: _metalState.Config.number(),
			primaryItems: _clayManagementToolbar.creationMenuItemsValidator,
			secondaryItems: _clayManagementToolbar.creationMenuItemsValidator,
			viewMoreURL: _metalState.Config.string()
		}),

		/**
   * Data to add to the element.
   * @default undefined
   * @instance
   * @memberof ClayDatasetDisplay
   * @type {?object}
   */
		data: _metalState.Config.object(),

		/**
   * Object that wires events with default listeners
   * @default undefined
   * @instance
   * @memberof ClayDatasetDisplay
   * @review
   * @type {?(object|undefined)}
   */
		defaultEventHandler: _metalState.Config.object(),

		/**
   * CSS classes to be applied to the element.
   * @default undefined
   * @instance
   * @memberof ClayDatasetDisplay
   * @type {?(string|undefined)}
   */
		elementClasses: _metalState.Config.string(),

		/**
   * List of filter menu items.
   * @default undefined
   * @instance
   * @memberof ClayDatasetDisplay
   * @type {?(array|undefined)}
   */
		filterItems: _clayManagementToolbar.filterItemsValidator,

		/**
   * List of filter label items.
   * @default undefined
   * @instance
   * @memberof ClayDatasetDisplay
   * @type {?(array|undefined)}
   */
		filterLabels: _clayManagementToolbar.filterLabelsValidator,

		/**
   * Id to be applied to the element.
   * @default undefined
   * @instance
   * @memberof ClayDatasetDisplay
   * @type {?(string|undefined)}
   */
		id: _metalState.Config.string(),

		/**
   * Items of the dataset.
   * @default undefined
   * @instance
   * @memberof ClayDatasetDisplay
   * @type {?(array|undefined)}
   */
		items: _metalState.Config.array(),

		/**
   * URL of the search form action
   * @default undefined
   * @instance
   * @memberof ClayDatasetDisplay
   * @type {?(string|undefined)}
   */
		searchActionURL: _metalState.Config.string(),

		/**
   * Name of the search form.
   * @default undefined
   * @instance
   * @memberof ClayDatasetDisplay
   * @type {?(string|undefined)}
   */
		searchFormName: _metalState.Config.string(),

		/**
   * Name of the search input.
   * @default undefined
   * @instance
   * @memberof ClayDatasetDisplay
   * @type {?(string|undefined)}
   */
		searchInputName: _metalState.Config.string(),

		/**
   * Flag to indicate if the dataset is selectable.
   * @default false
   * @instance
   * @memberof ClayDatasetDisplay
   * @type {?bool}
   */
		selectable: _metalState.Config.bool().value(false),

		/**
   * Position in the views list of the selected view.
   * @default undefined
   * @instance
   * @memberof ClayDatasetDisplay
   * @type {?(number|undefined)}
   */
		selectedView: _metalState.Config.number(),

		/**
   * Flag to indicate if management toolbar creation menu button should be
   * shown or not.
   * @default true
   * @instance
   * @memberof ClayDatasetDisplay
   * @type {?bool}
   */
		showCreationMenu: _metalState.Config.bool().value(true),

		/**
   * Flag to indicate if the `Done` button in management toolbar filter dropdown
   * should be shown or not.
   * @default true
   * @instance
   * @memberof ClayDatasetDisplay
   * @type {?bool}
   */
		showFiltersDoneButton: _metalState.Config.bool().value(true),

		/**
   * Sorting order.
   * @default asc
   * @instance
   * @memberof ClayDatasetDisplay
   * @type {?(string|undefined)}
   */
		sortingOrder: _metalState.Config.oneOf(['asc', 'desc']).value('asc'),

		/**
   * The path to the SVG spritemap file containing the icons.
   * @default undefined
   * @instance
   * @memberof ClayDatasetDisplay
   * @type {!string}
   */
		spritemap: _metalState.Config.string().required(),

		/**
   * Header of the list.
   * @default undefined
   * @instance
   * @memberof ClayDatasetDisplay
   * @type {?(string|undefined)}
   */
		title: _metalState.Config.string(),

		/**
   * List of view items.
   * @default undefined
   * @instance
   * @memberof ClayDatasetDisplay
   * @type {?(array|undefined)}
   */
		views: _metalState.Config.arrayOf(_metalState.Config.shapeOf({
			active: _metalState.Config.bool().value(false),
			disabled: _metalState.Config.bool().value(false),
			href: _metalState.Config.string(),
			icon: _metalState.Config.string().required(),
			id: _metalState.Config.string().required(),
			label: _metalState.Config.string().required()
		}))
	};

	(0, _metalWebComponent2.default)('clay-dataset-display', ClayDatasetDisplay);

	_metalSoy2.default.register(ClayDatasetDisplay, _ClayDatasetDisplaySoy2.default);

	exports.ClayDatasetDisplay = ClayDatasetDisplay;
	exports.default = ClayDatasetDisplay;
	//# sourceMappingURL=ClayDatasetDisplay.js.map
});
//# sourceMappingURL=ClayDatasetDisplay.js.map