'use strict';

Liferay.Loader.define('frontend-taglib-clay$clay-data-provider@2.15.1/lib/utils', ['module', 'exports', 'require'], function (module, exports, require) {
	var define = undefined;
	Object.defineProperty(exports, "__esModule", {
		value: true
	});
	/**
  * If `query` matches to `string`, returns an object with the
  * corresponding characters. If there is no match, return null.
  * @param {!String} query
  * @param {!String} string
  * @return {null|Object}
  */
	var match = exports.match = function match(query, string) {
		var currentScore = 0;
		var totalScore = 0;
		var queryIndex = 0;
		var result = [];

		var queryToLowerCase = query.toLowerCase();
		var stringToLowerCase = string.toLowerCase();

		for (var index = 0; index < string.length; index++) {
			var element = string[index];

			if (stringToLowerCase[index] === queryToLowerCase[queryIndex]) {
				element = { value: element, match: true };

				queryIndex += 1;
				currentScore += 1 + currentScore;
			} else {
				element = { value: element };
				currentScore = 0;
			}

			totalScore += currentScore;
			result[result.length] = element;
		}

		if (queryIndex === query.length) {
			totalScore = string === query ? Infinity : totalScore;
			return { values: result, score: totalScore };
		}

		return null;
	};

	/**
  * Implementation of the timeout.
  * Based on: https://github.com/github/fetch/issues/175#issuecomment-125779262
  * @param {!number} ms
  * @param {!Promise} promise
  * @return {Promise}
  */
	var timeout = exports.timeout = function timeout(ms, promise) {
		return new Promise(function (resolve, reject) {
			var timeoutId = setTimeout(function () {
				reject(new Error('timeout'));
			}, ms);
			promise.then(function (res) {
				clearTimeout(timeoutId);
				resolve(res);
			}).catch(function (err) {
				clearTimeout(timeoutId);
				reject(err);
			});
		});
	};
	//# sourceMappingURL=utils.js.map
});
//# sourceMappingURL=utils.js.map