'use strict';

Liferay.Loader.define("frontend-taglib-clay$clay-data-provider@2.15.1/lib/ClayDataProvider", ['module', 'exports', 'require', 'frontend-js-metal-web$metal-debounce', 'frontend-js-metal-web$metal-state', 'frontend-js-metal-web$metal', './utils', 'frontend-taglib-clay$clay-component', 'frontend-js-metal-web$metal-web-component', 'frontend-js-metal-web$metal-soy', './ClayDataProvider.soy'], function (module, exports, require) {
	var define = undefined;
	Object.defineProperty(exports, "__esModule", {
		value: true
	});
	exports.ClayDataProvider = undefined;

	var _createClass = function () {
		function defineProperties(target, props) {
			for (var i = 0; i < props.length; i++) {
				var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
			}
		}return function (Constructor, protoProps, staticProps) {
			if (protoProps) defineProperties(Constructor.prototype, protoProps);if (staticProps) defineProperties(Constructor, staticProps);return Constructor;
		};
	}();

	var _metalDebounce = require("frontend-js-metal-web$metal-debounce");

	var _metalState = require("frontend-js-metal-web$metal-state");

	var _metal = require("frontend-js-metal-web$metal");

	var _utils = require('./utils');

	var _clayComponent = require("frontend-taglib-clay$clay-component");

	var _clayComponent2 = _interopRequireDefault(_clayComponent);

	var _metalWebComponent = require("frontend-js-metal-web$metal-web-component");

	var _metalWebComponent2 = _interopRequireDefault(_metalWebComponent);

	var _metalSoy = require("frontend-js-metal-web$metal-soy");

	var _metalSoy2 = _interopRequireDefault(_metalSoy);

	var _ClayDataProviderSoy = require("./ClayDataProvider.soy");

	var _ClayDataProviderSoy2 = _interopRequireDefault(_ClayDataProviderSoy);

	function _interopRequireDefault(obj) {
		return obj && obj.__esModule ? obj : { default: obj };
	}

	function _classCallCheck(instance, Constructor) {
		if (!(instance instanceof Constructor)) {
			throw new TypeError("Cannot call a class as a function");
		}
	}

	function _possibleConstructorReturn(self, call) {
		if (!self) {
			throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
		}return call && (typeof call === "object" || typeof call === "function") ? call : self;
	}

	function _inherits(subClass, superClass) {
		if (typeof superClass !== "function" && superClass !== null) {
			throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
		}subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } });if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
	}

	/**
  * Metal ClayDataProvider component.
  * @extends ClayComponent
  */
	var ClayDataProvider = function (_ClayComponent) {
		_inherits(ClayDataProvider, _ClayComponent);

		function ClayDataProvider() {
			_classCallCheck(this, ClayDataProvider);

			return _possibleConstructorReturn(this, (ClayDataProvider.__proto__ || Object.getPrototypeOf(ClayDataProvider)).apply(this, arguments));
		}

		_createClass(ClayDataProvider, [{
			key: 'created',

			/**
    * @inheritDoc
    */
			value: function created() {
				this._isResolvedData = false;
				this._loadingTimeout = null;
				this._pollingInterval = 0;
				this._requestsCount = 0;
				if (this._hasData(this.dataSource)) {
					this._dataSource = this.dataSource;
					this._isResolvedData = true;
				} else {
					this.updateData();
				}

				if (this.inputMode === 'userInput') {
					this.updateData = (0, _metalDebounce.debounce)(this.updateData.bind(this), this.debounceTime);
				}

				this.addListener('dataChange', this._defaultDataChange, true);
				this.addListener('dataError', this._defaultDataError, true);
				this.addListener('dataLoading', this._defaultDataLoading, true);
			}

			/**
    * @inheritDoc
    */

		}, {
			key: 'disposed',
			value: function disposed() {
				if (this._pollingInterval) {
					clearInterval(this._pollingInterval);
					this._pollingInterval = null;
				}

				(0, _metalDebounce.cancelDebounce)(this.updateData);
			}

			/**
    * Makes the request and defines initial data while it is requesting.
    * @param {!string} query
    * @param {!number} requestRetries
    * @protected
    */

		}, {
			key: 'updateData',
			value: function updateData(query) {
				var _this2 = this;

				var requestRetries = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;

				this._isResolvedData = false;

				if (this.initialData && !this._pollingInterval && requestRetries === 0) {
					this._dataSource = this.initialData;
					this._handleDataChange();
				} else {
					this._handleDataLoading();
				}

				var promise = void 0;

				if ((0, _metal.isFunction)(this.dataSource)) {
					promise = this.dataSource(query);
				} else {
					promise = fetch(this.dataSource, this.requestOptions).then(function (res) {
						return res.json();
					});
				}

				(0, _utils.timeout)(this.requestTimeout, promise).then(function (res) {
					_this2._dataSource = res;
					_this2._requestsCount += 1;
					_this2._isResolvedData = true;
					_this2._handleDataChange();

					if (_this2.inputMode === 'polling') {
						_this2._setPolling();
					}
				}).catch(function (err) {
					return _this2._setRequestRetries(query, err, requestRetries);
				});
			}

			/**
    * @protected
    */

		}, {
			key: '_defaultDataChange',
			value: function _defaultDataChange() {
				this.isLoading = false;
				this.isError = false;

				if (this._requestsCount > 0) {
					clearTimeout(this._loadingTimeout);
				}
			}

			/**
    * @protected
    */

		}, {
			key: '_defaultDataError',
			value: function _defaultDataError() {
				this.isError = true;
				this.isLoading = false;
			}

			/**
    * @param {!Event} event
    * @protected
    */

		}, {
			key: '_defaultDataLoading',
			value: function _defaultDataLoading(event) {
				var _this3 = this;

				var requestsCount = event.data.requestsCount;

				this.isError = false;

				if (requestsCount > 0 && this.delayLoading) {
					this._loadingTimeout = setTimeout(function () {
						if (!_this3._isResolvedData) {
							_this3.isLoading = true;
						}
					}, this.delayLoadingTimer);
				} else {
					this.isLoading = true;
				}
			}

			/**
    * Handles the event when data changed.
    * @protected
    * @return {Boolean} If the event has been prevented or not.
    */

		}, {
			key: '_handleDataChange',
			value: function _handleDataChange() {
				return !this.emit({
					data: this._dataSource,
					name: 'dataChange'
				});
			}

			/**
    * Handles the event when request error
    * @param {!Error} err
    * @protected
    * @return {Boolean} If the event has been prevented or not.
    */

		}, {
			key: '_handleDataError',
			value: function _handleDataError(err) {
				return !this.emit({
					data: err,
					name: 'dataError'
				});
			}

			/**
    * Handle triggering the event of loading data
    * @protected
    * @return {Boolean} If the event has been prevented or not.
    */

		}, {
			key: '_handleDataLoading',
			value: function _handleDataLoading() {
				return !this.emit({
					data: {
						requestsCount: this._requestsCount
					},
					name: 'dataLoading'
				});
			}

			/**
    * Checks whether the data is locally.
    * @param {!(string|object|array)} data
    * @return {Boolean}
    */

		}, {
			key: '_hasData',
			value: function _hasData(data) {
				if (Array.isArray(data) || (0, _metal.isObject)(data)) {
					return true;
				}

				return false;
			}

			/**
    * Sets up the polling interval.
    * @protected
    */

		}, {
			key: '_setPolling',
			value: function _setPolling() {
				var _this4 = this;

				if (this.pollingInterval > 0) {
					if (this._pollingInterval) {
						clearInterval(this._pollingInterval);
					}

					this._pollingInterval = setInterval(function () {
						_this4._isResolvedData = false;
						_this4._fetchData();
					}, this.pollingInterval);
				}
			}

			/**
    * Sets up the request retries.
    * @param {!string} query
    * @param {!string} err
    * @param {!number} requestRetries
    * @protected
    */

		}, {
			key: '_setRequestRetries',
			value: function _setRequestRetries(query, err, requestRetries) {
				if (this.isDisposed()) {
					return;
				}

				if (this.requestRetries > 0 && requestRetries < this.requestRetries) {
					console.error('DataProvider: (' + (requestRetries + 1) + '/' + this.requestRetries + ') Request attempt failed', err);

					this.updateData(query, requestRetries + 1);
				} else {
					console.error('DataProvider: Error making the requisition', err);
					this._handleDataError(err);
				}
			}

			/**
    * Handles data mapping.
    * @param {!(function|string)} param
    * @param {!Array} data
    * @protected
    * @return {!(string|number)}
    */

		}, {
			key: '_performCall',
			value: function _performCall(param, data) {
				if (typeof param === 'function') {
					return param(data);
				}

				if (typeof data === 'string') {
					return data;
				}

				return data[param];
			}

			/**
    * Helper method to filter a list based on a string.
    * @param {!string} query
    * @param {?(function|string)} extract
    * @public
    * @return {Array} A list of items containing the corresponding characters
    */

		}, {
			key: 'filter',
			value: function filter(query) {
				var _this5 = this;

				var extract = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : function (elem) {
					return elem;
				};

				if (!this._isResolvedData) {
					return [];
				}

				return this._dataSource.reduce(function (prev, element, index) {
					var string = _this5._performCall(extract, element);
					var result = (0, _utils.match)(query, string);

					if (result != null) {
						prev[prev.length] = {
							data: element,
							index: index,
							matches: result.values,
							score: result.score,
							value: string
						};
					}

					return prev;
				}, []).sort(function (a, b) {
					if (a > b) return 1;
					if (a < b) return -1;
				});
			}
		}]);

		return ClayDataProvider;
	}(_clayComponent2.default);

	/**
  * State definition.
  * @static
  * @type {!Object}
  */

	ClayDataProvider.STATE = {
		/**
   * The array or object of items for internal manipulation
   * @instance
   * @default undefined
   * @memberof ClayDataProvider
   * @type {?(object|array)}
   */
		_dataSource: _metalState.Config.oneOfType([_metalState.Config.array(), _metalState.Config.func(), _metalState.Config.object()]).internal(),

		/**
   * The content renderer.
   * @default undefined
   * @instance
   * @memberof ClayDataProvider
   * @type {!html}
   */
		content: _metalState.Config.required(),

		/**
   * Data to add to the element.
   * @default undefined
   * @instance
   * @memberof ClayDataProvider
   * @type {?object}
   */
		data: _metalState.Config.object(),

		/**
   * The array of data items that the data source contains,
   * the URL for the data provider to request, or a function
   * that receives the query and returns a promise with the
   * elements.
   *
   * @instance
   * @default undefined
   * @memberof ClayDataProvider
   * @type {!(string|object|array|function)}
   */
		dataSource: _metalState.Config.oneOfType([_metalState.Config.array(), _metalState.Config.func(), _metalState.Config.object(), _metalState.Config.string()]).required(),

		/**
   * Set the request debounce time
   * @instance
   * @default 200
   * @memberof ClayDataProvider
   * @type {?number}
   */
		debounceTime: _metalState.Config.number().value(200),

		/**
   * @default false
   * @instance
   * @memberof ClayDataProvider
   * @type {?number}
   */
		delayLoading: _metalState.Config.bool().value(false),

		/**
   * @default 500
   * @instance
   * @memberof ClayDataProvider
   * @type {?number}
   */
		delayLoadingTimer: _metalState.Config.number().value(500),

		/**
   * The error content renderer.
   * @default undefined
   * @instance
   * @memberof ClayDataProvider
   * @type {!html}
   */
		errorContent: _metalState.Config.any(),

		/**
   * Set some initial data while the first request is being made
   * @instance
   * @default undefined
   * @memberof ClayDataProvider
   * @type {?(object|array)}
   */
		initialData: _metalState.Config.oneOfType([_metalState.Config.array(), _metalState.Config.object()]),

		/**
   * Specifies explicitly if request needs to be made with debounce
   * (userInput) or with polling (polling)
   * @instance
   * @default undefined
   * @memberof ClayDataProvider
   * @type {?(object|array)}
   */
		inputMode: _metalState.Config.oneOf(['polling', 'userInput']).value('userInput'),

		/**
   * @default false
   * @instance
   * @memberof ClayDataProvider
   * @type {?bool}
   */
		isError: _metalState.Config.bool().value(false).internal(),

		/**
   * Flag to indicate the render state. true will
   * render the contents of loadingContent.
   * @default false
   * @instance
   * @memberof ClayDataProvider
   * @type {?bool}
   */
		isLoading: _metalState.Config.bool().value(false).internal(),

		/**
   * The loading content renderer.
   * @default undefined
   * @instance
   * @memberof ClayDataProvider
   * @type {!html}
   */
		loadingContent: _metalState.Config.any(),

		/**
   * Flag to define how often to refetch data (ms)
   * @instance
   * @default 0
   * @memberof ClayDataProvider
   * @type {?(number|undefined)}
   */
		pollingInterval: _metalState.Config.number().value(0),

		/**
   * Set ups the request options
   * @instance
   * @default undefined
   * @memberof ClayDataProvider
   * @type {?(object|undefined)}
   */
		requestOptions: _metalState.Config.shapeOf({
			body: _metalState.Config.object(),
			cache: _metalState.Config.string(),
			credentials: _metalState.Config.string(),
			headers: _metalState.Config.object(),
			method: _metalState.Config.string(),
			mode: _metalState.Config.string(),
			redirect: _metalState.Config.string(),
			referrer: _metalState.Config.string()
		}),

		/**
   * Flag to define how often to refetch data (ms)
   * @instance
   * @default 0
   * @memberof ClayDataProvider
   * @type {?(number|undefined)}
   */
		requestPolling: _metalState.Config.validator(function (value) {
			if (value) {
				console.warn('🚨 `requestPolling` has been renamed to `pollingInterval` and will be deprecated and removed in the next release.');
			}
		}),

		/**
   * Define how many attempts will be made when the request fails
   * @instance
   * @default 5
   * @memberof ClayDataProvider
   * @type {?(number|undefined)}
   */
		requestRetries: _metalState.Config.number().value(5),

		/**
   * Set timeout of the request
   * @instance
   * @default 30000
   * @memberof ClayDataProvider
   * @type {?(number|undefined)}
   */
		requestTimeout: _metalState.Config.number().value(30000)
	};

	(0, _metalWebComponent2.default)('clay-data-provider', ClayDataProvider);

	_metalSoy2.default.register(ClayDataProvider, _ClayDataProviderSoy2.default);

	exports.ClayDataProvider = ClayDataProvider;
	exports.default = ClayDataProvider;
	//# sourceMappingURL=ClayDataProvider.js.map
});
//# sourceMappingURL=ClayDataProvider.js.map