'use strict';

Liferay.Loader.define("frontend-taglib-clay$clay-card@2.15.1/lib/ClayUserCard", ['module', 'exports', 'require', './ClayCardBase', 'frontend-taglib-clay$clay-link', 'frontend-taglib-clay$clay-sticker', 'frontend-taglib-clay$clay-dropdown', 'frontend-js-metal-web$metal-state', 'frontend-taglib-clay$clay-component', 'frontend-js-metal-web$metal-web-component', 'frontend-js-metal-web$metal-soy', './action_items_validator', './ClayUserCard.soy'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.ClayUserCard = undefined;

  var _createClass = function () {
    function defineProperties(target, props) {
      for (var i = 0; i < props.length; i++) {
        var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
      }
    }return function (Constructor, protoProps, staticProps) {
      if (protoProps) defineProperties(Constructor.prototype, protoProps);if (staticProps) defineProperties(Constructor, staticProps);return Constructor;
    };
  }();

  require('./ClayCardBase');

  require("frontend-taglib-clay$clay-link");

  require("frontend-taglib-clay$clay-sticker");

  var _clayDropdown = require("frontend-taglib-clay$clay-dropdown");

  var _metalState = require("frontend-js-metal-web$metal-state");

  var _clayComponent = require("frontend-taglib-clay$clay-component");

  var _clayComponent2 = _interopRequireDefault(_clayComponent);

  var _metalWebComponent = require("frontend-js-metal-web$metal-web-component");

  var _metalWebComponent2 = _interopRequireDefault(_metalWebComponent);

  var _metalSoy = require("frontend-js-metal-web$metal-soy");

  var _metalSoy2 = _interopRequireDefault(_metalSoy);

  var _action_items_validator = require('./action_items_validator');

  var _action_items_validator2 = _interopRequireDefault(_action_items_validator);

  var _ClayUserCardSoy = require("./ClayUserCard.soy");

  var _ClayUserCardSoy2 = _interopRequireDefault(_ClayUserCardSoy);

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { default: obj };
  }

  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _possibleConstructorReturn(self, call) {
    if (!self) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }return call && (typeof call === "object" || typeof call === "function") ? call : self;
  }

  function _inherits(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
    }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } });if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
  }
  // eslint-disable-next-line


  /**
   * Metal ClayUserCard component.
   * @extends ClayComponent
   */
  var ClayUserCard = function (_ClayComponent) {
    _inherits(ClayUserCard, _ClayComponent);

    function ClayUserCard() {
      _classCallCheck(this, ClayUserCard);

      return _possibleConstructorReturn(this, (ClayUserCard.__proto__ || Object.getPrototypeOf(ClayUserCard)).apply(this, arguments));
    }

    _createClass(ClayUserCard, [{
      key: '_handleActionItemClicked',

      /**
       * Continues the propagation of the dropdown action item click event
       * @param {!Event} event
       * @private
       * @return {Boolean} If the event has been prevented or not.
       */
      value: function _handleActionItemClicked(event) {
        return !this.emit('itemClicked', event);
      }

      /**
       * Continues the propagation of the checkbox changed event
       * @param {!Event} event
       * @private
       */

    }, {
      key: '_handleItemToggled',
      value: function _handleItemToggled(event) {
        this.emit('itemToggled', event);
      }
    }]);

    return ClayUserCard;
  }(_clayComponent2.default);

  /**
   * State definition.
   * @static
   * @type {!Object}
   */

  ClayUserCard.STATE = {
    /**
     * Aria label attribute for the action element.
     * @default undefined
     * @instance
     * @memberof ClayUserCard
     * @type {?(string|undefined)}
     */
    actionAriaLabel: _metalState.Config.string(),

    /**
     * List of items to display in the actions menu.
     * @default undefined
     * @instance
     * @memberof ClayUserCard
     * @type {?(array|undefined)}
     */
    actionItems: _action_items_validator2.default,

    /**
     * Data to add to the element.
     * @default undefined
     * @instance
     * @memberof ClayUserCard
     * @type {?object}
     */
    data: _metalState.Config.object(),

    /**
     * Object that wires events with default listeners
     * @default undefined
     * @instance
     * @memberof ClayUserCard
     * @review
     * @type {?(object|undefined)}
     */
    defaultEventHandler: _metalState.Config.object(),

    /**
     * Flag to indicate if the card is disabled or not.
     * @default false
     * @instance
     * @memberof ClayUserCard
     * @type {?bool}
     */
    disabled: _metalState.Config.bool().value(false),

    /**
     * CSS classes to be applied to the element.
     * @default undefined
     * @instance
     * @memberof ClayUserCard
     * @type {?(string|undefined)}
     */
    elementClasses: _metalState.Config.string(),

    /**
     * Url to be applied to the title of the card.
     * @default undefined
     * @instance
     * @memberof ClayUserCard
     * @type {?(string|undefined)}
     */
    href: _metalState.Config.string(),

    /**
     * Icon to be renderer in the visual area of the card.
     * @default undefined
     * @instance
     * @memberof ClayFileCard
     * @type {?(string|undefined)}
     */
    icon: _metalState.Config.string(),

    /**
     * Id to be applied to the element.
     * @default undefined
     * @instance
     * @memberof ClayUserCard
     * @type {?(string|undefined)}
     */
    id: _metalState.Config.string(),

    /**
     * Alternate text of the image.
     * @default undefined
     * @instance
     * @memberof ClayUserCard
     * @type {?(string|undefined)}
     */
    imageAlt: _metalState.Config.string(),

    /**
     * Source of the image to be rendered in the visual area of the card.
     * @default undefined
     * @instance
     * @memberof ClayUserCard
     * @type {?(string|undefined)}
     */
    imageSrc: _metalState.Config.string(),

    /**
     * Initials of the user.
     * @default undefined
     * @deprecated
     * @instance
     * @memberof ClayUserCard
     * @type {?(string|undefined)}
     */
    initials: _metalState.Config.validator(function (value) {
      if (value) {
        console.warn('🚨 `initials` has been deprecated and will be removed in the next major version.');
      }
    }),

    /**
     * Name to be applied to the input element.
     * @default undefined
     * @instance
     * @memberof ClayUserCard
     * @type {?(string|undefined)}
     */
    inputName: _metalState.Config.string(),

    /**
     * Value to be applied to the input element.
     * @default undefined
     * @instance
     * @memberof ClayUserCard
     * @type {?(string|undefined)}
     */
    inputValue: _metalState.Config.string(),

    /**
     * Name of the user.
     * @default undefined
     * @instance
     * @memberof ClayUserCard
     * @type {!string}
     */
    name: _metalState.Config.string().required(),

    /**
     * Flag to indicate if the card is selectable or not.
     * @default false
     * @instance
     * @memberof ClayUserCard
     * @type {?bool}
     */
    selectable: _metalState.Config.bool().value(false),

    /**
     * Flag to indicate if the card is selected or not.
     * @default false
     * @instance
     * @memberof ClayUserCard
     * @type {?bool}
     */
    selected: _metalState.Config.bool().value(false),

    /**
     * The path to the SVG spritemap file containing the icons.
     * @default undefined
     * @instance
     * @memberof ClayUserCard
     * @type {?(string|undefined)}
     */
    spritemap: _metalState.Config.string(),

    /**
     * Subtitle of the card.
     * @default undefined
     * @instance
     * @memberof ClayUserCard
     * @type {?(string|undefined)}
     */
    subtitle: _metalState.Config.string(),

    /**
     * Color of the user sticker.
     * @default primary
     * @instance
     * @memberof ClayUserCard
     * @type {?string}
     */
    userColorClass: _metalState.Config.string()
  };

  (0, _metalWebComponent2.default)('clay-user-card', ClayUserCard);

  _metalSoy2.default.register(ClayUserCard, _ClayUserCardSoy2.default);

  exports.ClayUserCard = ClayUserCard;
  exports.default = ClayUserCard;
  //# sourceMappingURL=ClayUserCard.js.map
});
//# sourceMappingURL=ClayUserCard.js.map