'use strict';

Liferay.Loader.define("frontend-taglib-clay$clay-card@2.15.1/lib/ClayImageCard", ['module', 'exports', 'require', 'frontend-taglib-clay$clay-icon', 'frontend-taglib-clay$clay-sticker', './ClayCardBase', 'frontend-taglib-clay$clay-component', 'frontend-js-metal-web$metal-web-component', 'frontend-js-metal-web$metal-soy', 'frontend-js-metal-web$metal-state', './action_items_validator', './ClayImageCard.soy'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.ClayImageCard = undefined;

  var _createClass = function () {
    function defineProperties(target, props) {
      for (var i = 0; i < props.length; i++) {
        var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
      }
    }return function (Constructor, protoProps, staticProps) {
      if (protoProps) defineProperties(Constructor.prototype, protoProps);if (staticProps) defineProperties(Constructor, staticProps);return Constructor;
    };
  }();

  require("frontend-taglib-clay$clay-icon");

  require("frontend-taglib-clay$clay-sticker");

  require('./ClayCardBase');

  var _clayComponent = require("frontend-taglib-clay$clay-component");

  var _clayComponent2 = _interopRequireDefault(_clayComponent);

  var _metalWebComponent = require("frontend-js-metal-web$metal-web-component");

  var _metalWebComponent2 = _interopRequireDefault(_metalWebComponent);

  var _metalSoy = require("frontend-js-metal-web$metal-soy");

  var _metalSoy2 = _interopRequireDefault(_metalSoy);

  var _metalState = require("frontend-js-metal-web$metal-state");

  var _action_items_validator = require('./action_items_validator');

  var _action_items_validator2 = _interopRequireDefault(_action_items_validator);

  var _ClayImageCardSoy = require("./ClayImageCard.soy");

  var _ClayImageCardSoy2 = _interopRequireDefault(_ClayImageCardSoy);

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { default: obj };
  }

  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _possibleConstructorReturn(self, call) {
    if (!self) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }return call && (typeof call === "object" || typeof call === "function") ? call : self;
  }

  function _inherits(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
    }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } });if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
  }

  /**
   * Metal ClayImageCard component.
   * @extends ClayComponent
   */
  var ClayImageCard = function (_ClayComponent) {
    _inherits(ClayImageCard, _ClayComponent);

    function ClayImageCard() {
      _classCallCheck(this, ClayImageCard);

      return _possibleConstructorReturn(this, (ClayImageCard.__proto__ || Object.getPrototypeOf(ClayImageCard)).apply(this, arguments));
    }

    _createClass(ClayImageCard, [{
      key: '_handleActionItemClicked',

      /**
       * Continues the propagation of the dropdown action item click event
       * @param {!Event} event
       * @private
       * @return {Boolean} If the event has been prevented or not.
       */
      value: function _handleActionItemClicked(event) {
        return !this.emit('itemClicked', event);
      }

      /**
       * Continues the propagation of the checkbox changed event
       * @param {!Event} event
       * @private
       * @return {Boolean} If the event has been prevented or not.
       */

    }, {
      key: '_handleItemToggled',
      value: function _handleItemToggled(event) {
        return !this.emit('itemToggled', event);
      }
    }]);

    return ClayImageCard;
  }(_clayComponent2.default);

  /**
   * State definition.
   * @static
   * @type {!Object}
   */

  ClayImageCard.STATE = {
    /**
     * Aria label attribute for the action element.
     * @default undefined
     * @instance
     * @memberof ClayImageCard
     * @type {?(string|undefined)}
     */
    actionAriaLabel: _metalState.Config.string(),

    /**
     * List of items to display in the actions menu.
     * @default undefined
     * @instance
     * @memberof ClayImageCard
     * @type {?(array|object|undefined)}
     */
    actionItems: _action_items_validator2.default,

    /**
     * Data to add to the element.
     * @default undefined
     * @instance
     * @memberof ClayImageCard
     * @type {?object}
     */
    data: _metalState.Config.object(),

    /**
     * Object that wires events with default listeners
     * @default undefined
     * @instance
     * @memberof ClayImageCard
     * @review
     * @type {?(object|undefined)}
     */
    defaultEventHandler: _metalState.Config.object(),

    /**
     * Flag to indicate if the card is disabled or not.
     * @default false
     * @instance
     * @memberof ClayImageCard
     * @type {?bool}
     */
    disabled: _metalState.Config.bool().value(false),

    /**
     * CSS classes to be applied to the element.
     * @default undefined
     * @instance
     * @memberof ClayImageCard
     * @type {?(string|undefined)}
     */
    elementClasses: _metalState.Config.string(),

    /**
     * Url to be applied to the title of the card.
     * @default undefined
     * @instance
     * @memberof ClayImageCard
     * @type {?(string|undefined)}
     */
    href: _metalState.Config.string(),

    /**
     * Icon to be rendered in the visual area of the card.
     * @default undefined
     * @instance
     * @memberof ClayImageCard
     * @type {?(string|undefined)}
     */
    icon: _metalState.Config.string(),

    /**
     * Id to be applied to the element.
     * @default undefined
     * @instance
     * @memberof ClayImageCard
     * @type {?(string|undefined)}
     */
    id: _metalState.Config.string(),

    /**
     * Alternate text of the image.
     * @default undefined
     * @instance
     * @memberof ClayImageCard
     * @type {?(string|undefined)}
     */
    imageAlt: _metalState.Config.string(),

    /**
     * Source of the image to be rendered in the visual area of the card.
     * @default undefined
     * @instance
     * @memberof ClayImageCard
     * @type {?(string|undefined)}
     */
    imageSrc: _metalState.Config.string(),

    /**
     * Name to be applied to the input element.
     * @default undefined
     * @instance
     * @memberof ClayImageCard
     * @type {?(string|undefined)}
     */
    inputName: _metalState.Config.string(),

    /**
     * Value to be applied to the input element.
     * @default undefined
     * @instance
     * @memberof ClayImageCard
     * @type {?(string|undefined)}
     */
    inputValue: _metalState.Config.string(),

    /**
     * Labels of the card.
     * @default undefined
     * @instance
     * @memberof ClayImageCard
     * @type {?(array|undefined)}
     */
    labels: _metalState.Config.arrayOf(_metalState.Config.oneOfType([_metalState.Config.string(), _metalState.Config.shapeOf({
      label: _metalState.Config.string(),
      style: _metalState.Config.oneOf(['danger', 'info', 'secondary', 'success', 'warning']).value('secondary')
    })])),

    /**
     * Object that maps specific label values with desired styles.
     * @default undefined
     * @instance
     * @memberof ClayImageCard
     * @type {?(object|undefined)}
     */
    labelStylesMap: _metalState.Config.object(),

    /**
     * Flag to indicate if the card is selectable or not.
     * @default false
     * @instance
     * @memberof ClayImageCard
     * @type {?bool}
     */
    selectable: _metalState.Config.bool().value(false),

    /**
     * Flag to indicate if the card is selected or not.
     * @default false
     * @instance
     * @memberof ClayImageCard
     * @type {?bool}
     */
    selected: _metalState.Config.bool().value(false),

    /**
     * The path to the SVG spritemap file containing the icons.
     * @default undefined
     * @instance
     * @memberof ClayImageCard
     * @type {?(string|undefined)}
     */
    spritemap: _metalState.Config.string(),

    /**
     * CSS classes for the inside the sticker.
     * @default undefined
     * @instance
     * @memberof ClayImageCard
     * @type {?(string|undefined)}
     */
    stickerClasses: _metalState.Config.string(),

    /**
     * Icon to be renderer inside the sticker.
     * @default undefined
     * @instance
     * @memberof ClayImageCard
     * @type {?(string|undefined)}
     */
    stickerIcon: _metalState.Config.string(),

    /**
     * Alternate text of the image to be renderer inside the sticker.
     * @default undefined
     * @instance
     * @memberof ClayImageCard
     * @type {?(string|undefined)}
     */
    stickerImageAlt: _metalState.Config.string(),

    /**
     * Source of the image to be rendered inside the sticker.
     * @default undefined
     * @instance
     * @memberof ClayImageCard
     * @type {?(string|undefined)}
     */
    stickerImageSrc: _metalState.Config.string(),

    /**
     * Label for the sticker represented in the card.
     * @default undefined
     * @instance
     * @memberof ClayImageCard
     * @type {?(string|undefined)}
     */
    stickerLabel: _metalState.Config.string(),

    /**
     * Style of sticker represented in the card.
     * @default primary
     * @instance
     * @memberof ClayImageCard
     * @type {?string}
     */
    stickerStyle: _metalState.Config.oneOf(['danger', 'dark', 'info', 'light', 'primary', 'secondary', 'success', 'warning']).value('primary'),

    /**
     * Shape for the sticker represented in the card.
     * @default rounded
     * @instance
     * @memberof ClayImageCard
     * @type {?string}
     */
    stickerShape: _metalState.Config.oneOf(['circle', 'rounded']).value('rounded'),

    /**
     * Subtitle of the card.
     * @default undefined
     * @instance
     * @memberof ClayImageCard
     * @type {?(string|undefined)}
     */
    subtitle: _metalState.Config.string(),

    /**
     * Title of the card.
     * @default undefined
     * @instance
     * @memberof ClayImageCard
     * @type {!string}
     */
    title: _metalState.Config.string().required()
  };

  (0, _metalWebComponent2.default)('clay-image-card', ClayImageCard);

  _metalSoy2.default.register(ClayImageCard, _ClayImageCardSoy2.default);

  exports.ClayImageCard = ClayImageCard;
  exports.default = ClayImageCard;
  //# sourceMappingURL=ClayImageCard.js.map
});
//# sourceMappingURL=ClayImageCard.js.map