'use strict';

Liferay.Loader.define("frontend-taglib-clay$clay-card@2.15.1/lib/ClayHorizontalCard", ['module', 'exports', 'require', 'frontend-taglib-clay$clay-checkbox', 'frontend-taglib-clay$clay-link', 'frontend-taglib-clay$clay-sticker', 'frontend-taglib-clay$clay-dropdown', 'frontend-js-metal-web$metal-state', 'frontend-taglib-clay$clay-component', 'frontend-js-metal-web$metal-web-component', 'frontend-js-metal-web$metal-soy', './action_items_validator', './ClayHorizontalCard.soy'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.ClayHorizontalCard = undefined;

  var _createClass = function () {
    function defineProperties(target, props) {
      for (var i = 0; i < props.length; i++) {
        var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
      }
    }return function (Constructor, protoProps, staticProps) {
      if (protoProps) defineProperties(Constructor.prototype, protoProps);if (staticProps) defineProperties(Constructor, staticProps);return Constructor;
    };
  }();

  require("frontend-taglib-clay$clay-checkbox");

  require("frontend-taglib-clay$clay-link");

  require("frontend-taglib-clay$clay-sticker");

  var _clayDropdown = require("frontend-taglib-clay$clay-dropdown");

  var _metalState = require("frontend-js-metal-web$metal-state");

  var _clayComponent = require("frontend-taglib-clay$clay-component");

  var _clayComponent2 = _interopRequireDefault(_clayComponent);

  var _metalWebComponent = require("frontend-js-metal-web$metal-web-component");

  var _metalWebComponent2 = _interopRequireDefault(_metalWebComponent);

  var _metalSoy = require("frontend-js-metal-web$metal-soy");

  var _metalSoy2 = _interopRequireDefault(_metalSoy);

  var _action_items_validator = require('./action_items_validator');

  var _action_items_validator2 = _interopRequireDefault(_action_items_validator);

  var _ClayHorizontalCardSoy = require("./ClayHorizontalCard.soy");

  var _ClayHorizontalCardSoy2 = _interopRequireDefault(_ClayHorizontalCardSoy);

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { default: obj };
  }

  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _possibleConstructorReturn(self, call) {
    if (!self) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }return call && (typeof call === "object" || typeof call === "function") ? call : self;
  }

  function _inherits(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
    }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } });if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
  }
  // eslint-disable-next-line


  /**
   * Metal ClayHorizontalCard component.
   * @extends ClayComponent
   */
  var ClayHorizontalCard = function (_ClayComponent) {
    _inherits(ClayHorizontalCard, _ClayComponent);

    function ClayHorizontalCard() {
      _classCallCheck(this, ClayHorizontalCard);

      return _possibleConstructorReturn(this, (ClayHorizontalCard.__proto__ || Object.getPrototypeOf(ClayHorizontalCard)).apply(this, arguments));
    }

    _createClass(ClayHorizontalCard, [{
      key: '_handleActionItemClicked',

      /**
       * Continues the propagation of the dropdown action item click event
       * @param {!Event} event
       * @private
       * @return {Boolean} If the event has been prevented or not.
       */
      value: function _handleActionItemClicked(event) {
        return !this.emit('itemClicked', event);
      }

      /**
       * Continues the propagation of the checkbox changed event
       * @param {!Event} event
       * @private
       */

    }, {
      key: '_handleItemCheckboxClick',
      value: function _handleItemCheckboxClick(event) {
        this.emit('itemToggled', event);
      }
    }]);

    return ClayHorizontalCard;
  }(_clayComponent2.default);

  /**
   * State definition.
   * @static
   * @type {!Object}
   */

  ClayHorizontalCard.STATE = {
    /**
     * Aria label attribute for the action element.
     * @default undefined
     * @instance
     * @memberof ClayHorizontalCard
     * @type {?(string|undefined)}
     */
    actionAriaLabel: _metalState.Config.string(),

    /**
     * List of items to display in the actions menu.
     * @default undefined
     * @instance
     * @memberof ClayHorizontalCard
     * @type {?(array|undefined)}
     */
    actionItems: _action_items_validator2.default,

    /**
     * Data to add to the element.
     * @default undefined
     * @instance
     * @memberof ClayHorizontalCard
     * @type {?object}
     */
    data: _metalState.Config.object(),

    /**
     * Object that wires events with default listeners
     * @default undefined
     * @instance
     * @memberof ClayHorizontalCard
     * @review
     * @type {?(object|undefined)}
     */
    defaultEventHandler: _metalState.Config.object(),

    /**
     * Flag to indicate if the card is disabled or not.
     * @default false
     * @instance
     * @memberof ClayHorizontalCard
     * @type {?bool}
     */
    disabled: _metalState.Config.bool().value(false),

    /**
     * CSS classes to be applied to the element.
     * @default undefined
     * @instance
     * @memberof ClayHorizontalCard
     * @type {?(string|undefined)}
     */
    elementClasses: _metalState.Config.string(),

    /**
     * Url to be applied to the title of the card.
     * @default undefined
     * @instance
     * @memberof ClayHorizontalCard
     * @type {?(string|undefined)}
     */
    href: _metalState.Config.string(),

    /**
     * Icon of the card.
     * @default folder
     * @instance
     * @memberof ClayHorizontalCard
     * @type {?string}
     */
    icon: _metalState.Config.string().value('folder'),

    /**
     * Id to be applied to the element.
     * @default undefined
     * @instance
     * @memberof ClayHorizontalCard
     * @type {?(string|undefined)}
     */
    id: _metalState.Config.string(),

    /**
     * Name to be applied to the input element.
     * @default undefined
     * @instance
     * @memberof ClayHorizontalCard
     * @type {?(string|undefined)}
     */
    inputName: _metalState.Config.string(),

    /**
     * Value to be applied to the input element.
     * @default undefined
     * @instance
     * @memberof ClayHorizontalCard
     * @type {?(string|undefined)}
     */
    inputValue: _metalState.Config.string(),

    /**
     * Flag to indicate if the card is selectable or not.
     * @default false
     * @instance
     * @memberof ClayHorizontalCard
     * @type {?bool}
     */
    selectable: _metalState.Config.bool().value(false),

    /**
     * Flag to indicate if the card is selected or not.
     * @default false
     * @instance
     * @memberof ClayHorizontalCard
     * @type {?bool}
     */
    selected: _metalState.Config.bool().value(false),

    /**
     * The path to the SVG spritemap file containing the icons.
     * @default undefined
     * @instance
     * @memberof ClayHorizontalCard
     * @type {!string}
     */
    spritemap: _metalState.Config.string().required(),

    /**
     * Title of the card.
     * @default undefined
     * @instance
     * @memberof ClayHorizontalCard
     * @type {!string}
     */
    title: _metalState.Config.string().required()
  };

  (0, _metalWebComponent2.default)('clay-horizontal-card', ClayHorizontalCard);

  _metalSoy2.default.register(ClayHorizontalCard, _ClayHorizontalCardSoy2.default);

  exports.ClayHorizontalCard = ClayHorizontalCard;
  exports.default = ClayHorizontalCard;
  //# sourceMappingURL=ClayHorizontalCard.js.map
});
//# sourceMappingURL=ClayHorizontalCard.js.map