'use strict';

Liferay.Loader.define("frontend-taglib-chart$clay-charts@2.15.1/lib/jsx/PredictiveChart", ['module', 'exports', 'require', './Chart', '../PredictiveChart', 'frontend-js-metal-web$metal'], function (module, exports, require) {
	var define = undefined;
	Object.defineProperty(exports, "__esModule", {
		value: true
	});
	exports.PredictiveChart = undefined;

	var _createClass = function () {
		function defineProperties(target, props) {
			for (var i = 0; i < props.length; i++) {
				var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
			}
		}return function (Constructor, protoProps, staticProps) {
			if (protoProps) defineProperties(Constructor.prototype, protoProps);if (staticProps) defineProperties(Constructor, staticProps);return Constructor;
		};
	}();

	var _Chart2 = require('./Chart');

	var _Chart3 = _interopRequireDefault(_Chart2);

	var _PredictiveChart = require('../PredictiveChart');

	var _metal = require("frontend-js-metal-web$metal");

	function _interopRequireDefault(obj) {
		return obj && obj.__esModule ? obj : { default: obj };
	}

	function _classCallCheck(instance, Constructor) {
		if (!(instance instanceof Constructor)) {
			throw new TypeError("Cannot call a class as a function");
		}
	}

	function _possibleConstructorReturn(self, call) {
		if (!self) {
			throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
		}return call && (typeof call === "object" || typeof call === "function") ? call : self;
	}

	function _inherits(subClass, superClass) {
		if (typeof superClass !== "function" && superClass !== null) {
			throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
		}subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } });if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
	}

	/**
  * Predictive Chart component.
  * @augments Chart
  */
	var PredictiveChart = function (_Chart) {
		_inherits(PredictiveChart, _Chart);

		function PredictiveChart() {
			_classCallCheck(this, PredictiveChart);

			return _possibleConstructorReturn(this, (PredictiveChart.__proto__ || Object.getPrototypeOf(PredictiveChart)).apply(this, arguments));
		}

		_createClass(PredictiveChart, [{
			key: 'created',

			/**
    * @inheritDoc
    */
			value: function created() {
				var config = this.getInitialConfig();

				if ((0, _metal.isDefAndNotNull)(config.timeseries)) {
					config.data.push({ data: config.timeseries, id: 'x' });
				}

				if ((0, _metal.isDefAndNotNull)(config.data)) {
					config.data = config.data.map(function (dataSeries) {
						if (dataSeries.id !== 'x') {
							dataSeries.data = dataSeries.data.map(function (element) {
								return (0, _metal.isNumber)(element) ? { low: element, mid: element, high: element } : element;
							});
						}

						return dataSeries;
					});
				}

				if ((0, _metal.isDefAndNotNull)(config.axisXTickFormat)) {
					config.axisX = {
						tick: {
							format: config.axisXTickFormat
						}
					};
				}

				if ((0, _metal.isDefAndNotNull)(config.predictionDate)) {
					if ((0, _metal.isString)(config.predictionDate)) {
						config.predictionDate = new Date(config.predictionDate);
					}

					if (!(0, _metal.isDefAndNotNull)(this.props.regions)) {
						this.props.regions = [];
					}

					this.props.regions.push({
						axis: 'x',
						start: config.predictionDate
					});
				}

				if ((0, _metal.isDefAndNotNull)(this.tooltipContents)) {
					this.tooltip.contents = this.tooltipContents;
				}
			}
		}]);

		return PredictiveChart;
	}(_Chart3.default);

	PredictiveChart.PROPS = _PredictiveChart.PredictiveChart.STATE;

	exports.PredictiveChart = PredictiveChart;
	exports.default = PredictiveChart;
	//# sourceMappingURL=PredictiveChart.js.map
});
//# sourceMappingURL=PredictiveChart.js.map